<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Zahlungsarten – Betten-Sauer Köln</title>
  <meta name="description" content="Übersicht der Zahlungsarten bei Betten-Sauer: Rechnung, PayPal, Lastschrift, Kreditkarte und direkte Banküberweisung.">
  <meta name="author" content="Betten-Sauer KG">
  <meta name="theme-color" content="#6793c4">

  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif">
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png">
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png">

  <link rel="stylesheet" href="css/style.css">

  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
  </style>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-[#0f1e2f]/90 transition duration-300';
    require __DIR__ . '/includes/header.php';
  ?>

  <main class="pt-28 pb-20 bg-gray-50">
    <section class="max-w-5xl mx-auto px-6 space-y-10">
      <div class="rounded-3xl bg-gradient-to-br from-[#0f1e2f] via-[#1b2f4b] to-[#274773] text-white text-center py-16 px-6 md:px-10 shadow-xl">
        <h1 class="text-3xl md:text-4xl font-semibold">Zahlungsarten</h1>
        <p class="mt-4 text-base md:text-lg text-white/85 max-w-2xl mx-auto">
          Wählen Sie Ihre bevorzugte Zahlungsart – sicher, bequem und transparent für Ihren Einkauf bei Betten-Sauer.
        </p>
      </div>

      <div class="bg-white shadow-lg rounded-2xl border border-gray-200 p-8 space-y-8 leading-relaxed">
        <section>
          <h2 class="text-2xl font-semibold mb-4">Rechnung</h2>
          <p>
            Sie erhalten nach der Bestellung eine Rechnung von uns. Bitte überweisen Sie den Gesamtbetrag innerhalb von 14 Tagen
            auf das angegebene Konto.
          </p>
          <p class="mt-4 font-semibold">
            Sparkasse Köln<br>IBAN: DE51 3705 0198 0012 1723 18
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">PayPal, Lastschrift, Kreditkarte</h2>
          <p>
            Wählen Sie während des Bestellprozesses Ihre gewünschte Zahlungsart. Die Abwicklung erfolgt über unseren Zahlungsdienstleister
            und ist selbstverständlich verschlüsselt und sicher.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Direkte Banküberweisung</h2>
          <p>
            Überweisen Sie den Betrag direkt an unsere Bankverbindung. Bitte nutzen Sie die Bestellnummer als Verwendungszweck.
            Ihre Bestellung wird nach Zahlungseingang versandt.
          </p>
          <p class="mt-4 font-semibold">
            Sparkasse Köln<br>IBAN: DE51 3705 0198 0012 1723 18
          </p>
        </section>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
