<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Waschen &amp; Reinigen von Bettwaren | Betten Sauer</title>
  <meta name="description" content="Professionelles Waschen und Reinigen von Bettdecken und Kissen bei Betten Sauer. Schonende Pflege mit Naturseife, UV-Licht und Spezialmaschinen – auf Wunsch mit Abholservice." />
  <meta name="keywords" content="Bettdecken waschen lassen, Kissen reinigen Köln, Bettwaren Pflege, Betten Sauer Reinigung, Daunendecken waschen, Abholservice Bettwaren" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="waschen.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="waschen.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Waschen &amp; Reinigen von Bettwaren | Betten Sauer" />
  <meta property="og:description" content="Bettwarenpflege vom Fachgeschäft: hygienisch, sanft und nachhaltig. Mit UV-Desinfektion, Naturseife und Abholservice." />
  <meta property="og:image" content="images/1200x800_abhol_lieferservice.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Waschen &amp; Reinigen von Bettwaren | Betten Sauer" />
  <meta name="twitter:description" content="Frisch, hygienisch und fachgerecht gepflegt – vertrauen Sie auf unseren Bettwaren-Waschservice in Köln &amp; Inhausen." />
  <meta name="twitter:image" content="images/1200x800_abhol_lieferservice.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <!-- Hero -->
    <section class="relative overflow-hidden bg-[#0f1e2f] text-white" aria-labelledby="hero-heading">
      <div class="absolute inset-0 opacity-35">
        <div class="absolute -left-20 top-12 h-72 w-72 rounded-full bg-[#4e759f] blur-3xl"></div>
        <div class="absolute right-8 top-0 h-80 w-80 rounded-full bg-[#2b4563] blur-3xl"></div>
        <div class="absolute bottom-0 left-1/3 h-64 w-64 rounded-full bg-[#6793c4] blur-3xl"></div>
      </div>
      <div class="relative mx-auto flex max-w-6xl flex-col gap-12 px-6 py-16 lg:px-0">
        <div class="grid items-center gap-12 lg:grid-cols-[1.05fr_0.95fr]">
          <div class="space-y-7 pt-8">
            <h1 id="hero-heading" class="text-3xl font-semibold leading-tight text-shadow sm:text-4xl md:text-5xl">
              Frisch. Hygienisch. Fachgerecht gepflegt – Ihre Bettwaren in besten Händen.
            </h1>
            <p class="text-base text-white/85 sm:text-lg md:text-xl">
              Ob Daune, Wolle oder Synthetik – wir reinigen schonend, gründlich und nachhaltig.
            </p>
            <div class="grid gap-4 text-sm text-white/85 sm:grid-cols-2">
              <?php
                $washingBenefits = [
                  ['icon' => '🧴', 'label' => 'Naturseife & UV-Licht statt aggressiver Chemie'],
                  ['icon' => '♻️', 'label' => 'Schonprogramme für Daune, Wolle & Funktionsfaser'],
                  ['icon' => '🚚', 'label' => 'Abhol- & Bringservice im Großraum Köln'],
                  ['icon' => '⏱️', 'label' => 'Innerhalb von 24 Stunden wieder einsatzbereit'],
                ];
              ?>
              <?php foreach ($washingBenefits as $benefit): ?>
                <div class="flex items-start gap-3 rounded-2xl border border-white/15 bg-white/5 p-4">
                  <span class="text-base leading-none"><?= htmlspecialchars($benefit['icon'], ENT_QUOTES) ?></span>
                  <span><?= htmlspecialchars($benefit['label'], ENT_QUOTES) ?></span>
                </div>
              <?php endforeach; ?>
            </div>
            <div class="flex flex-col gap-4 pt-2 sm:flex-row sm:items-center">
              <a href="#kontakt" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                Jetzt Reinigung beauftragen
              </a>
              <p class="text-sm text-white/70">
                Köln &bull; Inhausen &bull; Auch für Gewerbe & Pflegeeinrichtungen
              </p>
            </div>
          </div>
          <div class="relative">
            <div class="overflow-hidden rounded-[32px] border border-white/15 bg-white/10 shadow-2xl shadow-black/30 backdrop-blur-sm">
              <img
                src="images/1200x800_abhol_lieferservice.webp"
                alt="Mitarbeiterin pflegt Bettdecke in professioneller Waschmaschine bei Betten Sauer"
                class="h-full w-full object-cover"
                loading="eager"
                decoding="async"
              />
              <div class="absolute inset-0 bg-gradient-to-tr from-[#0f1e2f]/60 via-transparent to-transparent"></div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Nutzenbereich -->
    <section class="bg-white py-16" aria-labelledby="nutzen-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="nutzen-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Warum professionell waschen?
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Regelmäßige Pflege erhält Füllkraft, Hygiene und Komfort Ihrer Bettwaren – ganz ohne Aufwand für Sie.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-8 md:grid-cols-3">
          <?php
            $benefits = [
              [
                'icon' => '🧺',
                'title' => 'Sauberer Schlaf',
                'text'  => 'UV-Desinfektion & Naturseife statt aggressiver Chemie – ideal für Allergiker und sensible Haut.',
              ],
              [
                'icon' => '♻️',
                'title' => 'Länger haltbar',
                'text'  => 'Fachgerechte Reinigung erhält Füllkraft und verlängert die Lebensdauer Ihrer Lieblingsdecke.',
              ],
              [
                'icon' => '🚚',
                'title' => 'Bequem & flexibel',
                'text'  => 'Auf Wunsch mit Abhol- und Bringservice – wir übernehmen die Organisation für Sie.',
              ],
            ];
          ?>
          <?php foreach ($benefits as $benefit): ?>
            <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 text-center shadow-lg shadow-[#0f1e2f]/10">
              <div class="text-3xl" aria-hidden="true"><?= htmlspecialchars($benefit['icon'], ENT_QUOTES) ?></div>
              <h3 class="text-xl font-semibold text-[#0f1e2f]"><?= htmlspecialchars($benefit['title'], ENT_QUOTES) ?></h3>
              <p class="text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($benefit['text'], ENT_QUOTES) ?></p>
            </article>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- Erklärung -->
    <section class="bg-[#f5f7fa] py-16" aria-labelledby="ablauf-heading">
      <div class="mx-auto max-w-6xl space-y-12 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="ablauf-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            So funktioniert unsere Bettwarenpflege
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Einfach übergeben, frisch gepflegt zurückbekommen – zuverlässig und materialschonend.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-8 md:grid-cols-3">
          <?php
            $steps = [
              [
                'title' => '1. Anliefern oder Abholen lassen',
                'text'  => 'Bringen Sie Ihre Bettwaren vorbei – oder wir holen sie per Abholservice bei Ihnen zu Hause ab.',
              ],
              [
                'title' => '2. Sanfte Reinigung',
                'text'  => 'Spezialmaschinen, Naturseife und UV-Licht reinigen gründlich, lockern die Füllung und entfernen Keime.',
              ],
              [
                'title' => '3. Abholen am nächsten Tag',
                'text'  => 'Schon nach 24 Stunden erhalten Sie Ihre Decke frisch aufgeschüttelt und verpackt zurück.',
              ],
            ];
          ?>
          <?php foreach ($steps as $step): ?>
            <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-md shadow-[#0f1e2f]/10">
              <h3 class="text-lg font-semibold text-[#0f1e2f]"><?= htmlspecialchars($step['title'], ENT_QUOTES) ?></h3>
              <p class="text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($step['text'], ENT_QUOTES) ?></p>
            </article>
          <?php endforeach; ?>
        </div>
        <p class="text-center text-sm leading-relaxed text-gray-600">
          Auch Sondergrößen, empfindliche Naturhaarfüllungen und Funktionsmaterialien reinigen wir fachgerecht – fragen Sie uns einfach.
        </p>
      </div>
    </section>

    <!-- Preisübersicht -->
    <section class="bg-white py-16" aria-labelledby="preise-heading">
      <div class="mx-auto max-w-5xl space-y-8 px-6 text-gray-700 lg:px-0">
        <h2 id="preise-heading" class="text-center text-2xl font-semibold text-[#4e759f] sm:text-3xl">
          So preiswert ist professionelle Bettenpflege
        </h2>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
          <?php
            $prices = [
              ['label' => 'Daunendecke', 'range' => '38 – 48 €'],
              ['label' => 'Naturhaardecke', 'range' => '34 – 46 €'],
              ['label' => 'Synthetikdecke', 'range' => '29 – 39 €'],
              ['label' => 'Kopfkissen', 'range' => '15 – 25 €'],
            ];
          ?>
          <?php foreach ($prices as $price): ?>
            <div class="rounded-2xl border border-[#dce4ef] bg-[#f9fbfe] p-6 shadow-md shadow-[#0f1e2f]/10">
              <p class="text-sm font-semibold uppercase tracking-wide text-[#0f1e2f]"><?= htmlspecialchars($price['label'], ENT_QUOTES) ?></p>
              <p class="mt-2 text-lg font-semibold text-gray-800"><?= htmlspecialchars($price['range'], ENT_QUOTES) ?></p>
            </div>
          <?php endforeach; ?>
        </div>
        <p class="text-center text-sm text-gray-600">
          Decken, die Sie bei uns gekauft haben, erhalten Sie zum Sonderpreis. Gern informieren wir persönlich.
        </p>
      </div>
    </section>

    <!-- Vertrauen & Qualität -->
    <section class="bg-[#f5f7fa] py-16" aria-labelledby="qualitaet-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="qualitaet-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Fachkompetenz, die man spürt
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Seit 1921 pflegen wir Bettwaren mit handwerklichem Anspruch und modernster Technik.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-4">
          <?php
            $usps = [
              'Reinigung mit UV-Licht – hygienisch & umweltfreundlich.',
              'Wir waschen ausschließlich mit Naturseife.',
              'Spezialmaschinen für Daune, Wolle & Funktionsfasern.',
              'Familienbetrieb seit 1921 – Erfahrung über Generationen.',
            ];
          ?>
          <?php foreach ($usps as $usp): ?>
            <div class="rounded-2xl border border-[#d6e2f1] bg-white p-6 text-center text-sm leading-relaxed text-gray-600 shadow-md shadow-[#0f1e2f]/10">
              <?= htmlspecialchars($usp, ENT_QUOTES) ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- Call to Action -->
    <section class="bg-[#6793c4] py-16 text-white" aria-labelledby="cta-heading">
      <div class="mx-auto max-w-4xl space-y-6 px-6 text-center">
        <h2 id="cta-heading" class="text-2xl font-semibold sm:text-3xl">
          Lassen Sie Ihre Bettwaren professionell auffrischen – wir kümmern uns darum.
        </h2>
        <p class="text-base leading-relaxed text-white/85 sm:text-lg">
          Ein Anruf oder eine Nachricht genügt. Wir organisieren Reinigung, Abholung und Rückgabe ganz nach Ihrem Zeitplan.
        </p>
        <div class="flex flex-col items-center gap-4 sm:flex-row sm:justify-center sm:gap-6">
          <a href="#kontakt" class="inline-flex items-center justify-center rounded-lg bg-white px-7 py-3 text-sm font-semibold uppercase tracking-wide text-[#0f1e2f] transition hover:bg-[#dce4ef] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
            Reinigung vereinbaren
          </a>
          <div class="text-sm text-white/85">
            <p>Telefon Köln: <a href="tel:+49221843236" class="underline hover:text-white">0221&nbsp;843236</a></p>
            <p>Telefon Inhausen: <a href="tel:+4922412414230" class="underline hover:text-white">02241&nbsp;2414230</a></p>
          </div>
        </div>
        <p class="text-sm text-white/70">Oder schreiben Sie uns an <a href="mailto:info@betten-sauer.de" class="underline hover:text-white">info@betten-sauer.de</a>.</p>
      </div>
    </section>

    <!-- Kontaktbereich -->
    <section id="kontakt" class="bg-white py-16" aria-labelledby="kontakt-heading">
      <div class="mx-auto max-w-6xl gap-16 px-6 text-gray-700 lg:grid lg:grid-cols-[minmax(0,1fr)_minmax(0,1.05fr)] lg:px-0">
        <div class="space-y-6">
          <h2 id="kontakt-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Haben Sie Fragen?
          </h2>
          <p class="text-base leading-relaxed sm:text-lg">
            Wir beraten Sie gern zu Pflegeintervallen, empfindlichen Materialien oder unserem Abholservice. Melden Sie sich kurz – wir antworten werktags innerhalb von 24&nbsp;Stunden.
          </p>
          <div class="space-y-4 text-sm text-gray-600">
            <div>
              <h3 class="text-lg font-semibold text-[#0f1e2f]">Betten-Sauer Köln</h3>
              <p>Brücker Mauspfad 539<br />51109 Köln</p>
              <p>Telefon: <a href="tel:+49221843236" class="text-[#4e759f] underline hover:text-[#2f506f]">0221&nbsp;843236</a></p>
              <p class="text-xs text-gray-500">Mo – Fr: 09:30 – 18:30 &bull; Sa: 10:00 – 14:00</p>
            </div>
            <div>
              <h3 class="text-lg font-semibold text-[#0f1e2f]">Betten-Sauer by Inhausen</h3>
              <p>Cecilienstraße 8<br />53721 Inhausen</p>
              <p>Telefon: <a href="tel:+4922412414230" class="text-[#4e759f] underline hover:text-[#2f506f]">02241&nbsp;2414230</a></p>
              <p class="text-xs text-gray-500">Mo – Fr: 10:00 – 18:00 &bull; Sa: 10:00 – 14:00</p>
            </div>
          </div>
        </div>
        <div>
          <form action="lead.php" method="POST" class="rounded-2xl border border-[#dce4ef] bg-white p-8 shadow-xl shadow-[#0f1e2f]/10" novalidate aria-describedby="kontakt-form-info">
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
              <div>
                <label for="waschen-name" class="mb-1 block text-sm font-semibold text-gray-800">Name *</label>
                <input
                  type="text"
                  id="waschen-name"
                  name="name"
                  required
                  aria-required="true"
                  autocomplete="name"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
              <div>
                <label for="waschen-email" class="mb-1 block text-sm font-semibold text-gray-800">E-Mail *</label>
                <input
                  type="email"
                  id="waschen-email"
                  name="email"
                  required
                  aria-required="true"
                  autocomplete="email"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
            </div>
            <div class="mt-6">
              <label for="waschen-nachricht" class="mb-1 block text-sm font-semibold text-gray-800">Nachricht *</label>
              <textarea
                id="waschen-nachricht"
                name="nachricht"
                rows="6"
                required
                aria-required="true"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              ></textarea>
            </div>
            <div class="mt-6 flex items-start gap-3">
              <input
                type="checkbox"
                id="waschen-datenschutz"
                name="datenschutz"
                required
                aria-required="true"
                class="mt-1 h-5 w-5 cursor-pointer rounded border-gray-300 text-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:ring-offset-0"
              />
              <label for="waschen-datenschutz" class="text-sm leading-relaxed text-gray-700">
                Ich bin damit einverstanden, dass Betten Sauer meine Angaben zur Kontaktaufnahme verarbeitet.
                Mehr Informationen in unserer <a href="datenschutz.php" class="text-[#4e759f] underline hover:text-[#2f506f]">Datenschutzerklärung</a>.
              </label>
            </div>
            <div class="mt-6">
              <div class="rounded-md border border-dashed border-gray-300 bg-gray-50 p-4 text-center text-sm text-gray-500">
                reCAPTCHA Platzhalter – hinterlegen Sie Ihren Site-Key für den Live-Betrieb.
              </div>
            </div>
            <div class="mt-8">
              <button type="submit" class="w-full rounded-lg bg-[#6793c4] px-6 py-3 text-base font-semibold text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-4 focus-visible:ring-[#4e759f]/30">
                Reinigung anfragen
              </button>
            </div>
          </form>
          <p id="kontakt-form-info" class="mt-4 text-xs text-gray-500">
            Alle mit * gekennzeichneten Felder sind Pflichtfelder.
          </p>
        </div>
      </div>
    </section>

  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
