<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Produkte bei Betten-Sauer | Bettwaren von nachhaltigem Wert</title>
  <meta name="description" content="Entdecken Sie die Produktwelten von Betten-Sauer: Bettgestelle, Bettsysteme, Matratzen, Boxspringbetten, Bettwäsche, Lattenroste, Kissen und Seniorenbetten.">
  <meta name="author" content="Betten-Sauer KG">
  <meta name="theme-color" content="#6793c4">

  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif">
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png">
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png">

  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Regular.woff2') format('woff2'),
           url('fonts/WorkSans-Regular.woff') format('woff');
      font-weight: 400;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-SemiBold.woff2') format('woff2'),
           url('fonts/WorkSans-SemiBold.woff') format('woff');
      font-weight: 600;
      font-style: normal;
      font-display: swap;
    }
    body { font-family: 'Work Sans', sans-serif; color: #3a3a3a; background:#ffffff; }
    h1, h2, h3 { color: #6793c4; }
    header { transition: background 0.3s ease, box-shadow 0.3s ease; }
    header.scrolled { background: rgba(255,255,255,0.95); box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    header.scrolled a { color: #3a3a3a !important; text-shadow: none; }
    .hero-image { background: linear-gradient(120deg, rgba(15,30,47,0.75), rgba(39,71,115,0.65)), url('images/1200x800_boxspringbett.webp') center/cover no-repeat; }
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
  </style>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <!-- Hero -->
  <section class="hero-image h-[70vh] min-h-[420px] flex items-center justify-center text-center px-6">
    <div class="max-w-3xl text-white space-y-6">
      <p class="uppercase tracking-[0.3em] text-sm md:text-base text-white/80">Unsere Produktwelten</p>
      <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold leading-tight">Produkte bei Betten-Sauer</h1>
      <p class="text-lg sm:text-xl text-white/85">
        Schlaflösungen, die spürbar mehr leisten: Entdecken Sie Bettwaren von nachhaltigem Wert – handverlesen für Ihren Schlafkomfort.
      </p>
      <div class="flex flex-col sm:flex-row gap-4 justify-center">
        <a href="#produktwelten" class="bg-[#6793c4] hover:bg-[#4e759f] text-white font-semibold px-6 py-3 rounded-lg shadow transition">Zur Übersicht</a>
        <a href="index.php#kontaktformular" class="bg-white text-[#6793c4] font-semibold px-6 py-3 rounded-lg shadow hover:bg-gray-100 transition">Beratung anfragen</a>
      </div>
    </div>
  </section>

  <!-- Intro -->
  <main class="bg-white">
    <section class="max-w-5xl mx-auto px-6 py-16 space-y-8 text-lg" id="produktwelten">
      <div>
        <h2 class="text-3xl font-semibold mb-4">Bettwaren von nachhaltigem Wert</h2>
        <p class="mb-4">
          Ein gutes Produkt zeichnet sich dadurch aus, dass es wesentlich mehr leistet als man es ihm oberflächlich ansieht.
          Äußerlich betrachtet, ist an einer Matratze nicht viel Besonderes – und das Discountermodell zum Schleuderpreis sieht dem hochwertigen Ergebnis
          aus jahrzehntelanger Forschung und Erfahrung auf den ersten Blick ähnlich.
        </p>
        <p>
          Wir bleiben für Sie auf dem neuesten Stand von Forschung und Technik – und nehmen Ihnen die Suche ab: Bei BETTEN-SAUER finden Sie ausschließlich hochwertige,
          schlafgesunde Bettwaren von nachhaltigem Wert. Und: Wir erklären Ihnen klar und verständlich, was unsere Produkte für Sie leisten.
        </p>
      </div>
    </section>

    <!-- Produktkacheln -->
    <section class="max-w-6xl mx-auto px-6 pb-20">
      <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
        <article class="bg-gray-50 rounded-xl shadow hover:shadow-lg transition overflow-hidden">
          <img src="images/1200x800_bettgestell.webp" alt="Massives Bettgestell in modernem Schlafzimmer" class="w-full h-48 object-cover">
          <div class="p-5">
            <h3 class="text-xl font-semibold text-[#6793c4] mb-2">Bettgestelle</h3>
            <p class="text-sm text-gray-600">Designs aus Holz, Metall oder Polster, die Stabilität und Stil kombinieren.</p>
          </div>
        </article>
        <article class="bg-gray-50 rounded-xl shadow hover:shadow-lg transition overflow-hidden">
          <img src="images/1200x800_lattenroste.webp" alt="Schlafsystem Illustration mit ergonomischer Liegeposition" class="w-full h-48 object-cover">
          <div class="p-5">
            <h3 class="text-xl font-semibold text-[#6793c4] mb-2">Bettsysteme</h3>
            <p class="text-sm text-gray-600">Perfekt abgestimmte Systeme für ergonomisches Liegen und gesunden Schlaf.</p>
          </div>
        </article>
        <article class="bg-gray-50 rounded-xl shadow hover:shadow-lg transition overflow-hidden">
          <img src="images/1200x800_bettwaesche.webp" alt="Elegante Bettwäsche in gedeckten Farben" class="w-full h-48 object-cover">
          <div class="p-5">
            <h3 class="text-xl font-semibold text-[#6793c4] mb-2">Bettwäsche</h3>
            <p class="text-sm text-gray-600">Hautsympathische Stoffe, liebevolle Details und langlebige Qualität.</p>
          </div>
        </article>
        <article class="bg-gray-50 rounded-xl shadow hover:shadow-lg transition overflow-hidden">
          <img src="images/1200x800_boxspringbett.webp" alt="Modernes Boxspringbett in hellem Schlafzimmer" class="w-full h-48 object-cover">
          <div class="p-5">
            <h3 class="text-xl font-semibold text-[#6793c4] mb-2">Boxspringbetten</h3>
            <p class="text-sm text-gray-600">Premium-Komfort mit individuell abgestimmten Toppern und Matratzen.</p>
          </div>
        </article>
        <article class="bg-gray-50 rounded-xl shadow hover:shadow-lg transition overflow-hidden">
          <img src="images/1200x800_kissen.webp" alt="Ergonomisches Nackenstützkissen" class="w-full h-48 object-cover">
          <div class="p-5">
            <h3 class="text-xl font-semibold text-[#6793c4] mb-2">Kissen &amp; Nackenstützkissen</h3>
            <p class="text-sm text-gray-600">Individuelle Stützkraft für entspannte Hals- und Schultermuskulatur.</p>
          </div>
        </article>
        <article class="bg-gray-50 rounded-xl shadow hover:shadow-lg transition overflow-hidden">
          <img src="images/1200x800_lattenroste.webp" alt="Lattenrost Detailaufnahme" class="w-full h-48 object-cover">
          <div class="p-5">
            <h3 class="text-xl font-semibold text-[#6793c4] mb-2">Lattenroste</h3>
            <p class="text-sm text-gray-600">Verstellbare Rahmen, die Matratzen optimal unterstützen.</p>
          </div>
        </article>
        <article class="bg-gray-50 rounded-xl shadow hover:shadow-lg transition overflow-hidden">
          <img src="images/1200x800_matratzen.webp" alt="Premium Matratze mit Oberflächenstruktur" class="w-full h-48 object-cover">
          <div class="p-5">
            <h3 class="text-xl font-semibold text-[#6793c4] mb-2">Matratzen</h3>
            <p class="text-sm text-gray-600">Federkern, Latex oder Hybrid – abgestimmt auf Ihre Schlafgewohnheiten.</p>
          </div>
        </article>
        <article class="bg-gray-50 rounded-xl shadow hover:shadow-lg transition overflow-hidden">
          <img src="images/1200x800_seniorenbetten.webp" alt="Komfortables Seniorenbett mit Bettkasten" class="w-full h-48 object-cover">
          <div class="p-5">
            <h3 class="text-xl font-semibold text-[#6793c4] mb-2">Seniorenbetten</h3>
            <p class="text-sm text-gray-600">Komfortable Einstiegshöhen und praktische Funktionen für mehr Selbstständigkeit.</p>
          </div>
        </article>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
