<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Über uns – Betten-Sauer Köln | Team &amp; Unternehmensgeschichte</title>
   <!-- Die vom Nutzer gewünschten Favicon-Links wurden hier hinzugefügt -->
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif"/>
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png"/>
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png" />
  <meta name="description" content="Lernen Sie das Team von Betten-Sauer in Köln kennen und entdecken Sie unsere über 200-jährige Unternehmensgeschichte, individuelle Schlafberatung und nachhaltige Serviceleistungen." />
  <meta name="keywords" content="Betten-Sauer Über uns, Betten-Sauer Team, Schlafberatung Köln, Bettenfachgeschäft Geschichte" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="#/ueber-uns" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="#/ueber-uns" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Über uns – Betten-Sauer Köln | Team &amp; Unternehmensgeschichte" />
  <meta property="og:description" content="Lernen Sie das Beraterteam von Betten-Sauer kennen und erfahren Sie mehr über 200 Jahre Schlafkompetenz aus Köln." />
  <meta property="og:image" content="#/html_sauer/images/comic/header01.jpeg" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Über uns – Betten-Sauer Köln | Team &amp; Unternehmensgeschichte" />
  <meta name="twitter:description" content="Tradition, Schlafberatung und Service seit 1823 – entdecken Sie die Menschen hinter Betten-Sauer." />
  <meta name="twitter:image" content="#/html_sauer/images/comic/header01.jpeg" />
  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- GSAP for firmengeschichte scroll -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js"></script>
  <style>
    /* Overlay styling for firmengeschichte panels */
    .overlay {
      background: rgba(0, 0, 0, 0.35);
      padding: 3rem;
      border-radius: 0.5rem;
    }
    /* Background panels for firmengeschichte */
    .bg-container {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: -1;
    }
    .bg-panel {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-size: cover;
      background-position: center;
      opacity: 0;
    }
    /* Colour themes for the three Epochen */
    .bg-bieder {
      background-image: linear-gradient(to right, #f5d6b3, #e8caa4, #d8b894);
    }
    .bg-war {
      background-image: linear-gradient(to right, #d7d7d7, #c2c2c2, #b0b0b0);
    }
    .bg-modern {
      background-image: linear-gradient(to right, #a3c4f3, #d3e0fb, #ffffff);
    }
    .bg-future {
      background-image: linear-gradient(to bottom right, #7aa4d3, #bcd3eb, #ffffff);
    }
    /* Header */
    header { transition: background 0.3s ease, box-shadow 0.3s ease; }
    header.scrolled { background: rgba(255,255,255,0.95); box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    header.scrolled a { color: #3a3a3a !important; text-shadow: none; }
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
    /* --- Mobile Fixes --- */
@media (max-width: 768px) {

  /* Hintergrundcontainer soll nicht über dem Team liegen */
  .bg-container {
    position: relative;
    height: auto;
  }

  /* Panels sollen natürlich scrollen, keine feste Bildschirmhöhe */
  .firmengeschichte-panel {
    height: auto !important;
    min-height: 100vh;
    padding: 3rem 1rem;
    flex-direction: column;
    align-items: flex-start;
  }

  /* Overlay etwas transparenter und schmaler für Lesbarkeit */
  .overlay {
    padding: 1.5rem;
    background: rgba(0, 0, 0, 0.25);
  }

  /* Bilder in Panels kleiner, mittig ausrichten */
  .firmengeschichte-panel img {
    width: 5rem;
    height: 5rem;
  }

  /* Abstand zwischen Team-Section und Firmengeschichte */
  section.py-16.bg-white {
    margin-bottom: 3rem;
  }

  /* Verhindert Überlappung durch GSAP absolute Ebenen */
  .bg-panel {
    position: relative;
    opacity: 1 !important;
  }
}

  </style>
  <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "AboutPage",
      "name": "Über uns – Betten-Sauer Köln",
      "url": "#/ueber-uns",
      "description": "Erfahren Sie mehr über das Team und die Geschichte von Betten-Sauer in Köln – individuelle Schlafberatung und Schlafsysteme seit 1823.",
      "primaryImageOfPage": "#/html_sauer/images/comic/header01.jpeg",
      "isPartOf": {
        "@type": "WebSite",
        "name": "Betten-Sauer KG",
        "url": "#/"
      },
      "about": {
        "@type": "FurnitureStore",
        "name": "Betten-Sauer KG",
        "url": "#/",
        "image": "#/html_sauer/images/1200x800_boxspringbett.webp",
        "telephone": "+49-221-843236",
        "address": {
          "@type": "PostalAddress",
          "streetAddress": "Brücker Mauspfad 539",
          "postalCode": "51109",
          "addressLocality": "Köln",
          "addressCountry": "DE"
        },
        "openingHoursSpecification": [
          {
            "@type": "OpeningHoursSpecification",
            "dayOfWeek": [
              "Monday",
              "Tuesday",
              "Wednesday",
              "Thursday",
              "Friday"
            ],
            "opens": "09:00",
            "closes": "18:00"
          },
          {
            "@type": "OpeningHoursSpecification",
            "dayOfWeek": "Saturday",
            "opens": "09:00",
            "closes": "14:00"
          }
        ],
        "priceRange": "€€",
        "areaServed": {
          "@type": "AdministrativeArea",
          "name": "Köln"
        }
      }
    }
  </script>
</head>
<body class="bg-white">

  <!-- Header -->
  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-[#0f1e2f]/90 transition duration-300';
    require __DIR__ . '/includes/header.php';
  ?>

<main id="main-content">
<!-- Hero -->
<section id="ueber-uns-hero" class="relative overflow-hidden bg-[#0f1e2f] text-white" aria-labelledby="ueber-uns-heading">
  <div class="absolute inset-0 opacity-40">
    <div class="absolute -left-24 top-12 h-72 w-72 rounded-full bg-[#4e759f] blur-3xl"></div>
    <div class="absolute right-0 top-0 h-80 w-80 rounded-full bg-[#2f506f] blur-3xl"></div>
    <div class="absolute bottom-0 left-8 h-64 w-64 rounded-full bg-[#6793c4] blur-3xl"></div>
  </div>
  <div class="relative mx-auto max-w-6xl px-6 py-20 lg:px-0">
    <div class="grid items-center gap-16 lg:grid-cols-[1.05fr_0.95fr]">
      <div class="space-y-8 text-center lg:text-left">
        <p class="text-xs uppercase tracking-[0.4em] text-white/60">Team &amp; Geschichte seit 1823</p>
        <h1 id="ueber-uns-heading" class="text-3xl font-bold leading-tight text-shadow sm:text-4xl md:text-5xl lg:text-6xl">
          Das Team von Betten-Sauer in Köln
        </h1>
        <p class="mx-auto max-w-2xl text-base text-white/85 sm:text-lg md:text-xl">
          Persönliche Beratung, ehrliche Empfehlungen und über 200 Jahre Schlafkompetenz – lernen Sie die Menschen kennen, die hinter Betten-Sauer stehen.
        </p>
        <div class="flex flex-col gap-3 text-sm text-white/80 sm:flex-row sm:flex-wrap sm:justify-center lg:justify-start">
          <div class="flex items-center gap-3 rounded-full bg-white/5 px-4 py-2">
            <span class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/15 text-base font-semibold text-white">1</span>
            Zertifizierte Schlafexpert:innen
          </div>
          <div class="flex items-center gap-3 rounded-full bg-white/5 px-4 py-2">
            <span class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/15 text-base font-semibold text-white">2</span>
            Werkstatt &amp; Atelier in Köln
          </div>
          <div class="flex items-center gap-3 rounded-full bg-white/5 px-4 py-2">
            <span class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/15 text-base font-semibold text-white">3</span>
            Schlafberatung mit Tradition
          </div>
        </div>
      </div>
      <div class="relative">
        <div class="overflow-hidden rounded-[32px] border border-white/15 bg-white/10 shadow-2xl shadow-black/30 backdrop-blur-sm">
          <img
            src="images/header/header_team.jpg"
            alt="Beratungssituation mit dem Team von Betten-Sauer in Köln"
            loading="eager"
            decoding="async"
            class="h-full w-full object-cover"
          />
        </div>
        <div class="pointer-events-none absolute -left-8 -top-6 hidden h-24 w-24 rounded-full border border-white/30 bg-white/10 blur-2xl md:block"></div>
        <div class="pointer-events-none absolute -bottom-8 -right-6 h-24 w-24 rounded-full border border-white/30 bg-white/10 blur-3xl"></div>
      </div>
    </div>
  </div>
</section> 

  <!-- Team section -->
  <section id="team" class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-6">
      <h2 class="text-3xl font-bold mb-12 text-center">Lernen Sie unser Team kennen</h2>
      <p class="max-w-3xl mx-auto mb-12 text-center text-lg">Unser Team aus zertifizierten Schlafexpertinnen und Schlafexperten begleitet Sie auf dem Weg zu erholsamem Schlaf. Mit jahrzehntelanger Erfahrung, fundiertem Fachwissen und viel Empathie finden wir gemeinsam Ihr perfektes Schlafsystem.</p>
      <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-12">
        <!-- Person Michael -->
        <div class="bg-gray-50 rounded-lg shadow overflow-hidden">
          <img src="images/mitarbeiter/Michael_800.jpg" loading="lazy" decoding="async" alt="Geschäftsführer Michael Gouram im Betten-Sauer Showroom" class="w-full h-[350px] object-cover">
          <div class="p-6 text-center">
            <h3 class="text-xl font-semibold">Michael Gouram</h3>
            <p class="text-sm">Geschäftsführer / Inhaber</p>
            <button class="toggle-btn mt-4 text-[#6793c4] flex items-center justify-center w-full">
              <svg class="w-6 h-6 transform transition-transform" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"/></svg>
            </button>
            <div class="toggle-box hidden mt-4 text-left text-sm bg-white p-4 rounded shadow">
              <p>Michael Gouram wurde am 1.10.1999 nach seiner Lehre als Textil-Einzelhandels-Kaufmann bei der Firma BETTEN-SAUER als Fachverkäufer eingestellt und exakt vier Jahre später Assistent der Geschäftsleitung. Im Laufe der Jahre besuchte er unzählige Seminare, Möbel- und Textilmessen sowie eine Vielzahl von Bettenherstellern. Um unsere Azubis auszubilden legte er die Ausbilder-Eignungsprüfung ab, ebenfalls die Prüfung als Handelsassistenten und als „diplomierter Schlafberater“. Am 1. Januar 2014 hat er die Firma als Inhaber und alleiniger Geschäftsführer übernommen.</p>
            </div>
          </div>
        </div>
        <!-- Person Francois -->
        <div class="bg-gray-50 rounded-lg shadow overflow-hidden">
          <img src="images/mitarbeiter/Francois_800.jpg" loading="lazy" decoding="async" alt="Schlafberater Francois Kaiser von Betten-Sauer Köln" class="w-full h-[350px] object-cover">
          <div class="p-6 text-center">
            <h3 class="text-xl font-semibold">Francois Kaiser</h3>
            <p class="text-sm">Geschäftsleitung &amp; zertifizierter Schlafberater</p>
            <button class="toggle-btn mt-4 text-[#6793c4] flex items-center justify-center w-full">
              <svg class="w-6 h-6 transform transition-transform" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"/></svg>
            </button>
            <div class="toggle-box hidden mt-4 text-left text-sm bg-white p-4 rounded shadow">
              <p>Francois Kaiser ist seit dem 1.8.2011 bei BETTEN-SAUER tätig. Hier wurde er in drei Jahren zum Kaufmann im Einzelhandel ausgebildet. Seine theoretischen Kenntnisse erlernte er auf der Berufsschule, die praktischen bei seiner täglichen Arbeit. Diese umfasste außer diversen Bürotätigkeiten und dem Verkauf des gesamten Sortimentes die Arbeit im Atelier sowie Auslieferungen an unsere Kunden. Waren- und Betriebskunden in der Firma rundeten seine Ausbildung ab. Am 1.7.2014 wurde er wegen seiner guten Leistung als Fachverkäufer von der Firma übernommen. Die Teilnahme an vielen Fachseminaren wurde 2016 gekrönt durch die bestandene Prüfung als „diplomierter Schlafberater“.</p>
            </div>
          </div>
        </div>
        <!-- Person Mehmet -->
        <div class="bg-gray-50 rounded-lg shadow overflow-hidden">
          <img src="images/mitarbeiter/Mehmet_800.jpg" loading="lazy" decoding="async" alt="Fachberater Mehmet Özel bei Betten-Sauer" class="w-full h-[350px] object-cover">
          <div class="p-6 text-center">
            <h3 class="text-xl font-semibold">Mehmet Özel</h3>
            <p class="text-sm">Fachberater</p>
            <button class="toggle-btn mt-4 text-[#6793c4] flex items-center justify-center w-full">
              <svg class="w-6 h-6 transform transition-transform" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"/></svg>
            </button>
            <div class="toggle-box hidden mt-4 text-left text-sm bg-white p-4 rounded shadow">
              <p>Mehmet Özel schloss nach seinem Abitur eine dreijährige Ausbildung bei Möbel Hausmann als Kaufmann im Einzelhandel ab. Waren- und Betriebskunde in der Firma vervollständigen seine Ausbildung. Kurz nach seiner Lehre wechselte Herr Özel als Verkäufer zum Möbelunternehmen Porta, wo er mehrere Jahre in der Schlafzimmer-Abteilung angestellt war. Durch die verschiedenen Abteilungen im Möbelhandel eignete sich Herr Özel ein umfangreiches Wissen an. Seit Mitte 2019 begrüßen wir Herr Özel als Fachverkäufer in unserem Team.</p>
            </div>
          </div>
        </div>
        <!-- Person Andre -->
        <div class="bg-gray-50 rounded-lg shadow overflow-hidden">
          <img src="images/mitarbeiter/Andre_800.jpg" loading="lazy" decoding="async" alt="Filialleiter Andre Conrad von Betten-Sauer Siegburg" class="w-full h-[350px] object-cover">
          <div class="p-6 text-center">
            <h3 class="text-xl font-semibold">Andre Conrad</h3>
            <p class="text-sm">Filialleiter Siegburg</p>
            <button class="toggle-btn mt-4 text-[#6793c4] flex items-center justify-center w-full">
              <svg class="w-6 h-6 transform transition-transform" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"/></svg>
            </button>
            <div class="toggle-box hidden mt-4 text-left text-sm bg-white p-4 rounded shadow">
              <p>Andre Conrad leitet seit 2018 die Filiale Siegburg. Mit seiner Erfahrung aus dem Möbelhandel und einem geschulten Blick für Ergonomie begleitet er Kundinnen und Kunden von der Analyse bis zur finalen Montage ihres Schlafsystems.</p>
            </div>
          </div>
        </div>
        <!-- Person Figen -->
        <div class="bg-gray-50 rounded-lg shadow overflow-hidden">
          <img src="images/mitarbeiter/Figen_800.jpg" loading="lazy" decoding="async" alt="Atelierleiterin Figen Yildiz im Daunen-Atelier" class="w-full h-[350px] object-cover">
          <div class="p-6 text-center">
            <h3 class="text-xl font-semibold">Figen Yildiz</h3>
            <p class="text-sm">Atelierleiterin</p>
            <button class="toggle-btn mt-4 text-[#6793c4] flex items-center justify-center w-full">
              <svg class="w-6 h-6 transform transition-transform" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"/></svg>
            </button>
            <div class="toggle-box hidden mt-4 text-left text-sm bg-white p-4 rounded shadow">
              <p>Bis Ende 2005 war Figen Yildiz in unserem Atelier beschäftigt. Durch die Geburt ihres Sohnes setzte sie eine Weile aus und ist seit 1.1.2014 wieder als Näherin im Daunen-Atelier von BETTEN-SAUER tätig. Hier gehört sowohl die Anfertigung aller Daunendecken und Federkissen als auch der gesamte Service wie das Waschen, Reinigen, Auffüllen und neu Beziehen von Federwaren zu ihren Tätigkeiten. Selbst komplizierteste Aufgaben erledigt sie hier durch ihre langjährige Erfahrung ohne Probleme. Frau Yildiz ist verheiratet, hat drei Kinder und pflegt als Hobby das Nähen – wie in ihrem Beruf.</p>
            </div>
          </div>
        </div>
        <!-- Person Leon -->
        <div class="bg-gray-50 rounded-lg shadow overflow-hidden">
          <img src="images/mitarbeiter/Leon_800.jpg" loading="lazy" decoding="async" alt="Schlafberater Leon Derksen von Betten-Sauer Köln" class="w-full h-[350px] object-cover">
          <div class="p-6 text-center">
            <h3 class="text-xl font-semibold">Leon Derksen</h3>
            <p class="text-sm">Fachberater</p>
            <button class="toggle-btn mt-4 text-[#6793c4] flex items-center justify-center w-full">
              <svg class="w-6 h-6 transform transition-transform" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"/></svg>
            </button>
            <div class="toggle-box hidden mt-4 text-left text-sm bg-white p-4 rounded shadow">
              <p>Leon Derksen verstärkt das Beratungsteam seit 2022. Er verbindet aktuelle Ergonomie-Forschung mit viel Einfühlungsvermögen und erstellt maßgeschneiderte Empfehlungen für Matratzen, Lattenroste und Boxspringbetten.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section id="philosophie" class="py-16 bg-gray-50">
    <div class="max-w-6xl mx-auto px-6 text-center">
      <h2 class="text-3xl font-bold mb-6">Tradition und moderne Schlafberatung in Köln</h2>
      <p class="max-w-4xl mx-auto text-lg mb-10">Seit der Gründung 1823 steht Betten-Sauer für individuelle Schlaflösungen, handgefertigte Bettwaren und zuverlässigen Service. Unsere Expertinnen und Experten verbinden traditionelle Handwerkskunst mit innovativer Schlafdiagnostik, damit Sie jede Nacht regeneriert aufwachen.</p>
      <div class="grid grid-cols-1 md:grid-cols-3 gap-8 text-left">
        <div class="p-6 bg-white rounded-lg shadow">
          <h3 class="text-xl font-semibold mb-3 text-[#6793c4]">Individuelle Schlafberatung</h3>
          <p>Mit dem dormabell-Mess-System und jahrelanger Erfahrung analysieren wir Ihre Schlafgewohnheiten und stellen Matratzen, Lattenroste und Kissen exakt auf Ihre Bedürfnisse ein.</p>
        </div>
        <div class="p-6 bg-white rounded-lg shadow">
          <h3 class="text-xl font-semibold mb-3 text-[#6793c4]">Eigene Manufaktur</h3>
          <p>In unserem Atelier fertigen und pflegen wir Daunen- und Federwaren. So garantieren wir langlebige Qualität und nachhaltige Materialien für Ihren gesunden Schlaf.</p>
        </div>
        <div class="p-6 bg-white rounded-lg shadow">
          <h3 class="text-xl font-semibold mb-3 text-[#6793c4]">Service aus einer Hand</h3>
          <p>Von der Beratung über die Auslieferung bis zur Pflege begleiten wir Sie persönlich – in Köln, im Rheinland und digital über unseren Online-Service.</p>
        </div>
      </div>
    </div>
  </section>

    <!-- Firmengeschichte – Cinematic Story Scroll -->
<section id="geschichte" class="relative w-full">
  <!-- Background layers -->
  <div class="bg-container">
    <div class="bg-panel bg-bieder" id="bg1" style="opacity: 1;"></div>
    <div class="bg-panel bg-war" id="bg2"></div>
    <div class="bg-panel bg-modern" id="bg3"></div>
    <div class="bg-panel bg-future" id="bg4"></div>
  </div>

  <!-- Content panels -->
  <div class="w-full">
    <div class="py-20 flex items-center justify-center bg-transparent z-20">
        <h2 class="text-2xl md:text-2xl font-extrabold text-white text-center uppercase tracking-wider p-8 bg-black/50 rounded-2xl shadow-2xl transition duration-500 ease-in-out">
            Firmengeschichte
        </h2>
    </div>

    <!-- Panel 1: 1797–1881 -->
    <section class="firmengeschichte-panel h-screen flex items-center justify-center px-4">
      <div class="max-w-3xl overlay">
        <h2 class="text-4xl font-bold mb-4">1797–1881: Gründung & Aufbau</h2>
        <p class="text-lg leading-relaxed">
          <strong>1797</strong>: Hermann Joseph Hieb’l wird in Neumark in Böhmen geboren.<br>
          <strong>1821</strong>: In der Zeit des beschaulichen Biedermeiers reist er mit der Postkutsche nach Köln. Aus seiner Heimat bringt er Federn und Daunen mit, die er aus seinem Hotelzimmer „Zum Roten Elefanten“ verkauft.<br>
          <strong>1823</strong>: Er eröffnet das erste Bettengeschäft Kölns an der Großen Neugasse 20 – der Grundstein für die heutige Firma BETTEN-SAUER. Im gleichen Jahr entsteht das Festkomitee des Kölner Karnevals, und der erste Karnevalszug zieht durch Köln.<br>
          <strong>1853</strong>: Nach dem Tod von H. J. Hieb’l übernimmt sein Sohn Rudolf das Geschäft.<br>
          <strong>1881</strong>: Nachfolger von Rudolf wird dessen Neffe Josef Asbach. Er verlegt die Firma in das Haus Nr. 9.
        </p>

        <div class="flex flex-wrap gap-4 mt-6">
          <div class="flex flex-col items-center">
            <img src="images/roadmap/1797.png" loading="lazy" decoding="async" alt="Historische Illustration zur Gründung von Betten-Sauer 1797" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">1797</span>
          </div>
          <div class="flex flex-col items-center">
            <img src="images/roadmap/1823a.jpg" loading="lazy" decoding="async" alt="Erstes Bettenfachgeschäft von Betten-Sauer in Köln im Jahr 1823" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">1823</span>
          </div>
          <div class="flex flex-col items-center">
            <img src="images/roadmap/1823b.jpg" loading="lazy" decoding="async" alt="Zeitgenössische Darstellung des Bettenhauses an der Großen Neugasse 1823" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">1823</span>
          </div>
        </div>
      </div>
    </section>

    <!-- Panel 2: 1915–1954 -->
    <section class="firmengeschichte-panel h-screen flex items-center justify-center px-4">
      <div class="max-w-3xl overlay">
        <h2 class="text-4xl font-bold mb-4">1915–1954: Umbrüche & Wiederaufbau</h2>
        <p class="text-lg leading-relaxed">
          <strong>1915</strong>: Aufteilung der Firma – Josef Asbach übernimmt die Dekorationsabteilung, seine Schwester Maria das Bettenhaus. Ihr Ehemann Heinrich Sauer zieht mit dem Geschäft in die Martinstraße 45, direkt am Gürzenich, Kölns „guter Stube“.<br>
          <strong>1923</strong>: Nach Josefs Tod führt die Witwe Maria Sauer die Firma fort.<br>
          <strong>1929</strong>: Ihr Sohn Heinrich Sauer jun. übernimmt das Geschäft.<br>
          <strong>1942</strong>: Ein Bombenangriff zerstört das Firmengebäude; das Geschäft wird in das Privathaus am Rinderweg 15 in Köln-Brück verlegt.<br>
          <strong>1954</strong>: Nach dem frühen Tod ihres Mannes führt Ehefrau Anni Sauer die Firma weiter. Durch Bettfederreinigung, Matratzenherstellung und Polstermöbel-Aufarbeitung überlebt das Unternehmen die Nachkriegszeit.
        </p>

        <div class="flex flex-wrap gap-4 mt-6">
          <div class="flex flex-col items-center">
            <img src="images/roadmap/1881.png" loading="lazy" decoding="async" alt="Aufzeichnung der Geschäftsübergabe an Josef Asbach 1881" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">1881</span>
          </div>
          <div class="flex flex-col items-center">
            <img src="images/roadmap/1915.png" loading="lazy" decoding="async" alt="Historisches Foto des Standortes Martinstraße 45 aus dem Jahr 1915" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">1915</span>
          </div>
          <div class="flex flex-col items-center">
            <img src="images/roadmap/1929.png" loading="lazy" decoding="async" alt="Portrait von Heinrich Sauer junior, der 1929 das Geschäft übernimmt" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">1929</span>
          </div>
        </div>
      </div>
    </section>

    <!-- Panel 3: 1964–2014 -->
    <section class="firmengeschichte-panel h-screen flex items-center justify-center px-4">
      <div class="max-w-3xl overlay">
        <h2 class="text-4xl font-bold mb-4">1964–2014: Wachstum & Übergabe</h2>
        <p class="text-lg leading-relaxed">
          <strong>1964</strong>: Heinz Sauer übernimmt das Bettenhaus in fünfter Generation.<br>
          <strong>1974</strong>: Umzug zum Brücker Mauspfad 592.<br>
          <strong>1975</strong>: Eröffnung einer Filiale in Bensberg – später wieder geschlossen.<br>
          <strong>1976</strong>: Umzug in eigene größere Räume, Brücker Mauspfad 539 – bis heute der Firmensitz.<br>
          <strong>1979</strong>: Eröffnung einer Filiale in der Dürener Straße 84 in Köln-Lindenthal (später geschlossen).<br>
          <strong>1989</strong>: Anbau zur Erweiterung des Büros mit Kaffeebar und Besprechungsraum.<br>
          <strong>1990</strong>: Umbau und Modernisierung des Ateliers mit neuem Maschinenpark.<br>
          <strong>2002</strong>: Umzug des Außenlagers von Köln-Ostheim nach Köln-Brück in die ehemaligen Sparkassenräume.<br>
          <strong>2014</strong>: Da keine direkten Nachkommen vorhanden sind, übergibt Heinz Sauer die Firma an seinen langjährigen Mitarbeiter Michael Gouram.
        </p>

        <div class="flex flex-wrap gap-4 mt-6">
          <div class="flex flex-col items-center">
            <img src="images/roadmap/1964.jpg" loading="lazy" decoding="async" alt="Heinz Sauer führt das Unternehmen in fünfter Generation ab 1964" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">1964</span>
          </div>
          <div class="flex flex-col items-center">
            <img src="images/roadmap/2014.webp" loading="lazy" decoding="async" alt="Michael Gouram übernimmt Betten-Sauer im Jahr 2014" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">2014</span>
          </div>
        </div>
      </div>
    </section>

    <!-- Panel 4: 2014–heute -->
    <section class="firmengeschichte-panel h-screen flex items-center justify-center px-4">
      <div class="max-w-3xl overlay">
        <h2 class="text-4xl font-bold mb-4">2014–heute: Moderne Tradition & Zukunft</h2>
        <p class="text-lg leading-relaxed">
          <strong>2014</strong>: Michael Gouram übernimmt als Inhaber die Geschäftsführung und führt die Tradition des Hauses fort – mit Respekt für das Erbe und einem klaren Blick in die Zukunft.<br>
          <strong>2015–2020</strong>: Modernisierung des Sortiments, Ausbau der Schlafberatung nach neuesten ergonomischen Erkenntnissen und Integration digitaler Prozesse.<br>
          <strong>2021</strong>: Einführung des digitalen Beratungstools „Sleepy“ und Ausbau des Online-Auftritts – Betten-Sauer wird zur Kombination aus Fachgeschäft und digitaler Schlafmanufaktur.<br>
          <strong>heute</strong>: Betten-Sauer steht für über 200 Jahre Handwerk, Fachwissen und individuelle Beratung – in Köln, online und über die Grenzen hinaus.
        </p>

        <div class="flex flex-wrap gap-4 mt-6">
          <div class="flex flex-col items-center">
            <img src="images/roadmap/uebergabe.jpg" loading="lazy" decoding="async" alt="Übergabe des Unternehmens an Michael Gouram 2014" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">2014</span>
          </div>
          <div class="flex flex-col items-center">
            <img src="images/roadmap/modernesiert.jpg" loading="lazy" decoding="async" alt="Modernisierter Betten-Sauer Showroom 2020" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">2020</span>
          </div>
          <div class="flex flex-col items-center">
            <img src="images/roadmap/team.jpg" loading="lazy" decoding="async" alt="Betten-Sauer Team 2025 im Fachgeschäft Köln" class="w-32 h-32 object-cover rounded-lg border border-white/20">
            <span class="mt-1 text-sm">2025</span>
          </div>
        </div>
      </div>
    </section>

  </div>
</section>

  </main>
  
  <!-- Footer -->
  <?php require __DIR__ . '/includes/footer.php'; ?>

  <!-- Scripts -->
  <script src="js/menu.js"></script>
  <script>
  	 // Header Scroll
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();

    // Accordion toggle
    document.querySelectorAll('.toggle-btn').forEach(btn => {
      btn.addEventListener('click', () => {
        const box  = btn.nextElementSibling;
        const icon = btn.querySelector('svg');
        box.classList.toggle('hidden');
        icon.classList.toggle('rotate-180');
      });
    });
    // GSAP ScrollTrigger for firmengeschichte panels
    gsap.registerPlugin(ScrollTrigger);
    const panels = document.querySelectorAll('.firmengeschichte-panel');
    function setBackground(index) {
      gsap.to('.bg-panel', { opacity: 0, duration: 1, ease: 'power2.out' });
      gsap.to('#bg' + (index + 1), { opacity: 1, duration: 1, ease: 'power2.out' });
    }
    panels.forEach((panel, i) => {
      ScrollTrigger.create({
        trigger: panel,
        start: 'top center',
        end: 'bottom center',
        onEnter: () => setBackground(i),
        onEnterBack: () => setBackground(i)
      });
      gsap.from(panel.querySelector('.overlay'), {
        y: 50,
        opacity: 0,
        duration: 1,
        ease: 'power2.out',
        scrollTrigger: {
          trigger: panel,
          start: 'top 80%',
          toggleActions: 'play none none reverse'
        }
      });
    });
  </script>

</body>
</html>
