<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Individuelle Steppbetten aus eigener Fertigung | Betten Sauer</title>
  <meta name="description" content="Individuelle Steppbetten aus dem Atelier von Betten Sauer: maßgefertigt in Köln und Siegburg. Natur- und Funktionsfüllungen für Allergiker, Naturliebhaber und anspruchsvolle Schläfer." />
  <meta name="keywords" content="Steppbetten, maßgefertigte Bettdecken, Atelier Köln, Atelier Siegburg, Naturhaar Steppbett, Funktionsfaser Decke, Allergiker Bettdecke" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="steppbetten.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="steppbetten.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Individuelle Steppbetten aus eigener Fertigung | Betten Sauer" />
  <meta property="og:description" content="Steppbetten von Hand gearbeitet: Naturhaar oder Funktionsfaser, abgestimmt auf Gewicht, Wärme und Pflege. Beratung in Köln und Siegburg." />
  <meta property="og:image" content="images/1200x800_steppbetten.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Individuelle Steppbetten aus eigener Fertigung | Betten Sauer" />
  <meta name="twitter:description" content="Bettdecken nach Maß – gefertigt in unserem Atelier. Persönliche Beratung, handwerkliche Qualität und Service seit über 120 Jahren." />
  <meta name="twitter:image" content="images/1200x800_steppbetten.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <!-- Hero -->
    <section class="relative" aria-labelledby="hero-heading">
      <div class="relative hidden lg:block">
        <div class="relative h-[360px] sm:h-[420px] md:h-[480px] lg:h-[540px]">
          <img
            src="images/1200x800_steppbetten.webp"
            alt="Atelier von Betten Sauer mit hängenden Decken und handwerklicher Atmosphäre"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
            decoding="async"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/60"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/40 to-[#0f1e2f]/80"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_steppbetten.jpg"
          alt="Steppbetten aus dem Atelier – mobile Ansicht"
          class="hero-mobile-img"
          loading="eager"
          decoding="async"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-6 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center">
        <div class="mx-auto flex max-w-5xl flex-col gap-6 lg:px-12">
          <h1 id="hero-heading" class="text-3xl font-semibold leading-tight text-shadow sm:text-4xl md:text-5xl">
            Individuelle Steppbetten – von Hand gefertigt in Köln und Siegburg.
          </h1>
          <p class="mx-auto max-w-3xl text-base text-white/85 sm:text-lg md:text-xl">
            Weil guter Schlaf kein Zufall ist, sondern Handarbeit.
          </p>
          <p class="mx-auto max-w-3xl text-sm text-white/80 sm:text-base">
            Seit über 120 Jahren fertigen wir Decken und Kissen in eigener Werkstatt – mit Natur- oder Funktionsfüllungen, abgestimmt auf Ihr persönliches Schlafklima.
          </p>
          <div class="pt-2">
            <a href="#kontakt" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
              Beratungstermin vereinbaren
            </a>
          </div>
        </div>
      </div>
    </section>

    <!-- Problem & Nutzen -->
    <section class="bg-white py-16" aria-labelledby="warum-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="warum-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Warum individuell gefertigte Steppbetten?
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Jede Nacht ist anders – deshalb passen wir Gewicht, Füllung und Hülle präzise auf Ihren Körper, Ihr Raumklima und Ihre Vorlieben an.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-8 md:grid-cols-3">
          <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-[#f8fbff] p-8 shadow-lg shadow-[#0f1e2f]/10">
            <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15" aria-hidden="true">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-[#4e759f]" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                <path d="M3 12h18" />
                <path d="M5 16h14" />
                <path d="M7 20h10" />
                <path d="M7 8h10" />
                <path d="M5 4h14" />
              </svg>
            </div>
            <h3 class="text-xl font-semibold text-[#0f1e2f]">Unruhiger Schlaf?</h3>
            <p class="text-base leading-relaxed">Wir stimmen Gewicht, Füllung und Steppung exakt auf Sie ab, damit die Decke ruhig liegt und Schlafbewegungen auffängt.</p>
          </article>
          <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-lg shadow-[#0f1e2f]/10">
            <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15" aria-hidden="true">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-[#4e759f]" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                <path d="M12 2v20" />
                <path d="M5 9a7 7 0 0 1 14 0c0 4-4 7-7 10-3-3-7-6-7-10Z" />
              </svg>
            </div>
            <h3 class="text-xl font-semibold text-[#0f1e2f]">Allergien oder sensible Haut?</h3>
            <p class="text-base leading-relaxed">Wir arbeiten mit hypoallergenen, waschbaren Funktionsfasern und hautfreundlichen Bezügen – individuell verarbeitet.</p>
          </article>
          <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-lg shadow-[#0f1e2f]/10">
            <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15" aria-hidden="true">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-[#4e759f]" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                <path d="M12 2v4" />
                <path d="M12 18v4" />
                <path d="m4.93 4.93 2.83 2.83" />
                <path d="m16.24 16.24 2.83 2.83" />
                <path d="M2 12h4" />
                <path d="M18 12h4" />
                <path d="m4.93 19.07 2.83-2.83" />
                <path d="m16.24 7.76 2.83-2.83" />
                <circle cx="12" cy="12" r="3" />
              </svg>
            </div>
            <h3 class="text-xl font-semibold text-[#0f1e2f]">Nachhaltigkeit wichtig?</h3>
            <p class="text-base leading-relaxed">Wir fertigen regional, reparieren auf Wunsch und nutzen langlebige Materialien, die sich pflegen und auffrischen lassen.</p>
          </article>
        </div>
      </div>
    </section>

    <!-- Füllungsarten -->
    <section class="bg-[#f4f7fb] py-16" aria-labelledby="fuellungen-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="fuellungen-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Wählen Sie Ihre Füllung
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Wir beraten Sie, welche Füllung Ihr gewünschtes Schlafklima unterstützt – von wohlig warm bis federleicht temperiert.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-8 md:grid-cols-2">
          <article class="flex flex-col gap-6 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-lg shadow-[#0f1e2f]/10">
            <div class="flex items-center gap-4">
              <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-[#4e759f]" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                  <path d="M2 12a10 10 0 0 1 20 0c0 5-5 8-10 10-5-2-10-5-10-10Z" />
                  <path d="m8 11 4 4 4-4" />
                </svg>
              </div>
              <h3 class="text-xl font-semibold text-[#0f1e2f]">Naturhaarfüllungen</h3>
            </div>
            <p class="text-base leading-relaxed">Kamelhaar, Schurwolle, Seide oder Leinen schaffen ein atmungsaktives Bettklima. Sie speichern Wärme, lassen Feuchtigkeit entweichen und fühlen sich natürlich an.</p>
            <ul class="space-y-2 text-sm text-gray-600">
              <li>• Ideal für Naturliebhaberinnen und Naturliebhaber mit Wunsch nach regulierendem Schlafklima.</li>
              <li>• Individuelle Wärmegrade durch gezielte Anpassung der Füllmenge.</li>
              <li>• Naturfasern aus kontrollierten, nachvollziehbaren Quellen.</li>
            </ul>
          </article>
          <article class="flex flex-col gap-6 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-lg shadow-[#0f1e2f]/10">
            <div class="flex items-center gap-4">
              <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-[#4e759f]" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                  <path d="M3 9a4 4 0 0 1 4-4h10a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4H7a4 4 0 0 1-4-4Z" />
                  <path d="M7 5h10" />
                  <path d="M7 19h10" />
                  <path d="M12 7v10" />
                </svg>
              </div>
              <h3 class="text-xl font-semibold text-[#0f1e2f]">Funktionsfasern</h3>
            </div>
            <p class="text-base leading-relaxed">Moderne Hightech-Fasern sind pflegeleicht, waschbar und ideal für Allergiker. Sie bleiben formstabil, sind schnell trocknend und leicht im Gewicht.</p>
            <ul class="space-y-2 text-sm text-gray-600">
              <li>• Allergikerfreundlich dank hygienischer Waschbarkeit bis 60&nbsp;°C.</li>
              <li>• Feine Mikrohohlfasern speichern Luft und regulieren Wärme.</li>
              <li>• Perfekt für sensible Haut und alle, die unkomplizierte Pflege lieben.</li>
            </ul>
          </article>
        </div>
      </div>
    </section>

    <!-- Atelier -->
    <section class="bg-white py-16" aria-labelledby="atelier-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="grid grid-cols-1 gap-12 lg:grid-cols-[minmax(0,1fr)_minmax(0,1.05fr)] lg:items-center">
          <div class="space-y-6">
            <h2 id="atelier-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
              Unser Premium-Atelier: Steppbetten mit Handschrift
            </h2>
            <p class="text-base leading-relaxed sm:text-lg">
              In unserem Atelier entstehen Unikate. Jede Decke wird zugeschnitten, gefüllt, gesteppt und geprüft – von einem eingespielten Team, das seit Jahrzehnten mit Stoffen, Nadeln und Füllungen arbeitet.
            </p>
            <p class="text-base leading-relaxed sm:text-lg">
              Wir kontrollieren jeden Arbeitsschritt persönlich. So stellen wir sicher, dass Nähte sauber verlaufen, die Füllung gleichmäßig verteilt ist und das Finish überzeugt. Erst wenn alles stimmt, verlässt das Steppbett unsere Werkstatt.
            </p>
            <blockquote class="rounded-xl border-l-4 border-[#6793c4] bg-[#f8fbff] p-6 text-sm italic text-[#0f1e2f]">
              „Wir glauben, dass guter Schlaf aus ehrlicher Handarbeit entsteht – mit Zeit, Sorgfalt und dem Gespür für Details.“
            </blockquote>
          </div>
          <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
            <figure class="relative h-56 w-full overflow-hidden rounded-2xl bg-gray-200 shadow-lg shadow-[#0f1e2f]/10">
              <div class="absolute inset-0 flex items-center justify-center text-sm text-gray-600">
                <span class="rounded-md bg-white px-3 py-1 shadow">Werkstattfoto – Platzhalter</span>
              </div>
            </figure>
            <figure class="relative h-56 w-full overflow-hidden rounded-2xl bg-gray-200 shadow-lg shadow-[#0f1e2f]/10">
              <div class="absolute inset-0 flex items-center justify-center text-sm text-gray-600">
                <span class="rounded-md bg-white px-3 py-1 shadow">Steppnähte Nahaufnahme – Platzhalter</span>
              </div>
            </figure>
            <figure class="relative h-56 w-full overflow-hidden rounded-2xl bg-gray-200 shadow-lg shadow-[#0f1e2f]/10 sm:col-span-2">
              <div class="absolute inset-0 flex items-center justify-center text-sm text-gray-600">
                <span class="rounded-md bg-white px-3 py-1 shadow">Team bei der Arbeit – Platzhalter</span>
              </div>
            </figure>
          </div>
        </div>
      </div>
    </section>

    <!-- Maßanfertigung & Service -->
    <section class="bg-[#f4f7fb] py-16" aria-labelledby="service-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="service-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Perfekte Passform – in Größe, Gewicht und Wärme
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Sondergrößen bis 240&nbsp;cm Länge sind für uns selbstverständlich. Wenn sich Ihre Bedürfnisse ändern, passen wir Füllung oder Hülle an – damit Ihre Decke ein Leben lang begleitet.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-8 md:grid-cols-3">
          <article class="flex flex-col gap-3 rounded-2xl border border-[#d6e2f1] bg-white p-8 text-center shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Maßarbeit</h3>
            <p class="text-sm leading-relaxed text-gray-600">Sondergrößen, individuelle Steppungen und passgenaue Füllmengen für jede Saison.</p>
          </article>
          <article class="flex flex-col gap-3 rounded-2xl border border-[#d6e2f1] bg-white p-8 text-center shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Änderungsservice</h3>
            <p class="text-sm leading-relaxed text-gray-600">Füllung ergänzen oder reduzieren, neue Hülle oder Reparaturen – unser Team kümmert sich darum.</p>
          </article>
          <article class="flex flex-col gap-3 rounded-2xl border border-[#d6e2f1] bg-white p-8 text-center shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Beratung vor Ort</h3>
            <p class="text-sm leading-relaxed text-gray-600">In Köln und Siegburg erleben Sie Materialien, Temperaturzonen und Gewichte live.</p>
          </article>
        </div>
      </div>
    </section>

    <!-- Kontakt -->
    <section id="kontakt" class="bg-white py-16" aria-labelledby="kontakt-heading">
      <div class="mx-auto max-w-6xl gap-16 px-6 text-gray-700 lg:grid lg:grid-cols-[minmax(0,1fr)_minmax(0,1.05fr)] lg:px-0">
        <div class="space-y-8">
          <h2 id="kontakt-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Unsere Fachberater helfen Ihnen, das perfekte Bettklima zu finden.
          </h2>
          <div class="space-y-6">
            <div class="space-y-3">
              <h3 class="text-xl font-semibold text-[#0f1e2f]">Betten-Sauer Köln</h3>
              <p class="text-base leading-relaxed">
                Brücker Mauspfad 539<br />
                51109 Köln
              </p>
              <ul class="space-y-1 text-base">
                <li>Telefon: <a href="tel:+49221843236" class="text-[#4e759f] underline hover:text-[#2f506f]">0221&nbsp;843236</a></li>
                <li>E-Mail: <a href="mailto:info@betten-sauer.de" class="text-[#4e759f] underline hover:text-[#2f506f]">info@betten-sauer.de</a></li>
              </ul>
              <p class="text-sm text-gray-600">Mo – Fr: 09:30 – 18:30 &bull; Sa: 10:00 – 14:00</p>
            </div>
            <div class="space-y-3">
              <h3 class="text-xl font-semibold text-[#0f1e2f]">Betten-Sauer by Inhausen</h3>
              <p class="text-base leading-relaxed">
                Cecilienstraße 8<br />
                53721 Inhausen
              </p>
              <ul class="space-y-1 text-base">
                <li>Telefon: <a href="tel:+4922412414230" class="text-[#4e759f] underline hover:text-[#2f506f]">02241&nbsp;2414230</a></li>
              </ul>
              <p class="text-sm text-gray-600">Mo – Fr: 10:00 – 18:00 &bull; Sa: 10:00 – 14:00</p>
            </div>
          </div>
        </div>
        <div>
          <form action="lead.php" method="POST" class="rounded-2xl border border-[#dce4ef] bg-white p-8 shadow-xl shadow-[#0f1e2f]/10" novalidate aria-describedby="kontakt-form-info">
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
              <div>
                <label for="kontakt-name" class="mb-1 block text-sm font-semibold text-gray-800">Name *</label>
                <input
                  type="text"
                  id="kontakt-name"
                  name="name"
                  required
                  aria-required="true"
                  autocomplete="name"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
              <div>
                <label for="kontakt-email" class="mb-1 block text-sm font-semibold text-gray-800">E-Mail *</label>
                <input
                  type="email"
                  id="kontakt-email"
                  name="email"
                  required
                  aria-required="true"
                  autocomplete="email"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
            </div>
            <div class="mt-6">
              <label for="kontakt-nachricht" class="mb-1 block text-sm font-semibold text-gray-800">Nachricht *</label>
              <textarea
                id="kontakt-nachricht"
                name="nachricht"
                rows="6"
                required
                aria-required="true"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              ></textarea>
            </div>
            <div class="mt-6">
              <label for="kontakt-standort" class="mb-1 block text-sm font-semibold text-gray-800">Bevorzugter Standort</label>
              <select
                id="kontakt-standort"
                name="standort"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              >
                <option value="">Bitte auswählen</option>
                <option value="koeln">Köln</option>
                <option value="inhausen">Inhausen</option>
                <option value="telefonisch">Telefonisch / digital</option>
              </select>
            </div>
            <div class="mt-6 flex items-start gap-3">
              <input
                type="checkbox"
                id="kontakt-datenschutz"
                name="datenschutz"
                required
                aria-required="true"
                class="mt-1 h-5 w-5 cursor-pointer rounded border-gray-300 text-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:ring-offset-0"
              />
              <label for="kontakt-datenschutz" class="text-sm leading-relaxed text-gray-700">
                Ich bin damit einverstanden, dass Betten Sauer meine Angaben zur Kontaktaufnahme verarbeitet.
                Mehr Informationen in der <a href="datenschutz.php" class="text-[#4e759f] underline hover:text-[#2f506f]">Datenschutzerklärung</a>.
              </label>
            </div>
            <div class="mt-6">
              <div class="rounded-md border border-dashed border-gray-300 bg-gray-50 p-4 text-center text-sm text-gray-500">
                reCAPTCHA Platzhalter – hinterlegen Sie Ihren Site-Key für den Live-Betrieb.
              </div>
            </div>
            <div class="mt-8">
              <button type="submit" class="w-full rounded-lg bg-[#6793c4] px-6 py-3 text-base font-semibold text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-4 focus-visible:ring-[#4e759f]/30">
                Absenden
              </button>
            </div>
          </form>
          <p id="kontakt-form-info" class="mt-4 text-xs text-gray-500">
            Alle mit * gekennzeichneten Felder sind Pflichtfelder.
          </p>
        </div>
      </div>
    </section>

  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
