<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Motorisch verstellbare Seniorenbetten | Betten Sauer</title>
  <meta name="description" content="Motorisch verstellbare Seniorenbetten von Kirchner: leichter aufstehen, sicherer liegen und wohnliches Design ohne Pflegebett-Optik. Persönliche Beratung in Köln und Inhausen." />
  <meta name="keywords" content="Seniorenbetten, Komfortbetten, motorisch verstellbares Bett, Kirchner Bett, Aufstehhilfe Bett, Seniorenbett Köln, Seniorenbett Inhausen" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="seniorenbetten.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="seniorenbetten.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Motorisch verstellbare Seniorenbetten | Betten Sauer" />
  <meta property="og:description" content="Kirchner Liftsysteme für motorisch verstellbare Betten – leise, sicher und stilvoll. Persönliche Beratung bei Betten Sauer in Köln &amp; Inhausen." />
  <meta property="og:image" content="images/1200x800_seniorenbetten.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Motorisch verstellbare Seniorenbetten | Betten Sauer" />
  <meta name="twitter:description" content="Erleben Sie motorisch verstellbare Komfortbetten, die beim Aufstehen helfen, ohne wie ein Pflegebett auszusehen. Beratung vor Ort bei Betten Sauer." />
  <meta name="twitter:image" content="images/1200x800_seniorenbetten.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <!-- Hero Section -->
    <section class="relative overflow-hidden bg-[#0f1e2f] text-white" aria-labelledby="hero-heading">
      <div class="absolute inset-0 opacity-40">
        <div class="absolute -left-24 top-12 h-72 w-72 rounded-full bg-[#4e759f] blur-3xl"></div>
        <div class="absolute right-0 top-0 h-80 w-80 rounded-full bg-[#2f506f] blur-3xl"></div>
        <div class="absolute bottom-0 left-8 h-64 w-64 rounded-full bg-[#6793c4] blur-3xl"></div>
      </div>
      <div class="relative mx-auto max-w-6xl px-6 py-20 lg:px-0">
        <div class="grid items-center gap-16 lg:grid-cols-[1.05fr_0.95fr]">
          <div class="space-y-8 text-center lg:max-w-3xl lg:text-left">
            <p class="text-xs uppercase tracking-[0.4em] text-white/60">Komfortbetten von Kirchner</p>
            <h1 id="hero-heading" class="text-3xl font-semibold leading-tight text-shadow sm:text-4xl md:text-5xl lg:text-6xl">
              Leichter aufstehen. Sicherer liegen. Komfort, der bleibt.
            </h1>
            <p class="mx-auto max-w-2xl text-base text-white/85 sm:text-lg md:text-xl">
              Motorisch verstellbare Betten von Kirchner – für mehr Lebensqualität im Alltag. Elegant, leise und intuitiv bedienbar.
            </p>
            <div class="flex flex-col items-center gap-4 pt-4 sm:flex-row sm:flex-wrap sm:justify-center lg:justify-start">
              <a href="#beratung" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-8 py-3 text-base font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                Beratung vereinbaren
              </a>
              <ul class="grid gap-3 text-sm text-white/85 sm:grid-cols-3 sm:text-left">
                <li class="flex items-center gap-3 rounded-full bg-white/5 px-4 py-2">
                  <span class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/15 text-base font-semibold text-white">1</span>
                  Sanft aufstehen per Liftsystem
                </li>
                <li class="flex items-center gap-3 rounded-full bg-white/5 px-4 py-2">
                  <span class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/15 text-base font-semibold text-white">2</span>
                  Bedienung per Fernbedienung &amp; App
                </li>
                <li class="flex items-center gap-3 rounded-full bg-white/5 px-4 py-2">
                  <span class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/15 text-base font-semibold text-white">3</span>
                  Stilvolle Rahmen statt Pflege-Optik
                </li>
              </ul>
            </div>
            <p class="text-xs uppercase tracking-[0.4em] text-white/60">Köln &bull; Inhausen &bull; Vor-Ort Beratung</p>
          </div>
          <div class="relative w-full">
            <div class="overflow-hidden rounded-[32px] border border-white/15 bg-white/10 shadow-2xl shadow-black/30 backdrop-blur-sm">
              <img
                src="images/header/header_senioren.jpg"
                alt="Seniorenbett mit integrierter Aufstehhilfe im Betten-Sauer Showroom"
                loading="eager"
                decoding="async"
                class="h-full w-full object-cover"
              />
            </div>
            <div class="pointer-events-none absolute -left-8 -top-6 hidden h-24 w-24 rounded-full border border-white/30 bg-white/10 blur-2xl md:block"></div>
            <div class="pointer-events-none absolute -bottom-8 -right-6 h-24 w-24 rounded-full border border-white/30 bg-white/10 blur-3xl"></div>
          </div>
        </div>
      </div>
    </section>

    <!-- Problem & Nutzenbereich -->
    <section class="bg-white py-16" aria-labelledby="nutzen-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="nutzen-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Was Ihnen Sorgen macht, lösen wir mit Komfort &amp; Design
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Motorisch verstellbare Betten von Kirchner vereinen Aufstehhilfe, ergonomische Liegepositionen und wohnliches Design. Jedes Detail ist darauf ausgelegt, Sicherheit zu geben, ohne auf Wohlfühloptik verzichten zu müssen.
          </p>
        </div>

        <div class="grid grid-cols-1 gap-8 md:grid-cols-3">
          <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-[#f8fbff] p-8 shadow-lg shadow-[#0f1e2f]/10">
            <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15 text-2xl text-[#4e759f]" aria-hidden="true">↑</div>
            <h3 class="text-xl font-semibold text-[#0f1e2f]">Das Aufstehen fällt schwer?</h3>
            <p class="text-base leading-relaxed">Unser integriertes Liftsystem hebt Sie sanft an. Sie richten sich kontrolliert auf, entlasten Ihren Kreislauf und gewinnen jeden Morgen Sicherheit.</p>
          </article>
          <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-lg shadow-[#0f1e2f]/10">
            <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15 text-2xl text-[#4e759f]" aria-hidden="true">◎</div>
            <h3 class="text-xl font-semibold text-[#0f1e2f]">Sie möchten Stil statt Klinik-Design?</h3>
            <p class="text-base leading-relaxed">Wir integrieren die Technik unsichtbar in moderne Bettrahmen. Sie wählen Stoffe, Hölzer und Kopfteile, die sich harmonisch in Ihr Schlafzimmer einfügen.</p>
          </article>
          <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-lg shadow-[#0f1e2f]/10">
            <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15 text-2xl text-[#4e759f]" aria-hidden="true">✓</div>
            <h3 class="text-xl font-semibold text-[#0f1e2f]">Komfort ohne komplizierte Steuerung?</h3>
            <p class="text-base leading-relaxed">Per Funkfernbedienung oder App stellen Sie Liegeposition, Sitzhöhe und Licht ein. Die Steuerung reagiert leise, schnell und intuitiv – ohne technische Hürden.</p>
          </article>
        </div>
      </div>
    </section>

    <!-- Funktionsbereich -->
    <section class="bg-[#f4f7fb] py-16" aria-labelledby="funktion-heading">
      <div class="mx-auto flex max-w-6xl flex-col gap-12 px-6 lg:flex-row lg:items-start lg:px-0">
        <div class="lg:w-1/2">
          <h2 id="funktion-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            So funktioniert das integrierte Liftsystem
          </h2>
          <p class="mt-4 text-base leading-relaxed text-gray-700 sm:text-lg">
            Der motorisierte Rahmen hebt die Liegefläche millimetergenau an. Sie gelangen ohne Kraftaufwand in eine sichere Sitzposition und gleiten anschließend kontrolliert zurück in die Liegeposition. Alles funktioniert geräuscharm, bestens abgestimmt auf Ihre Bewegungsabläufe.
          </p>
          <ul class="mt-6 space-y-4 text-base leading-relaxed text-gray-700">
            <li class="flex items-start gap-3">
              <span class="mt-1 inline-flex h-6 w-6 flex-none items-center justify-center rounded-full bg-[#6793c4]/20 text-sm font-semibold text-[#4e759f]">1</span>
              Wahlweise Bedienung über kabelgebundene oder kabellose Fernbedienung, optional via App – auch mit Memory-Funktionen.
            </li>
            <li class="flex items-start gap-3">
              <span class="mt-1 inline-flex h-6 w-6 flex-none items-center justify-center rounded-full bg-[#6793c4]/20 text-sm font-semibold text-[#4e759f]">2</span>
              Sicherheitsabschaltung mit sensibler Hinderniserkennung und Notabsenkung gewährleistet Schutz in jeder Situation.
            </li>
            <li class="flex items-start gap-3">
              <span class="mt-1 inline-flex h-6 w-6 flex-none items-center justify-center rounded-full bg-[#6793c4]/20 text-sm font-semibold text-[#4e759f]">3</span>
              Synchron laufende Motoren bewegen sich leise und gleichmäßig – perfekt für Partnerbetten und ungestörte Nächte.
            </li>
          </ul>
        </div>
        <div class="flex flex-col gap-10 lg:w-1/2">
          <figure class="relative aspect-video w-full overflow-hidden rounded-2xl shadow-xl shadow-[#0f1e2f]/20">
            <iframe
              class="h-full w-full"
              src="https://www.youtube.com/embed/g5oDqnoQFBs?rel=0"
              title="Einfach aufstehen – demonstriert im Showroom"
              loading="lazy"
              allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
              allowfullscreen
            ></iframe>
          </figure>
          <figure class="relative overflow-hidden rounded-2xl border border-dashed border-[#b8cbe2] bg-white p-4 text-center shadow-lg shadow-[#0f1e2f]/10">
            <figcaption class="mb-4 text-lg font-semibold text-[#4e759f]">Mechanischer Bewegungsablauf</figcaption>
            <img
              src="images/produktbilder/seniorenbett/strichzeichnung.jpg"
              alt="Strichzeichnung des mechanischen Bewegungsablaufs des Seniorenbetts"
              loading="lazy"
              decoding="async"
              class="h-auto w-full rounded-xl border border-[#d6e2f1] bg-[#f4f7fb] object-contain"
            />
          </figure>
        </div>
      </div>
    </section>

    <!-- Variantenwahl -->
    <section class="bg-white py-16" aria-labelledby="varianten-heading">
      <div class="mx-auto max-w-6xl space-y-12 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="varianten-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Wählen Sie Ihren Stil – Boxlike oder Classic
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Ob textile Wohlfühloptik oder zeitlose Holzgestaltung: Beide Varianten verbergen die Technik elegant und lassen sich individuell konfigurieren.
          </p>
        </div>

        <div class="grid grid-cols-1 gap-10 md:grid-cols-2">
          <article class="flex flex-col overflow-hidden rounded-2xl border border-[#dce4ef] bg-white shadow-lg shadow-[#0f1e2f]/10">
            <figure class="relative">
              <img
                src="images/1200x800_boxspringbett.webp"
                alt="Boxlike Bettvariante mit textiler, wohnlicher Optik"
                class="h-64 w-full object-cover"
                loading="lazy"
                decoding="async"
              />
            </figure>
            <div class="flex flex-1 flex-col gap-4 p-8">
              <h3 class="text-xl font-semibold text-[#0f1e2f]">Boxlike</h3>
              <p class="text-base leading-relaxed">Die textile, wohnliche Optik integriert Motoren und Hebekolben unsichtbar. Ideal für Liebhaberinnen und Liebhaber moderner Boxbetten, die Ruhe und Ästhetik schätzen.</p>
              <ul class="mt-2 space-y-2 text-sm text-gray-600">
                <li>• Individuelle Stoffkollektionen und weich gepolsterte Kopfteile.</li>
                <li>• Optionale LED-Ambientebeleuchtung sorgt für Orientierung in der Nacht.</li>
                <li>• Perfekt kombinierbar mit Doppelmotor-Lattenrosten und Komfortmatratzen.</li>
              </ul>
            </div>
          </article>
          <article class="flex flex-col overflow-hidden rounded-2xl border border-[#dce4ef] bg-white shadow-lg shadow-[#0f1e2f]/10">
            <figure class="relative">
              <img
                src="images/1200x800_bettgestell.webp"
                alt="Classic Bettvariante mit sichtbarer Holzstruktur"
                class="h-64 w-full object-cover"
                loading="lazy"
                decoding="async"
              />
            </figure>
            <div class="flex flex-1 flex-col gap-4 p-8">
              <h3 class="text-xl font-semibold text-[#0f1e2f]">Classic</h3>
              <p class="text-base leading-relaxed">Klare Linien, edle Hölzer oder lackierte Oberflächen – die Classic-Variante verbindet traditionelle Formensprache mit moderner Technik im Inneren.</p>
              <ul class="mt-2 space-y-2 text-sm text-gray-600">
                <li>• Variable Einstiegshöhen und Seitenteile für sicheren Halt.</li>
                <li>• Maßanfertigungen für bestehende Matratzen und Lattenroste möglich.</li>
                <li>• Pflegeleichte Holz- &amp; Dekoroberflächen mit natürlicher Haptik.</li>
              </ul>
            </div>
          </article>
        </div>
      </div>
    </section>

    <!-- Sonderausstattungen -->
    <section class="bg-[#f4f7fb] py-16" aria-labelledby="ausstattung-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="ausstattung-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Mehr Komfort auf Wunsch
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Stellen Sie Ihr Bett nach Ihren Bedürfnissen zusammen – modular, nachrüstbar und abgestimmt auf Ihren Alltag.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3">
          <article class="flex flex-col gap-3 rounded-xl border border-[#d6e2f1] bg-white p-6 shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Rollen</h3>
            <p class="text-sm leading-relaxed text-gray-600">Für flexible Raumgestaltung – fest arretierbar und bodenschonend.</p>
          </article>
          <article class="flex flex-col gap-3 rounded-xl border border-[#d6e2f1] bg-white p-6 shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Beleuchtung</h3>
            <p class="text-sm leading-relaxed text-gray-600">Orientierungslicht unter dem Bett aktiviert sich nachts automatisch.</p>
          </article>
          <article class="flex flex-col gap-3 rounded-xl border border-[#d6e2f1] bg-white p-6 shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Bettideen</h3>
            <p class="text-sm leading-relaxed text-gray-600">Praktische Stauraum-Lösungen wie Bettkästen oder Lift-Deckel.</p>
          </article>
          <article class="flex flex-col gap-3 rounded-xl border border-[#d6e2f1] bg-white p-6 shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Seitenschutz</h3>
            <p class="text-sm leading-relaxed text-gray-600">Sicher schlafen ohne Einschränkung – absenkbar und stoffbezogen.</p>
          </article>
          <article class="flex flex-col gap-3 rounded-xl border border-[#d6e2f1] bg-white p-6 shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Clevere Lösungen</h3>
            <p class="text-sm leading-relaxed text-gray-600">Von USB-Ladestationen bis hin zu Haltegriffen – alles individuell ergänzbar.</p>
          </article>
          <article class="flex flex-col gap-3 rounded-xl border border-[#d6e2f1] bg-white p-6 shadow-md shadow-[#0f1e2f]/10">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">Komfortsteuerung</h3>
            <p class="text-sm leading-relaxed text-gray-600">Per App oder Memory-Funktion Lieblingspositionen speichern und abrufen.</p>
          </article>
        </div>
      </div>
    </section>

    <!-- Galerie -->
    <section class="bg-white py-16" aria-labelledby="galerie-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="galerie-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Inspiration aus echten Schlafzimmern
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Warme Lichtstimmungen, natürliche Materialien und Technik, die diskret bleibt – so integrieren Kundinnen und Kunden unsere Systeme zu Hause.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3">
          <figure class="overflow-hidden rounded-2xl shadow-lg shadow-[#0f1e2f]/15">
            <img src="images/1200x800_seniorenbetten.webp" alt="Seniorenbett mit Holzrahmen und integrierter Aufstehhilfe in warmem Licht" class="h-64 w-full object-cover" loading="lazy" decoding="async" />
          </figure>
          <figure class="overflow-hidden rounded-2xl shadow-lg shadow-[#0f1e2f]/15">
            <img src="images/1200x800_boxspringbett.webp" alt="Textiles Komfortbett mit indirekter Beleuchtung im Schlafzimmer" class="h-64 w-full object-cover" loading="lazy" decoding="async" />
          </figure>
          <figure class="overflow-hidden rounded-2xl shadow-lg shadow-[#0f1e2f]/15">
            <img src="images/1200x800_bettgestell.webp" alt="Modernes Bettgestell mit strukturierter Wand und Liftsystem" class="h-64 w-full object-cover" loading="lazy" decoding="async" />
          </figure>
          <figure class="overflow-hidden rounded-2xl shadow-lg shadow-[#0f1e2f]/15 sm:col-span-2 lg:col-span-3">
            <img src="images/1200x800_matratzen.webp" alt="Großzügiges Doppelbett mit motorischer Verstellung und wohnlichen Accessoires" class="h-80 w-full object-cover" loading="lazy" decoding="async" />
          </figure>
        </div>
      </div>
    </section>

    <!-- Beratung & Kontakt -->
    <section id="beratung" class="bg-[#0f1e2f] py-16 text-white" aria-labelledby="beratung-heading">
      <div class="mx-auto max-w-6xl gap-12 px-6 lg:grid lg:grid-cols-[minmax(0,0.95fr)_minmax(0,1.05fr)] lg:px-0">
        <div class="space-y-6">
          <h2 id="beratung-heading" class="text-2xl font-semibold sm:text-3xl">
            Individuelle Beratung bei Betten Sauer
          </h2>
          <p class="text-base leading-relaxed text-white/85 sm:text-lg">
            Unsere Fachberater erklären Ihnen gerne, welche Systeme zu Ihnen passen. In Köln oder Inhausen – mit 120&nbsp;Jahren Erfahrung.
          </p>
          <p class="text-base leading-relaxed text-white/80 sm:text-lg">
            Wir nehmen uns Zeit, hören zu und begleiten Sie vom ersten Kennenlernen bis zur Montage bei Ihnen zu Hause. Auf Wunsch koordinieren wir uns mit Angehörigen, Pflegekräften oder Therapeutinnen.
          </p>
          <div class="space-y-3 text-sm text-white/75">
            <p><strong class="text-white">Persönliche Beratung:</strong> Brücker Mauspfad 539, 51109 Köln &bull; Cecilienstraße 8, 53721 Inhausen</p>
            <p>Telefon Köln: <a href="tel:+49221843236" class="underline hover:text-white">0221 843236</a> &bull; Telefon Inhausen: <a href="tel:+4922412414230" class="underline hover:text-white">02241 2414230</a></p>
          </div>
        </div>
        <div class="mt-10 lg:mt-0">
          <form action="lead.php" method="POST" class="rounded-2xl bg-white p-8 text-left shadow-2xl shadow-black/20" novalidate aria-describedby="beratung-form-info">
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
              <div>
                <label for="beratung-name" class="mb-1 block text-sm font-semibold text-gray-800">Name *</label>
                <input
                  type="text"
                  id="beratung-name"
                  name="name"
                  required
                  aria-required="true"
                  autocomplete="name"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
              <div>
                <label for="beratung-email" class="mb-1 block text-sm font-semibold text-gray-800">E-Mail *</label>
                <input
                  type="email"
                  id="beratung-email"
                  name="email"
                  required
                  aria-required="true"
                  autocomplete="email"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
            </div>
            <div class="mt-6">
              <label for="beratung-nachricht" class="mb-1 block text-sm font-semibold text-gray-800">Nachricht *</label>
              <textarea
                id="beratung-nachricht"
                name="nachricht"
                rows="6"
                required
                aria-required="true"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              ></textarea>
            </div>
            <div class="mt-6">
              <label for="beratung-standort" class="mb-1 block text-sm font-semibold text-gray-800">Bevorzugter Standort</label>
              <select
                id="beratung-standort"
                name="standort"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              >
                <option value="">Bitte auswählen</option>
                <option value="koeln">Köln</option>
                <option value="inhausen">Inhausen</option>
                <option value="telefonisch">Telefonisch / digital</option>
              </select>
            </div>
            <div class="mt-6 flex items-start gap-3">
              <input
                type="checkbox"
                id="beratung-datenschutz"
                name="datenschutz"
                required
                aria-required="true"
                class="mt-1 h-5 w-5 cursor-pointer rounded border-gray-300 text-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:ring-offset-0"
              />
              <label for="beratung-datenschutz" class="text-sm leading-relaxed text-gray-700">
                Ich bin damit einverstanden, dass Betten Sauer meine Angaben zur Kontaktaufnahme verarbeitet.
                Mehr Informationen in der <a href="datenschutz.php" class="text-[#4e759f] underline hover:text-[#2f506f]">Datenschutzerklärung</a>.
              </label>
            </div>
            <div class="mt-6">
              <div class="rounded-md border border-dashed border-gray-300 bg-gray-50 p-4 text-center text-sm text-gray-500">
                reCAPTCHA Platzhalter – aktivieren Sie Ihren Site-Key für den Live-Betrieb.
              </div>
            </div>
            <div class="mt-8">
              <button type="submit" class="w-full rounded-lg bg-[#6793c4] px-6 py-3 text-base font-semibold text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-4 focus-visible:ring-[#4e759f]/30">
                Termin vereinbaren
              </button>
            </div>
          </form>
          <p id="beratung-form-info" class="mt-4 text-xs text-white/60">
            Alle mit * gekennzeichneten Felder sind Pflichtfelder. Wir melden uns werktags innerhalb von 24&nbsp;Stunden.
          </p>
        </div>
      </div>
    </section>

  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
