<?php
declare(strict_types=1);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.html');
    exit;
}

$name = trim(filter_input(INPUT_POST, 'name', FILTER_SANITIZE_SPECIAL_CHARS) ?? '');
$telefon = trim(filter_input(INPUT_POST, 'telefon', FILTER_SANITIZE_SPECIAL_CHARS) ?? '');
$zeit = trim(filter_input(INPUT_POST, 'zeit', FILTER_SANITIZE_SPECIAL_CHARS) ?? '');
$datenschutz = filter_input(INPUT_POST, 'datenschutz', FILTER_SANITIZE_SPECIAL_CHARS);

$errors = [];
if ($name === '') {
    $errors[] = 'Bitte geben Sie Ihren Namen an.';
}
if ($telefon === '') {
    $errors[] = 'Bitte geben Sie Ihre Telefonnummer an.';
}
if ($datenschutz === null) {
    $errors[] = 'Bitte stimmen Sie der Datenschutzerklärung zu.';
}

if ($errors) {
    http_response_code(400);
    echo renderResponse('Fehler beim Absenden', implode('<br>', $errors), true);
    exit;
}

$to = 'aresfight@gmail.com';
$subject = 'Neue Rückruf-Anfrage über Betten-Sauer';
$message = "Neue Rückruf-Anfrage:\n\n"
    . "Name: {$name}\n"
    . "Telefon: {$telefon}\n"
    . "Bevorzugte Zeit: " . ($zeit !== '' ? $zeit : 'Keine Angabe') . "\n"
    . "Datenschutz: Zustimmung erteilt.";
$headers = [
    'Content-Type: text/plain; charset=utf-8',
    'From: no-reply@betten-sauer.de',
    'Reply-To: no-reply@betten-sauer.de',
];

mail($to, $subject, $message, implode("\r\n", $headers));

echo renderResponse(
    'Vielen Dank!',
    'Wir haben Ihre Rückruf-Anfrage erhalten und melden uns schnellstmöglich bei Ihnen.',
    false
);
exit;

function renderResponse(string $title, string $body, bool $isError): string
{
    $statusColor = $isError ? '#dc2626' : '#16a34a';
    $linkHref = 'index.html#top';
    $linkText = 'Zurück zur Startseite';

    return <<<HTML
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{$title}</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f7f7f7; color: #111827; margin: 0; padding: 0; }
        .wrapper { max-width: 540px; margin: 80px auto; padding: 32px; background: #fff; border-radius: 16px; box-shadow: 0 20px 45px rgba(15, 23, 42, 0.12); text-align: center; }
        h1 { color: {$statusColor}; font-size: 24px; margin-bottom: 16px; }
        p { line-height: 1.6; margin-bottom: 24px; }
        a { display: inline-block; padding: 12px 24px; background: #6793c4; color: #fff; border-radius: 9999px; text-decoration: none; font-weight: bold; transition: background 0.2s ease; }
        a:hover { background: #4e759f; }
    </style>
</head>
<body>
    <div class="wrapper">
        <h1>{$title}</h1>
        <p>{$body}</p>
        <a href="{$linkHref}">{$linkText}</a>
    </div>
</body>
</html>
HTML;
}
