<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Projekt-Roadmap – Betten Sauer</title>
  <meta name="description" content="Transparente Projekt-Roadmap für den Website- und Shop-Relaunch von Betten Sauer (HTML-Website + PrestaShop)." />
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      /* Marke Betten Sauer (anpassbar) */
      --brand:#6793c4;
      --brand-dark:#3a6ea6;
      --ink:#3a3a3a;
      --muted:#f6f7fb;
      --ok:#1fa971;
      --warn:#f59e0b;
      --todo:#cbd5e1;
      --bg:#ffffff;
      --card:#ffffff;
      --shadow: 0 8px 24px rgba(0,0,0,.06);
      --radius:16px;
    }
    *{box-sizing:border-box}
    html,body{margin:0;background:var(--bg);color:var(--ink);font:16px/1.5 system-ui, -apple-system, "Segoe UI", Roboto, Inter, "Helvetica Neue", Arial, "Noto Sans", "Apple Color Emoji", "Segoe UI Emoji";}
    .wrap{max-width:1100px;margin-inline:auto;padding:120px 20px 80px}
    header { transition: background 0.3s ease, box-shadow 0.3s ease; }
    header.scrolled { background: rgba(255,255,255,0.95); box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    header.scrolled a { color: #3a3a3a !important; text-shadow: none; }
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
    .head{display:flex;flex-wrap:wrap;align-items:flex-start;gap:16px;justify-content:space-between;margin-bottom:20px}
    .title{font-weight:700;font-size:clamp(20px,3vw,30px);letter-spacing:.1px;margin:0}
    .subtitle{margin:0;color:#64748b}
    .legend{display:flex;flex-wrap:wrap;gap:10px;align-items:center}
    .chip{display:inline-flex;align-items:center;gap:8px;border-radius:999px;padding:6px 10px;background:var(--muted);font-size:14px}
    .dot{width:10px;height:10px;border-radius:50%}
    .dot.ok{background:var(--ok)}
    .dot.doing{background:var(--warn)}
    .dot.todo{background:var(--todo)}

    /* Progress */
    .progress{background:var(--muted);border-radius:999px;position:relative;height:14px;box-shadow:inset 0 0 0 1px rgba(0,0,0,.04)}
    .bar{height:100%;width:0%;background:linear-gradient(90deg,var(--brand),var(--brand-dark));border-radius:999px;transition:width .6s ease}
    .progress-row{display:grid;grid-template-columns:1fr auto;align-items:center;gap:14px;margin:10px 0 24px}
    .percent{font-variant-numeric:tabular-nums;min-width:64px;text-align:right;font-weight:700}

    /* Timeline */
    .timeline{
      display:grid;
      grid-template-columns:repeat(5, minmax(220px,1fr));
      gap:16px;
    }
    @media (max-width:1000px){ .timeline{grid-template-columns:repeat(3,1fr)} }
    @media (max-width:720px){ .timeline{grid-template-columns:1fr} }

    .phase{
      background:var(--card);
      border-radius:var(--radius);
      box-shadow:var(--shadow);
      padding:44px 22px 24px;
      border:1px solid rgba(0,0,0,.05);
      position:relative;
    }
    .phase h3{margin:0 0 6px;font-size:18px}
    .badge{
      position:absolute;top:12px;right:12px;
      font-size:12px;padding:4px 8px;border-radius:999px;
      background:var(--muted);color:#475569;border:1px solid rgba(0,0,0,.06)
    }
    .badge[data-s="done"]{background:rgba(31,169,113,.12);color:#116845;border-color:rgba(31,169,113,.25)}
    .badge[data-s="doing"]{background:rgba(245,158,11,.12);color:#8a5a06;border-color:rgba(245,158,11,.25)}
    .badge[data-s="todo"]{background:rgba(203,213,225,.35);color:#475569;border-color:rgba(71,85,105,.15)}
    .meta{font-size:13px;color:#64748b;margin:0 0 10px}
    .list{margin:0;padding-left:18px}
    .list li{margin:4px 0}
    .note{margin:12px 0 0;font-size:13px;background:var(--muted);border-radius:12px;padding:10px 12px}

    /* Overall footer note */
    .foot{margin-top:22px;color:#64748b;font-size:13px}

    /* Reduced motion */
    @media (prefers-reduced-motion: reduce){
      .bar{transition:none}
    }
  </style>
</head>
<body>

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-[#0f1e2f]/90 transition duration-300';
    require __DIR__ . '/includes/header.php';
  ?>

  <main class="wrap" aria-labelledby="roadmap-title">
    <header class="head">
      <div>
        <h1 id="roadmap-title" class="title">Projekt-Roadmap · Betten Sauer – Website (HTML) &amp; Shop (PrestaShop)</h1>
        <p class="subtitle" id="roadmap-updated">Stand: 16.10.2025 · Statusüberblick &amp; Meilensteine</p>
      </div>
      <div class="legend" aria-label="Legende">
        <span class="chip"><span class="dot ok" aria-hidden="true"></span> Abgeschlossen</span>
        <span class="chip"><span class="dot doing" aria-hidden="true"></span> In Arbeit</span>
        <span class="chip"><span class="dot todo" aria-hidden="true"></span> Geplant</span>
      </div>
    </header>

    <!-- Gesamtfortschritt -->
    <div class="progress-row" aria-live="polite">
      <div class="progress" aria-label="Projektfortschritt gesamt" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0" role="progressbar">
        <div class="bar" id="progressBar"></div>
      </div>
      <div class="percent" id="progressPercent">0%</div>
    </div>

    <!-- Timeline / Phasen
         WICHTIG: data-status auf "done" | "doing" | "todo" setzen.  -->
    <section class="timeline" aria-label="Projektphasen">

      <article class="phase" data-status="done">
        <span class="badge" data-s="done">Abgeschlossen</span>
        <h3>Phase 1 · Bedarfsanalyse, Prototyping &amp; Planvorbereitung</h3>
        <p class="meta">Zeitraum: KW 42–43</p>
        <ul class="list">
          <li>Kick-off, Zieldefinition und Bedarfserhebung</li>
          <li>Erstellung erster Wireframes/Prototypen</li>
          <li>Priorisierte Feature-Liste &amp; Projektplan</li>
        </ul>
        <p class="note">Ergebnis: Abgestimmter Projektumfang inkl. grobem Prototyp und Roadmap.</p>
      </article>

      <article class="phase" data-status="doing">
        <span class="badge" data-s="doing">In Arbeit</span>
        <h3>Phase 2 · Planung &amp; Migration</h3>
        <p class="meta">Zeitraum: KW 43–44</p>
        <ul class="list">
          <li>Hosting (HTML / PrestaShop) &amp; SSL</li>
          <li>Staging aufsetzen, Mail-Migration</li>
          <li>Redirect-Plan vorbereiten</li>
        </ul>
        <p class="note">Ziel: Funktionierende Testsysteme für Website &amp; Shop.</p>
      </article>

      <article class="phase" data-status="todo">
        <span class="badge" data-s="todo">Geplant</span>
        <h3>Phase 3 · Design &amp; Umsetzung</h3>
        <p class="meta">Zeitraum: KW 44–46</p>
        <ul class="list">
          <li>HTML-Layout (schnell, barrierearm)</li>
          <li>PrestaShop-Theme &amp; CI</li>
          <li>SEO-Texte, Bilder, Performance</li>
        </ul>
        <p class="note">Ergebnis: Fertige Staging-Version (Site + Shop) zur Abnahme.</p>
      </article>

      <article class="phase" data-status="todo">
        <span class="badge" data-s="todo">Geplant</span>
        <h3>Phase 4 · Tests &amp; Launch</h3>
        <p class="meta">Zeitraum: KW 47</p>
        <ul class="list">
          <li>Checkout, Zahlungen, Versand</li>
          <li>SEO, Redirects, Analytics/SC</li>
          <li>DNS-Switch &amp; Liveschaltung</li>
        </ul>
        <p class="note">Ergebnis: Live, stabil, messbar.</p>
      </article>

      <article class="phase" data-status="todo">
        <span class="badge" data-s="todo">Geplant</span>
        <h3>Phase 5 · Nachbetreuung &amp; Wachstum</h3>
        <p class="meta">ab KW 48 · fortlaufend</p>
        <ul class="list">
          <li>Updates, Backups, Sicherheit</li>
          <li>SEO-Monitoring &amp; Performance</li>
          <li>Monatsreporting &amp; Iterationen</li>
        </ul>
        <p class="note">Ziel: Dauerhaft schnelle, sichere &amp; verkaufsstarke Plattform.</p>
      </article>

    </section>

    <p class="foot">
      Hinweis: Der Gesamt-Fortschritt berechnet sich automatisch (Gewichtung: <strong>done = 100 %</strong>, <strong>doing = 50 %</strong>, <strong>todo = 0 %</strong> je Phase).
      Passe die Status-Attribute bei Updates einfach an.
    </p>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    (function(){
      const phases = document.querySelectorAll('.phase');
      const bar = document.getElementById('progressBar');
      const pct = document.getElementById('progressPercent');
      const progressEl = document.querySelector('.progress');
      const updated = document.getElementById('roadmap-updated');

      function calc(){
        let score = 0;
        const max = phases.length;
        phases.forEach(p=>{
          const s = (p.getAttribute('data-status')||'todo').toLowerCase();
          let val = 0;
          if(s==='done'){ val = 1; }
          else if(s==='doing'){ val = 0.5; }

          score += val;

          const badge = p.querySelector('.badge');
          if(badge){
            const map = {done:'Abgeschlossen', doing:'In Arbeit', todo:'Geplant'};
            badge.dataset.s = s;
            badge.textContent = map[s] || 'Geplant';
          }
        });
        const percent = Math.round((score/max)*100);
        bar.style.width = percent + '%';
        pct.textContent = percent + '%';
        progressEl.setAttribute('aria-valuenow', String(percent));
      }

      try{
        const d = new Date();
        const f = d.toLocaleDateString('de-DE', {year:'numeric', month:'2-digit', day:'2-digit'});
        updated.textContent = 'Stand: ' + f + ' · Statusüberblick & Meilensteine';
      }catch(e){/* ignore */}

      calc();
    })();

    // Header Scroll
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
