<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Produkte | Betten-Sauer Köln</title>
  <meta name="description" content="Entdecken Sie hochwertige Bettgestelle, Matratzen, Lattenroste und Bettwaren bei Betten-Sauer in Köln. Nachhaltige Produkte für gesunden Schlaf." />
  <meta name="keywords" content="Betten-Sauer Produkte, Bettgestelle Köln, Boxspringbetten Köln, Matratzen Köln, Bettwaren Köln" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="produkte.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="produkte.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Produkte bei Betten-Sauer Köln" />
  <meta property="og:description" content="Bei Betten-Sauer finden Sie ausschließlich hochwertige, schlafgesunde Bettwaren von nachhaltigem Wert." />
  <meta property="og:image" content="images/produktbilder/header_produkte.jpg" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Produkte bei Betten-Sauer Köln" />
  <meta name="twitter:description" content="Entdecken Sie Bettsysteme, Boxspringbetten, Matratzen und mehr im Fachgeschäft Betten-Sauer." />
  <meta name="twitter:image" content="images/produktbilder/header_produkte.jpg" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Light.woff2') format('woff2'),
           url('fonts/WorkSans-Light.woff') format('woff');
      font-weight: 300;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-LightItalic.woff2') format('woff2'),
           url('fonts/WorkSans-LightItalic.woff') format('woff');
      font-weight: 300;
      font-style: italic;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Regular.woff2') format('woff2'),
           url('fonts/WorkSans-Regular.woff') format('woff');
      font-weight: 400;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Italic.woff2') format('woff2'),
           url('fonts/WorkSans-Italic.woff') format('woff');
      font-weight: 400;
      font-style: italic;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-SemiBold.woff2') format('woff2'),
           url('fonts/WorkSans-SemiBold.woff') format('woff');
      font-weight: 600;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-SemiBoldItalic.woff2') format('woff2'),
           url('fonts/WorkSans-SemiBoldItalic.woff') format('woff');
      font-weight: 600;
      font-style: italic;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Bold.woff2') format('woff2'),
           url('fonts/WorkSans-Bold.woff') format('woff');
      font-weight: 700;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-BoldItalic.woff2') format('woff2'),
           url('fonts/WorkSans-BoldItalic.woff') format('woff');
      font-weight: 700;
      font-style: italic;
      font-display: swap;
    }

    html, body { font-family: 'Work Sans', sans-serif; color: #3a3a3a; scroll-behavior: smooth; }
    h1, h2, h3, h4, h5, h6 { color: #6793c4; }
    .text-shadow { text-shadow: 0 2px 8px rgba(0,0,0,.6); }

    header { transition: background 0.3s ease, box-shadow 0.3s ease; }
    header.scrolled { background: rgba(255,255,255,0.95); box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    header.scrolled a { color: #3a3a3a !important; text-shadow: none; }
  </style>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <section class="relative">
      <div class="relative h-[320px] sm:h-[360px] md:h-[420px] lg:h-[460px]">
        <img
          src="images/produktbilder/header_produkte.jpg"
          alt="Showroom mit stilvollen Betten und Lichtkonzept bei Betten-Sauer (WebP, komprimiert)"
          class="absolute inset-0 h-full w-full object-cover"
          loading="eager"
        />
        <div class="absolute inset-0 bg-[#0f1e2f]/30 md:bg-gradient-to-b md:from-black/50 md:via-black/30 md:to-black/50"></div>
        <div class="relative z-10 flex h-full items-center">
          <div class="mx-auto max-w-3xl px-6 text-center text-white">
            <h1 class="text-shadow text-3xl sm:text-4xl md:text-5xl font-semibold">Betten Sauer für anspruchsvollen Schlafkomfort</h1>
          </div>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-4xl px-6 space-y-8">
        <p class="text-base sm:text-lg leading-relaxed text-gray-800">Betten Sauer Köln steht für eine fachkundige Auswahl, die gehobenen Ansprüchen gerecht wird. Als Betten Sauer beraten wir den gehobenen Mittelstand zu Lösungen, die Komfort, Ergonomie und Ästhetik vereinen. So erhalten Sie planbare Schlafqualität in jedem Detail.</p>
        <header class="space-y-5">
          <h2 class="text-2xl sm:text-3xl font-semibold">Warum Betten Sauer Köln im Premiumsegment überzeugt</h2>
          <p class="text-base sm:text-lg leading-relaxed">Ihr Schlafsystem muss sich an Ihren Alltag anpassen, nicht umgekehrt. Deshalb verbindet Betten Sauer Köln persönliche Analyse, modernste Technik und langlebige Materialien, die den gehobenen Mittelstand spürbar entlasten.</p>
          <ul class="grid gap-4 rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 text-left text-sm sm:text-base md:grid-cols-2">
            <li class="font-medium text-[#0f1e2f]">Messbare Ergonomie durch individuelle Liegeprofile</li>
            <li class="font-medium text-[#0f1e2f]">Designlinien, die Funktion und Stil harmonisch kombinieren</li>
            <li class="font-medium text-[#0f1e2f]">Langfristiger Werterhalt dank nachhaltiger Fertigung</li>
            <li class="font-medium text-[#0f1e2f]">Planbare Servicepakete inklusive Pflege- und Aufbereitungsoptionen</li>
          </ul>
        </header>

        <div class="space-y-5">
          <h2 class="text-2xl sm:text-3xl font-semibold">Boxspringbetten Köln &amp; Matratzenberatung Köln strategisch einsetzen</h2>
          <p class="text-base sm:text-lg leading-relaxed">Damit Boxspringbetten Köln und Matratzenberatung Köln spürbare Wirkung entfalten, betrachten wir Ihren Schlafraum als Gesamtkonzept. Unsere Fachberater kombinieren passende Komponenten, testen Einstellungen unmittelbar vor Ort und sorgen für transparente Empfehlungen.</p>
          <div class="rounded-xl border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-[#0f1e2f]">So entsteht Ihr persönliches Schlafkonzept</h3>
            <p class="mt-3 text-sm sm:text-base leading-relaxed text-gray-700">Wir prüfen Körperbau, Schlafgewohnheiten und Raumklima, bevor wir Materialien, Lagerungen und Komfortzonen auswählen. Jede Empfehlung bleibt nachvollziehbar, damit Sie Entscheidungen fundiert treffen.</p>
          </div>
        </div>
      </div>
    </section>

    <section class="pb-20 pt-6">
      <div class="mx-auto max-w-6xl px-6 space-y-8">
        <h2 class="text-2xl sm:text-3xl font-semibold text-center">Sortiment für gehobene Schlafräume</h2>
        <p class="mx-auto max-w-3xl text-center text-base sm:text-lg leading-relaxed text-gray-700">Jedes Modul unseres Sortiments ergänzt Betten Sauer Köln sowie Boxspringbetten Köln und Matratzenberatung Köln passgenau. Die Auswahl wird laufend kuratiert, damit Sie nachhaltige Materialien, präzise Verarbeitung und modulare Erweiterungen kombinieren können.</p>
        <div class="grid grid-cols-1 gap-8 sm:grid-cols-2 lg:grid-cols-4">
          <figure class="flex flex-col overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/Bettgestelle.jpg" alt="Helles Schlafzimmer mit Massivholz-Bettgestell im Betten-Sauer Showroom (WebP, komprimiert)" class="h-48 w-full object-cover" loading="lazy" decoding="async" />
            <figcaption class="px-6 py-4 text-center text-lg font-semibold text-[#6793c4]">Bettgestelle</figcaption>
          </figure>
          <figure class="flex flex-col overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/Bettsystem-2.jpg" alt="Grafische Darstellung eines ergonomischen Bettsystems mit Liegezonen (WebP, komprimiert)" class="h-48 w-full object-cover" loading="lazy" decoding="async" />
            <figcaption class="px-6 py-4 text-center text-lg font-semibold text-[#6793c4]">Bettsysteme</figcaption>
          </figure>
          <figure class="flex flex-col overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/bettwaesche-1.jpg" alt="Feine Bettwäsche in gedeckten Farben auf Boxspringbett arrangiert (WebP, komprimiert)" class="h-48 w-full object-cover" loading="lazy" decoding="async" />
            <figcaption class="px-6 py-4 text-center text-lg font-semibold text-[#6793c4]">Bettwäsche</figcaption>
          </figure>
          <figure class="flex flex-col overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/Bild-Boxspringbett.jpg" alt="Modernes Boxspringbett in elegantem Schlafzimmerambiente (WebP, komprimiert)" class="h-48 w-full object-cover" loading="lazy" decoding="async" />
            <figcaption class="px-6 py-4 text-center text-lg font-semibold text-[#6793c4]">Boxspringbetten</figcaption>
          </figure>
          <figure class="flex flex-col overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/kissen_u_nackenstuetzkissen-1.jpg" alt="Ergonomisches Nackenstützkissen mit abnehmbarer Hülle (WebP, komprimiert)" class="h-48 w-full object-cover" loading="lazy" decoding="async" />
            <figcaption class="px-6 py-4 text-center text-lg font-semibold text-[#6793c4]">Kissen &amp; Nackenstützkissen</figcaption>
          </figure>
          <figure class="flex flex-col overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/lattenroste-1.jpg" alt="Lattenrost mit verstellbaren Komfortzonen und grünen Markierungen (WebP, komprimiert)" class="h-48 w-full object-cover" loading="lazy" decoding="async" />
            <figcaption class="px-6 py-4 text-center text-lg font-semibold text-[#6793c4]">Lattenroste</figcaption>
          </figure>
          <figure class="flex flex-col overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/matratzen.jpg" alt="Matratzenstapel mit Markenetikett im Detail (WebP, komprimiert)" class="h-48 w-full object-cover" loading="lazy" decoding="async" />
            <figcaption class="px-6 py-4 text-center text-lg font-semibold text-[#6793c4]">Matratzen</figcaption>
          </figure>
          <figure class="flex flex-col overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/Pflegebetten-1.jpg" alt="Komfortables Seniorenbett mit höhenverstellbarem Rahmen in hellem Raum (WebP, komprimiert)" class="h-48 w-full object-cover" loading="lazy" decoding="async" />
            <figcaption class="px-6 py-4 text-center text-lg font-semibold text-[#6793c4]">Seniorenbetten</figcaption>
          </figure>
        </div>
      </div>
    </section>

    <section class="bg-[#f7fbff] py-12">
      <div class="mx-auto flex max-w-4xl flex-col items-center gap-4 px-6 text-center">
        <p class="text-base sm:text-lg leading-relaxed text-gray-800">Sie wünschen sich eine abgestimmte Kombination, wie sie Betten Sauer Köln mit Boxspringbetten Köln und Matratzenberatung Köln für Ihr Zuhause vorbereitet? Unsere Schlafexperten bereiten Ihnen eine individuelle Produktauswahl vor.</p>
        <a href="index.php#kontaktformular" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-6 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">Beratungstermin sichern</a>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
