<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>30‑Tage‑LinkedIn‑Strategie – Betten-Sauer</title>
  <meta name="description" content="30‑Tage‑LinkedIn‑Strategie für Gouram: Formate, Ziele und Hashtags für eine konsistente Social-Media-Präsenz.">
  <meta name="author" content="Betten-Sauer KG">
  <meta name="theme-color" content="#6793c4">

  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif">
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png">
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png">

  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Regular.woff2') format('woff2'),
           url('fonts/WorkSans-Regular.woff') format('woff');
      font-weight: 400;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-SemiBold.woff2') format('woff2'),
           url('fonts/WorkSans-SemiBold.woff') format('woff');
      font-weight: 600;
      font-style: normal;
      font-display: swap;
    }
    body { font-family: 'Work Sans', sans-serif; color: #3a3a3a; background-color: #ffffff; }
    h1, h2 { color: #6793c4; }
    header { transition: background 0.3s ease, box-shadow 0.3s ease; }
    header.scrolled { background: rgba(255,255,255,0.95); box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    header.scrolled a { color: #3a3a3a !important; text-shadow: none; }
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
    table.table-plan {
      width: 100%;
      border-collapse: collapse;
      font-size: 0.95rem;
    }
    .table-plan th,
    .table-plan td {
      padding: 0.75rem 1rem;
      border: 1px solid #e5e7eb;
      vertical-align: top;
      word-break: break-word;
      white-space: normal;
    }
    .table-plan th {
      background-color: #0f1e2f;
      color: #fff;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.02em;
    }
    .table-plan tbody tr:nth-child(even) { background-color: #f9fafb; }
    @media (max-width: 768px) {
      .table-plan {
        font-size: 0.9rem;
      }
    }
  </style>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-[#0f1e2f]/90 transition duration-300';
    require __DIR__ . '/includes/header.php';
  ?>

  <main class="pt-28 pb-20 bg-gray-50">
    <section class="max-w-6xl mx-auto px-6 space-y-10">
      <div class="rounded-3xl bg-gradient-to-br from-[#0f1e2f] via-[#1b2f4b] to-[#274773] text-white text-center py-16 px-6 md:px-10 shadow-xl">
        <h1 class="text-3xl md:text-4xl font-semibold">30‑Tage‑LinkedIn‑Strategie</h1>
        <p class="mt-4 text-base md:text-lg text-white/85 max-w-3xl mx-auto">
          Ein strukturierter Fahrplan für Gourams LinkedIn‑Auftritt: Formate, Ziele und Calls-to-Action,
          um Entscheider im DACH‑Raum rund um gesunden Schlaf und luxuriöses Interior zu erreichen.
        </p>
      </div>

      <div class="bg-white shadow-lg rounded-2xl border border-gray-200 p-8 space-y-8 leading-relaxed">
        <div class="space-y-4 text-gray-700">
          <p>
            Diese Seite visualisiert den 30‑Tage‑Plan für den LinkedIn‑Account des Geschäftsführers Gouram.
            Der Mix aus Awareness‑, Engagement‑ und Lead‑generierenden Formaten sorgt dafür, dass Informationen
            geteilt und Interaktionen gefördert werden.
          </p>
          <p>
            Beiträge sollten werktags am frühen Morgen veröffentlicht werden, um die bestmögliche Reichweite in der
            Zielgruppe zu erzielen.
          </p>
        </div>

        <div class="space-y-4">
          <h2 class="text-2xl font-semibold">30‑Tage‑Plan im Überblick</h2>
          <div class="overflow-x-auto">
            <table class="table-plan">
              <thead>
                <tr>
                  <th>Tag</th>
                  <th>Thema&nbsp;/ Schwerpunkt</th>
                  <th>Format</th>
                  <th>Ziel</th>
                  <th>Call‑to‑Action</th>
                  <th>Hashtags&nbsp;/ Tags</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>1</td>
                  <td>Auftakt – Mission &amp; Schlafökonomie (585 Mrd.&nbsp;USD)</td>
                  <td>Video (≤60&nbsp;Sek.)</td>
                  <td>Awareness</td>
                  <td>Serie ankündigen, Kommentare willkommen</td>
                  <td>#SleepEconomy #Luxusmöbel #Gouram</td>
                </tr>
                <tr>
                  <td>2</td>
                  <td>Provokante Frage: „Was kostet schlechter Schlaf?“ – 37 % schliefen 2023 schlechter</td>
                  <td>Kurztext (≤150 Zeichen)</td>
                  <td>Engagement</td>
                  <td>Frage beantworten lassen</td>
                  <td>#Schlafprobleme #CEO #Diskussion</td>
                </tr>
                <tr>
                  <td>3</td>
                  <td>Branchendiskussion kommentieren (Sleep‑Economy‑Artikel teilen)</td>
                  <td>Engagement (Kommentieren/Liken)</td>
                  <td>Awareness</td>
                  <td>Wertvolle Insights in Kommentar</td>
                  <td>#SleepTech #Industrie</td>
                </tr>
                <tr>
                  <td>4</td>
                  <td>Artikel: Schlafökonomie &amp; Gesundheit – Markt, Tech, Gesundheit</td>
                  <td>Artikel / Long‑Post</td>
                  <td>Thought‑Leadership</td>
                  <td>Artikel lesen/teilen</td>
                  <td>#ThoughtLeadership #SleepHealth</td>
                </tr>
                <tr>
                  <td>5</td>
                  <td>Handwerk &amp; Behind‑the‑Scenes – Herstellung eines Bettes</td>
                  <td>Video</td>
                  <td>Brand&nbsp;Story</td>
                  <td>Interesse an individuellem Design wecken</td>
                  <td>#Handwerk #Luxusbett #BTS</td>
                </tr>
                <tr>
                  <td>6</td>
                  <td>Schlafroutine des CEO (Tipps gegen schlechten Schlaf)</td>
                  <td>Kurztext</td>
                  <td>Engagement</td>
                  <td>Eigene Routine teilen</td>
                  <td>#Schlafroutine #Productivity</td>
                </tr>
                <tr>
                  <td>7</td>
                  <td>Mitarbeiterpost resharen – Teamvorstellung</td>
                  <td>Engagement (Repost + Kommentar)</td>
                  <td>Vertrauen</td>
                  <td>Mitarbeitende ermutigen zu teilen</td>
                  <td>#Team #EmployeeAdvocacy</td>
                </tr>
                <tr>
                  <td>8</td>
                  <td>Smart‑Bed‑Demo (Temperatur/Flexibilität)</td>
                  <td>Video</td>
                  <td>Lead‑Gen</td>
                  <td>Demo‑Anfragen anregen</td>
                  <td>#SmartBed #SleepTech</td>
                </tr>
                <tr>
                  <td>9</td>
                  <td>Frage: „Welche Schlafzimmer‑Features sind wichtig?“ (Umfrage)</td>
                  <td>Kurztext / Poll</td>
                  <td>Engagement</td>
                  <td>Umfrage ausfüllen</td>
                  <td>#Umfrage #Schlafzimmer</td>
                </tr>
                <tr>
                  <td>10</td>
                  <td>Teilnahme an LinkedIn‑Gruppe zu Executive‑Wellness</td>
                  <td>Engagement</td>
                  <td>Awareness</td>
                  <td>Expertenbeitrag in Diskussion</td>
                  <td>#Wellness #Leadership</td>
                </tr>
                <tr>
                  <td>11</td>
                  <td>Artikel: Schlaf &amp; Leistung – persönliche Erfahrungen; Tipps</td>
                  <td>Long‑Post</td>
                  <td>Thought‑Leadership</td>
                  <td>Erfahrungsberichte teilen</td>
                  <td>#Performance #SleepTips</td>
                </tr>
                <tr>
                  <td>12</td>
                  <td>Kundentestimonial (CEO berichtet über bessere Schlafqualität)</td>
                  <td>Video</td>
                  <td>Social Proof</td>
                  <td>Nachricht senden für Beratung</td>
                  <td>#Kundenstory #Erfolg</td>
                </tr>
                <tr>
                  <td>13</td>
                  <td>Zitat über Handwerk &amp; emotionalen Wert</td>
                  <td>Kurztext</td>
                  <td>Brand&nbsp;Story</td>
                  <td>Eigene Definition von Luxus teilen</td>
                  <td>#EmotionalValue #Craftsmanship</td>
                </tr>
                <tr>
                  <td>14</td>
                  <td>Design‑Influencer‑Posts liken &amp; kommentieren</td>
                  <td>Engagement</td>
                  <td>Awareness</td>
                  <td>Kontakte knüpfen</td>
                  <td>#InteriorDesign #Netzwerk</td>
                </tr>
                <tr>
                  <td>15</td>
                  <td>„Day in the Life“ eines Handwerkers</td>
                  <td>Video</td>
                  <td>Brand&nbsp;Story</td>
                  <td>Kommentare einladen</td>
                  <td>#Team #Handwerk</td>
                </tr>
                <tr>
                  <td>16</td>
                  <td>Statistik: 1/3 nutzen Schlaf‑Tracker – Nutzen?</td>
                  <td>Kurztext</td>
                  <td>Engagement</td>
                  <td>Nutzung von Trackern diskutieren</td>
                  <td>#SleepTracker #HealthTech</td>
                </tr>
                <tr>
                  <td>17</td>
                  <td>Sleep‑Tech‑Investments – News teilen &amp; kommentieren</td>
                  <td>Engagement</td>
                  <td>Awareness</td>
                  <td>Meinung posten</td>
                  <td>#Investments #SleepTech</td>
                </tr>
                <tr>
                  <td>18</td>
                  <td>Artikel: Materialien &amp; Nachhaltigkeit von Luxusbetten</td>
                  <td>Long‑Post</td>
                  <td>Thought‑Leadership</td>
                  <td>Kontakt für Details</td>
                  <td>#Nachhaltigkeit #Materialien</td>
                </tr>
                <tr>
                  <td>19</td>
                  <td>Expertenvideo: Vorteile von verstellbaren Betten</td>
                  <td>Video</td>
                  <td>Lead‑Gen</td>
                  <td>Anmeldung zum Webinar</td>
                  <td>#SleepScience #VerstellbaresBett</td>
                </tr>
                <tr>
                  <td>20</td>
                  <td>Frage: „Was hindert Sie am besten Schlaf?“ (Stress? Technik?)</td>
                  <td>Kurztext</td>
                  <td>Engagement</td>
                  <td>Tipps austauschen</td>
                  <td>#Stress #Schlafbarrieren</td>
                </tr>
                <tr>
                  <td>21</td>
                  <td>Teilnahme an Branchen‑Event / Webinar – Highlights teilen</td>
                  <td>Engagement</td>
                  <td>Awareness</td>
                  <td>Diskussion anregen</td>
                  <td>#EventRecap #Netzwerk</td>
                </tr>
                <tr>
                  <td>22</td>
                  <td>CEO‑Morgenroutine nach erholsamem Schlaf</td>
                  <td>Video</td>
                  <td>Authenticity</td>
                  <td>Eigene Routine posten</td>
                  <td>#MorningRoutine #Leadership</td>
                </tr>
                <tr>
                  <td>23</td>
                  <td>Farb‑/Design‑Umfrage für Schlafzimmer</td>
                  <td>Poll</td>
                  <td>Engagement</td>
                  <td>Abstimmen lassen</td>
                  <td>#Design #Umfrage</td>
                </tr>
                <tr>
                  <td>24</td>
                  <td>Partner/Supplier würdigen (Reshare)</td>
                  <td>Engagement</td>
                  <td>Relationship</td>
                  <td>Dank posten</td>
                  <td>#Partnerschaft #SupplyChain</td>
                </tr>
                <tr>
                  <td>25</td>
                  <td>Artikel: Zukunft der Sleep‑Tech &amp; KI – Chancen &amp; VC Trends</td>
                  <td>Long‑Post</td>
                  <td>Thought‑Leadership</td>
                  <td>Newsletter abonnieren</td>
                  <td>#FutureOfSleep #AI</td>
                </tr>
                <tr>
                  <td>26</td>
                  <td>Q&amp;A‑Video: Häufige Fragen zu Produkten</td>
                  <td>Video</td>
                  <td>Lead‑Gen</td>
                  <td>Fragen stellen</td>
                  <td>#FAQ #Beratung</td>
                </tr>
                <tr>
                  <td>27</td>
                  <td>Kurztext mit Zitat über Schlaf &amp; mentale Gesundheit</td>
                  <td>Kurztext</td>
                  <td>Awareness</td>
                  <td>Kommentar anregen</td>
                  <td>#MentalHealth #GesunderSchlaf</td>
                </tr>
                <tr>
                  <td>28</td>
                  <td>Mitarbeiter zum Teilen motivieren (Reminder)</td>
                  <td>Engagement</td>
                  <td>Internal&nbsp;Advocacy</td>
                  <td>Postings teilen</td>
                  <td>#EmployeeAdvocacy #Team</td>
                </tr>
                <tr>
                  <td>29</td>
                  <td>Recap‑Video: Erkenntnisse der 30‑Tage‑Kampagne</td>
                  <td>Video</td>
                  <td>Awareness &amp; Lead‑Gen</td>
                  <td>Newsletter abonnieren / Kontakt</td>
                  <td>#Recap #Danke</td>
                </tr>
                <tr>
                  <td>30</td>
                  <td>Ankündigung eines Webinars/Events (Schlaf &amp; Luxusdesign)</td>
                  <td>Kurztext</td>
                  <td>Lead‑Gen</td>
                  <td>Zur Anmeldung klicken</td>
                  <td>#Webinar #Luxusdesign</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

        <div class="rounded-xl bg-[#0f1e2f]/5 border border-[#0f1e2f]/20 px-5 py-4 text-sm md:text-base text-[#0f1e2f]">
          Hinweis: Für optimale Ergebnisse sollten die Inhalte in den frühen Morgenstunden wochentags veröffentlicht
          und die Performance über LinkedIn‑Analytics überwacht werden. Die Mischung aus Videos, Texten und Engagement
          sorgt für Sichtbarkeit, Interaktion und qualifizierte Leads.
        </div>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
