<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Matratzen Köln &amp; Siegburg | Betten Sauer</title>
  <meta name="description" content="Ergonomische Matratzen mit individueller Liegeanalyse bei Betten Sauer. Persönliche Schlafberatung in Köln und Siegburg für erholsamen Schlaf." />
  <meta name="keywords" content="Matratzen, ergonomische Matratze, Kaltschaummatratze, Taschenfederkernmatratze, Matratzen Köln, Matratzen Siegburg, Schlafberatung" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="matratzen.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="matratzen.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Individuelle Matratzenberatung – Betten Sauer" />
  <meta property="og:description" content="Entdecken Sie ergonomische Matratzen von Röwa, Grosana, Werkmeister und dormabell. Persönliche Schlafberatung in Köln und Siegburg." />
  <meta property="og:image" content="images/1200x800_matratzen.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Individuelle Matratzenberatung – Betten Sauer" />
  <meta name="twitter:description" content="Passende Matratzen für Ihren Körperbau – mit Liegeanalyse bei Betten Sauer in Köln oder Siegburg." />
  <meta name="twitter:image" content="images/1200x800_matratzen.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <section class="relative">
      <div class="relative hidden lg:block">
        <div class="relative h-[320px] sm:h-[360px] md:h-[420px] lg:h-[460px]">
          <img
            src="images/header/header_matratzen.jpg"
            alt="Matratzenberatung mit Schlafexperten im Fachgeschäft von Betten Sauer"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
            decoding="async"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/55"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/40 to-[#0f1e2f]/70"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_matratzen.jpg"
          alt="Matratzenberatung – mobile Ansicht"
          class="hero-mobile-img"
          loading="eager"
          decoding="async"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-5 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center lg:justify-end">
        <div class="w-full max-w-3xl lg:ml-auto lg:pr-12">
          <h1 class="text-3xl font-semibold text-shadow sm:text-4xl md:text-5xl">
            Die richtige Matratze – weil jeder Körper anders schläft
          </h1>
        </div>
      </div>
    </section>

    <section class="bg-white py-12">
      <div class="mx-auto max-w-6xl px-6 text-gray-700 lg:px-0">
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-[minmax(0,1.4fr)_minmax(0,1fr)] lg:items-center">
          <div class="space-y-4">
            <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Ankommen, Absinken, Aufatmen – Ihre Matratze, die sich nach Ihnen richtet</h2>
            <p class="text-base leading-relaxed sm:text-lg">Stellen Sie sich vor, Sie sinken abends in eine Matratze, die Ihren Körper ruhig trägt, Druckstellen löst und den Atem sanft vertieft. Der Rücken entlastet, die Schultern frei – und am Morgen fühlen Sie sich, als wäre jede Stunde Schlaf ein Geschenk.</p>
            <p class="text-base leading-relaxed sm:text-lg">Bei Betten Sauer erhalten Sie keine Standardmatratzen, sondern individuell abgestimmte Schlafsysteme. Wir verbinden Tradition und moderne Ergonomie, analysieren Haltung, Körperbau und Schlafposition – und finden die ergonomische Matratze, die Ihrer Wirbelsäule und Ihrem Lebensrhythmus gerecht wird.</p>
          </div>
          <figure class="overflow-hidden rounded-xl shadow-lg">
            <img
              src="images/produktbilder/matratzen.jpg"
              alt="Auswahl an Matratzen im Fachgeschäft Betten Sauer"
              class="h-full w-full object-cover"
              loading="lazy"
              decoding="async"
            />
          </figure>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-4xl space-y-6 px-6 text-gray-700 lg:px-0">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Warum Ihre Matratze über guten Schlaf entscheidet</h2>
        <p class="text-base leading-relaxed sm:text-lg">Die Wirbelsäule möchte im Liegen so behutsam gestützt werden wie im Stehen. Liegezonen, Stützkraft und Materialqualität Ihrer Matratze sorgen dafür, dass Lendenwirbel, Schultergürtel und Nacken entspannen. Eine ergonomische Matratze entlastet dort, wo Sie einsinken sollen, und stabilisiert dort, wo Ihr Körper Halt braucht.</p>
        <p class="text-base leading-relaxed sm:text-lg">Wer morgens mit Rücken- oder Nackenschmerzen erwacht, liegt häufig zu weich im Becken oder zu hart an der Schulter. Auch ein verkrampfter Kiefer, eingeschlafene Arme oder ein unruhiger Schlaf können Hinweise sein, dass die Matratze nicht zu Körpergewicht, Schlafposition oder Bewegungsprofil passt. Erst wenn Matratze, Lattenrost und Kissen als System harmonieren, entsteht regenerierende Ruhe.</p>
        <p class="text-base leading-relaxed sm:text-lg">In Köln und Siegburg erleben Sie, wie spürbar korrekt eingestellte Liegezonen wirken: Die Muskulatur darf loslassen, Bandscheiben werden gleichmäßig entlastet und der Atem fließt freier. So verwandelt sich jede Nacht in einen wohltuenden Teil Ihres Tagesrhythmus.</p>
        <div class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
          <h3 class="text-lg font-semibold text-[#4e759f]">Typische Beschwerden, die wir häufig lösen</h3>
          <ul class="mt-4 space-y-3 text-sm leading-relaxed">
            <li class="rounded-lg border border-[#dce6f5] bg-white px-4 py-3">Hartnäckige Rückenschmerzen, weil Becken und Lordose nicht abgestützt werden.</li>
            <li class="rounded-lg border border-[#dce6f5] bg-white px-4 py-3">Schulterdruck bei Seitenschläfern durch fehlende Einsinktiefe der Matratze.</li>
            <li class="rounded-lg border border-[#dce6f5] bg-white px-4 py-3">Verspannter Nacken und Kopfschmerzen, wenn Kopfkissen und Matratzenhärte nicht zusammenpassen.</li>
            <li class="rounded-lg border border-[#dce6f5] bg-white px-4 py-3">Nächtliches Schwitzen, ausgelöst durch Materialien ohne klimaregulierende Eigenschaften.</li>
          </ul>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl space-y-8 px-6 text-gray-700 lg:px-0">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Matratze ist nicht gleich Matratze</h2>
        <p class="text-base leading-relaxed sm:text-lg">Jeder Schlaftyp benötigt andere Eigenschaften: Seitenschläfer wünschen sich mehr Schulterkomfort, Rückenschläfer aufrechtes Stützen, Bauchschläfer klare Stabilität. Deshalb wählen wir zwischen Kaltschaummatratze, Taschenfederkernmatratze, Latex- oder Hybridvarianten und kombinieren sie mit passenden Zonen und Bezügen.</p>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Kaltschaummatratze</h3>
            <p class="mt-3 text-sm leading-relaxed">Reagiert punktgenau und lässt sich präzise zonieren. Ideal für Seitenschläfer mit empfindlichen Schultern sowie für Menschen, die es ruhig und druckentlastend mögen. Durch offenporigen Aufbau bleibt das Schlafklima ausgeglichen.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Taschenfederkernmatratze</h3>
            <p class="mt-3 text-sm leading-relaxed">Jede Feder ist einzeln vernäht, sodass Bewegungen kaum übertragen werden. Perfekt für Paare mit unterschiedlichem Gewicht, Rückenschläfer und alle, die eine angenehm federnde Unterstützung schätzen – auch in warmen Nächten dank sehr guter Belüftung.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Latexmatratze</h3>
            <p class="mt-3 text-sm leading-relaxed">Naturlatex passt sich fließend an den Körper an, unterstützt dynamisch und bleibt elastisch über viele Jahre. Empfohlen für Allergiker sowie Menschen, die nachhaltige Materialien und eine besonders anschmiegsame Oberfläche bevorzugen.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Hybridmatratze</h3>
            <p class="mt-3 text-sm leading-relaxed">Hybridmodelle vereinen Taschenfedern mit innovativen Schäumen oder Naturkautschuk. Sie richten sich an Schläfer, die adaptiven Komfort, hohe Rückstellkraft und flexible Körperzonen in einer Matratze kombinieren möchten.</p>
          </article>
        </div>
        <p class="text-base leading-relaxed sm:text-lg">Unabhängig vom Material stimmen wir Härtegrad, Kernhöhe und Bezugsvarianten auf Ihre Schlafgewohnheiten ab. So entsteht ein Schlafsystem, das Sie spüren, sobald Sie sich hinlegen – nicht erst nach Wochen des Eingewöhnens.</p>
      </div>
    </section>

    <section id="beratung" class="bg-white py-16">
      <div class="mx-auto max-w-4xl space-y-8 px-6 text-gray-700 lg:px-0">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Individuell abgestimmt – die Liegeanalyse bei Betten Sauer</h2>
        <p class="text-base leading-relaxed sm:text-lg">Seit über 200 Jahren steht Betten Sauer für Schlafkultur und handwerkliche Sorgfalt. Unsere Liegeanalyse verbindet moderne Messsysteme mit geschultem Blick. Wir vermessen Rückenlänge, Schulterbreite und Hüftstellung, prüfen Bewegungsmuster und berücksichtigen medizinische Hinweise Ihres Orthopäden.</p>
        <p class="text-base leading-relaxed sm:text-lg">Im Anschluss testen wir gemeinsam verschiedene Matratzen: Sie spüren die Unterschiede unmittelbar, während wir Druckpunkte sichtbar machen und Härtegrade feinjustieren. Die Matratze soll sich Ihrem Körper anpassen – nicht umgekehrt.</p>
        <ul class="space-y-3 text-sm leading-relaxed">
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Präzise Vermessung mit dem dormabell-Mess-System und ergänzender Körperanalyse.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Probeliegen auf abgestimmten Matratzen und Lattenrosten – in Ruhe, ohne Zeitdruck.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Feinabstimmung von Liegezonen, Stützkraft und Klimamanagement durch erfahrene Schlafberater.</li>
        </ul>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-4xl space-y-6 px-6 text-gray-700 lg:px-0">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Schlafkomfort trifft Langlebigkeit</h2>
        <p class="text-base leading-relaxed sm:text-lg">Eine gute Matratze begleitet Sie viele Jahre. Darum setzen wir auf hochwertige Kerne, langlebige Bezüge und sorgfältige Verarbeitung. Feuchtigkeitsregulierende Materialien wie Klimafasern, Schafschurwolle oder Tencel sorgen für ausgeglichene Temperaturen und ein trockenes Bettklima – wichtig für Menschen, die nachts schwitzen oder frieren.</p>
        <p class="text-base leading-relaxed sm:text-lg">Nachhaltigkeit bedeutet für uns transparente Herkunft, kurze Lieferwege und austauschbare Komponenten. Viele unserer Hersteller fertigen in Deutschland oder der Schweiz, sodass Reparaturen, Austausch von Bezügen und Recycling gesichert sind. So genießen Sie jeden Abend ein Gefühl von Wertigkeit und verantwortungsvoller Schlafkultur.</p>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-4xl space-y-8 px-6 text-gray-700 lg:px-0">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Markenqualität, der Sie vertrauen können</h2>
        <p class="text-base leading-relaxed sm:text-lg">Wir kuratieren für Sie Matratzenkollektionen renommierter Hersteller, die Innovation mit Handwerk verbinden. Jede Marke bringt besondere Stärken mit – von anpassungsfähigen Schulterzonen bis zu nachhaltigen Naturmaterialien.</p>
        <ul class="space-y-3 text-sm leading-relaxed">
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3"><strong>Röwa</strong> – individuell konfigurierbare Matratzen und Rahmen aus schwäbischer Fertigung, präzise abgestimmt auf Ihre Körperkonturen.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3"><strong>Grosana</strong> – innovative Schaumtechnologien mit spürbar elastischer Schulterkomfortzone für empfindliche Seitenschläfer.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3"><strong>Werkmeister</strong> – Manufakturqualität mit Naturkautschuk, klimatisierenden Bezügen und modularen Systemen für höchste Langlebigkeit.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3"><strong>dormabell</strong> – perfekt abgestimmte Programme aus Matratzen, Lattenrosten und Kissen mit fundierter Schlafberatung.</li>
        </ul>
        <p class="text-base leading-relaxed sm:text-lg">Aus dieser Vielfalt entwickeln wir Ihre persönliche Lösung – für Einzelbetten, Boxspring-Systeme oder Paarkonzepte mit individuell wählbaren Festigkeiten.</p>
      </div>
    </section>

    <section class="bg-white py-12">
      <div class="mx-auto max-w-4xl space-y-6 px-6 text-center">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Probeschlafen &amp; persönliche Beratung</h2>
        <p class="text-base leading-relaxed text-gray-700 sm:text-lg">Erleben Sie in Köln oder Siegburg, wie sich echte Entlastung anfühlt. Unsere Schlafberatung begleitet Sie mit Ruhe, Erfahrung und fundierter Ergonomie-Kompetenz – von der ersten Analyse bis zur Lieferung Ihrer neuen Matratze.</p>
        <p class="text-base leading-relaxed text-gray-700 sm:text-lg">Reservieren Sie Ihren Termin zum Probeschlafen, testen Sie verschiedene Matratzen Köln oder Matratzen Siegburg in entspannter Atmosphäre und nehmen Sie unsere Empfehlungen mit nach Hause. So treffen Sie eine Entscheidung, die sich Nacht für Nacht richtig anfühlt.</p>
        <a href="index.php#kontaktformular" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
          Jetzt Termin vereinbaren
        </a>
        <div class="space-y-1 text-sm leading-relaxed text-gray-600">
          <p>Telefon: <a class="underline hover:text-[#4e759f]" href="tel:+49221843236">0221 843236</a> &bull; WhatsApp: <a class="underline hover:text-[#4e759f]" href="https://wa.me/49221843236" target="_blank" rel="noopener">Nachricht an Betten Sauer senden</a></p>
          <p>Wir freuen uns auf Ihre Fragen rund um Schlafberatung, ergonomische Matratzen und individuelle Liegesysteme.</p>
        </div>
      </div>
    </section>

    <?php require __DIR__ . '/kontakt_sektion.php'; ?>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
<!--
Meta Title: Matratzen Köln & Siegburg | Betten Sauer
Meta Description: Ergonomische Matratzen mit Liegeanalyse bei Betten Sauer. Persönliche Schlafberatung in Köln & Siegburg für entspannten, gesunden Schlaf.
-->
