<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Hersteller &amp; Marken bei Betten Sauer | Qualitätsauswahl seit 1921</title>
  <meta name="description" content="Entdecken Sie die Markenwelt von Betten Sauer. Wir führen ausgewählte Hersteller für Bettsysteme, Bettgestelle, Boxspringbetten, Bettwäsche und Accessoires – mit persönlicher Beratung." />
  <meta name="keywords" content="Betten Marken Köln, dormabell Händler, Kirchner Bettsystem, Schramm Boxspring, Bettwäsche Marken, Betten Sauer Hersteller" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="marken.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="marken.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Hersteller &amp; Marken bei Betten Sauer" />
  <meta property="og:description" content="Über 30 Markenpartner – von Bettsystemen bis Bettwäsche. Lernen Sie unsere Hersteller kennen und finden Sie mit uns das passende Schlafsystem." />
  <meta property="og:image" content="images/1200x800_markenwelt.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Hersteller &amp; Marken bei Betten Sauer" />
  <meta name="twitter:description" content="Markenorientiert, beratungsstark und unabhängig – entdecken Sie die Qualitätshersteller von Betten Sauer." />
  <meta name="twitter:image" content="images/1200x800_markenwelt.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <!-- Hero -->
    <section class="relative" aria-labelledby="hero-heading">
      <div class="relative hidden lg:block">
        <div class="relative h-[360px] sm:h-[420px] md:h-[480px] lg:h-[540px]">
          <img
            src="images/header/header_marken.jpg"
            alt="Showroom von Betten Sauer mit verschiedenen Marken und Bettsystemen"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
            decoding="async"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/55"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/35 to-[#0f1e2f]/80"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_marken.jpg"
          alt="Markenwelt von Betten Sauer – mobile Ansicht"
          class="hero-mobile-img"
          loading="eager"
          decoding="async"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-6 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center">
        <div class="mx-auto flex max-w-5xl flex-col gap-6 lg:px-12">
          <h1 id="hero-heading" class="text-3xl font-semibold leading-tight text-shadow sm:text-4xl md:text-5xl">
            Unsere Marken – Ihre Qualitätsschlafgarantie.
          </h1>
          <p class="mx-auto max-w-3xl text-base text-white/85 sm:text-lg md:text-xl">
            Wir führen nur Hersteller, von deren Qualität und Langlebigkeit wir überzeugt sind – weil Ihr Schlaf etwas Besseres verdient.
          </p>
          <div class="pt-2">
            <a href="#termin" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
              Beratung zu Ihrem Lieblingshersteller buchen
            </a>
          </div>
        </div>
      </div>
    </section>

    <!-- Einleitung -->
    <section class="bg-white py-16" aria-labelledby="intro-heading">
      <div class="mx-auto max-w-6xl space-y-6 px-6 text-gray-700 lg:px-0">
        <h2 id="intro-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
          Markenkompetenz seit 1921
        </h2>
        <p class="text-base leading-relaxed sm:text-lg">
          Seit über 100 Jahren arbeiten wir mit führenden Marken, die unser Qualitätsverständnis teilen: präzise Verarbeitung, nachhaltige Materialien und ergonomische Innovation. Jede Marke steht für eine eigene Philosophie – wir helfen Ihnen, die passende zu entdecken und zu erleben.
        </p>
      </div>
    </section>

    <?php
      $sections = [
        [
          'title' => 'Bettsysteme – Matratzen & Lattenroste',
          'description' => 'Schlafkomfort entsteht, wenn Matratze, Unterfederung und Ihr Körper perfekt zusammenspielen. Diese Marken stehen für präzise Ergonomie.',
          'brands' => [
            ['name' => 'Dormabell', 'text' => 'Individuell angepasst durch unser Messsystem.', 'image' => 'images/marken/Dormabell.jpg'],
            ['name' => 'Grosana', 'text' => 'Dynamische Schlafsysteme mit feinfühliger Anpassung.', 'image' => 'images/marken/Grosana.jpg'],
            ['name' => 'Kirchner', 'text' => 'Motorische Komfortsysteme mit Liftfunktion.', 'image' => 'images/marken/Kirchner-Betten.jpg'],
            ['name' => 'Lattoflex', 'text' => 'Patentierte Flügelfederung für federnen Halt.', 'image' => 'images/marken/Lattoflex.png'],
            ['name' => 'Röwa', 'text' => 'Deutsche Präzision & ergonomische Unterstützung.', 'image' => 'images/marken/Roewa.jpg'],
            ['name' => 'Schramm', 'text' => 'Handmade in Germany – zweistufiger Federkomfort.', 'image' => 'images/marken/Schramm.jpg'],
            ['name' => 'Selecta', 'text' => 'Matratzen & Unterfederungen für alle Schlaflagen.', 'image' => 'images/marken/Selecta.jpg'],
            ['name' => 'Sympathica', 'text' => 'Rückenfreundliche Matratzen mit zonierter Entlastung.', 'image' => 'images/marken/Sympathica.jpg'],
            ['name' => 'Treca Interiors Paris', 'text' => 'Französischer Luxus – handgefertigte Schlafsysteme.', 'image' => 'images/marken/treca.png'],
            ['name' => 'Werkmeister', 'text' => 'Manufakturqualität aus Deutschland.', 'image' => 'images/marken/Werkmeister.jpg'],
          ],
          'cta' => true,
        ],
        [
          'title' => 'Bettgestelle',
          'description' => 'Rahmen, die Ihren Stil und Ihre Ergonomie verbinden – von modern bis handwerklich.',
          'brands' => [
            ['name' => 'Badenia', 'text' => 'Variantenreiche Bettgestelle für jeden Wohnstil.', 'image' => 'images/marken/Badenia-Boxspringbetten.jpg'],
            ['name' => 'Hasena', 'text' => 'Moderne Massivholzbetten mit klaren Linien.', 'image' => 'images/marken/Hasena.jpg'],
            ['name' => 'Maggioni', 'text' => 'Italienisches Design mit filigranen Details.', 'image' => 'images/marken/Maggioni.jpg'],
            ['name' => 'Reichert', 'text' => 'Traditionshandwerk mit Liebe zum Detail.', 'image' => 'images/marken/Reichert-Betten.jpg'],
            ['name' => 'Ruhe & Raum', 'text' => 'Wohnliche Manufakturgestelle aus Naturmaterialien.', 'image' => 'images/marken/Ruhe-Raum.jpg'],
            ['name' => 'Schramm', 'text' => 'Schlafsysteme inklusive abgestimmter Rahmen.', 'image' => 'images/marken/Schramm-Kopie.jpg'],
            ['name' => 'Svane', 'text' => 'Skandinavisches Design mit intelligenter Ergonomie.', 'image' => 'images/marken/SVANE_Zincere_Intelligel-Kontinental.jpg'],
            ['name' => 'Traumwerk', 'text' => 'Handwerkliche Rahmenfertigung aus Bayern.', 'image' => 'images/marken/Traumwerk.jpg'],
            ['name' => 'Zack Design', 'text' => 'Massivholz-Unikate mit klarer Formensprache.', 'image' => 'images/marken/ZACK-DESIGN.jpg'],
          ],
        ],
        [
          'title' => 'Boxspringbetten',
          'description' => 'Mehrlagige Federkernsysteme für höchsten Schlafkomfort – individuell abgestimmt auf Ihre Bedürfnisse.',
          'brands' => [
            ['name' => 'Treca Interiors Paris', 'text' => 'Pariser Atelierkunst mit luxuriösen Materialien.', 'image' => 'images/marken/treca.png'],
            ['name' => 'Schramm', 'text' => 'Individuell abgestimmte Boxspring-Systeme.', 'image' => 'images/marken/Schramm.jpg'],
            ['name' => 'Brinkhaus (Badenia)', 'text' => 'Tradition & Innovation für langlebige Boxspringbetten.', 'image' => 'images/marken/Badenia-Boxspringbetten.jpg'],
            ['name' => 'Svane', 'text' => 'Norwegische Boxspringtechnologie mit IntelliGel.', 'image' => 'images/marken/SVANE_Zincere_Intelligel-Kontinental.jpg'],
          ],
        ],
        [
          'title' => 'Bettwäsche & Accessoires',
          'description' => 'Feine Stoffe, weichste Baumwolle und Designs, die Schlafzimmer in Wohlfühloasen verwandeln.',
          'brands' => [
            ['name' => 'Christian Fischbacher', 'text' => 'Schweizer Luxusstoffe mit Liebe zum Detail.', 'image' => 'images/marken/Christian-Fischbacher.jpg'],
            ['name' => 'Elegante', 'text' => 'Klassisch-elegante Dessins, gefertigt in Deutschland.', 'image' => 'images/marken/elegante-1.jpg'],
            ['name' => 'Estella', 'text' => 'Hautfreundlich, pflegeleicht und langlebig.', 'image' => 'images/marken/Estella.jpg'],
            ['name' => 'Joop!', 'text' => 'Ausdrucksstarkes Design mit Premium-Qualität.', 'image' => 'images/marken/Joop.jpg'],
            ['name' => 'Schlossberg', 'text' => 'Feinste Materialien und zeitlose Eleganz.', 'image' => 'images/marken/Schlossberg.jpg'],
          ],
        ],
        [
          'title' => 'Ergänzungen & Wohntextilien',
          'description' => 'Vom Daunenkissen bis zum Frottierhandtuch – Qualitätsmarken, die Ihr Zuhause komplettieren.',
          'brands' => [
            ['name' => 'BNP', 'text' => 'Spezialmatratzen für Pflege & Komfort.', 'image' => 'images/marken/BNP-1.jpg'],
            ['name' => 'Centa-Star', 'text' => 'Innovative Bettwaren für Allergiker und Genießer.', 'image' => 'images/marken/Centa-Star.jpg'],
            ['name' => 'Sahco', 'text' => 'Edle Wohntextilien mit architektonischem Look.', 'image' => 'images/marken/Sahco.jpg'],
            ['name' => 'Sanders', 'text' => 'Hochwertige Inletts aus deutscher Fertigung.', 'image' => 'images/marken/sanders-1.jpg'],
            ['name' => 'Traumina', 'text' => 'Individuelle Bettdecken für jede Klimazone.', 'image' => 'images/marken/traumina.jpg'],
            ['name' => 'Cawö', 'text' => 'Frottierwaren mit Wohlfühlfaktor.', 'image' => 'images/marken/cawo_3.webp'],
          ],
        ],
      ];
    ?>

    <?php foreach ($sections as $index => $section): ?>
      <section class="<?= $index % 2 === 0 ? 'bg-[#f6f7f9]' : 'bg-white' ?> py-16" aria-labelledby="section-<?= $index ?>">
        <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
          <div class="space-y-4">
            <h2 id="section-<?= $index ?>" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
              <?= htmlspecialchars($section['title'], ENT_QUOTES) ?>
            </h2>
            <p class="text-base leading-relaxed sm:text-lg">
              <?= htmlspecialchars($section['description'], ENT_QUOTES) ?>
            </p>
          </div>
          <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-4">
            <?php foreach ($section['brands'] as $brand): ?>
              <?php
                $imagePath = $brand['image'] ?? null;
                $imageAbsolutePath = $imagePath ? __DIR__ . '/' . ltrim($imagePath, '/') : null;
                $hasImage = $imageAbsolutePath && file_exists($imageAbsolutePath);
                $titleClasses = $hasImage ? 'text-white drop-shadow-sm' : 'text-[#0f1e2f]';
              ?>
              <article class="group flex flex-col gap-4 rounded-2xl border border-[#dce4ef] bg-white p-4 shadow-md shadow-[#0f1e2f]/10 transition hover:-translate-y-1 hover:shadow-lg">
                <div class="relative h-48 overflow-hidden rounded-2xl bg-[#dfe6f3]">
                  <?php if ($hasImage): ?>
                    <img
                      src="<?= htmlspecialchars($imagePath, ENT_QUOTES) ?>"
                      alt="<?= htmlspecialchars($brand['name'] . ' Impression', ENT_QUOTES) ?>"
                      loading="lazy"
                      decoding="async"
                      class="h-full w-full object-cover transition duration-500 group-hover:scale-105"
                    />
                    <div class="pointer-events-none absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/20 to-[#0f1e2f]/80"></div>
                  <?php else: ?>
                    <div class="flex h-full w-full items-center justify-center">
                      <span class="text-4xl font-semibold text-[#4e759f]">
                        <?= htmlspecialchars(mb_substr($brand['name'], 0, 1)) ?>
                      </span>
                    </div>
                  <?php endif; ?>
                  <div class="pointer-events-none absolute inset-0 flex items-end p-4">
                    <h3 class="text-lg font-semibold <?= htmlspecialchars($titleClasses, ENT_QUOTES) ?>">
                      <?= htmlspecialchars($brand['name'], ENT_QUOTES) ?>
                    </h3>
                  </div>
                </div>
                <p class="text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($brand['text'], ENT_QUOTES) ?></p>
              </article>
            <?php endforeach; ?>
          </div>
          <?php if (!empty($section['cta'])): ?>
            <div class="pt-4">
              <a href="#termin" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-6 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-[#0f1e2f]/40">Jetzt Markenberatung buchen</a>
            </div>
          <?php endif; ?>
        </div>
      </section>
    <?php endforeach; ?>

    <!-- Vertrauen & Expertise -->
    <section class="bg-white py-16" aria-labelledby="vertrauen-heading">
      <div class="mx-auto max-w-5xl space-y-8 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="vertrauen-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Vertrauen Sie auf unsere Markenkompetenz
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Markenunabhängig, beratungsstark und handwerklich erfahren – wir zeigen Ihnen, welche Hersteller wirklich zu Ihnen passen.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-6 text-center sm:grid-cols-2 lg:grid-cols-4">
          <?php
            $pillars = [
              ['icon' => '🛏️', 'text' => 'Über 30 Markenpartner'],
              ['icon' => '🧵', 'text' => '100 Jahre Erfahrung'],
              ['icon' => '🧠', 'text' => 'Geschulte Schlafexperten'],
              ['icon' => '♻️', 'text' => 'Nachhaltige Materialien & faire Produktion'],
            ];
          ?>
          <?php foreach ($pillars as $pillar): ?>
            <div class="flex flex-col items-center gap-3 rounded-2xl border border-[#d6e2f1] bg-[#f6f7f9] p-6 shadow-md shadow-[#0f1e2f]/10">
              <div class="text-3xl" aria-hidden="true"><?= htmlspecialchars($pillar['icon'], ENT_QUOTES) ?></div>
              <p class="text-sm font-semibold text-[#0f1e2f]"><?= htmlspecialchars($pillar['text'], ENT_QUOTES) ?></p>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- Call to Action -->
    <section id="termin" class="bg-[#6793c4] py-16 text-white" aria-labelledby="cta-heading">
      <div class="mx-auto max-w-4xl space-y-6 px-6 text-center">
        <h2 id="cta-heading" class="text-2xl font-semibold sm:text-3xl">
          Sie wissen schon, welche Marke Sie interessiert?
        </h2>
        <p class="text-base leading-relaxed text-white/85 sm:text-lg">
          Vereinbaren Sie Ihre persönliche Markenberatung – kostenlos und unverbindlich. Wir nehmen uns Zeit für Ihre Fragen und Wünsche.
        </p>
        <div class="flex flex-col items-center gap-4 sm:flex-row sm:justify-center sm:gap-6">
          <a href="#kontakt" class="inline-flex items-center justify-center rounded-lg bg-white px-7 py-3 text-sm font-semibold uppercase tracking-wide text-[#0f1e2f] transition hover:bg-[#dce4ef] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
            Termin vereinbaren
          </a>
          <div class="text-sm text-white/85">
            <p>Telefon Köln: <a href="tel:+49221843236" class="underline hover:text-white">0221&nbsp;843236</a></p>
            <p>Telefon Inhausen: <a href="tel:+4922412414230" class="underline hover:text-white">02241&nbsp;2414230</a></p>
          </div>
        </div>
      </div>
    </section>

    <!-- Kontakt -->
    <section id="kontakt" class="bg-white py-16" aria-labelledby="kontakt-heading">
      <div class="mx-auto max-w-6xl gap-16 px-6 text-gray-700 lg:grid lg:grid-cols-[minmax(0,1fr)_minmax(0,1.05fr)] lg:px-0">
        <div class="space-y-6">
          <h2 id="kontakt-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Markenberatung anfragen
          </h2>
          <p class="text-base leading-relaxed sm:text-lg">
            Nennen Sie uns Ihre Wunschmarke oder Ihr Anliegen – wir bereiten uns auf Ihren Termin vor und melden uns werktags innerhalb von 24 Stunden.
          </p>
          <div class="space-y-4 text-sm text-gray-600">
            <div>
              <h3 class="text-lg font-semibold text-[#0f1e2f]">Betten-Sauer Köln</h3>
              <p>Brücker Mauspfad 539<br />51109 Köln</p>
              <p>Telefon: <a href="tel:+49221843236" class="text-[#4e759f] underline hover:text-[#2f506f]">0221&nbsp;843236</a></p>
              <p class="text-xs text-gray-500">Mo – Fr: 09:30 – 18:30 &bull; Sa: 10:00 – 14:00</p>
            </div>
            <div>
              <h3 class="text-lg font-semibold text-[#0f1e2f]">Betten-Sauer by Inhausen</h3>
              <p>Cecilienstraße 8<br />53721 Inhausen</p>
              <p>Telefon: <a href="tel:+4922412414230" class="text-[#4e759f] underline hover:text-[#2f506f]">02241&nbsp;2414230</a></p>
              <p class="text-xs text-gray-500">Mo – Fr: 10:00 – 18:00 &bull; Sa: 10:00 – 14:00</p>
            </div>
          </div>
        </div>
        <div>
          <form action="lead.php" method="POST" class="rounded-2xl border border-[#dce4ef] bg-white p-8 shadow-xl shadow-[#0f1e2f]/10" novalidate aria-describedby="kontakt-form-info">
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
              <div>
                <label for="marken-name" class="mb-1 block text-sm font-semibold text-gray-800">Name *</label>
                <input
                  type="text"
                  id="marken-name"
                  name="name"
                  required
                  aria-required="true"
                  autocomplete="name"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
              <div>
                <label for="marken-email" class="mb-1 block text-sm font-semibold text-gray-800">E-Mail *</label>
                <input
                  type="email"
                  id="marken-email"
                  name="email"
                  required
                  aria-required="true"
                  autocomplete="email"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
            </div>
            <div class="mt-6">
              <label for="marken-nachricht" class="mb-1 block text-sm font-semibold text-gray-800">Nachricht *</label>
              <textarea
                id="marken-nachricht"
                name="nachricht"
                rows="6"
                required
                aria-required="true"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              ></textarea>
            </div>
            <div class="mt-6 flex items-start gap-3">
              <input
                type="checkbox"
                id="marken-datenschutz"
                name="datenschutz"
                required
                aria-required="true"
                class="mt-1 h-5 w-5 cursor-pointer rounded border-gray-300 text-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:ring-offset-0"
              />
              <label for="marken-datenschutz" class="text-sm leading-relaxed text-gray-700">
                Ich bin damit einverstanden, dass Betten Sauer meine Angaben zur Kontaktaufnahme verarbeitet.
                Mehr Informationen in unserer <a href="datenschutz.php" class="text-[#4e759f] underline hover:text-[#2f506f]">Datenschutzerklärung</a>.
              </label>
            </div>
            <div class="mt-6">
              <div class="rounded-md border border-dashed border-gray-300 bg-gray-50 p-4 text-center text-sm text-gray-500">
                reCAPTCHA Platzhalter – hinterlegen Sie Ihren Site-Key für den Live-Betrieb.
              </div>
            </div>
            <div class="mt-8">
              <button type="submit" class="w-full rounded-lg bg-[#6793c4] px-6 py-3 text-base font-semibold text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-4 focus-visible:ring-[#4e759f]/30">
                Anfrage senden
              </button>
            </div>
          </form>
          <p id="kontakt-form-info" class="mt-4 text-xs text-gray-500">
            Alle mit * gekennzeichneten Felder sind Pflichtfelder.
          </p>
        </div>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
