<?php
// lead.php – nimmt Lead entgegen und sendet E-Mail an Joachim
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: https://auswahl-fuer-dich.de/html_sauer'); // <- ggf. anpassen
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }

$raw = file_get_contents('php://input');
$data = json_decode($raw, true) ?: [];

$name  = trim($data['name']  ?? '');
$phone = trim($data['phone'] ?? '');
$pref  = trim($data['time_preference'] ?? '');
$notes = trim($data['notes'] ?? '');
$url   = trim($data['url']   ?? '');
$ts    = trim($data['ts']    ?? date('c'));

if ($name === '' || preg_replace('/\D+/', '', $phone) === '' || strlen(preg_replace('/\D+/', '', $phone)) < 8) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'invalid_input']);
  exit;
}

$to   = 'joachimkaiser@online.de';
$subj = 'Neuer Chat-Lead – Betten Sauer';
$body = "Neuer Rückruf-Lead (Chat)\n\n"
      . "Name:  {$name}\n"
      . "Telefon: {$phone}\n"
      . "Wunschzeit: {$pref}\n"
      . "Hinweise: {$notes}\n\n"
      . "Seite: {$url}\n"
      . "Eingang: {$ts}\n";

$headers = [];
$headers[] = 'From: Betten Sauer Chat <no-reply@auswahl-fuer-dich.de.de>';
$headers[] = 'Reply-To: no-reply@auswahl-fuer-dich.de.de';
$headers[] = 'Content-Type: text/plain; charset=UTF-8';
$headers[] = 'X-Mailer: PHP/'.phpversion();

$ok = @mail($to, '=?UTF-8?B?'.base64_encode($subj).'?=', $body, implode("\r\n", $headers));

if ($ok) {
  echo json_encode(['ok' => true]);
} else {
  http_response_code(502);
  echo json_encode(['ok' => false, 'error' => 'mail_failed']);
}
