<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Lattenroste | Betten Sauer Köln &amp; Siegburg</title>
  <meta name="description" content="Lattenroste bei Betten Sauer: ergonomische Beratung, individuelle Liegeanalyse und Premium-Unterfederungen in Köln &amp; Siegburg. Finden Sie den Lattenrost, der Sie trägt." />
  <meta name="keywords" content="Lattenroste, ergonomischer Lattenrost, verstellbarer Lattenrost, Tellerrahmen, Lattenrost Köln, Lattenrost Siegburg, Matratzen und Lattenroste, Betten Sauer" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="lattenroste.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="lattenroste.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Lattenroste – Betten Sauer" />
  <meta property="og:description" content="Ergonomische Lattenroste und Tellerrahmen bei Betten Sauer. Persönliche Beratung in Köln und Siegburg für erholsamen Schlaf." />
  <meta property="og:image" content="images/1200x800_lattenrost.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Lattenroste – Betten Sauer" />
  <meta name="twitter:description" content="Lattenroste mit Liegeanalyse bei Betten Sauer Köln &amp; Siegburg. Finden Sie den Unterbau für gesunden Schlaf." />
  <meta name="twitter:image" content="images/1200x800_lattenrost.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <section class="relative">
      <div class="relative hidden lg:block">
        <div class="relative h-[340px] sm:h-[380px] md:h-[440px] lg:h-[500px]">
          <img
            src="images/header/header_lattenrost.jpg"
            alt="Ergonomischer Lattenrost in warmem Schlafzimmer mit Holzdetails"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
            decoding="async"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/50"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/45 to-[#0f1e2f]/75"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_lattenrost.jpg"
          alt="Lattenrost – mobile Ansicht"
          class="hero-mobile-img"
          loading="eager"
          decoding="async"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-5 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center lg:justify-end">
        <div class="w-full max-w-5xl space-y-5 lg:w-1/2 lg:px-12">
          <h1 class="text-3xl font-semibold text-shadow sm:text-4xl md:text-5xl lg:ml-auto">
            Der richtige Lattenrost – das Fundament für erholsamen Schlaf
          </h1>
          <p class="text-base sm:text-lg md:text-xl text-white/90 lg:ml-auto">
            Ein Lattenrost, der Körper und Matratze perfekt unterstützt, trägt Sie – jede Nacht. Wir zeigen Ihnen, wie sich dieses stabile, leichte Gefühl anfühlt.
          </p>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-6xl px-6 lg:px-8 text-gray-700">
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-[minmax(0,1fr)_minmax(0,2fr)] lg:items-center">
          <div class="flex justify-center lg:justify-start">
            <img src="images/produktbilder/lattenrost/lattenrost.jpg" alt="Lattenrost" class="w-full max-w-md rounded-lg shadow-lg" />
          </div>
          <div class="space-y-6">
            <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Das unsichtbare Fundament Ihres Schlafs.</h2>
            <p class="text-base leading-relaxed sm:text-lg">Stellen Sie sich vor, Sie legen sich hin und der Rücken wird sofort getragen. Es entsteht, wenn der Lattenrost Bewegungen elastisch auffängt und Luft zirkuliert. Bei Betten Sauer denken wir jedes Bettsystem als Einheit.</p>
            <p class="text-base leading-relaxed sm:text-lg">Seit 1823 beraten wir in Köln und Siegburg Menschen, die ihrem Schlaf Aufmerksamkeit schenken. Wir analysieren Ihre Liegegewohnheiten und empfehlen den Lattenrost, der Ihre Matratze ergänzt – vom Tellerrahmen bis zur verstellbaren Komfortlösung.</p>
          </div>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Warum der Lattenrost so wichtig ist</h2>
        <p class="text-base leading-relaxed sm:text-lg">Der Lattenrost stützt die Matratze, lässt Schultern und Becken tiefer einsinken und hält dort gegen, wo die Wirbelsäule Stabilität braucht. Gleichzeitig fördert er die Luftzirkulation, damit Feuchtigkeit entweichen kann und das Schlafklima angenehm bleibt.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Tragen statt drücken</h3>
            <p class="mt-3 text-sm leading-relaxed">Viele Rücken- oder Schulterprobleme entstehen, wenn der Unterbau starr ist. Eine anpassungsfähige Unterfederung entlastet Bandscheiben und Muskulatur spürbar.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Mehr Atem für die Matratze</h3>
            <p class="mt-3 text-sm leading-relaxed">Offene Lamellen oder Teller fördern die Luftzirkulation. So bleibt die Matratze trocken und hygienisch – ideal bei Allergien oder nächtlichem Schwitzen.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Ruhiger Schlaf</h3>
            <p class="mt-3 text-sm leading-relaxed">Ein abgestimmter Lattenrost reagiert leise und punktgenau auf jede Bewegung. Sie drehen sich um, ohne dass der Körper „gegenarbeiten“ muss.</p>
          </article>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Komfort und Ergonomie in einem</h2>
        <p class="text-base leading-relaxed sm:text-lg">Moderne Lattenroste ermöglichen Schulterabsenkung, stabilisieren die Mittelzone und bringen Sie mit sanfter Verstellung in Ihre Wohlfühlposition. Wir justieren die Zonen so, dass Ihr Körper in Balance bleibt.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-4">
          <article class="flex h-full flex-col rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 pb-6 shadow-sm">
            <div>
              <h3 class="text-lg font-semibold text-[#4e759f]">Schulterabsenkung</h3>
              <p class="mt-3 text-sm leading-relaxed">Nachgiebige Lamellen oder Teller geben im Schulterbereich nach – die Halswirbelsäule bleibt entspannt.</p>
            </div>
            <figure class="mt-auto flex justify-center pt-6">
              <img src="images/produktbilder/lattenrost/schulterabsenkung.jpg" alt="Lattenrost mit Schulterabsenkung" class="h-32 w-full rounded-lg object-cover" loading="lazy" decoding="async" />
            </figure>
          </article>
          <article class="flex h-full flex-col rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 pb-6 shadow-sm">
            <div>
              <h3 class="text-lg font-semibold text-[#4e759f]">Mittelzonen verstärkung</h3>
              <p class="mt-3 text-sm leading-relaxed">Verstellbare Schieber stärken den Lendenbereich. So bleibt das Becken in Position und die Bandscheiben werden entlastet.</p>
            </div>
            <figure class="mt-auto flex justify-center pt-6">
              <img src="images/produktbilder/lattenrost/lendenbereich.jpg" alt="Lattenrost mit Mittelzonenverstärkung" class="h-32 w-full rounded-lg object-cover" loading="lazy" decoding="async" />
            </figure>
          </article>
          <article class="flex h-full flex-col rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 pb-6 shadow-sm">
            <div>
              <h3 class="text-lg font-semibold text-[#4e759f]">Elektrische Verstellung</h3>
              <p class="mt-3 text-sm leading-relaxed">Per Handsender oder App in die Wunschposition – angenehm zum Entspannen, für die Beinentspannung oder einen sanften Start in den Morgen.</p>
            </div>
            <figure class="mt-auto flex justify-center pt-6">
              <img src="images/produktbilder/lattenrost/verstellung.jpg" alt="Lattenrost mit elektrischer Verstellung" class="h-32 w-full rounded-lg object-cover" loading="lazy" decoding="async" />
            </figure>
          </article>
          <article class="flex h-full flex-col rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 pb-6 shadow-sm">
            <div>
              <h3 class="text-lg font-semibold text-[#4e759f]">Komfortable Einstiegshöhe</h3>
              <p class="mt-3 text-sm leading-relaxed">Rahmenhöhe, Füße und Motorrahmen stimmen wir so ab, dass Sie mühelos aufstehen – ideal, wenn Gelenke oder Rücken sensibel reagieren.</p>
            </div>
            <figure class="mt-auto flex justify-center pt-6">
              <img src="images/produktbilder/lattenrost/einstiegshoehe.jpg" alt="Lattenrost mit komfortabler Einstiegshöhe" class="h-32 w-full rounded-lg object-cover" loading="lazy" decoding="async" />
            </figure>
          </article>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-4xl px-6 lg:px-0 space-y-8 text-gray-700 text-center">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Individuelle Beratung bei Betten Sauer</h2>
        <p class="text-base leading-relaxed sm:text-lg">Unsere zertifizierten Schlafberaterinnen und Schlafberater kombinieren Messdaten mit Erfahrung. Bringen Sie Ihren aktuellen Lattenrost oder Ihre Matratze mit – wir prüfen das Zusammenspiel, nehmen Feinjustierungen vor und zeigen Alternativen.</p>
        <p class="text-base leading-relaxed sm:text-lg">In Köln und Siegburg erwarten Sie ruhige Beratungsräume und Tradition seit 1823. Sie probeliegen, spüren die Einstellungen und finden das System, das Sie langfristig trägt.</p>
      </div>
    </section>

    <section class="bg-[#0f1e2f] py-16 text-white">
      <div class="mx-auto max-w-4xl px-6 text-center space-y-6">
        <h2 class="text-2xl font-semibold sm:text-3xl">Lassen Sie sich persönlich beraten</h2>
        <p class="text-base leading-relaxed sm:text-lg text-white/85">Lassen Sie sich bei Betten Sauer persönlich beraten – wir finden den Lattenrost, der Sie wirklich trägt.</p>
        <a href="index.php#kontaktformular" class="inline-flex items-center justify-center rounded-lg bg-white px-7 py-3 text-sm font-semibold uppercase tracking-wide text-[#4e759f] transition hover:bg-[#dce6f5] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
          Beratungstermin vereinbaren
        </a>
      </div>
    </section>

    <?php require __DIR__ . '/kontakt_sektion.php'; ?>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>

  <!-- Meta Title: Lattenroste | Betten Sauer Köln & Siegburg -->
  <!-- Meta Description: Ergonomische Lattenroste & Tellerrahmen bei Betten Sauer – persönliche Beratung und Liegeanalyse in Köln & Siegburg. -->
</body>
</html>
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Lattenrost ist nicht gleich Lattenrost</h2>
        <p class="text-base leading-relaxed sm:text-lg">Je nach Schlafgewohnheiten, körperlichen Bedürfnissen und gewünschtem Komfort empfehlen wir unterschiedliche Systeme. In unserer Ausstellung erleben Sie die Unterschiede unmittelbar – wir erklären, wie jeder Lattenrost arbeitet und wo er seine Stärken ausspielt.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-4">
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm h-full">
            <h3 class="text-lg font-semibold text-[#4e759f]">Starre Lattenroste</h3>
            <p class="mt-3 text-sm leading-relaxed">Solide Basis für schlichtes Liegen, gut für Gästezimmer oder feste Matratzen, wenn die Matratze selbst stark zoniert ist.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm h-full">
            <h3 class="text-lg font-semibold text-[#4e759f]">Manuell verstellbar</h3>
            <p class="mt-3 text-sm leading-relaxed">Kopf- oder Fußteil lassen sich anheben – ideal, wenn Sie lesen, fernsehen oder die Beine entlasten möchten.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm h-full">
            <h3 class="text-lg font-semibold text-[#4e759f]">Motorische Lattenroste</h3>
            <p class="mt-3 text-sm leading-relaxed">Mit einem Tastendruck in die Lieblingsposition: Entlastung für Rücken und Beine, komfortabel beim Lesen und beim Aufstehen.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm h-full">
            <h3 class="text-lg font-semibold text-[#4e759f]">Tellerrahmen</h3>
            <p class="mt-3 text-sm leading-relaxed">Flexible Teller reagieren punktgenau. Schulter und Becken sinken fein dosiert ein, Drehbewegungen bleiben ruhig – ideal für sensible Schläferinnen und Schläfer.</p>
          </article>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Das perfekte Zusammenspiel – Matratze &amp; Lattenrost</h2>
        <p class="text-base leading-relaxed sm:text-lg">Matratze und Lattenrost sind ein Duo: Erst wenn beide abgestimmt sind, entfalten sich ergonomische Zonen. Deshalb testen wir Ihre Matratze bei Betten Sauer immer auf dem passenden Unterbau und justieren Schulterabsenkung, Mittelzone und Hüftstütze auf Ihr Profil.</p>
        <div class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
          <h3 class="text-lg font-semibold text-[#4e759f]">Unser Systemcheck</h3>
          <ul class="mt-3 space-y-2 text-sm leading-relaxed">
            <li>&bull; Analyse Ihrer bisherigen Kombination aus Matratze und Lattenrost</li>
            <li>&bull; Feinanpassung der Latten- oder Tellerzonen auf Ihr Körperprofil</li>
            <li>&bull; Empfehlung für Matratzen, die mit Ihrem neuen Lattenrost harmonieren</li>
          </ul>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
