<?php
$kontaktSectionTitle = $kontaktSectionTitle ?? 'Haben Sie Fragen?';
$kontaktSectionIntro = $kontaktSectionIntro ?? 'Nutzen Sie unsere seit 1823 gesammelte Erfahrung und nehmen Sie Kontakt mit uns auf, damit wir einen Termin für eine individuelle Schlafberatung vereinbaren können.';
$kontaktFormAction = $kontaktFormAction ?? 'kontakt_absenden.php';
$kontaktFormMethod = $kontaktFormMethod ?? 'POST';
$kontaktRecaptchaSiteKey = $kontaktRecaptchaSiteKey ?? '';
?>

<section class="bg-[#f7f9fc] py-16" aria-labelledby="kontakt-section-heading">
  <div class="mx-auto grid max-w-6xl grid-cols-1 gap-16 px-4 lg:grid-cols-[minmax(0,1fr)_minmax(0,1.1fr)] lg:px-8">
    <!-- Kontaktinformationen -->
    <div class="space-y-8 text-gray-700">
      <div class="space-y-4">
        <h2 id="kontakt-section-heading" class="text-3xl font-semibold text-[#4e759f] sm:text-4xl">
          <?= htmlspecialchars($kontaktSectionTitle, ENT_QUOTES) ?>
        </h2>
        <p class="text-base leading-relaxed text-gray-600">
          <?= htmlspecialchars($kontaktSectionIntro, ENT_QUOTES) ?>
        </p>
      </div>

      <div class="space-y-10">
        <!-- Standort Köln -->
        <div class="space-y-3">
          <h3 class="text-2xl font-semibold text-[#4e759f]">Betten-Sauer Köln</h3>
          <p class="text-base leading-relaxed">
            Brücker Mauspfad 539, 51109 Köln
          </p>
          <ul class="space-y-1 text-base">
            <li>Telefon: <a href="tel:+49221843236" class="text-[#4e759f] underline hover:text-[#2f506f]">0221 843236</a></li>
            <li>Fax: 0221 844349</li>
            <li>E-Mail: <a href="mailto:info@betten-sauer.de" class="text-[#4e759f] underline hover:text-[#2f506f]">info@betten-sauer.de</a></li>
          </ul>
          <div>
            <span class="font-semibold text-gray-800">Öffnungszeiten:</span>
            <p>Mo – Fr: 09:30 – 18:30 &nbsp;&bull;&nbsp; Sa: 10:00 – 14:00</p>
          </div>
        </div>

        <!-- Standort Siegburg -->
        <div class="space-y-3">
          <h3 class="text-2xl font-semibold text-[#4e759f]">Betten-Sauer by Inhausen</h3>
          <p class="text-base leading-relaxed">
            Cecilienstraße 8, 53721 Siegburg
          </p>
          <ul class="space-y-1 text-base">
            <li>Telefon: <a href="tel:+4922412414230" class="text-[#4e759f] underline hover:text-[#2f506f]">02241 2414230</a></li>
          </ul>
          <div>
            <span class="font-semibold text-gray-800">Öffnungszeiten:</span>
            <p>Mo – Fr: 10:00 – 18:00 &nbsp;&bull;&nbsp; Sa: 10:00 – 14:00</p>
          </div>
        </div>
      </div>
    </div>

    <!-- Kontaktformular -->
    <div>
      <form
        class="rounded-xl border border-[#dce4ef] bg-white p-8 shadow-xl shadow-[#0f1e2f]/5"
        action="<?= htmlspecialchars($kontaktFormAction, ENT_QUOTES) ?>"
        method="<?= htmlspecialchars(strtoupper($kontaktFormMethod), ENT_QUOTES) ?>"
        novalidate
        aria-describedby="kontakt-form-info"
      >
        <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
          <div>
            <label for="kontakt-name" class="mb-1 block text-sm font-semibold text-gray-800">Name *</label>
            <input
              type="text"
              id="kontakt-name"
              name="name"
              required
              aria-required="true"
              autocomplete="name"
              class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
            />
          </div>
          <div>
            <label for="kontakt-email" class="mb-1 block text-sm font-semibold text-gray-800">E-Mail *</label>
            <input
              type="email"
              id="kontakt-email"
              name="email"
              required
              aria-required="true"
              autocomplete="email"
              class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
            />
          </div>
        </div>

        <div class="mt-6">
          <label for="kontakt-nachricht" class="mb-1 block text-sm font-semibold text-gray-800">Nachricht *</label>
          <textarea
            id="kontakt-nachricht"
            name="nachricht"
            rows="6"
            required
            aria-required="true"
            class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
          ></textarea>
        </div>

        <div class="mt-6 flex items-start gap-3">
          <input
            type="checkbox"
            id="kontakt-datenschutz"
            name="datenschutz"
            required
            aria-required="true"
            class="mt-1 h-5 w-5 cursor-pointer rounded border-gray-300 text-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:ring-offset-0"
          />
          <label for="kontakt-datenschutz" class="text-sm leading-relaxed text-gray-700">
            Ich bin damit einverstanden, dass meine Daten im Bezug auf meine Anfrage gespeichert und genutzt werden.
            Mehr dazu finden Sie in unserer <a href="datenschutz.php" class="text-[#4e759f] underline hover:text-[#2f506f]">Datenschutzerklärung</a>.
          </label>
        </div>

        <div class="mt-6">
          <?php if (!empty($kontaktRecaptchaSiteKey)): ?>
            <div class="g-recaptcha" data-sitekey="<?= htmlspecialchars($kontaktRecaptchaSiteKey, ENT_QUOTES) ?>"></div>
            <script src="https://www.google.com/recaptcha/api.js" async defer></script>
          <?php else: ?>
            <div class="rounded-md border border-dashed border-gray-300 bg-gray-50 p-4 text-center text-sm text-gray-500">
              reCAPTCHA Platzhalter – hinterlegen Sie Ihren Site-Key in <code>$kontaktRecaptchaSiteKey</code>.
            </div>
          <?php endif; ?>
        </div>

        <div class="mt-8">
          <button
            type="submit"
            class="w-full rounded-lg bg-[#6793c4] px-6 py-3 text-center text-base font-semibold text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-4 focus-visible:ring-[#4e759f]/30"
          >
            Absenden
          </button>
        </div>
      </form>

      <p id="kontakt-form-info" class="mt-4 text-xs text-gray-500">
        Alle mit * gekennzeichneten Felder sind Pflichtfelder.
      </p>
    </div>
  </div>
</section>
