<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Kissen &amp; Nackenstützkissen | Betten Sauer Köln</title>
  <meta name="description" content="Kissen &amp; Nackenstützkissen bei Betten Sauer: ergonomische Beratung, individuelle Liegeanalyse und Premium-Materialien in Köln und Siegburg. Finden Sie Ihr Wohlfühlkissen." />
  <meta name="keywords" content="Kissen &amp; Nackenstützkissen, Nackenstützkissen kaufen, ergonomisches Kissen, Schlafkomfort, Kissenberatung Köln, Kissen Siegburg, Kissen gegen Nackenschmerzen" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="kissen.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="kissen.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Kissen &amp; Nackenstützkissen – Betten Sauer" />
  <meta property="og:description" content="Finden Sie Ihr persönliches Wohlfühlkissen bei Betten Sauer in Köln und Siegburg. Ergonomische Kissenberatung und Premium-Materialien seit 1823." />
  <meta property="og:image" content="images/1200x800_kissen.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Kissen &amp; Nackenstützkissen – Betten Sauer" />
  <meta name="twitter:description" content="Nackenstützkissen und ergonomische Kissen mit persönlicher Beratung bei Betten Sauer Köln &amp; Siegburg." />
  <meta name="twitter:image" content="images/1200x800_kissen.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <section class="relative">
      <div class="relative hidden lg:block">
        <div class="relative h-[340px] sm:h-[380px] md:h-[440px] lg:h-[500px]">
          <img
            src="images/header/header_kissen.jpg"
            alt="Ergonomisches Nackenstützkissen und Daunenkissen in einem ruhigen Schlafzimmer"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
            decoding="async"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/50"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/45 to-[#0f1e2f]/75"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_kissen.jpg"
          alt="Kissen-Inszenierung – mobile Ansicht"
          class="hero-mobile-img"
          loading="eager"
          decoding="async"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-5 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center lg:justify-end">
        <div class="w-full max-w-5xl space-y-5 lg:w-1/2 lg:px-12">
          <h1 class="text-3xl font-semibold text-shadow sm:text-4xl md:text-5xl lg:ml-auto">
            Das richtige Kissen – weil gesunder Schlaf am Hals beginnt
          </h1>
          <p class="text-base sm:text-lg md:text-xl text-white/90 lg:ml-auto">
            Wenn Kopf, Nacken und Schultern getragen werden, entsteht dieses leichte Morgen-Gefühl, das den ganzen Tag begleitet. Wir zeigen Ihnen, wie sich ein perfekt abgestimmtes Kissen anfühlt.
          </p>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-6xl px-6 lg:px-8 text-gray-700">
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-[minmax(0,1.8fr)_minmax(0,1fr)] lg:items-center">
          <div class="space-y-6">
            <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Kissen, die sich anfühlen wie für Sie gemacht.</h2>
            <p class="text-base leading-relaxed sm:text-lg">Stellen Sie sich vor, Sie sinken ins Bett und Ihr Kissen nimmt den Kopf sofort auf. Dieses Gefühl entsteht, wenn Kissenhöhe, Stützkraft und Material zusammenpassen – abgestimmt auf Ihre Matratze, Ihren Körperbau und Ihre Schlafgewohnheiten.</p>
            <p class="text-base leading-relaxed sm:text-lg">Seit 1823 begleitet Betten Sauer Menschen, die auf ehrliche Beratung setzen. Wir hören zu, analysieren Schmerzen oder Verspannungen und wählen Kissen &amp; Nackenstützkissen, die ergonomische Unterstützung mit luxuriösem Schlafkomfort verbinden.</p>
          </div>
          <figure class="overflow-hidden rounded-xl shadow-lg">
            <img
              src="images/produktbilder/kissen/frau_kissen.jpg"
              alt="Frau legt sich entspannt mit ergonomischem Kissen zur Ruhe"
              class="h-full w-full object-cover"
              loading="lazy"
              decoding="async"
            />
          </figure>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Warum das richtige Kissen so wichtig ist</h2>
        <p class="text-base leading-relaxed sm:text-lg">Der Hals ist die Brücke zwischen Kopf und Wirbelsäule. Passt das Kissen nicht, spannen Muskeln an, es drohen Kopfschmerzen und unruhige Nächte. Stimmen Höhe und Stützkraft, bleibt die Halslordose entspannt und der Körper findet leichter in tiefen Schlaf.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 pb-20 shadow-sm relative">
            <h3 class="text-lg font-semibold text-[#4e759f]">Verspannungen vorbeugen</h3>
            <p class="mt-3 text-sm leading-relaxed">Ein ergonomisches Kissen hält den Kopf achsgerecht, die Muskulatur entspannt sich und die Wirbelsäule regeneriert.</p>
            <img src="images/produktbilder/kissen/schmerz_small.png" alt="Illustration zu Nacken- und Schulterentspannung" class="pointer-events-none absolute bottom-4 right-4 h-16 w-16 object-contain opacity-90" loading="lazy" decoding="async" />
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 pb-20 shadow-sm relative">
            <h3 class="text-lg font-semibold text-[#4e759f]">Besser durchschlafen</h3>
            <p class="mt-3 text-sm leading-relaxed">Wer nicht nach einer neuen Position sucht, schläft tiefer – das passende Kissen beruhigt Bewegungen und Atem.</p>
            <img src="images/produktbilder/kissen/durchschlafen_small.png" alt="Illustration eines entspannten Schlafenden" class="pointer-events-none absolute bottom-4 right-4 h-16 w-16 object-contain opacity-90" loading="lazy" decoding="async" />
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 pb-20 shadow-sm relative">
            <h3 class="text-lg font-semibold text-[#4e759f]">Wohlbefinden am Morgen</h3>
            <p class="mt-3 text-sm leading-relaxed">Stützkraft dämpft Druckpunkte, fördert die Durchblutung und lässt Sie klarer in den Tag starten.</p>
            <img src="images/produktbilder/kissen/fit_small.png" alt="Illustration für Energie am Morgen" class="pointer-events-none absolute bottom-4 right-4 h-16 w-16 object-contain opacity-90" loading="lazy" decoding="async" />
          </article>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Kissen ist nicht gleich Kissen</h2>
        <p class="text-base leading-relaxed sm:text-lg">Unsere Kollektion reicht von weichen Daunenkissen über formstabile Nackenstützkissen bis zu innovativen Gel- und Latexschaummodellen. Jede Variante erfüllt einen klaren Zweck – gemeinsam finden wir den Begleiter, der Ihre Liegefläche ergänzt.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 pb-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Daunenkissen</h3>
            <p class="mt-3 text-sm leading-relaxed">Federleicht, formbar und kuschelig. Ideal für Schläfer, die sanfte Unterstützung wünschen und ihr Kissen gern anpassen. Unsere Daunen stammen aus kontrollierten Quellen und sind waschbar.</p>
            <figure class="mt-6">
              <img src="images/produktbilder/kissen/dormabell_daunenkissen.jpg" alt="Daunenkissen aus der Kollektion von Betten Sauer" class="h-32 w-full rounded-lg object-cover" loading="lazy" decoding="async" />
            </figure>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 pb-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Nackenstützkissen</h3>
            <p class="mt-3 text-sm leading-relaxed">Mit ergonomischem Profil, herausnehmbaren Einlagen und unterschiedlichen Höhen stützen sie den Halsbereich gezielt. Perfekt bei Nackenbeschwerden oder für Menschen, die klar definierte Stützzonen bevorzugen.</p>
            <figure class="mt-6">
              <img src="images/produktbilder/kissen/nackenstuetzkissen.jpg" alt="Nackenstützkissen mit ergonomischem Profil" class="h-32 w-full rounded-lg object-cover" loading="lazy" decoding="async" />
            </figure>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 pb-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Faserkissen bzw. Naturfaserkissen</h3>
            <p class="mt-3 text-sm leading-relaxed">Faserkissen sind waschbar, trocknergeeignet und ideal für Allergiker. Ihre Höhe ist variabel. Naturfaserkissen nehmen Feuchtigkeit besser auf und bieten festeren Komfort.</p>
            <figure class="mt-6">
              <img src="images/produktbilder/kissen/faserkissen.jpg" alt="Faserkissen als pflegeleichte Alternative" class="h-32 w-full rounded-lg object-cover" loading="lazy" decoding="async" />
            </figure>
          </article>
        </div>
        <p class="text-base leading-relaxed sm:text-lg">Ob ergonomisches Kissen oder anschmiegsame Daune – entscheidend ist die Abstimmung mit Ihrem Bettsystem und Ihrem gewünschten Schlafklima.</p>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Welches Kissen passt zu mir?</h2>
        <p class="text-base leading-relaxed sm:text-lg">Die perfekte Kissenhöhe hängt von der Schlafposition, der Schulterbreite, der Matratzenhärte und Ihrem persönlichen Wohlfühlfaktor ab. Deshalb analysieren wir im Beratungsgespräch alle Parameter und testen gemeinsam verschiedene Varianten.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Nach Schlafposition</h3>
            <ul class="mt-3 list-disc pl-6 space-y-2 text-sm leading-relaxed">
              <li>Seitenschläfer: Schulterfreiheit und stabile Höhe für eine waagerechte Wirbelsäule.</li>
              <li>Rückenschläfer: moderate Unterstützung, die das Kinn nicht nach vorn drückt.</li>
              <li>Bauchschläfer: flache, formbare Kissen gegen Überdehnung des Nackens.</li>
            </ul>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Individuelle Bedürfnisse</h3>
            <ul class="mt-3 list-disc pl-6 space-y-2 text-sm leading-relaxed">
              <li>Allergien: waschbare Bezüge, milbenarme Füllungen, OEKO-TEX Zertifizierung.</li>
              <li>Wärmeempfinden: Tencel- oder Latexkerne für spürbare Frische.</li>
              <li>Haltungsprobleme: modulare Nackenstützkissen mit anpassbaren Einlagen.</li>
            </ul>
          </article>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Für sensible Schläfer – Materialien, die atmen</h2>
        <p class="text-base leading-relaxed sm:text-lg">Hautfreundliche Stoffe und atmungsaktive Kerne sind für empfindliche Schläfer unverzichtbar. Unsere Kissen vereinen natürliche Fasern, moderne Technik und verantwortungsvolle Produktion.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Tencel &amp; Baumwolle</h3>
            <p class="mt-3 text-sm leading-relaxed">Seidig, feuchtigkeitsregulierend und sanft zur Haut. Perfekt für Menschen, die nachts schnell schwitzen oder Wert auf pflanzliche Fasern legen.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Latex &amp; Naturkautschuk</h3>
            <p class="mt-3 text-sm leading-relaxed">Federnd und stützend zugleich. Die offene Zellstruktur lässt Luft zirkulieren, die antibakterielle Wirkung unterstützt Allergiker.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Zertifizierte Qualität</h3>
            <p class="mt-3 text-sm leading-relaxed">Viele Kissen tragen OEKO-TEX oder GOTS Siegel, sind waschbar und behalten ihre Formstabilität über Jahre – für hygienischen Schlafkomfort.</p>
          </article>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700 text-center">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Individuelle Beratung bei Betten Sauer</h2>
        <p class="text-base leading-relaxed sm:text-lg">Unsere Kissenberatung verbindet Messtechnik mit dem geschulten Blick eines Traditionshauses. Bringen Sie Ihr aktuelles Kissen mit – wir analysieren es, testen Alternativen und zeigen den Unterschied unmittelbar.</p>
        <p class="text-base leading-relaxed sm:text-lg">In Köln und Siegburg erwarten Sie zertifizierte Schlafexpertinnen, ruhige Beratungsräume und die Erfahrung eines Familienunternehmens seit 1823. Wir nehmen uns Zeit und begleiten Sie bis zum passenden Nackenstützkissen.</p>
      </div>
    </section>

    <section class="bg-[#0f1e2f] py-16 text-white">
      <div class="mx-auto max-w-5xl px-6 text-center space-y-6">
        <h2 class="text-2xl font-semibold sm:text-3xl">Finden Sie Ihr persönliches Wohlfühlkissen</h2>
        <p class="text-base leading-relaxed sm:text-lg text-white/85">Lassen Sie sich in Köln oder Siegburg persönlich beraten und erleben Sie den Unterschied eines abgestimmten Kissensystems.</p>
        <a href="index.php#kontaktformular" class="inline-flex items-center justify-center rounded-lg bg-white px-7 py-3 text-sm font-semibold uppercase tracking-wide text-[#4e759f] transition hover:bg-[#dce6f5] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
          Beratungstermin vereinbaren
        </a>
      </div>
    </section>

    <?php require __DIR__ . '/kontakt_sektion.php'; ?>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>

  <!-- Meta Title: Kissen & Nackenstützkissen | Betten Sauer Köln -->
  <!-- Meta Description: Ergonomische Kissenberatung in Köln & Siegburg – Kissen & Nackenstützkissen von Betten Sauer für entspannten Schlafkomfort. -->
</body>
</html>
