console.log('menu.js loaded');

document.addEventListener('DOMContentLoaded', function() {
  console.log('DOM loaded');
  
  const menuToggle = document.getElementById('menuToggle');
  const mobileMenu = document.getElementById('mobileMenu');
  const mobileOverlay = document.getElementById('mobileMenuOverlay');
  
  console.log('menuToggle:', menuToggle);
  console.log('mobileMenu:', mobileMenu);
  console.log('mobileOverlay:', mobileOverlay);
  
  if (!menuToggle || !mobileMenu) {
    console.error('Elements not found!');
    return;
  }
  
  menuToggle.addEventListener('click', function(e) {
    e.preventDefault();
    console.log('Button clicked!');
    
    const isOpen = mobileMenu.style.transform === 'translateX(0px)';
    console.log('Is open:', isOpen);
    
    if (isOpen) {
      // Close
      mobileMenu.style.transform = 'translateX(100%)';
      mobileOverlay.style.display = 'none';
      document.body.style.overflow = '';
    } else {
      // Open
      mobileMenu.style.transform = 'translateX(0)';
      mobileOverlay.style.display = 'block';
      document.body.style.overflow = 'hidden';
    }
  });
  
  // Close on overlay click
  if (mobileOverlay) {
    mobileOverlay.addEventListener('click', function() {
      mobileMenu.style.transform = 'translateX(100%)';
      mobileOverlay.style.display = 'none';
      document.body.style.overflow = '';
    });
  }
  
  // Close button
  const closeBtn = document.querySelector('[data-close-mobile-menu]');
  if (closeBtn) {
    closeBtn.addEventListener('click', function() {
      mobileMenu.style.transform = 'translateX(100%)';
      mobileOverlay.style.display = 'none';
      document.body.style.overflow = '';
    });
  }
  
  console.log('Menu initialized');
});