<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Betten-Sauer Köln | Betten, Matratzen &amp; Schlafberatung</title>
   <!-- Die vom Nutzer gewünschten Favicon-Links wurden hier hinzugefügt -->
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif"/>
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png"/>
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png" />
  <meta name="description" content="Betten-Sauer in Köln bietet seit über 200 Jahren individuelle Schlafberatung, hochwertige Boxspringbetten, Matratzen und Bettwaren führender Marken. Vereinbaren Sie Ihren Beratungstermin für erholsamen Schlaf." />
  <meta name="keywords" content="Betten-Sauer Köln, Bettenfachgeschäft Köln, Boxspringbetten Köln, Matratzen Beratung Köln, Schlafberatung Köln" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="#/" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="#/" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Betten-Sauer Köln – Fachgeschäft für Betten &amp; Schlafkomfort" />
  <meta property="og:description" content="Erleben Sie individuelle Schlafberatung, Premium-Matratzen, Boxspringbetten und Bettwaren bei Betten-Sauer in Köln. Tradition trifft Schlafinnovation." />
  <meta property="og:image" content="#/html_sauer/images/1200x800_boxspringbett.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Betten-Sauer Köln – Fachgeschäft für Betten &amp; Schlafkomfort" />
  <meta name="twitter:description" content="Erleben Sie individuelle Schlafberatung, Premium-Matratzen, Boxspringbetten und Bettwaren bei Betten-Sauer in Köln. Tradition trifft Schlafinnovation." />
  <meta name="twitter:image" content="#/html_sauer/images/1200x800_boxspringbett.webp" />
  <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "FurnitureStore",
      "name": "Betten-Sauer KG",
      "description": "Traditionsreiches Bettenfachgeschäft in Köln mit individueller Schlafberatung, Premium-Matratzen, Boxspringbetten und maßgeschneiderten Schlafsystemen.",
      "url": "#/",
      "image": "#/html_sauer/images/1200x800_boxspringbett.webp",
      "telephone": "+49-221-843236",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "Brücker Mauspfad 539",
        "postalCode": "51109",
        "addressLocality": "Köln",
        "addressCountry": "DE"
      },
      "openingHoursSpecification": [
        {
          "@type": "OpeningHoursSpecification",
          "dayOfWeek": [
            "Monday",
            "Tuesday",
            "Wednesday",
            "Thursday",
            "Friday"
          ],
          "opens": "09:00",
          "closes": "18:00"
        },
        {
          "@type": "OpeningHoursSpecification",
          "dayOfWeek": "Saturday",
          "opens": "09:00",
          "closes": "14:00"
        }
      ],
      "priceRange": "€€",
      "areaServed": {
        "@type": "AdministrativeArea",
        "name": "Köln"
      }
    }
  </script>

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Swiper -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>

  <style>
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Light.woff2') format('woff2'),
           url('fonts/WorkSans-Light.woff') format('woff');
      font-weight: 300;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-LightItalic.woff2') format('woff2'),
           url('fonts/WorkSans-LightItalic.woff') format('woff');
      font-weight: 300;
      font-style: italic;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Regular.woff2') format('woff2'),
           url('fonts/WorkSans-Regular.woff') format('woff');
      font-weight: 400;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Italic.woff2') format('woff2'),
           url('fonts/WorkSans-Italic.woff') format('woff');
      font-weight: 400;
      font-style: italic;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-SemiBold.woff2') format('woff2'),
           url('fonts/WorkSans-SemiBold.woff') format('woff');
      font-weight: 600;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-SemiBoldItalic.woff2') format('woff2'),
           url('fonts/WorkSans-SemiBoldItalic.woff') format('woff');
      font-weight: 600;
      font-style: italic;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Bold.woff2') format('woff2'),
           url('fonts/WorkSans-Bold.woff') format('woff');
      font-weight: 700;
      font-style: normal;
      font-display: swap;
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-BoldItalic.woff2') format('woff2'),
           url('fonts/WorkSans-BoldItalic.woff') format('woff');
      font-weight: 700;
      font-style: italic;
      font-display: swap;
    }
    html, body { font-family: 'Work Sans', sans-serif; color: #3a3a3a; scroll-behavior: smooth; }
    h2, h3, h4, h5, h6 { color: #6793c4; }
    .text-shadow { text-shadow: 0 2px 8px rgba(0,0,0,.6); }

    @keyframes fadeIn { from {opacity:0;} to {opacity:1;} }
    .fade-in { opacity:0; animation:fadeIn 2s ease forwards; animation-delay:2s; }
    .fade-in-sub { opacity:0; animation:fadeIn 2s ease forwards; animation-delay:4s; }
    .fade-in-cta { opacity:0; animation:fadeIn 2s ease forwards; animation-delay:5s; }

    /* Header */
    header { transition: background 0.3s ease, box-shadow 0.3s ease; }
    header.scrolled { background: rgba(255,255,255,0.95); box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    header.scrolled a { color: #3a3a3a !important; text-shadow: none; }
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }

    /* Swiper Default-Pfeil-Grafik ausblenden, da wir eigene SVGs nutzen */
    .products-button-prev::after,
    .products-button-next::after { content: none !important; }

    /* Popup Modal */
    .modal {
      display: none;
      position: fixed;
      z-index: 100;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      overflow: auto;
      background-color: rgba(0,0,0,0.6);
      animation: fadeIn 0.3s ease;
    }
    .modal.active { display: flex; align-items: center; justify-content: center; }
    .modal-content {
      background-color: #fff;
      margin: auto;
      padding: 2rem;
      border-radius: 12px;
      width: 90%;
      max-width: 500px;
      box-shadow: 0 8px 32px rgba(0,0,0,0.3);
      position: relative;
      animation: slideIn 0.3s ease;
    }
    @keyframes slideIn {
      from { transform: translateY(-50px); opacity: 0; }
      to { transform: translateY(0); opacity: 1; }
    }
    .close-modal {
      position: absolute;
      right: 1rem;
      top: 1rem;
      font-size: 28px;
      font-weight: bold;
      color: #aaa;
      cursor: pointer;
      transition: color 0.2s;
    }
    .close-modal:hover { color: #000; }
   

  </style>
</head>
<body class="bg-white">

  <!-- Header -->
  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

 <main id="top">
  <section class="relative overflow-hidden bg-[#0f1e2f] text-white" aria-labelledby="hero-heading">
    <div class="absolute inset-0 opacity-40">
      <div class="absolute -left-32 top-16 h-72 w-72 rounded-full bg-[#4e759f] blur-3xl"></div>
      <div class="absolute right-0 top-0 h-80 w-80 rounded-full bg-[#2f506f] blur-3xl"></div>
      <div class="absolute bottom-0 left-12 h-64 w-64 rounded-full bg-[#6793c4] blur-3xl"></div>
    </div>
    <div class="relative mx-auto max-w-6xl px-6 py-20 lg:px-0">
      <div class="grid items-center gap-12 lg:grid-cols-[1.05fr_0.95fr]">
        <div class="space-y-6 pt-12 text-center lg:text-left">
          <p class="text-xs uppercase tracking-[0.3em] text-white/60">Seit 1823 in Köln</p>
          <h1 id="hero-heading" class="text-shadow text-3xl font-bold leading-tight sm:text-4xl md:text-5xl">
            Nur Engel schlafen besser
          </h1>
          <p class="text-lg text-white/85 sm:text-xl md:text-2xl">
            Besser schlafen seit über 200 Jahren – Ihr Bettenfachgeschäft in Köln.
          </p>
          <p class="text-sm text-white/70 sm:text-base">
            Persönliche Schlafberatung, maßgeschneiderte Liegesysteme und ausgewählte Premium-Marken für echte Traum-Nächte.
          </p>
          <div class="flex flex-col gap-4 pt-4 sm:flex-row sm:justify-center lg:justify-start">
            <a href="tel:+49221843236" class="inline-flex items-center justify-center gap-2 rounded-lg bg-[#6793c4] px-6 py-3 font-semibold text-white shadow-lg transition-all duration-300 hover:bg-[#4e759f]">
              <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
              </svg>
              Jetzt anrufen: 0221 843236
            </a>
            <button type="button" class="callback-trigger inline-flex items-center justify-center gap-2 rounded-lg border-2 border-[#6793c4]/70 bg-white px-6 py-3 font-semibold text-[#6793c4] shadow-2xl transition-all duration-300 hover:bg-gray-100">
              <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
              </svg>
              Rückruf anfordern
            </button>
          </div>
          <p class="text-sm uppercase tracking-[0.3em] text-white/60">
            Köln &bull; Inhausen &bull; Vor-Ort &amp; In-Home Beratung
          </p>
        </div>
        <div class="relative">
          <div class="overflow-hidden rounded-[32px] border border-white/15 bg-white/5 shadow-2xl shadow-black/30 backdrop-blur">
            <video
              id="heroVideo"
              src="videos/frau_schwebt_mobil.mp4"
              autoplay
              muted
              playsinline
              class="h-full w-full object-cover"
              aria-label="Imagefilm Betten-Sauer"
            ></video>
          </div>
          <div class="pointer-events-none absolute -left-6 -top-6 h-20 w-20 rounded-full border border-white/40 bg-white/10 blur-2xl md:block"></div>
          <div class="pointer-events-none absolute -bottom-6 -right-6 h-24 w-24 rounded-full border border-white/30 bg-white/10 blur-3xl"></div>
        </div>
      </div>
    </div>
  </section>
</main>

  <!-- Rückruf-Popup Modal -->
  <div id="callbackModal" class="modal">
    <div class="modal-content">
      <span class="close-modal" id="closeModal">&times;</span>
      <h3 class="text-2xl font-bold text-[#6793c4] mb-4">Rückruf anfordern</h3>
      <p class="text-gray-700 mb-6">Hinterlassen Sie uns Ihre Kontaktdaten und wir rufen Sie schnellstmöglich zurück.</p>
      
      <form id="callbackForm" action="rueckruf_absenden.php" method="POST" class="space-y-4">
        <div>
          <label for="callback_name" class="block text-sm font-semibold text-gray-800 mb-1">Name *</label>
          <input type="text" id="callback_name" name="name" required aria-required="true" placeholder="Ihr vollständiger Name"
            class="w-full rounded-md border border-gray-400 focus:border-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:outline-none px-3 py-2 text-gray-900 placeholder-gray-500 transition-all duration-150">
        </div>
        
        <div>
          <label for="callback_telefon" class="block text-sm font-semibold text-gray-800 mb-1">Telefonnummer *</label>
          <input type="tel" id="callback_telefon" name="telefon" required aria-required="true" inputmode="tel" placeholder="Ihre Telefonnummer"
            class="w-full rounded-md border border-gray-400 focus:border-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:outline-none px-3 py-2 text-gray-900 placeholder-gray-500 transition-all duration-150">
        </div>

        <div>
          <label for="callback_zeit" class="block text-sm font-semibold text-gray-800 mb-1">Bevorzugte Rückrufzeit (optional)</label>
          <select id="callback_zeit" name="zeit"
            class="w-full rounded-md border border-gray-400 focus:border-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:outline-none px-3 py-2 text-gray-900 transition-all duration-150">
            <option value="">Bitte wählen</option>
            <option value="vormittags">Vormittags (9-12 Uhr)</option>
            <option value="mittags">Mittags (12-14 Uhr)</option>
            <option value="nachmittags">Nachmittags (14-18 Uhr)</option>
          </select>
        </div>
        
        <div class="flex items-start gap-3">
          <input type="checkbox" id="callback_datenschutz" name="datenschutz" required aria-required="true"
            class="mt-1 h-5 w-5 text-[#6793c4] border-gray-400 rounded focus:ring-4 focus:ring-[#6793c4]/40 focus:ring-offset-2 focus:outline-none cursor-pointer transition-all duration-150">
          <label for="callback_datenschutz" class="text-sm text-gray-800 leading-snug cursor-pointer">
            Ich stimme der <a href="datenschutz.php" class="underline text-[#4e759f] hover:text-[#6793c4]">Datenschutzerklärung</a> zu. *
          </label>
        </div>
        
        <div class="text-center pt-2">
          <button type="submit"
            class="bg-[#6793c4] text-white font-medium px-8 py-3 rounded-lg hover:bg-[#4e759f] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/40 transition-all duration-200 w-full">
            Rückruf anfordern
          </button>
        </div>
      </form>
    </div>
  </div>

  <!-- 2. Kurzer Überblick (USP-Sektion) -->
<section id="usp" class="bg-white py-16">
  <div class="max-w-7xl mx-auto px-6 text-center">
    <h2 class="text-3xl font-bold mb-6 text-[#6793c4]">Kurzer Überblick</h2>
    <p class="mb-10 text-lg">Betten-Sauer verbindet seit 1823 traditionelles Handwerk mit modernen Schlafsystemen – für Menschen, die in Köln und Umgebung Wert auf erholsame Nächte legen.</p>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
      <!-- Kachel 1 -->
      <div class="p-6 rounded-lg shadow-lg bg-gray-50">
        <div class="mx-auto mb-4 flex items-center justify-center w-12 h-12 rounded-full bg-white ring-1 ring-[#6793c4]/30">
          <svg class="w-6 h-6 text-[#6793c4]" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
               stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
            <path d="M20 6L9 17l-5-5"/>
          </svg>
        </div>
        <h3 class="text-xl font-semibold text-[#6793c4]">Über 200 Jahre Erfahrung</h3>
      </div>

      <!-- Kachel 2 -->
      <div class="p-6 rounded-lg shadow-lg bg-gray-50">
        <div class="mx-auto mb-4 flex items-center justify-center w-12 h-12 rounded-full bg-white ring-1 ring-[#6793c4]/30">
          <svg class="w-6 h-6 text-[#6793c4]" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
               stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
            <path d="M20 6L9 17l-5-5"/>
          </svg>
        </div>
        <h3 class="text-xl font-semibold text-[#6793c4]">Persönliche Schlafberatung</h3>
      </div>

      <!-- Kachel 3 -->
      <div class="p-6 rounded-lg shadow-lg bg-gray-50">
        <div class="mx-auto mb-4 flex items-center justify-center w-12 h-12 rounded-full bg-white ring-1 ring-[#6793c4]/30">
          <svg class="w-6 h-6 text-[#6793c4]" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
               stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
            <path d="M20 6L9 17l-5-5"/>
          </svg>
        </div>
        <h3 class="text-xl font-semibold text-[#6793c4]">Premium-Marken & nachhaltige Materialien</h3>
      </div>

      <!-- Kachel 4 -->
      <div class="p-6 rounded-lg shadow-lg bg-gray-50">
        <div class="mx-auto mb-4 flex items-center justify-center w-12 h-12 rounded-full bg-white ring-1 ring-[#6793c4]/30">
          <svg class="w-6 h-6 text-[#6793c4]" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
               stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
            <path d="M20 6L9 17l-5-5"/>
          </svg>
        </div>
        <h3 class="text-xl font-semibold text-[#6793c4]">100 Tage Rückgabegarantie</h3>
      </div>
    </div>

    <div class="flex justify-center mt-12">
      <a href="tel:+49221843236"
         class="inline-flex items-center gap-2 bg-[#6793c4] text-white font-semibold px-6 py-3 rounded-lg shadow hover:bg-[#4e759f] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/40 transition-all duration-200">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="1.8" viewBox="0 0 24 24" aria-hidden="true">
          <path stroke-linecap="round" stroke-linejoin="round"
                d="M2.5 5.5c0-1 .8-1.8 1.8-1.8h2.1c.8 0 1.4.5 1.6 1.3l.7 2.6c.2.7-.1 1.4-.6 1.8l-1.3 1c1.3 2.6 3.4 4.7 6 6l1-1.3c.4-.5 1.1-.7 1.8-.6l2.6.7c.8.2 1.3.8 1.3 1.6v2.1c0 1-.8 1.8-1.8 1.8h-.9C8.6 19 5 15.4 3 11.1v-.9z"/>
        </svg>
        Anrufen
      </a>
    </div>
  </div>
</section>

  <!-- 3. Über uns -->
  <section id="about" class="py-16 bg-gray-50">
    <div class="max-w-4xl mx-auto text-center">
      <h2 class="text-3xl font-bold mb-6">Über uns</h2>
      <p class="mb-6">Seit 1823 steht Betten-Sauer für Qualität, Handwerkskunst und persönlichen Service. In unserem Kölner Bettenhaus vereinen wir Tradition mit modernster Schlaftechnologie, um für jede Schlafgewohnheit die passende Lösung zu finden.</p>
      <a href="#/ueber-uns" class="inline-block bg-[#6793c4] text-white px-6 py-3 rounded-lg hover:bg-[#4e759f]">Mehr über uns erfahren</a>
    </div>
  </section>

<!-- 4. Produktwelten -->
<section id="produkte" class="py-16">
  <div class="max-w-7xl mx-auto px-6 text-center">
    <h2 class="text-3xl font-bold mb-8">Produktwelten</h2>
    <p class="mb-12">Entdecken Sie unsere Auswahl an Boxspringbetten, Matratzen, Lattenrosten und Bettwaren – individuell abgestimmt auf Ihren Schlafkomfort.</p>

    <div class="relative">
      <div class="swiper products-swiper">
        <div class="swiper-wrapper">
          <!-- Slides -->
          <div class="swiper-slide p-6 bg-gray-50 rounded-lg shadow">
            <img src="images/1200x800_boxspringbett.webp" width="1200" height="800" loading="lazy" decoding="async" alt="Boxspringbett-Ausstellung bei Betten-Sauer in Köln" class="mb-4 mx-auto rounded object-cover">
            <h3 class="text-xl font-semibold mb-2">Boxspringbetten</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Produkte ansehen</a>
          </div>

          <div class="swiper-slide p-6 bg-gray-50 rounded-lg shadow">
            <img src="images/1200x800_matratzen.webp" width="1200" height="800" loading="lazy" decoding="async" alt="Matratzenberatung in Köln bei Betten-Sauer" class="mb-4 mx-auto rounded object-cover">
            <h3 class="text-xl font-semibold mb-2">Matratzen</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Produkte ansehen</a>
          </div>

          <div class="swiper-slide p-6 bg-gray-50 rounded-lg shadow">
            <img src="images/1200x800_lattenroste.webp" width="1200" height="800" loading="lazy" decoding="async" alt="Lattenroste und Schlafsysteme von Betten-Sauer" class="mb-4 mx-auto rounded object-cover">
            <h3 class="text-xl font-semibold mb-2">Lattenroste</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Produkte ansehen</a>
          </div>

          <div class="swiper-slide p-6 bg-gray-50 rounded-lg shadow">
            <img src="images/1200x800_kissen.webp" width="1200" height="800" loading="lazy" decoding="async" alt="Ergonomische Kissen &amp; Nackenstützkissen bei Betten-Sauer" class="mb-4 mx-auto rounded object-cover">
            <h3 class="text-xl font-semibold mb-2">Kissen & Nackenstützkissen</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Produkte ansehen</a>
          </div>

          <div class="swiper-slide p-6 bg-gray-50 rounded-lg shadow">
            <img src="images/1200x800_steppbetten.webp" width="1200" height="800" loading="lazy" decoding="async" alt="Steppbetten und Decken im Fachgeschäft Betten-Sauer" class="mb-4 mx-auto rounded object-cover">
            <h3 class="text-xl font-semibold mb-2">Steppbetten</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Produkte ansehen</a>
          </div>

          <div class="swiper-slide p-6 bg-gray-50 rounded-lg shadow">
            <img src="images/1200x800_bettgestell.webp" width="1200" height="800" loading="lazy" decoding="async" alt="Hochwertige Bettgestelle von Betten-Sauer in Köln" class="mb-4 mx-auto rounded object-cover">
            <h3 class="text-xl font-semibold mb-2">Bettgestelle</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Produkte ansehen</a>
          </div>

          <div class="swiper-slide p-6 bg-gray-50 rounded-lg shadow">
            <img src="images/1200x800_seniorenbetten.webp" width="1200" height="800" loading="lazy" decoding="async" alt="Komfortable Seniorenbetten im Sortiment von Betten-Sauer" class="mb-4 mx-auto rounded object-cover">
            <h3 class="text-xl font-semibold mb-2">Seniorenbetten</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Produkte ansehen</a>
          </div>

          <div class="swiper-slide p-6 bg-gray-50 rounded-lg shadow">
            <img src="images/1200x800_bettwaesche.webp" width="1200" height="800" loading="lazy" decoding="async" alt="Feine Bettwäsche-Kollektionen bei Betten-Sauer in Köln" class="mb-4 mx-auto rounded object-cover">
            <h3 class="text-xl font-semibold mb-2">Bettwäsche</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Produkte ansehen</a>
          </div>
        </div>
      </div>

      <!-- Pfeile & Pagination (falls noch nicht vorhanden) -->
      <button class="products-button-prev absolute top-1/2 -translate-y-1/2 left-2 md:left-0 z-20 w-10 h-10 flex items-center justify-center rounded-full bg-white/95 shadow ring-1 ring-black/5 hover:bg-white focus:outline-none focus:ring-2 focus:ring-[#6793c4]" aria-label="Zurück">
        <svg class="w-5 h-5 text-[#6793c4]" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><path d="M15 18l-6-6 6-6"/></svg>
        <span class="sr-only">Zurück</span>
      </button>
      <button class="products-button-next absolute top-1/2 -translate-y-1/2 right-2 md:right-0 z-20 w-10 h-10 flex items-center justify-center rounded-full bg-white/95 shadow ring-1 ring-black/5 hover:bg-white focus:outline-none focus:ring-2 focus:ring-[#6793c4]" aria-label="Weiter">
        <svg class="w-5 h-5 text-[#6793c4]" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><path d="M9 6l6 6-6 6"/></svg>
        <span class="sr-only">Weiter</span>
      </button>
      <div class="products-pagination mt-6"></div>
    </div>

    <div class="mt-12 flex flex-col sm:flex-row items-center justify-center gap-4">
      <a href="tel:+49221843236"
         class="inline-flex items-center gap-2 bg-[#6793c4] text-white font-semibold px-6 py-3 rounded-lg shadow hover:bg-[#4e759f] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/40 transition-all duration-200">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="1.8" viewBox="0 0 24 24" aria-hidden="true">
          <path stroke-linecap="round" stroke-linejoin="round"
                d="M2.5 5.5c0-1 .8-1.8 1.8-1.8h2.1c.8 0 1.4.5 1.6 1.3l.7 2.6c.2.7-.1 1.4-.6 1.8l-1.3 1c1.3 2.6 3.4 4.7 6 6l1-1.3c.4-.5 1.1-.7 1.8-.6l2.6.7c.8.2 1.3.8 1.3 1.6v2.1c0 1-.8 1.8-1.8 1.8h-.9C8.6 19 5 15.4 3 11.1v-.9z"/>
        </svg>
        Anrufen
      </a>
      <button type="button"
              class="callback-trigger inline-flex items-center gap-2 bg-white text-[#6793c4] font-semibold px-6 py-3 rounded-lg shadow-2xl border-2 border-[#6793c4]/70 hover:bg-gray-100 focus:outline-none focus:ring-4 focus:ring-[#6793c4]/30 transition-all duration-200">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" aria-hidden="true">
          <path stroke-linecap="round" stroke-linejoin="round"
                d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
        </svg>
        Rückruf anfordern
      </button>
    </div>
  </div>
</section>


  <!-- 5. Service -->
<section id="service" class="bg-gray-50 py-16">
  <div class="max-w-7xl mx-auto px-6 text-center">
    <h2 class="text-3xl font-bold mb-8">Unser Service macht den Unterschied</h2>

    <!-- Icons / Kurzliste -->
    <ul class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
      <li>✔ Abhol- & Lieferservice</li>
      <li>✔ Dormabell-Mess-System</li>
      <li>✔ Professionelle Reinigung &amp; Pflege</li>
      <li>✔ 100 Tage Garantie</li>
    </ul>

    <!-- Bilder unter den Icons -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 mb-10">
      <figure class="overflow-hidden rounded-lg shadow bg-white">
        <img
          src="images/1200x800_abhol_lieferservice.webp"
          width="1200" height="800"
          loading="lazy" decoding="async"
          alt="Abhol- &amp; Lieferservice von Betten-Sauer in Köln"
          class="w-full h-auto object-cover">
        <figcaption class="sr-only">Abhol- &amp; Lieferservice</figcaption>
      </figure>

      <figure class="overflow-hidden rounded-lg shadow bg-white">
        <img
          src="images/produktbilder/dormabell_messsystem.jpg"
          width="1200" height="800"
          loading="lazy" decoding="async"
          alt="Dormabell-Mess-System für perfekte Liegediagnose bei Betten-Sauer"
          class="w-full h-auto object-cover">
        <figcaption class="sr-only">Dormabell-Mess-System</figcaption>
      </figure>

      <figure class="overflow-hidden rounded-lg shadow bg-white">
        <img
          src="images/1200x800_waschen.webp"
          width="1200" height="800"
          loading="lazy" decoding="async"
          alt="Professionelle Reinigung &amp; Pflege von Bettwaren in Köln"
          class="w-full h-auto object-cover">
        <figcaption class="sr-only">Professionelle Reinigung &amp; Pflege</figcaption>
      </figure>

      <figure class="overflow-hidden rounded-lg shadow bg-white">
        <img
          src="images/1200x800_garantie.webp"
          width="1200" height="800"
          loading="lazy" decoding="async"
          alt="100 Tage Zufriedenheitsgarantie bei Betten-Sauer"
          class="w-full h-auto object-cover">
        <figcaption class="sr-only">100 Tage Garantie</figcaption>
      </figure>
    </div>

    <a href="#kontaktformular" class="inline-block bg-[#6793c4] text-white px-6 py-3 rounded-lg hover:bg-[#4e759f]">
      Jetzt Service nutzen
    </a>
  </div>
</section>


  <!-- 6. Vertrauen -->
<section id="vertrauen" class="py-16">
  <div class="max-w-7xl mx-auto px-6 text-center">
    <h2 class="text-3xl font-bold mb-12">Vertrauen Sie auf unsere Expertise</h2>

    <!-- Logos -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mb-12 items-center">
      <img src="images/logos/dormabell-logo-300x300-1.webp" width="300" height="150" loading="lazy" decoding="async" alt="Dormabell Logo" class="mx-auto h-20 object-contain">
      <img src="images/logos/lattologo.webp" width="300" height="150" loading="lazy" decoding="async" alt="Lattoflex Logo" class="mx-auto h-20 object-contain">
      <img src="images/logos/Ruhe-und-Raum_Logo.webp" width="300" height="150" loading="lazy" decoding="async" alt="Ruhe & Raum Logo" class="mx-auto h-20 object-contain">
      <img src="images/logos/selecta_logo_4c11.webp" width="300" height="150" loading="lazy" decoding="async" alt="Selecta Logo" class="mx-auto h-20 object-contain">
    </div>

    <!-- Kundenbewertungen -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
      <blockquote class="p-6 bg-gray-50 rounded-lg shadow">
        ⭐⭐⭐⭐⭐
        <p class="mt-2">„Hervorragende Beratung und Top-Qualität!"</p>
      </blockquote>
      <blockquote class="p-6 bg-gray-50 rounded-lg shadow">
        ⭐⭐⭐⭐⭐
        <p class="mt-2">„Seit Jahren unser Fachgeschäft des Vertrauens."</p>
      </blockquote>
      <blockquote class="p-6 bg-gray-50 rounded-lg shadow">
        ⭐⭐⭐⭐⭐
        <p class="mt-2">„Endlich wieder erholsam schlafen – Danke!"</p>
      </blockquote>
    </div>
  </div>
</section>


  <!-- 7. Aktuelles -->
  <section id="angebote" class="bg-gray-50 py-16">
    <div class="max-w-7xl mx-auto px-6 text-center">
      <h2 class="text-3xl font-bold mb-8">Aktuelles & Angebote</h2>
      <div class="swiper mySwiperOffers">
        <div class="swiper-wrapper">
          <div class="swiper-slide bg-white shadow rounded-lg p-4">
            <img src="images/450x250_boxspringbett_angebot.webp" alt="Herbstangebot" class="mb-4 rounded">
            <h3 class="text-xl font-semibold mb-2">Boxspringbett-Angebote Herbst 2025</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Alle Angebote ansehen</a>
          </div>
          <div class="swiper-slide bg-white shadow rounded-lg p-4">
            <img src="images/450x250_neue_kollektion.webp" alt="News" class="mb-4 rounded">
            <h3 class="text-xl font-semibold mb-2">Neue Kollektion</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Alle Angebote ansehen</a>
          </div>
          <div class="swiper-slide bg-white shadow rounded-lg p-4">
            <img src="images/450x250_bettwaesche_angebot.webp" alt="Aktion" class="mb-4 rounded">
            <h3 class="text-xl font-semibold mb-2">Sommer-Sale Bettwäsche</h3>
            <a href="#" class="text-[#6793c4] hover:underline">Alle Angebote ansehen</a>
          </div>
        </div>
        <div class="swiper-pagination mt-6"></div>
      </div>
    </div>
  </section>

  <!-- 8. Call-to-Action -->
<section class="py-20 bg-[#6793c4] text-white text-center">
  <div class="max-w-4xl mx-auto px-6">
    <h2 class="text-3xl font-bold mb-6">Individuelle Beratung – finden Sie Ihr perfektes Bett.</h2>
    <div class="flex flex-col sm:flex-row gap-4 justify-center mb-10">
      <a href="#" class="bg-white text-[#6793c4] px-6 py-3 rounded-lg font-medium hover:bg-gray-100">Beratungstermin buchen</a>
      <a href="#" class="bg-white text-[#6793c4] px-6 py-3 rounded-lg font-medium hover:bg-gray-100">Jetzt im Shop stöbern</a>
    </div>

<!-- Kontaktformular (final barrierefrei & kontrastreich) -->
<form id="kontaktformular" action="kontakt_absenden.php" method="POST" 
  class="bg-white text-gray-900 rounded-xl shadow-xl p-8 text-left max-w-2xl mx-auto border border-gray-300 focus-within:shadow-2xl transition-shadow duration-300" 
  aria-labelledby="kontaktformular-titel">

  <h3 id="kontaktformular-titel" class="text-2xl font-semibold text-[#4e759f] mb-6 text-center">Kontaktieren Sie uns</h3>
  <p class="text-center text-gray-700 mb-8 leading-relaxed">
    Haben Sie Fragen zu unseren Betten, Matratzen oder zur Schlafberatung?<br>
    Schreiben Sie uns – wir melden uns schnellstmöglich zurück.
  </p>

  <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div>
      <label for="vorname" class="block text-sm font-semibold text-gray-800 mb-1">Vorname *</label>
      <input type="text" id="vorname" name="vorname" required aria-required="true" placeholder="Ihr Vorname"
        class="w-full rounded-md border border-gray-400 focus:border-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:outline-none px-3 py-2 text-gray-900 placeholder-gray-500 transition-all duration-150">
    </div>
    <div>
      <label for="nachname" class="block text-sm font-semibold text-gray-800 mb-1">Nachname *</label>
      <input type="text" id="nachname" name="nachname" required aria-required="true" placeholder="Ihr Nachname"
        class="w-full rounded-md border border-gray-400 focus:border-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:outline-none px-3 py-2 text-gray-900 placeholder-gray-500 transition-all duration-150">
    </div>
  </div>

  <div class="mt-6">
    <label for="email" class="block text-sm font-semibold text-gray-800 mb-1">E-Mail *</label>
    <input type="email" id="email" name="email" required aria-required="true" placeholder="Ihre E-Mail-Adresse"
      class="w-full rounded-md border border-gray-400 focus:border-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:outline-none px-3 py-2 text-gray-900 placeholder-gray-500 transition-all duration-150">
  </div>

  <div class="mt-6">
    <label for="telefon" class="block text-sm font-semibold text-gray-800 mb-1">Telefon (optional)</label>
    <input type="tel" id="telefon" name="telefon" inputmode="tel" placeholder="Ihre Telefonnummer"
      class="w-full rounded-md border border-gray-400 focus:border-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:outline-none px-3 py-2 text-gray-900 placeholder-gray-500 transition-all duration-150">
  </div>

  <div class="mt-6">
    <label for="anliegen" class="block text-sm font-semibold text-gray-800 mb-1">Ihr Anliegen *</label>
    <textarea id="anliegen" name="anliegen" required aria-required="true" rows="5" placeholder="Wie können wir Ihnen helfen?"
      class="w-full rounded-md border border-gray-400 focus:border-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:outline-none px-3 py-2 text-gray-900 placeholder-gray-500 transition-all duration-150"></textarea>
  </div>

  <div class="mt-6 flex items-start gap-3">
    <input type="checkbox" id="datenschutz" name="datenschutz" required aria-required="true"
      class="mt-1 h-5 w-5 text-[#6793c4] border-gray-400 rounded focus:ring-4 focus:ring-[#6793c4]/40 focus:ring-offset-2 focus:outline-none cursor-pointer transition-all duration-150">
    <label for="datenschutz" class="text-sm text-gray-800 leading-snug cursor-pointer">
      Ich stimme der <a href="datenschutz.php" class="underline text-[#4e759f] hover:text-[#6793c4]">Datenschutzerklärung</a> zu.
    </label>
  </div>

  <div class="mt-8 text-center">
    <button type="submit"
      class="bg-[#6793c4] text-white font-medium px-8 py-3 rounded-lg hover:bg-[#4e759f] focus:outline-none focus:ring-4 focus:ring-white/40 focus:ring-offset-2 focus:ring-offset-[#6793c4] transition-all duration-200">
      Nachricht senden
    </button>
  </div>
</form>

    <!-- Barrierefreier Hinweis -->
    <p class="mt-8 text-sm text-white/80 text-center">
      Dieses Formular ist barrierefrei gestaltet. Sie können alle Felder mit der Tabulator-Taste ansteuern.
    </p>
  </div>
</section>


  <!-- 9. Footer -->
  <?php require __DIR__ . '/includes/footer.php'; ?>

  <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
  <script src="js/menu.js"></script>
  <script>
    // Header Scroll
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();

    // Video letzter Frame
    const lockLastFrame = (video) => {
      if (!video) return;
      const freeze = () => {
        const t = Math.max(0, (video.duration || 0) - 0.05);
        if (t > 0) video.currentTime = t;
        video.pause();
      };
      video.addEventListener('ended', freeze);
    };
    lockLastFrame(document.getElementById('heroVideo'));

    // Swiper Init
    new Swiper(".mySwiperOffers", {
      slidesPerView: 1, spaceBetween: 20,
      pagination: { el: ".swiper-pagination", clickable: true },
      breakpoints: { 768:{slidesPerView:2}, 1024:{slidesPerView:3} }
    });

    // Produktwelten Slider
    const productsSwiper = new Swiper('.products-swiper', {
      slidesPerView: 1,
      spaceBetween: 20,
      pagination: { el: '.products-pagination', clickable: true },
      navigation: {
        nextEl: '.products-button-next',
        prevEl: '.products-button-prev',
      },
      breakpoints: {
        640:  { slidesPerView: 2 },
        1024: { slidesPerView: 4 }
      }
    });

    // Initialer Scroll-Check
    if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
            link.classList.remove('text-white');
            link.classList.add('text-gray-800');
            link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
    }

   // Rückruf-Popup Modal Funktionalität
    const callbackTriggers = document.querySelectorAll('.callback-trigger');
    const callbackModal = document.getElementById('callbackModal');
    const closeModal = document.getElementById('closeModal');

    // Modal öffnen
    callbackTriggers.forEach(trigger => {
      trigger.addEventListener('click', () => {
        callbackModal.classList.add('active');
        document.body.style.overflow = 'hidden'; // Verhindert Scrollen im Hintergrund
      });
    });

    // Modal schließen beim Klick auf X
    closeModal.addEventListener('click', () => {
      callbackModal.classList.remove('active');
      document.body.style.overflow = 'auto';
    });

    // Modal schließen beim Klick außerhalb des Modal-Inhalts
    callbackModal.addEventListener('click', (e) => {
      if (e.target === callbackModal) {
        callbackModal.classList.remove('active');
        document.body.style.overflow = 'auto';
      }
    });

    // Modal schließen mit ESC-Taste
    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape' && callbackModal.classList.contains('active')) {
        callbackModal.classList.remove('active');
        document.body.style.overflow = 'auto';
      }
    });

    // Formular-Absenden (optional: Erfolgsbestätigung)
    const callbackForm = document.getElementById('callbackForm');
    callbackForm.addEventListener('submit', (e) => {
      // Hier könntest du AJAX verwenden, um das Formular ohne Seitenneuladen zu senden
      // Für jetzt wird das Formular normal abgesendet
      // e.preventDefault(); // Auskommentieren, wenn du AJAX verwenden möchtest
      
      // Optional: Erfolgsbestätigung anzeigen
      // alert('Vielen Dank! Wir werden Sie schnellstmöglich zurückrufen.');
      // callbackModal.classList.remove('active');
      // document.body.style.overflow = 'auto';
      // callbackForm.reset();
    });
  </script>
 

</body>
</html>
