<?php
$headerClass = $headerClass ?? 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
$headerDataHero = $headerDataHero ?? false;

$navItems = [
    [
        'label' => 'Startseite',
        'href'   => 'index.php',
    ],
[
    'label' => 'Über uns',
    'href'   => 'ueber_uns.php',
],
[
    'label' => 'Marken',
    'href'   => 'marken.php',
],
[
    'label'    => 'Produkte',
    'href'     => 'produkte.php',
        'children' => [
            ['label' => 'Bettgestelle', 'href' => 'bettgestelle.php'],
            ['label' => 'Bettsysteme', 'href' => 'bettsysteme.php'],
            ['label' => 'Bettwäsche', 'href' => 'bettwaesche.php'],
            ['label' => 'Boxspringbetten', 'href' => 'boxspringbetten.php'],
            ['label' => 'Kissen & Nackenstützkissen', 'href' => 'kissen.php'],
            ['label' => 'Lattenroste', 'href' => 'lattenroste.php'],
            ['label' => 'Matratzen', 'href' => 'matratzen.php'],
            ['label' => 'Seniorenbetten', 'href' => 'seniorenbetten.php'],
            ['label' => 'Steppbetten', 'href' => 'steppbetten.php'],
        ],
    ],
    [
        'label'    => 'Service',
        'href'     => 'abhol.php',
        'children' => [
            ['label' => 'dormabell-Mess-System', 'href' => 'dormabell.php'],
            ['label' => 'Waschen & Reinigen', 'href' => 'waschen.php'],
            ['label' => '100 Tage Zufriedenheits-Garantie', 'href' => 'garantie.php'],
            ['label' => 'Abhol- & Lieferservice', 'href' => 'abhol.php'],
        ],
    ],
    [
        'label'    => 'Infos',
        'href'     => 'versandarten.php',
        'children' => [
            ['label' => 'Versandarten', 'href' => 'versandarten.php'],
            ['label' => 'Zahlungsarten', 'href' => 'zahlungsarten.php'],
            ['label' => 'AGB', 'href' => 'agb.php'],
            ['label' => 'Datenschutz', 'href' => 'datenschutz.php'],
            ['label' => 'Impressum', 'href' => 'impressum.php'],
        ],
    ],
    [
        'label' => 'Kontakt',
        'href'   => 'index.php#kontaktformular',
    ],
];

$linkBaseClasses = 'inline-flex items-center gap-1 text-white font-medium tracking-wide transition-colors duration-200 hover:text-[#dce6f5] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-[#0f1e2f]';
$subLinkClasses  = 'block px-4 py-2 text-sm text-gray-800 hover:bg-[#f1f5f9] hover:text-[#0f1e2f] transition';
?>

<header class="<?= htmlspecialchars($headerClass, ENT_QUOTES) ?>" <?= !empty($headerDataHero) ? 'data-hero="true"' : '' ?>>
  <div class="mx-auto flex max-w-7xl items-center justify-between gap-6 px-4 py-4 lg:px-8">
    <!-- Logo -->
    <a href="index.php" class="flex items-center gap-3 text-white font-semibold tracking-wide focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-[#0f1e2f]">
      <img
        src="images/Logo_BS_BS-Inhausen-1.webp"
        alt="Betten-Sauer Logo"
        class="h-12 w-auto"
        width="120"
        height="48"
        loading="lazy"
        decoding="async"
      />
      
    </a>

    <!-- Desktop Navigation -->
    <nav class="hidden lg:block" aria-label="Hauptmenü">
      <ul id="menu" class="flex items-center gap-6">
        <?php foreach ($navItems as $index => $item): ?>
          <?php if (!empty($item['children'])): ?>
            <!-- Dropdown Menu Item -->
            <li class="relative group" data-dropdown>
              <a
                href="<?= htmlspecialchars($item['href'], ENT_QUOTES) ?>"
                class="<?= $linkBaseClasses ?>"
                data-keep-open="true"
                aria-haspopup="true"
                aria-expanded="false"
              >
                <?= htmlspecialchars($item['label']) ?>
                <svg class="h-4 w-4 transition-transform duration-200 group-hover:rotate-180" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                  <path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 011.06.02L10 10.94l3.71-3.71a.75.75 0 111.06 1.06l-4.24 4.24a.75.75 0 01-1.06 0L5.21 8.29a.75.75 0 01.02-1.08z" clip-rule="evenodd" />
                </svg>
              </a>
              <ul data-dropdown-panel class="absolute left-0 top-full mt-0 hidden min-w-[220px] rounded-xl bg-white py-3 shadow-xl ring-1 ring-black/5 group-hover:block group-focus-within:block">
                <?php foreach ($item['children'] as $child): ?>
                  <li>
                    <a href="<?= htmlspecialchars($child['href'], ENT_QUOTES) ?>" class="<?= $subLinkClasses ?>">
                      <?= htmlspecialchars($child['label']) ?>
                    </a>
                  </li>
                <?php endforeach; ?>
              </ul>
            </li>
          <?php else: ?>
            <!-- Regular Menu Item -->
            <li>
              <a href="<?= htmlspecialchars($item['href'], ENT_QUOTES) ?>" class="<?= $linkBaseClasses ?>">
                <?= htmlspecialchars($item['label']) ?>
              </a>
            </li>
          <?php endif; ?>
        <?php endforeach; ?>
      </ul>
    </nav>

    <!-- Mobile Menu Toggle Button -->
    <!-- Mobile Menu Toggle Button -->
<button
  id="menuToggle"
  class="inline-flex items-center justify-center rounded-md p-2 text-white bg-[#0f1e2f]/80 backdrop-blur-sm transition hover:bg-[#0f1e2f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 lg:hidden"
  type="button"
  aria-expanded="false"
  aria-controls="mobileMenu"
  aria-label="Menü öffnen"
>
  <svg class="h-6 w-6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" aria-hidden="true">
    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16" />
  </svg>
</button>
  </div>
</header>

<!-- Mobile Menu Overlay -->
<div id="mobileMenuOverlay" class="fixed inset-0 z-30 bg-black/40" style="display: none;"></div>

<!-- Mobile Menu -->
<nav
  id="mobileMenu"
  class="fixed inset-y-0 right-0 z-40 w-80 max-w-full bg-white shadow-2xl lg:hidden"
  style="transform: translateX(100%); transition: transform 0.3s ease-in-out;"
  aria-label="Mobiles Menü"
>
  <!-- Mobile Menu Header -->
  <div class="flex items-center justify-between border-b border-gray-200 px-6 py-4">
    <span class="text-base font-semibold text-gray-900">Menü</span>
    <button
      type="button"
      class="rounded-full p-2 text-gray-500 transition hover:text-gray-700 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-[#6793c4]"
      data-close-mobile-menu
      aria-label="Menü schließen"
    >
      <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" aria-hidden="true">
        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
      </svg>
    </button>
  </div>

  <!-- Mobile Menu Content -->
  <div class="h-full overflow-y-auto px-6 py-6">
    <ul class="space-y-6 text-gray-900">
      <?php foreach ($navItems as $item): ?>
        <?php if (empty($item['children'])): ?>
          <!-- Simple Link -->
          <li>
            <a href="<?= htmlspecialchars($item['href'], ENT_QUOTES) ?>" class="block text-base font-medium transition hover:text-[#6793c4]">
              <?= htmlspecialchars($item['label']) ?>
            </a>
          </li>
        <?php else: ?>
          <!-- Link with Children -->
          <li>
            <p class="text-xs font-semibold uppercase tracking-widest text-gray-500">
              <?= htmlspecialchars($item['label']) ?>
            </p>
            <ul class="mt-3 space-y-3 border-l border-gray-200 pl-4">
              <?php foreach ($item['children'] as $child): ?>
                <li>
                  <a href="<?= htmlspecialchars($child['href'], ENT_QUOTES) ?>" class="block text-base font-medium text-gray-700 transition hover:text-[#6793c4]">
                    <?= htmlspecialchars($child['label']) ?>
                  </a>
                </li>
              <?php endforeach; ?>
            </ul>
          </li>
        <?php endif; ?>
      <?php endforeach; ?>
    </ul>
  </div>
</nav>
