<!-- Vertrauensfooter -->
<footer class="bg-[#0f1e2f] py-16 text-white" aria-labelledby="vertrauen-heading">
  <div class="mx-auto max-w-6xl space-y-12 px-6 lg:px-0">
    <div class="grid grid-cols-1 gap-6 text-center sm:grid-cols-3">
      <div class="flex flex-col items-center gap-3 rounded-2xl border border-white/15 bg-white/5 p-8 shadow-lg shadow-black/20">
        <div class="flex h-12 w-12 items-center justify-center rounded-full bg-white/15" aria-hidden="true">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-white" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
            <path d="M12 3 20 7l-8 4-8-4Z" />
            <path d="M4 11v5l8 5 8-5v-5" />
          </svg>
        </div>
        <h3 class="text-lg font-semibold">Seit 1921 Ihr Fachgeschäft für guten Schlaf.</h3>
      </div>
      <div class="flex flex-col items-center gap-3 rounded-2xl border border-white/15 bg-white/5 p-8 shadow-lg shadow-black/20">
        <div class="flex h-12 w-12 items-center justify-center rounded-full bg-white/15" aria-hidden="true">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-white" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
            <path d="m4 4 5.5 5.5" />
            <path d="m16 4-8.5 8.5" />
            <path d="m4 20 9.5-9.5" />
            <path d="m18 14 2 2-6 6h-2v-2Z" />
          </svg>
        </div>
        <h3 class="text-lg font-semibold">Unser handgemachter Service.</h3>
      </div>
      <div class="flex flex-col items-center gap-3 rounded-2xl border border-white/15 bg-white/5 p-8 shadow-lg shadow-black/20">
        <div class="flex h-12 w-12 items-center justify-center rounded-full bg-white/15" aria-hidden="true">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-white" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
            <path d="M8 2v4" />
            <path d="M16 2v4" />
            <rect x="3" y="6" width="18" height="16" rx="2" />
            <path d="M3 12h18" />
            <path d="M8 12v10" />
          </svg>
        </div>
        <h3 class="text-lg font-semibold">Umfangreiche Beratung vor Ort.</h3>
      </div>
    </div>
    <div class="grid grid-cols-1 gap-10 lg:grid-cols-[minmax(0,1.1fr)_minmax(0,0.9fr)]">
      <div class="grid grid-cols-1 gap-8 text-sm sm:grid-cols-2 lg:grid-cols-4">
        <div class="space-y-3 text-left">
          <h4 class="text-xs font-semibold uppercase tracking-wide text-white/70">Produkte</h4>
          <ul class="space-y-2 text-white/80">
            <li><a href="bettgestelle.php" class="transition hover:text-white">Bettgestelle</a></li>
            <li><a href="boxspringbetten.php" class="transition hover:text-white">Boxspringbetten</a></li>
            <li><a href="bettsysteme.php" class="transition hover:text-white">Bettsysteme</a></li>
            <li><a href="matratzen.php" class="transition hover:text-white">Matratzen</a></li>
          </ul>
        </div>
        <div class="space-y-3 text-left">
          <h4 class="text-xs font-semibold uppercase tracking-wide text-white/70">Services</h4>
          <ul class="space-y-2 text-white/80">
            <li><a href="checkliste.php" class="transition hover:text-white">Beratungs-Checkliste</a></li>
            <li><a href="lead.php" class="transition hover:text-white">Beratung anfragen</a></li>
            <li><a href="rueckruf_absenden.php" class="transition hover:text-white">Rückrufservice</a></li>
            <li><a href="agb.php" class="transition hover:text-white">AGB</a></li>
          </ul>
        </div>
        <div class="space-y-3 text-left">
          <h4 class="text-xs font-semibold uppercase tracking-wide text-white/70">Unternehmen</h4>
          <ul class="space-y-2 text-white/80">
            <li><a href="ueber_uns.php" class="transition hover:text-white">Über uns</a></li>
            <li><a href="impressum.php" class="transition hover:text-white">Impressum</a></li>
            <li><a href="datenschutz.php" class="transition hover:text-white">Datenschutz</a></li>
            <li><a href="versandarten.php" class="transition hover:text-white">Versand &amp; Lieferung</a></li>
          </ul>
        </div>
        <div class="space-y-3 text-left">
          <h4 class="text-xs font-semibold uppercase tracking-wide text-white/70">Kontakt</h4>
          <ul class="space-y-2 text-white/80">
            <li><a href="tel:+49221843236" class="transition hover:text-white">0221 843236</a></li>
            <li><a href="tel:+4922412414230" class="transition hover:text-white">02241 2414230</a></li>
            <li><a href="mailto:info@betten-sauer.de" class="transition hover:text-white">info@betten-sauer.de</a></li>
            <li><a href="index.php#kontaktformular" class="transition hover:text-white">Kontaktformular</a></li>
          </ul>
        </div>
      </div>
      <div class="rounded-2xl border border-white/15 bg-white/5 p-4 shadow-lg shadow-black/20">
        <figure class="relative h-[260px] w-full overflow-hidden rounded-xl">
          <img
            src="images/karte.jpg"
            alt="Google-Maps Karte der Betten-Sauer Standorte in Köln und Inhausen"
            class="h-full w-full object-cover"
            loading="lazy"
            decoding="async"
          />
          <figcaption class="absolute bottom-4 left-4 rounded-full bg-[#0f1e2f]/80 px-4 py-2 text-xs font-semibold uppercase tracking-wide text-white shadow-lg shadow-black/30">
            Positions-Karte
          </figcaption>
        </figure>
      </div>
    </div>
  </div>
</footer>

<?php
if (basename($_SERVER['SCRIPT_NAME']) === 'index.php') {
    include __DIR__ . '/chatwidget.php';
}
?>
