<?php
// includes/chatwidget.php
// FINAL: Premium Chat Widget for Betten Sauer (diagnostic funnel + DSGVO + lazy load)
// Position: Desktop right / Mobile left, Lazy load: scroll OR 1.5s, Modal lock on mobile
?>
<style>
  /* Container-Position: Desktop rechts unten, Mobile links unten */
  .bs-chat {
    position: fixed;
    bottom: 18px;
    right: 18px;
    z-index: 9999;
    font-family: system-ui, Arial, sans-serif;
  }
  @media (max-width: 768px) {
    .bs-chat { right: auto; left: 18px; }
  }

  /* Premium-Button */
  .bs-btn {
    border: 1px solid rgba(214, 226, 241, 0.8);
    padding: 12px 18px;
    border-radius: 999px;
    cursor: pointer;
    font-weight: 600;
    font-size: 14px;
    color: #fff;
    background: linear-gradient(135deg, #6793c4 0%, #4e759f 100%);
    box-shadow: 0 8px 20px rgba(15, 30, 47, 0.25);
    display: flex;
    align-items: center;
    gap: 6px;
    transition: transform .2s ease, box-shadow .2s ease, opacity .2s ease;
  }
  .bs-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 24px rgba(15, 30, 47, 0.3);
    opacity: .95;
  }

  /* Dezente, hochwertige Attention-Animation (wird per JS zufällig getriggert) */
  @keyframes wiggle-premium {
    0%   { transform: scale(1);   box-shadow: 0 6px 20px rgba(0,0,0,.15); }
    40%  { transform: scale(1.05) translateY(-2px); box-shadow: 0 10px 25px rgba(0,0,0,.22); }
    100% { transform: scale(1);   box-shadow: 0 6px 20px rgba(0,0,0,.15); }
  }

  /* Panel (Chat-Fenster) */
  .bs-panel {
    width: 330px;
    max-height: 70vh;
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 12px 30px rgba(0,0,0,.2);
    overflow: hidden;
    display: none;           /* JS zeigt/verbirgt */
    flex-direction: column;
  }
  .bs-head {
    padding: 12px 14px;
    background: #0f172a;
    color: #fff;
    font-weight: 600;
    font-size: 14px;
    display: flex;
    align-items: center;
    justify-content: space-between;
  }
  .bs-body {
    padding: 12px;
    overflow-y: auto;
    max-height: 52vh;
  }
  .bs-msg { margin: 10px 0; font-size: 14px; line-height: 1.35; }
  .bs-msg.me { text-align: right; }
  .bs-bot {
    background: #f3f4f6;
    display: inline-block;
    padding: 10px 12px;
    border-radius: 12px;
    max-width: 80%;
  }
  .bs-me {
    background: #dbeafe;
    display: inline-block;
    padding: 10px 12px;
    border-radius: 12px;
    max-width: 80%;
  }
  .bs-foot {
    display: flex;
    gap: 8px;
    padding: 12px;
    border-top: 1px solid #e5e7eb;
  }
  .bs-inp {
    flex: 1;
    padding: 10px 12px;
    border-radius: 10px;
    border: 1px solid #d1d5db;
    font-size: 14px;
  }
  .bs-send {
    padding: 10px 12px;
    border-radius: 10px;
    border: 0;
    background: #0ea5e9;
    color: #fff;
    cursor: pointer;
  }
  .bs-cta {
    font-size: 12px;
    color: #334155;
    margin: 6px 0 10px;
    padding: 0 12px;
  }
  .bs-hint {
    padding: 0 12px 14px;
    font-size: 11px;
    color: #475569;
    opacity: .9;
  }

  /* DSGVO-Hinweis (Brand-grün, rundes (i)-Icon, Fade-In) – wird per JS eingefügt */
  .bs-gdpr {
    display: flex;
    align-items: flex-start;
    gap: 8px;
    font-size: 12.5px;              /* Größe M (12–13px) */
    color: #0d9488;                 /* Premium-grün */
    opacity: 0;                     /* fade-in start */
    animation: bs-fadein .4s ease forwards;
    margin-top: 8px;
  }
  .bs-gdpr i {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 18px; height: 18px;
    min-width: 18px;
    border-radius: 999px;           /* rundes Icon */
    background: #0d9488;
    color: #fff;
    font-style: normal;
    font-size: 12px;
    line-height: 18px;
  }
  @keyframes bs-fadein { to { opacity: 1; } }

  /* Body-Scrollsperre bei geöffnetem Chat (wird per JS getoggelt) */
  .bs-modal-open { overflow: hidden !important; }
</style>

<div class="bs-chat" id="bs-chat">
  <button class="bs-btn" id="bs-open">🛏️ Schlafberatung starten</button>

  <div class="bs-panel" id="bs-panel" aria-live="polite" aria-label="Chatfenster Betten Sauer">
    <div class="bs-head">
      <div>Betten Sauer – Chat</div>
      <button id="bs-close" title="Schließen" style="background:transparent;border:0;color:#fff;font-size:18px;cursor:pointer;">×</button>
    </div>

    <div class="bs-body" id="bs-body"></div>

    <div class="bs-foot">
      <input id="bs-input" class="bs-inp" placeholder="Ihre Nachricht…" maxlength="280" />
      <button id="bs-send" class="bs-send">Senden</button>
    </div>

    <!-- Öffnungszeiten + Kontakt-Leiste (finale Zeiten) -->
    <div class="bs-cta">Mo–Fr 9:30 bis 18:30 Uhr • Sa 10 bis 14 Uhr · Rückruf: 0151&nbsp;41391390</div>
    <div class="bs-hint">Persönliche Schlafberatung vor Ort in Köln</div>
  </div>
</div>

<script>
/* ===== LAZY LOADER =====
   Initialisiert das Chat-Widget-JS erst bei Scroll ODER nach 1500ms.
   Dadurch bessere PageSpeed/Core Web Vitals. */
(function lazyInit(){
  let booted = false;
  function boot(){
    if (booted) return; booted = true;
    initBettenSauerChat();
  }
  window.addEventListener('scroll', boot, { once: true, passive: true });
  setTimeout(boot, 1500);

  /* Haupt-Initialisierung */
  function initBettenSauerChat(){
    const CHAT_ENDPOINT = '/html_sauer/chat.php';
    const LEAD_ENDPOINT = '/html_sauer/lead.php';

    let stage = 1;               // 1: Diagnose1, 2: Diagnose2, 3: Nutzen, 4: Lead, done: Abschluss
    let awaitingPref = false;    // wartet auf Terminpräferenz
    let wiggleTimer;

    const panel = document.getElementById('bs-panel');
    const openBtn  = document.getElementById('bs-open');
    const closeBtn = document.getElementById('bs-close');
    const body   = document.getElementById('bs-body');
    const input  = document.getElementById('bs-input');
    const send   = document.getElementById('bs-send');

    const history = [];

    function randomWiggle() {
      const delay = Math.floor(Math.random() * (18000 - 12000 + 1)) + 12000;
      wiggleTimer = setTimeout(() => {
        openBtn.style.animation = 'wiggle-premium 0.9s ease';
        setTimeout(() => { openBtn.style.animation = ''; randomWiggle(); }, 1000);
      }, delay);
    }

    function pushMsg(role, text){
      history.push({ role, content: text });
      const wrap = document.createElement('div');
      wrap.className = 'bs-msg ' + (role === 'user' ? 'me' : 'bot');
      const bubble = document.createElement('div');
      bubble.className = role === 'user' ? 'bs-me' : 'bs-bot';
      bubble.textContent = text;
      wrap.appendChild(bubble);
      body.appendChild(wrap);
      body.scrollTop = body.scrollHeight;
    }

    function addGdprHint(){
      const wrap = document.createElement('div');
      wrap.className = 'bs-msg bot';
      const box = document.createElement('div');
      box.className = 'bs-gdpr';
      const icon = document.createElement('i');
      icon.textContent = 'i';
      const text = document.createElement('div');
      text.textContent = 'Ihre Angaben verwenden wir nur für die persönliche Terminabstimmung und geben sie selbstverständlich nicht an Dritte weiter.';
      box.appendChild(icon);
      box.appendChild(text);
      wrap.appendChild(box);
      body.appendChild(wrap);
      body.scrollTop = body.scrollHeight;
    }

    async function ask(text){
      // Reset-Befehle
      if (/^(neu|nochmal|von vorne)$/i.test(text.trim())) {
        stage = 1;
        awaitingPref = false;
        history.length = 0;
        body.innerHTML = '';
        pushMsg('assistant',
          'Gerne – wir beginnen von vorne. Sind Sie eher Seiten- oder Rückenschläfer?'
        );
        return;
      }

      // Terminpräferenz (nach Lead)
      if (awaitingPref) {
        awaitingPref = false;
        pushMsg('user', text);
        pushMsg('assistant', 'Vielen Dank – wir melden uns telefonisch unter 0151 41391390 und stimmen gemeinsam den bestmöglichen Beratungstermin für Sie ab.');
        stage = 'done';
        return;
      }

      // Normale Anfrage an KI
      pushMsg('user', text);
      input.value = ''; input.focus();

      const payload = { history };
      try{
        const r = await fetch(CHAT_ENDPOINT, {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(payload),
        });
        const j = await r.json();
        const ai = j?.choices?.[0]?.message?.content || 'Bitte erneut senden.';
        pushMsg('assistant', ai);
      }catch(e){
        pushMsg('assistant', 'Gerade ausgelastet – bitte kurz erneut senden.');
      }

      // Stage-Fortschritt
      if (stage === 1) stage = 2;
      else if (stage === 2) stage = 3;
      else if (stage === 3) stage = 4;
      else if (stage === 4) {
        setTimeout(promptLead, 250);
      }
    }

    function promptLead(){
      const name  = prompt('Ihr Name (für Rückruf):');
      if (!name) return;
      const phone = prompt('Ihre Telefonnummer:');
      if (!phone) return;
      const time  = new Date().toISOString();

      // Lead an Server senden (Mail via lead.php)
      fetch(LEAD_ENDPOINT, {
        method: 'POST',
        headers: { 'Content-Type':'application/json' },
        body: JSON.stringify({
          source: 'chatbot',
          name, phone,
          time_preference: '',
          notes: history.slice(-6).map(m => `${m.role}: ${m.content}`).join(' | '),
          url: location.href,
          ts: time
        })
      }).catch(()=>{});

      // Danach DSGVO-Hinweis + Terminpräferenz
      pushMsg('assistant', 'Bevorzugen Sie einen Termin eher unter der Woche oder am Samstag?');
      addGdprHint();
      awaitingPref = true;
    }

    // Öffnen/Schließen
    openBtn.onclick = () => {
      panel.style.display = 'flex';
      openBtn.style.display = 'none';
      document.documentElement.classList.add('bs-modal-open');
      document.body.classList.add('bs-modal-open');
      clearTimeout(wiggleTimer);

      // erstes Bot-Intro
      if (history.length === 0) {
        pushMsg('assistant',
          'Willkommen bei Betten Sauer. Wollen wir kurz herausfinden, welche Matratze zu Ihrem Körper passt – als Vorbereitung fürs Probeliegen? Sind Sie eher Seiten- oder Rückenschläfer?'
        );
      }
    };
    closeBtn.onclick = () => {
      panel.style.display = 'none';
      openBtn.style.display = 'flex';
      document.documentElement.classList.remove('bs-modal-open');
      document.body.classList.remove('bs-modal-open');
      randomWiggle();
    };

    // Senden
    send.onclick = () => { if (input.value.trim()) ask(input.value.trim()); };
    input.addEventListener('keydown', e => { if (e.key === 'Enter' && input.value.trim()) ask(input.value.trim()); });

    // Start Attention-Animation
    randomWiggle();
  }
})();
</script>
