<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Impressum – Betten-Sauer Köln</title>
  <meta name="description" content="Impressum der Betten-Sauer KG in Köln. Angaben gemäß § 5 TMG, Verantwortliche, Umsatzsteuer-ID und Quellenangaben.">
  <meta name="author" content="Betten-Sauer KG">
  <meta name="theme-color" content="#6793c4">

  <!-- Favicons -->
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif">
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png">
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png">

  <link rel="stylesheet" href="css/style.css">

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
  </style>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-[#0f1e2f]/90 transition duration-300';
    require __DIR__ . '/includes/header.php';
  ?>

  <main class="pt-28 pb-20 bg-gray-50">
    <section class="max-w-5xl mx-auto px-6 space-y-10">
      <div class="rounded-3xl bg-gradient-to-br from-[#0f1e2f] via-[#1b2f4b] to-[#274773] text-white text-center py-16 px-6 md:px-10 shadow-xl">
        <h1 class="text-3xl md:text-4xl font-semibold">Impressum</h1>
        <p class="mt-4 text-base md:text-lg text-white/85 max-w-2xl mx-auto">
          Alle Pflichtangaben zur Betten-Sauer KG im Überblick – transparent und auf einen Blick gemäß §&nbsp;5 TMG.
        </p>
      </div>

      <div class="bg-white shadow-lg rounded-2xl border border-gray-200 p-8 space-y-8">
        <section>
          <h2 class="text-2xl font-semibold mb-4">Angaben gemäß § 5 TMG</h2>
          <p class="leading-relaxed">
            BETTEN-SAUER KG<br>
            Brücker Mauspfad 539<br>
            D – 51109 Köln<br>
            Telefon: +49 (0)221 – 843236<br>
            Telefax: +49 (0)221 – 844349
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Vertretungsberechtigte</h2>
          <p class="leading-relaxed">
            Herrn Michael Gouram (Geschäftsführer)
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Umsatzsteuer-ID</h2>
          <p class="leading-relaxed">
            Umsatzsteuer-Identifikationsnummer gemäß §27a Umsatzsteuergesetz:<br>
            DE 122 939 052
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Registergericht</h2>
          <p class="leading-relaxed">
            Amtsgericht Köln HRB 30215
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Verantwortlich für den Inhalt nach § 55 Abs. 2 RStV</h2>
          <p class="leading-relaxed">
            Michael Gouram<br>
            Brücker Mauspfad 539<br>
            D – 51109 Köln
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Quellenangaben</h2>
          <ul class="list-disc list-inside space-y-2 leading-relaxed">
            <li><strong>Konzept &amp; Text:</strong> Christian Malessa | Malessa Communication</li>
            <li><strong>Fotografie:</strong> Renate Forst | Foto-Studio B</li>
            <li><strong>Fotografie:</strong> Christian Schillings | Rheinseite</li>
            <li><strong>Quelle dieses Impressums:</strong> Impressumgenerator | <a href="http://www.e-recht24.de" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">www.e-recht24.de</a></li>
          </ul>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Urheberrecht</h2>
          <p class="leading-relaxed space-y-4">
            Die durch die Seitenbetreiber erstellten Inhalte und Werke auf diesen Seiten unterliegen dem deutschen Urheberrecht.
            Die Vervielfältigung, Bearbeitung, Verbreitung und jede Art der Verwertung außerhalb der Grenzen des Urheberrechtes
            bedürfen der schriftlichen Zustimmung des jeweiligen Autors bzw. Erstellers. Downloads und Kopien dieser Seite sind
            nur für den privaten, nicht kommerziellen Gebrauch gestattet.
          </p>
          <p class="leading-relaxed">
            Soweit die Inhalte auf dieser Seite nicht vom Betreiber erstellt wurden, werden die Urheberrechte Dritter beachtet.
            Insbesondere werden Inhalte Dritter als solche gekennzeichnet. Sollten Sie trotzdem auf eine Urheberrechtsverletzung
            aufmerksam werden, bitten wir um einen entsprechenden Hinweis. Bei Bekanntwerden von Rechtsverletzungen werden wir
            derartige Inhalte umgehend entfernen.
          </p>
        </section>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
