<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>100 Tage Zufriedenheits-Garantie | Betten Sauer</title>
  <meta name="description" content="Mit der 100 Tage Zufriedenheits-Garantie von Betten Sauer kaufen Sie Ihre Matratze ohne Risiko. Probeschlafen zuhause, kostenlose Festigkeitsanpassung und persönliche Fachberatung." />
  <meta name="keywords" content="100 Tage Garantie Matratze, Zufriedenheitsgarantie Betten Sauer, Matratzen Probeschlafen, Festigkeitswechsel kostenlos, Liegeanalyse Köln" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="garantie.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="garantie.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="100 Tage Zufriedenheits-Garantie | Betten Sauer" />
  <meta property="og:description" content="Probieren Sie Ihre neue Matratze 100 Tage zuhause aus. Wenn sie nicht perfekt passt, passen wir sie kostenlos an – dank Zufriedenheits-Garantie von Betten Sauer." />
  <meta property="og:image" content="images/1200x800_garantie.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="100 Tage Zufriedenheits-Garantie | Betten Sauer" />
  <meta name="twitter:description" content="Matratzenkauf ohne Risiko: 100 Tage Probeschlafen, kostenlose Anpassung der Festigkeit und persönliche Fachberatung bei Betten Sauer." />
  <meta name="twitter:image" content="images/1200x800_garantie.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <!-- Hero -->
    <section class="relative overflow-hidden bg-[#0f1e2f] text-white" aria-labelledby="hero-heading">
      <div class="absolute inset-0 opacity-40">
        <div class="absolute -left-24 top-12 h-72 w-72 rounded-full bg-[#4e759f] blur-3xl"></div>
        <div class="absolute right-0 top-0 h-80 w-80 rounded-full bg-[#2f506f] blur-3xl"></div>
        <div class="absolute bottom-0 left-20 h-64 w-64 rounded-full bg-[#6793c4] blur-3xl"></div>
      </div>
      <div class="relative mx-auto flex max-w-6xl flex-col gap-12 px-6 py-16 lg:px-0">
        <div class="grid items-center gap-12 lg:grid-cols-[1.05fr_0.95fr]">
          <div class="space-y-7 pt-8">
            <h1 id="hero-heading" class="text-3xl font-semibold leading-tight text-shadow sm:text-4xl md:text-5xl">
              100 Tage Probeschlafen – ohne Risiko, mit Zufriedenheits-Garantie.
            </h1>
            <p class="text-base text-white/85 sm:text-lg md:text-xl">
              Wir möchten, dass Sie mit Ihrer neuen Matratze wirklich glücklich sind. Deshalb geben wir Ihnen 100 Tage Zeit, um Ihren perfekten Schlaf zu finden.
            </p>
            <div class="grid gap-4 text-sm text-white/85 sm:grid-cols-2">
              <?php
                $guaranteeHighlights = [
                  ['icon' => '🛌', 'label' => 'Probeschlafen zu Hause – ganz ohne Risiko'],
                  ['icon' => '🔄', 'label' => 'Kostenfreier Festigkeitswechsel & Feineinstellung'],
                  ['icon' => '📋', 'label' => 'Dokumentiertes Messprotokoll aus der Beratung'],
                  ['icon' => '🤝', 'label' => 'Persönlicher Kontakt zu Ihrem Schlafberater-Team'],
                ];
              ?>
              <?php foreach ($guaranteeHighlights as $highlight): ?>
                <div class="flex items-start gap-3 rounded-2xl border border-white/15 bg-white/5 p-4">
                  <span class="text-base leading-none"><?= htmlspecialchars($highlight['icon'], ENT_QUOTES) ?></span>
                  <span><?= htmlspecialchars($highlight['label'], ENT_QUOTES) ?></span>
                </div>
              <?php endforeach; ?>
            </div>
            <div class="flex flex-col gap-4 pt-2 sm:flex-row sm:items-center">
              <a href="#termin" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                Jetzt Beratung vereinbaren
              </a>
              <p class="text-sm text-white/70">
                Köln &bull; Inhausen &bull; Beratungen im Studio oder bei Ihnen zu Hause
              </p>
            </div>
          </div>
          <div class="relative">
            <div class="overflow-hidden rounded-[32px] border border-white/15 bg-white/10 shadow-2xl shadow-black/30 backdrop-blur-sm">
              <img
                src="images/1200x800_garantie.webp"
                alt="Glückliches Paar testet Matratze im Schlafzimmer mit warmem Licht"
                class="h-full w-full object-cover"
                loading="eager"
                decoding="async"
              />
              <div class="absolute inset-0 bg-gradient-to-tr from-[#0f1e2f]/60 via-transparent to-transparent"></div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Vertrauen & Problemansprache -->
    <section class="bg-white py-16" aria-labelledby="warum-heading">
      <div class="mx-auto max-w-6xl gap-12 px-6 text-gray-700 lg:grid lg:grid-cols-[minmax(0,1.05fr)_minmax(0,0.95fr)] lg:px-0 lg:items-center">
        <div class="space-y-6">
          <h2 id="warum-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Warum wir diese Garantie geben
          </h2>
          <p class="text-base leading-relaxed sm:text-lg">
            Der Matratzenkauf ist Vertrauenssache. Viele Kundinnen und Kunden sind unsicher, ob sie das Richtige wählen. Mit unserer individuellen Fachberatung und der 100&nbsp;Tage Zufriedenheits-Garantie nehmen wir Ihnen dieses Risiko ab.
          </p>
          <p class="text-base leading-relaxed sm:text-lg">
            Wir begleiten Sie vom ersten Probeliegen bis zur finalen Feineinstellung. Sollte sich unterwegs zeigen, dass eine andere Festigkeit besser passt, übernehmen wir den Wechsel – kostenfrei und unkompliziert.
          </p>
        </div>
        <figure class="relative mt-10 overflow-hidden rounded-2xl bg-gray-200 shadow-lg shadow-[#0f1e2f]/15 lg:mt-0">
          <img
            src="images/beratung.jpg"
            alt="Schlafberater erläutert die individuelle Liegeanalyse"
            class="h-full w-full object-cover"
            loading="lazy"
            decoding="async"
          />
        </figure>
      </div>
    </section>

    <!-- Erklärung der Garantie -->
    <section class="bg-[#f6f7f9] py-16" aria-labelledby="garantie-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="garantie-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Was bedeutet 100 Tage Zufriedenheit?
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Sie haben 100 Tage Zeit, Ihre neue Matratze zu testen. Wenn sie nicht perfekt passt, passen wir sie in der Festigkeit kostenlos an – ganz ohne Aufwand für Sie.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-3">
          <?php
            $highlights = [
              ['icon' => '🛏️', 'title' => '100 Tage Probeschlafen', 'text' => 'Testen Sie in Ruhe zuhause – so wie Sie schlafen.'],
              ['icon' => '🔄', 'title' => 'Kostenloser Festigkeitswechsel', 'text' => 'Wir justieren die Matratze ohne Zusatzkosten.'],
              ['icon' => '👨‍🔧', 'title' => 'Persönliche Fachberatung', 'text' => 'Erfahrene Schlafberater begleiten jeden Schritt.'],
            ];
          ?>
          <?php foreach ($highlights as $item): ?>
            <article class="flex flex-col items-center gap-3 rounded-2xl border border-[#d6e2f1] bg-white p-8 text-center shadow-md shadow-[#0f1e2f]/10">
              <div class="text-3xl" aria-hidden="true"><?= htmlspecialchars($item['icon'], ENT_QUOTES) ?></div>
              <h3 class="text-lg font-semibold text-[#0f1e2f]"><?= htmlspecialchars($item['title'], ENT_QUOTES) ?></h3>
              <p class="text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($item['text'], ENT_QUOTES) ?></p>
            </article>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- Ablauf -->
    <section class="bg-white py-16" aria-labelledby="ablauf-heading">
      <div class="mx-auto max-w-6xl space-y-12 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="ablauf-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            So funktioniert es
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Von der Beratung bis zur möglichen Anpassung – transparent, fair und ohne Stress.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-8 md:grid-cols-3">
          <?php
            $steps = [
              [
                'title' => 'Beratung & Auswahl',
                'text'  => 'Wir ermitteln Ihr Liegeprofil, testen verschiedene Systeme und finden das passende Modell.',
                'icon'  => '<path d="M12 20h9" /><path d="M12 4H9" /><path d="M20 7h-7" /><path d="M9 7H4" /><path d="M9 4v16" /><path d="M12 7v13" />',
              ],
              [
                'title' => '100 Tage testen',
                'text'  => 'Ihr Körper gewöhnt sich in Ruhe an das neue Liegegefühl – Sie beobachten, wie gut Sie schlafen.',
                'icon'  => '<path d="M3 4h18" /><path d="M3 10h18" /><path d="M5 6v14" /><path d="M19 6v14" /><path d="M10 14h4" />',
              ],
              [
                'title' => 'Anpassung bei Bedarf',
                'text'  => 'Stimmt etwas nicht? Wir wechseln kostenfrei die Festigkeit oder nehmen Feineinstellungen vor.',
                'icon'  => '<path d="M21 10h-6l-2 5-3-10-2 5H3" /><path d="M21 6v4" /><path d="M21 10h-4" />',
              ],
            ];
          ?>
          <?php foreach ($steps as $step): ?>
            <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-md shadow-[#0f1e2f]/10">
              <div class="flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-[#4e759f]" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                  <?= $step['icon'] ?>
                </svg>
              </div>
              <h3 class="text-lg font-semibold text-[#0f1e2f]"><?= htmlspecialchars($step['title'], ENT_QUOTES) ?></h3>
              <p class="text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($step['text'], ENT_QUOTES) ?></p>
            </article>
          <?php endforeach; ?>
        </div>
        <div class="rounded-2xl border border-dashed border-[#bed0e6] bg-[#f6f7f9] px-6 py-5 text-center text-sm leading-relaxed text-gray-600">
          Bitte testen Sie Ihre Matratze mindestens 14 Tage, damit sich Ihr Körper an das neue Schlafsystem gewöhnen kann.
        </div>
      </div>
    </section>

    <!-- Vertrauensbeweis -->
    <section class="bg-[#f6f7f9] py-16" aria-labelledby="nachhaltigkeit-heading">
      <div class="mx-auto max-w-5xl space-y-8 px-6 text-gray-700 lg:px-0">
        <h2 id="nachhaltigkeit-heading" class="text-center text-2xl font-semibold text-[#4e759f] sm:text-3xl">
          Was passiert mit zurückgenommenen Matratzen?
        </h2>
        <p class="text-center text-base leading-relaxed sm:text-lg">
          Unsere Rücknahmequote liegt bei unter 1&nbsp;%. Produkte, die wir dennoch zurücknehmen, werden von unseren Lieferanten an gemeinnützige Organisationen gespendet – ressourcenschonend und fair.
        </p>
        <div class="mx-auto flex max-w-sm items-center justify-center gap-3 rounded-2xl border border-[#d6e2f1] bg-white p-4 text-sm text-[#0f1e2f] shadow-md shadow-[#0f1e2f]/10">
          <span aria-hidden="true">♻️</span>
          <span>Nachhaltig schlafen – Verantwortung von Anfang an.</span>
        </div>
      </div>
    </section>

    <!-- Kundenstimme -->
    <section class="bg-white py-16" aria-labelledby="stimme-heading">
      <div class="mx-auto max-w-4xl px-6 text-gray-700 lg:px-0">
        <h2 id="stimme-heading" class="text-center text-2xl font-semibold text-[#4e759f] sm:text-3xl">
          Erfahrungswert aus Köln
        </h2>
        <blockquote class="mt-8 rounded-2xl border border-[#dce4ef] bg-[#f6f7f9] p-8 text-center text-base italic text-gray-700 shadow-md shadow-[#0f1e2f]/10">
          „Ich war erst unsicher, aber die Beratung und die 100 Tage Garantie haben mich überzeugt. Heute schlafe ich endlich ohne Rückenschmerzen.“<br />
          <span class="mt-4 block text-sm font-semibold text-[#0f1e2f]">— Kundin aus Köln</span>
        </blockquote>
      </div>
    </section>

    <!-- Call to Action -->
    <section id="termin" class="bg-[#6793c4] py-16 text-white" aria-labelledby="cta-heading">
      <div class="mx-auto max-w-4xl space-y-6 px-6 text-center">
        <h2 id="cta-heading" class="text-2xl font-semibold sm:text-3xl">
          Finden Sie Ihre perfekte Matratze – ganz ohne Risiko.
        </h2>
        <p class="text-base leading-relaxed text-white/85 sm:text-lg">
          Buchen Sie Ihre Liegeanalyse mit dormabell-Mess-System und erleben Sie, wie individuell Schlafkomfort sein kann.
        </p>
        <div class="flex flex-col items-center gap-4 sm:flex-row sm:justify-center sm:gap-6">
          <a href="#kontakt" class="inline-flex items-center justify-center rounded-lg bg-white px-7 py-3 text-sm font-semibold uppercase tracking-wide text-[#0f1e2f] transition hover:bg-[#dce4ef] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
            Termin vereinbaren
          </a>
          <div class="text-sm text-white/85">
            <p>Telefon Köln: <a href="tel:+49221843236" class="underline hover:text-white">0221&nbsp;843236</a></p>
            <p>Telefon Inhausen: <a href="tel:+4922412414230" class="underline hover:text-white">02241&nbsp;2414230</a></p>
          </div>
        </div>
        <p class="text-sm text-white/70">Oder schreiben Sie uns an <a href="mailto:info@betten-sauer.de" class="underline hover:text-white">info@betten-sauer.de</a>.</p>
      </div>
    </section>

    <!-- Kontakt -->
    <section id="kontakt" class="bg-white py-16" aria-labelledby="kontakt-heading">
      <div class="mx-auto max-w-6xl gap-16 px-6 text-gray-700 lg:grid lg:grid-cols-[minmax(0,1fr)_minmax(0,1.05fr)] lg:px-0">
        <div class="space-y-6">
          <h2 id="kontakt-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Haben Sie Fragen?
          </h2>
          <p class="text-base leading-relaxed sm:text-lg">
            Wir beraten Sie gern zu Schlafsystemen, Garantieleistung und individuellem Liegegefühl. Melden Sie sich – wir antworten werktags innerhalb von 24&nbsp;Stunden.
          </p>
          <div class="space-y-4 text-sm text-gray-600">
            <div>
              <h3 class="text-lg font-semibold text-[#0f1e2f]">Betten-Sauer Köln</h3>
              <p>Brücker Mauspfad 539<br />51109 Köln</p>
              <p>Telefon: <a href="tel:+49221843236" class="text-[#4e759f] underline hover:text-[#2f506f]">0221&nbsp;843236</a></p>
              <p class="text-xs text-gray-500">Mo – Fr: 09:30 – 18:30 &bull; Sa: 10:00 – 14:00</p>
            </div>
            <div>
              <h3 class="text-lg font-semibold text-[#0f1e2f]">Betten-Sauer by Inhausen</h3>
              <p>Cecilienstraße 8<br />53721 Inhausen</p>
              <p>Telefon: <a href="tel:+4922412414230" class="text-[#4e759f] underline hover:text-[#2f506f]">02241&nbsp;2414230</a></p>
              <p class="text-xs text-gray-500">Mo – Fr: 10:00 – 18:00 &bull; Sa: 10:00 – 14:00</p>
            </div>
          </div>
        </div>
        <div>
          <form action="lead.php" method="POST" class="rounded-2xl border border-[#dce4ef] bg-white p-8 shadow-xl shadow-[#0f1e2f]/10" novalidate aria-describedby="kontakt-form-info">
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
              <div>
                <label for="garantie-name" class="mb-1 block text-sm font-semibold text-gray-800">Name *</label>
                <input
                  type="text"
                  id="garantie-name"
                  name="name"
                  required
                  aria-required="true"
                  autocomplete="name"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
              <div>
                <label for="garantie-email" class="mb-1 block text-sm font-semibold text-gray-800">E-Mail *</label>
                <input
                  type="email"
                  id="garantie-email"
                  name="email"
                  required
                  aria-required="true"
                  autocomplete="email"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
            </div>
            <div class="mt-6">
              <label for="garantie-nachricht" class="mb-1 block text-sm font-semibold text-gray-800">Nachricht *</label>
              <textarea
                id="garantie-nachricht"
                name="nachricht"
                rows="6"
                required
                aria-required="true"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              ></textarea>
            </div>
            <div class="mt-6 flex items-start gap-3">
              <input
                type="checkbox"
                id="garantie-datenschutz"
                name="datenschutz"
                required
                aria-required="true"
                class="mt-1 h-5 w-5 cursor-pointer rounded border-gray-300 text-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:ring-offset-0"
              />
              <label for="garantie-datenschutz" class="text-sm leading-relaxed text-gray-700">
                Ich bin damit einverstanden, dass Betten Sauer meine Angaben zur Kontaktaufnahme verarbeitet.
                Mehr Informationen in unserer <a href="datenschutz.php" class="text-[#4e759f] underline hover:text-[#2f506f]">Datenschutzerklärung</a>.
              </label>
            </div>
            <div class="mt-6">
              <div class="rounded-md border border-dashed border-gray-300 bg-gray-50 p-4 text-center text-sm text-gray-500">
                reCAPTCHA Platzhalter – hinterlegen Sie Ihren Site-Key für den Live-Betrieb.
              </div>
            </div>
            <div class="mt-8">
              <button type="submit" class="w-full rounded-lg bg-[#6793c4] px-6 py-3 text-base font-semibold text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-4 focus-visible:ring-[#4e759f]/30">
                Anfrage senden
              </button>
            </div>
          </form>
          <p id="kontakt-form-info" class="mt-4 text-xs text-gray-500">
            Alle mit * gekennzeichneten Felder sind Pflichtfelder.
          </p>
        </div>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
