<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>dormabell-Mess-System | Persönliche Liege-Analyse bei Betten Sauer</title>
  <meta name="description" content="Das dormabell-Mess-System ermittelt Ihre ideale Schlafposition. Bei Betten Sauer messen wir digital, passen Matratze und Lattenrost individuell an und verbessern Ihren Schlaf nachhaltig." />
  <meta name="keywords" content="dormabell Mess System, Liegeanalyse Köln, ergonomische Schlafberatung, Betten Sauer dormabell, Matratzenmessung, Lattenrost Einstellung" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="dormabell.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="dormabell.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="dormabell-Mess-System | Persönliche Liege-Analyse bei Betten Sauer" />
  <meta property="og:description" content="Wir messen, was Sie fühlen: Mit dem dormabell-Mess-System finden wir Ihr individuelles Schlafsystem – wissenschaftlich fundiert, spürbar besser." />
  <meta property="og:image" content="images/1200x800_dormabell.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="dormabell-Mess-System | Persönliche Liege-Analyse bei Betten Sauer" />
  <meta name="twitter:description" content="Digitale Liege-Analyse, ergonomische Empfehlung und maßgeschneiderter Schlafkomfort – Betten Sauer ist dormabell-Fachhändler." />
  <meta name="twitter:image" content="images/1200x800_dormabell.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <!-- Hero -->
    <section class="relative overflow-hidden bg-[#0f1e2f] text-white" aria-labelledby="hero-heading">
      <div class="absolute inset-0 opacity-40">
        <div class="absolute -left-32 top-16 h-72 w-72 rounded-full bg-[#4e759f] blur-3xl"></div>
        <div class="absolute right-0 top-0 h-80 w-80 rounded-full bg-[#2f506f] blur-3xl"></div>
        <div class="absolute bottom-0 left-12 h-64 w-64 rounded-full bg-[#6793c4] blur-3xl"></div>
      </div>
      <div class="relative mx-auto flex max-w-6xl flex-col gap-12 px-6 py-16 lg:px-0">
        <div class="grid items-center gap-12 lg:grid-cols-[1.05fr_0.95fr]">
          <div class="space-y-7 pt-12">
            <h1 id="hero-heading" class="text-3xl font-semibold leading-tight text-shadow sm:text-4xl md:text-5xl">
              Ihr Körper ist einzigartig – Ihr Bett sollte es auch sein.
            </h1>
            <p class="text-base text-white/85 sm:text-lg md:text-xl">
              Wir messen, was Sie fühlen: Sensoren erfassen Haltung, Druckpunkte und Schlafposition. Daraus entsteht Ihr persönliches Schlafsystem.
            </p>
            <div class="grid gap-4 text-sm text-white/85 sm:grid-cols-2">
              <?php
                $heroBenefits = [
                  ['label' => 'Digitale Liege-Analyse in 12 Minuten', 'icon' => '⏱️'],
                  ['label' => 'Individuelle Matratzen- & Lattenrost-Einstellung', 'icon' => '🛏️'],
                  ['label' => 'Messprotokoll zum Mitnehmen', 'icon' => '📊'],
                  ['label' => 'Fachberatung durch zertifizierte Schlafexpert:innen', 'icon' => '🎓'],
                ];
              ?>
              <?php foreach ($heroBenefits as $benefit): ?>
                <div class="flex items-start gap-3 rounded-2xl border border-white/15 bg-white/5 p-4">
                  <span class="text-base leading-none"><?= htmlspecialchars($benefit['icon'], ENT_QUOTES) ?></span>
                  <span><?= htmlspecialchars($benefit['label'], ENT_QUOTES) ?></span>
                </div>
              <?php endforeach; ?>
            </div>
            <div class="flex flex-col gap-4 pt-2 sm:flex-row sm:items-center">
              <a href="#termin" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                Jetzt Liege-Analyse vereinbaren
              </a>
              <p class="text-sm text-white/70">
                Köln &bull; Inhausen &bull; Vor-Ort &amp; In-Home Termine
              </p>
            </div>
          </div>
          <div class="relative">
            <div class="overflow-hidden rounded-[32px] border border-white/15 bg-white/10 shadow-2xl shadow-black/30 backdrop-blur-sm">
              <img
                src="images/produktbilder/dormabell_messsystem.jpg"
                alt="Schlafberater misst Liegeposition mit dormabell-Mess-System bei Betten Sauer"
                class="h-full w-full object-cover"
                loading="eager"
                decoding="async"
              />
              <div class="absolute inset-0 bg-gradient-to-tr from-[#0f1e2f]/60 via-transparent to-transparent"></div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Problem / Nutzen -->
    <section class="bg-white py-16" aria-labelledby="nutzen-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="nutzen-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Warum messen statt raten?
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Viele Menschen wachen mit Verspannungen auf, weil ihr Bett nicht zu Körperform, Gewicht oder Schlafposition passt. Wir machen sichtbar, was Ihr Rücken braucht.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-8 md:grid-cols-3">
          <?php
            $painPoints = [
              [
                'icon' => '😣',
                'title' => 'Rückenschmerzen am Morgen?',
                'text'  => 'Unsere Analyse erkennt punktgenau, wo Fehlbelastungen entstehen – und wie Ihr Bett sie ausgleicht.',
              ],
              [
                'icon' => '🛏️',
                'title' => 'Schon viele Matratzen ausprobiert?',
                'text'  => 'Wir messen Druckverteilung und Körperkontur digital, damit Sie wissen, was wirklich zu Ihnen passt.',
              ],
              [
                'icon' => '💡',
                'title' => 'Unsicher beim Matratzenkauf?',
                'text'  => 'Wir ersetzen Bauchgefühl durch Messwerte – nachvollziehbar, transparent und individuell.',
              ],
            ];
          ?>
          <?php foreach ($painPoints as $point): ?>
            <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 text-center shadow-lg shadow-[#0f1e2f]/10">
              <div class="text-3xl" aria-hidden="true"><?= htmlspecialchars($point['icon'], ENT_QUOTES) ?></div>
              <h3 class="text-xl font-semibold text-[#0f1e2f]"><?= htmlspecialchars($point['title'], ENT_QUOTES) ?></h3>
              <p class="text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($point['text'], ENT_QUOTES) ?></p>
            </article>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- Funktionsbeschreibung -->
    <section class="bg-[#f5f7fa] py-16" aria-labelledby="funktion-heading">
      <div class="mx-auto max-w-6xl space-y-12 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="funktion-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Wie funktioniert das Mess-System?
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Ihre Liege-Analyse erfolgt in drei klaren Schritten – objektiv, reproduzierbar und wissenschaftlich begleitet.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-10 md:grid-cols-3">
          <?php
            $steps = [
              [
                'title' => '1. Digitale Messung',
                'text'  => 'Sensoren erfassen Druckverteilung und Körperkontur, während Sie entspannt auf der Messmatratze liegen.',
              ],
              [
                'title' => '2. Ergonomische Auswertung',
                'text'  => 'Die dormabell-Software berechnet das ideale Zusammenspiel aus Matratze, Lattenrost und Zoneneinstellung.',
              ],
              [
                'title' => '3. Feineinstellung durch Fachberater',
                'text'  => 'Unser Team stellt das System direkt an Ihre Werte an – Sie spüren den Unterschied sofort.',
              ],
            ];
          ?>
          <?php foreach ($steps as $step): ?>
            <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 shadow-md shadow-[#0f1e2f]/10">
              <h3 class="text-lg font-semibold text-[#0f1e2f]"><?= htmlspecialchars($step['title'], ENT_QUOTES) ?></h3>
              <p class="text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($step['text'], ENT_QUOTES) ?></p>
            </article>
          <?php endforeach; ?>
        </div>
        <div class="rounded-2xl border border-dashed border-[#bed0e6] bg-white px-6 py-8 text-center text-sm leading-relaxed text-gray-600 shadow-inner">
          Das dormabell-Mess-System wurde gemeinsam mit dem <strong class="text-[#0f1e2f]">Ergonomie Institut München</strong> entwickelt – wissenschaftlich geprüft, in Fachgeschäften erprobt und kontinuierlich weiterentwickelt.
        </div>
      </div>
    </section>

    <!-- Kopfkissen-Analyse -->
    <section class="bg-white py-16" aria-labelledby="kissen-heading">
      <div class="mx-auto max-w-6xl space-y-6 px-6 text-gray-700 lg:px-0">
        <h2 id="kissen-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
          Vergessen Sie Ihr Kissen nicht
        </h2>
        <p class="text-base leading-relaxed sm:text-lg">
          Neben der Liege-Analyse bestimmen wir mit der dormabell Cervical Messung, welche Nackenstütze Ihre Wirbelsäule optimal unterstützt. Höhe, Material und Form werden exakt auf Ihre Schultern und Schlafposition angepasst – für vollständige Entlastung vom Nacken bis in die Lendenwirbelsäule.
        </p>
      </div>
    </section>

    <!-- Ergebnis -->
    <section class="bg-[#f5f7fa] py-16" aria-labelledby="ergebnis-heading">
      <div class="mx-auto max-w-6xl gap-12 px-6 text-gray-700 lg:grid lg:grid-cols-[minmax(0,1.05fr)_minmax(0,0.95fr)] lg:px-0 lg:items-center">
        <div class="space-y-6">
          <h2 id="ergebnis-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Das Ergebnis: Ihr perfektes Bett
          </h2>
          <p class="text-base leading-relaxed sm:text-lg">
            Nach der Analyse wissen Sie genau, welche Matratze, welcher Lattenrost und welches Kissen zu Ihnen passen. Kein Rätselraten mehr – sondern Schlaf, der spürbar besser wird, Druckpunkte reduziert und Ihre Wirbelsäule langfristig entlastet.
          </p>
          <ul class="space-y-3 text-sm leading-relaxed text-gray-600">
            <li class="rounded-lg border border-[#dce4ef] bg-white px-4 py-3">Dokumentierte Messwerte als Grundlage für Produktwahl und Feintuning.</li>
            <li class="rounded-lg border border-[#dce4ef] bg-white px-4 py-3">Ergebnis direkt am Testbett erlebbar – Sie spüren sofort, was sich verändert.</li>
            <li class="rounded-lg border border-[#dce4ef] bg-white px-4 py-3">Der Weg zu dauerhaft besserem Schlaf beginnt mit einem Termin von ca. 45 Minuten.</li>
          </ul>
        </div>
        <figure class="relative mt-10 overflow-hidden rounded-2xl bg-gray-200 shadow-lg shadow-[#0f1e2f]/15 lg:mt-0">
          <img
            src="images/produktbilder/dormabell/dormabell_bett_liegen.jpg"
            alt="Kundin testet das optimal eingestellte dormabell Schlafsystem"
            class="h-full w-full object-cover"
            loading="lazy"
            decoding="async"
          />
        </figure>
      </div>
    </section>

    <!-- Call to Action -->
    <section id="termin" class="bg-[#6793c4] py-16 text-white" aria-labelledby="termin-heading">
      <div class="mx-auto max-w-4xl space-y-6 px-6 text-center">
        <h2 id="termin-heading" class="text-2xl font-semibold sm:text-3xl">
          Buchen Sie Ihre persönliche Liege-Analyse – kostenlos &amp; unverbindlich.
        </h2>
        <p class="text-base leading-relaxed text-white/85 sm:text-lg">
          Wir nehmen uns Zeit für Sie, analysieren Ihre Liegeposition und zeigen Ihnen, wie sich ergonomischer Schlaf wirklich anfühlt.
        </p>
        <div class="flex flex-col items-center gap-4 sm:flex-row sm:justify-center sm:gap-6">
          <a href="#kontakt" class="inline-flex items-center justify-center rounded-lg bg-white px-7 py-3 text-sm font-semibold uppercase tracking-wide text-[#0f1e2f] transition hover:bg-[#dce4ef] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
            Termin vereinbaren
          </a>
          <div class="text-sm text-white/85">
            <p>Telefon Köln: <a href="tel:+49221843236" class="underline hover:text-white">0221&nbsp;843236</a></p>
            <p>Telefon Inhausen: <a href="tel:+4922412414230" class="underline hover:text-white">02241&nbsp;2414230</a></p>
          </div>
        </div>
        <p class="text-sm text-white/70">Oder schreiben Sie uns an <a href="mailto:info@betten-sauer.de" class="underline hover:text-white">info@betten-sauer.de</a>.</p>
      </div>
    </section>

    <!-- Vertrauen & Expertise -->
    <section class="bg-white py-16" aria-labelledby="vertrauen-heading">
      <div class="mx-auto max-w-5xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="vertrauen-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Vertrauen in Fachkompetenz
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Betten Sauer ist dormabell-Fachhändler und zertifiziert für das dormabell-Mess-System – präzise Messung, ehrliche Beratung, gesunder Schlaf.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-6 text-center sm:grid-cols-3">
          <div class="rounded-2xl border border-[#d6e2f1] bg-[#f9fbfe] p-6 shadow-md shadow-[#0f1e2f]/10">
            <p class="text-sm font-semibold uppercase tracking-wide text-[#0f1e2f]">Ergonomie Institut München</p>
            <p class="mt-2 text-xs text-gray-600">Wissenschaftlicher Partner des dormabell-Mess-Systems</p>
          </div>
          <div class="rounded-2xl border border-[#d6e2f1] bg-[#f9fbfe] p-6 shadow-md shadow-[#0f1e2f]/10">
            <p class="text-sm font-semibold uppercase tracking-wide text-[#0f1e2f]">dormabell Fachhändler</p>
            <p class="mt-2 text-xs text-gray-600">Zertifizierte Beratung &amp; Montage direkt vor Ort</p>
          </div>
          <div class="rounded-2xl border border-[#d6e2f1] bg-[#f9fbfe] p-6 shadow-md shadow-[#0f1e2f]/10">
            <p class="text-sm font-semibold uppercase tracking-wide text-[#0f1e2f]">Über 120 Jahre Erfahrung</p>
            <p class="mt-2 text-xs text-gray-600">Handwerkliche Schlafkultur in Köln &amp; Inhausen</p>
          </div>
        </div>
      </div>
    </section>

    <!-- Kontakt -->
    <section id="kontakt" class="bg-[#f5f7fa] py-16" aria-labelledby="kontakt-heading">
      <div class="mx-auto max-w-6xl gap-16 px-6 text-gray-700 lg:grid lg:grid-cols-[minmax(0,1fr)_minmax(0,1.05fr)] lg:px-0">
        <div class="space-y-6">
          <h2 id="kontakt-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Termin anfragen
          </h2>
          <p class="text-base leading-relaxed sm:text-lg">
            Teilen Sie uns kurz Ihre Wünsche mit. Wir melden uns werktags innerhalb von 24 Stunden, um Ihren persönlichen Mess-Termin abzustimmen.
          </p>
        </div>
        <div>
          <form action="lead.php" method="POST" class="rounded-2xl border border-[#dce4ef] bg-white p-8 shadow-xl shadow-[#0f1e2f]/10" novalidate aria-describedby="kontakt-form-info">
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
              <div>
                <label for="mess-name" class="mb-1 block text-sm font-semibold text-gray-800">Name *</label>
                <input
                  type="text"
                  id="mess-name"
                  name="name"
                  required
                  aria-required="true"
                  autocomplete="name"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
              <div>
                <label for="mess-email" class="mb-1 block text-sm font-semibold text-gray-800">E-Mail *</label>
                <input
                  type="email"
                  id="mess-email"
                  name="email"
                  required
                  aria-required="true"
                  autocomplete="email"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
            </div>
            <div class="mt-6">
              <label for="mess-telefon" class="mb-1 block text-sm font-semibold text-gray-800">Telefon</label>
              <input
                type="tel"
                id="mess-telefon"
                name="telefon"
                autocomplete="tel"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              />
            </div>
            <div class="mt-6">
              <label for="mess-wunschdatum" class="mb-1 block text-sm font-semibold text-gray-800">Wunschtermin</label>
              <input
                type="date"
                id="mess-wunschdatum"
                name="wunschdatum"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              />
            </div>
            <div class="mt-6">
              <label for="mess-nachricht" class="mb-1 block text-sm font-semibold text-gray-800">Nachricht *</label>
              <textarea
                id="mess-nachricht"
                name="nachricht"
                rows="6"
                required
                aria-required="true"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              ></textarea>
            </div>
            <div class="mt-6 flex items-start gap-3">
              <input
                type="checkbox"
                id="mess-datenschutz"
                name="datenschutz"
                required
                aria-required="true"
                class="mt-1 h-5 w-5 cursor-pointer rounded border-gray-300 text-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:ring-offset-0"
              />
              <label for="mess-datenschutz" class="text-sm leading-relaxed text-gray-700">
                Ich bin damit einverstanden, dass Betten Sauer meine Angaben zur Kontaktaufnahme verarbeitet.
                Details finden Sie in unserer <a href="datenschutz.php" class="text-[#4e759f] underline hover:text-[#2f506f]">Datenschutzerklärung</a>.
              </label>
            </div>
            <div class="mt-6">
              <div class="rounded-md border border-dashed border-gray-300 bg-gray-50 p-4 text-center text-sm text-gray-500">
                reCAPTCHA Platzhalter – hinterlegen Sie Ihren Site-Key für den Live-Betrieb.
              </div>
            </div>
            <div class="mt-8">
              <button type="submit" class="w-full rounded-lg bg-[#6793c4] px-6 py-3 text-base font-semibold text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-4 focus-visible:ring-[#4e759f]/30">
                Liege-Analyse anfragen
              </button>
            </div>
          </form>
          <p id="kontakt-form-info" class="mt-4 text-xs text-gray-600">
            Alle mit * gekennzeichneten Felder sind Pflichtfelder.
          </p>
        </div>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
