<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Datenschutzerklärung – Betten-Sauer Köln</title>
  <meta name="description" content="Datenschutzhinweise der Betten-Sauer KG. Informationen zu Verantwortlichen, Datenerhebung, Cookies, Analyse-Tools und Ihren Rechten.">
  <meta name="author" content="Betten-Sauer KG">
  <meta name="theme-color" content="#6793c4">

  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif">
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png">
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png">

  <link rel="stylesheet" href="css/style.css">

  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
  </style>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-[#0f1e2f]/90 transition duration-300';
    require __DIR__ . '/includes/header.php';
  ?>

  <main class="pt-28 pb-20 bg-gray-50">
    <section class="max-w-5xl mx-auto px-6 space-y-10">
      <div class="rounded-3xl bg-gradient-to-br from-[#0f1e2f] via-[#1b2f4b] to-[#274773] text-white text-center py-16 px-6 md:px-10 shadow-xl">
        <h1 class="text-3xl md:text-4xl font-semibold">Datenschutzerklärung</h1>
        <p class="mt-4 text-base md:text-lg text-white/85 max-w-2xl mx-auto">
          Erfahren Sie, wie wir Ihre Daten schützen: Transparente Informationen zu Erhebung, Verarbeitung und Ihren Rechten.
        </p>
      </div>

      <div class="bg-white shadow-lg rounded-2xl border border-gray-200 p-8 space-y-8 leading-relaxed">
        <section>
          <h2 class="text-2xl font-semibold mb-4">Verantwortliche Stelle</h2>
          <p>
            BETTEN-SAUER KG<br>
            Brücker Mauspfad 539<br>
            D – 51109 Köln<br>
            Telefon: +49 (0)221 – 843236<br>
            Telefax: +49 (0)221 – 844349
          </p>
          <p class="mt-4">
            Vertreten durch:<br>
            Herrn Michael Gouram (Geschäftsführer)
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Erfassung allgemeiner Informationen</h2>
          <p>
            Wenn Sie auf unsere Webseite zugreifen, werden automatisch Informationen allgemeiner Natur erfasst.
            Diese Informationen (Server-Logfiles) beinhalten etwa die Art des Webbrowsers, das verwendete Betriebssystem,
            den Domainnamen Ihres Internet Service Providers und Ähnliches. Hierbei handelt es sich ausschließlich um
            Informationen, welche keine Rückschlüsse auf Ihre Person zulassen. Diese Informationen sind technisch notwendig,
            um von Ihnen angeforderte Inhalte von Webseiten korrekt auszuliefern und fallen bei Nutzung des Internets zwingend an.
          </p>
          <p class="mt-4">
            Anonyme Informationen dieser Art werden von uns statistisch ausgewertet, um unseren Internetauftritt und die
            dahinterstehende Technik zu optimieren.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Cookies</h2>
          <p>
            Wie viele andere Webseiten verwenden wir auch so genannte „Cookies“. Cookies sind kleine Textdateien,
            die von einem Webseitenserver auf Ihre Festplatte übertragen werden. Hierdurch erhalten wir automatisch bestimmte Daten
            wie z. B. IP-Adresse, verwendeter Browser, Betriebssystem über Ihren Computer und Ihre Verbindung zum Internet.
          </p>
          <p class="mt-4">
            Cookies können nicht verwendet werden, um Programme zu starten oder Viren auf einen Computer zu übertragen.
            Anhand der in Cookies enthaltenen Informationen können wir Ihnen die Navigation erleichtern und die korrekte Anzeige
            unserer Webseiten ermöglichen. In keinem Fall werden die von uns erfassten Daten an Dritte weitergegeben oder ohne
            Ihre Einwilligung eine Verknüpfung mit personenbezogenen Daten hergestellt.
          </p>
          <p class="mt-4">
            Natürlich können Sie unsere Website grundsätzlich auch ohne Cookies betrachten. Internet-Browser sind regelmäßig so
            eingestellt, dass sie Cookies akzeptieren. Sie können die Verwendung von Cookies jederzeit über die Einstellungen
            Ihres Browsers deaktivieren. Bitte verwenden Sie die Hilfefunktionen Ihres Internetbrowsers, um zu erfahren,
            wie Sie diese Einstellungen ändern können. Bitte beachten Sie, dass einzelne Funktionen unserer Website möglicherweise
            nicht funktionieren, wenn Sie die Verwendung von Cookies deaktiviert haben.
          </p>
          <p class="mt-4">
            <a href="javascript:void(0)" class="text-[#6793c4] hover:underline">Cookie-Einstellungen anpassen</a>
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">SSL-Verschlüsselung</h2>
          <p>
            Um die Sicherheit Ihrer Daten bei der Übertragung zu schützen, verwenden wir dem aktuellen Stand der Technik
            entsprechende Verschlüsselungsverfahren (z. B. SSL) über HTTPS.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Kommentarfunktion</h2>
          <p>
            Wenn Nutzer Kommentare im Blog hinterlassen, werden neben diesen Angaben auch der Zeitpunkt ihrer Erstellung und
            der zuvor durch den Websitebesucher gewählte Nutzername gespeichert. Dies dient unserer Sicherheit, da wir für
            widerrechtliche Inhalte auf unserer Webseite belangt werden können, auch wenn diese durch Benutzer erstellt wurden.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Newsletter</h2>
          <p>
            Bei der Anmeldung zum Bezug unseres Newsletters werden die von Ihnen angegebenen Daten ausschließlich für diesen Zweck verwendet.
            Abonnenten können auch über Umstände per E-Mail informiert werden, die für den Dienst oder die Registrierung relevant sind,
            beispielsweise Änderungen des Newsletterangebots oder technische Gegebenheiten.
          </p>
          <p class="mt-4">
            Für eine wirksame Registrierung benötigen wir eine valide E-Mail-Adresse. Um zu überprüfen, dass eine Anmeldung tatsächlich durch
            den Inhaber einer E-Mail-Adresse erfolgt, setzen wir das „Double-opt-in“-Verfahren ein. Hierzu protokollieren wir die Bestellung des Newsletters,
            den Versand einer Bestätigungsmail und den Eingang der hiermit angeforderten Antwort. Weitere Daten werden nicht erhoben.
          </p>
          <p class="mt-4">
            Die Einwilligung zur Speicherung Ihrer persönlichen Daten und ihrer Nutzung für den Newsletterversand können Sie jederzeit widerrufen.
            In jedem Newsletter findet sich dazu ein entsprechender Link. Außerdem können Sie sich jederzeit auch direkt auf dieser Webseite abmelden
            oder uns Ihren entsprechenden Wunsch über die am Ende dieser Datenschutzhinweise angegebene Kontaktmöglichkeit mitteilen.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Kontaktformular</h2>
          <p>
            Treten Sie per E-Mail oder Kontaktformular mit uns in Kontakt, werden die von Ihnen gemachten Angaben zum Zwecke
            der Bearbeitung der Anfrage sowie für mögliche Anschlussfragen gespeichert.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Löschung bzw. Sperrung der Daten</h2>
          <p>
            Wir halten uns an die Grundsätze der Datenvermeidung und Datensparsamkeit. Wir speichern Ihre personenbezogenen Daten daher nur so lange,
            wie dies zur Erreichung der hier genannten Zwecke erforderlich ist oder wie es die vom Gesetzgeber vorgesehenen vielfältigen Speicherfristen vorsehen.
            Nach Fortfall des jeweiligen Zweckes bzw. Ablauf dieser Fristen werden die entsprechenden Daten routinemäßig und entsprechend den gesetzlichen Vorschriften
            gesperrt oder gelöscht.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Verwendung von Google Analytics</h2>
          <p>
            Diese Webseite benutzt Google Analytics, einen Webanalysedienst der Google Inc. Google Analytics verwendet sog. „Cookies“, also Textdateien,
            die auf Ihrem Computer gespeichert werden und die eine Analyse der Benutzung der Webseite durch Sie ermöglichen.
            Die durch das Cookie erzeugten Informationen über Ihre Benutzung dieser Webseite werden in der Regel an einen Server von Google in den USA
            übertragen und dort gespeichert.
          </p>
          <p class="mt-4">
            Aufgrund der Aktivierung der IP-Anonymisierung auf diesen Webseiten wird Ihre IP-Adresse von Google jedoch innerhalb von Mitgliedstaaten
            der Europäischen Union oder in anderen Vertragsstaaten des Abkommens über den Europäischen Wirtschaftsraum zuvor gekürzt.
            Nur in Ausnahmefällen wird die volle IP-Adresse an einen Server von Google in den USA übertragen und dort gekürzt.
          </p>
          <p class="mt-4">
            Sie können die Speicherung der Cookies durch eine entsprechende Einstellung Ihrer Browser-Software verhindern.
            Darüber hinaus können Sie die Erfassung der durch das Cookie erzeugten und auf Ihre Nutzung der Webseite bezogenen
            Daten (inkl. Ihrer IP-Adresse) an Google sowie die Verarbeitung dieser Daten durch Google verhindern, indem Sie das
            unter dem folgenden Link verfügbare Browser-Plugin herunterladen und installieren:
            <a href="https://tools.google.com/dlpage/gaoptout" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">
              Browser-Add-on zur Deaktivierung von Google Analytics
            </a>.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Verwendung von Piwik</h2>
          <p>
            Diese Webseite benutzt Piwik, eine Open-Source-Software zur statistischen Auswertung von Besucherzugriffen.
            Piwik verwendet sog. „Cookies“, Textdateien, die auf Ihrem Computer gespeichert werden und die eine Analyse der Benutzung
            der Website durch Sie ermöglichen. Die durch den Cookie erzeugten Informationen über Ihre Nutzung des Internetangebotes
            werden auf einem Server in Deutschland gespeichert. Die IP-Adresse wird unmittelbar nach der Verarbeitung anonymisiert.
          </p>
          <p class="mt-4">
            Sie haben die Möglichkeit, die Installation der Cookies durch Änderung der Einstellung Ihrer Browser-Software zu verhindern.
            Wir weisen Sie darauf hin, dass bei entsprechender Einstellung eventuell nicht mehr alle Funktionen dieser Website zur Verfügung stehen.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Verwendung von Adobe Analytics (Omniture)</h2>
          <p>
            Diese Webseite benutzt Adobe Analytics, einen Webanalysedienst der Adobe Systems Software Ireland Limited („Adobe“).
            Adobe Analytics verwendet sog. „Cookies“, Textdateien, die auf Ihrem Computer gespeichert werden und die eine Analyse
            der Benutzung der Webseite durch Sie ermöglichen.
          </p>
          <p class="mt-4">
            Die im Rahmen von Adobe Analytics von Ihrem Browser übermittelte IP-Adresse wird nicht mit anderen Daten von Adobe zusammengeführt.
            Sie können die Speicherung der Cookies durch eine entsprechende Einstellung Ihrer Browser-Software verhindern.
            Weitere Informationen finden Sie unter
            <a href="https://www.adobe.com/de/privacy/opt-out.html" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">
              www.adobe.com/de/privacy/opt-out.html
            </a>.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Analyse durch WiredMinds</h2>
          <p>
            Unsere Webseite nutzt die Zählpixeltechnologie der WiredMinds AG zur Analyse des Besucherverhaltens.
            Dabei werden Daten erhoben, verarbeitet und gespeichert, aus denen unter einem Pseudonym Nutzungsprofile erstellt werden.
          </p>
          <p class="mt-4">
            Der Datenerhebung, -verarbeitung und -speicherung kann jederzeit mit Wirkung für die Zukunft unter folgendem Link widersprochen werden:
            <a href="https://www.wiredminds.de/datenschutz/widerspruch-datenerhebung.html" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">
              Vom Webseiten-Tracking ausschließen
            </a>.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Nutzung des Skalierbaren Zentralen Messverfahrens</h2>
          <p>
            Unsere Website nutzt das „Skalierbare Zentrale Messverfahren“ (SZM) der INFOnline GmbH für die Ermittlung statistischer Kennwerte
            zur Nutzung unserer Angebote. Die Reichweitenmessung verwendet zur Wiedererkennung von Computersystemen ein Cookie oder eine Signatur.
          </p>
          <p class="mt-4">
            Weitere Informationen zum SZM-Verfahren finden Sie unter
            <a href="https://www.infonline.de" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">www.infonline.de</a>.
            Sie können der Datenverarbeitung durch das SZM unter folgenden Links widersprechen:
            <a href="http://optout.ioam.de" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">optout.ioam.de</a>
            und
            <a href="http://optout.ivwbox.de" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">optout.ivwbox.de</a>.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Verwendung von Scriptbibliotheken</h2>
          <p>
            Um unsere Inhalte browserübergreifend korrekt und grafisch ansprechend darzustellen, verwenden wir Script- und Schriftbibliotheken
            wie z. B. Google Webfonts. Der Aufruf solcher Bibliotheken löst automatisch eine Verbindung zum Betreiber der Bibliothek aus.
            Die Datenschutzrichtlinie des Bibliothekbetreibers Google finden Sie unter
            <a href="https://www.google.com/policies/privacy/" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">
              www.google.com/policies/privacy
            </a>.
          </p>
          <p class="mt-4">
            Wir setzen zudem Adobe Typekit zur visuellen Gestaltung unserer Website ein. Weitere Informationen finden Sie unter
            <a href="https://www.adobe.com/privacy/typekit.html" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">
              www.adobe.com/privacy/typekit.html
            </a>.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Verwendung von Google Maps</h2>
          <p>
            Diese Webseite verwendet Google Maps API, um geographische Informationen visuell darzustellen. Bei der Nutzung von Google Maps werden durch Google
            Daten über die Nutzung der Funktionen erhoben, verarbeitet und genutzt. Nähere Informationen über die Datenverarbeitung durch Google finden Sie
            in den Google-Datenschutzhinweisen.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Eingebettete YouTube-Videos</h2>
          <p>
            Auf einigen unserer Webseiten betten wir Youtube-Videos ein. Betreiber ist die YouTube, LLC. Wird ein Youtube-Video gestartet, setzt der Anbieter
            Cookies ein, die Hinweise über das Nutzerverhalten sammeln. Weitere Informationen finden Sie in der Datenschutzerklärung von YouTube unter
            <a href="https://www.google.de/intl/de/policies/privacy/" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">
              www.google.de/intl/de/policies/privacy/
            </a>.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Social Plugins</h2>
          <p>
            Wir bieten Ihnen die Möglichkeit der Nutzung von „Social-Media-Buttons“ an. Zum Schutze Ihrer Daten setzen wir bei der Implementierung auf die Lösung „Shariff“.
            Dadurch werden Buttons lediglich als Grafik eingebunden, die eine Verlinkung auf die entsprechende Webseite des Button-Anbieters enthält.
          </p>
          <p class="mt-4">
            Wir haben Social-Media-Buttons folgender Unternehmen eingebunden: Facebook, Twitter, Google Plus, WhatsApp, Pinterest, XING, LinkedIn, Reddit, Stumbleupon, Flattr.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Google AdWords</h2>
          <p>
            Unsere Webseite nutzt das Google Conversion-Tracking. Wenn Sie über eine Google-Anzeige auf unsere Webseite gelangen, wird ein Cookie gesetzt.
            Dieser dient der statistischen Auswertung unserer Werbeaktivitäten.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Einsatz von Google Remarketing</h2>
          <p>
            Diese Webseite verwendet die Remarketing-Funktion der Google Inc. Sie dient dazu, Webseitenbesuchern innerhalb des Google-Werbenetzwerks
            interessenbezogene Werbeanzeigen zu präsentieren. Sie können die Funktion unter
            <a href="http://www.google.com/settings/ads" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">
              www.google.com/settings/ads
            </a>
            deaktivieren.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Ihre Rechte</h2>
          <p>
            Sie haben das Recht, jederzeit Auskunft über Ihre bei uns gespeicherten personenbezogenen Daten zu erhalten.
            Ebenso können Sie Berichtigung, Sperrung oder Löschung verlangen, sofern keine gesetzliche Archivierungsverpflichtung besteht.
          </p>
          <p class="mt-4">
            Sie können Änderungen oder den Widerruf einer Einwilligung durch entsprechende Mitteilung an uns mit Wirkung für die Zukunft vornehmen.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Änderung unserer Datenschutzbestimmungen</h2>
          <p>
            Wir behalten uns vor, diese Datenschutzerklärung gelegentlich anzupassen, damit sie stets den aktuellen rechtlichen Anforderungen entspricht
            oder um Änderungen unserer Leistungen umzusetzen.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">Fragen zum Datenschutz</h2>
          <p>
            Wenn Sie Fragen zum Datenschutz haben, schreiben Sie uns bitte eine E-Mail oder wenden Sie sich direkt an unseren Datenschutzbeauftragten:<br>
            <a href="mailto:info@betten-sauer.de" class="text-[#6793c4] hover:underline">info@betten-sauer.de</a>
          </p>
        </section>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
