<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Projekt-Checkliste index.html – Betten-Sauer</title>
  <!-- Die vom Nutzer gewünschten Favicon-Links wurden hier hinzugefügt -->
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif"/>
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png"/>
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png" />
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root {
      color-scheme: light;
      --color-background: #eef2f8;
      --color-card: #ffffff;
      --color-border: #d4dbe8;
      --color-text: #0f172a;
      --color-muted: #475569;
      --color-true: #15803d;
      --color-false: #b91c1c;
    }
     @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-Regular.woff2') format('woff2'),
           url('fonts/WorkSans-Regular.woff') format('woff');
      font-weight: 400;
      font-style: normal;
      font-display: swap;
    }
    header { transition: background 0.3s ease, box-shadow 0.3s ease; }
    header.scrolled { background: rgba(255,255,255,0.95); box-shadow: 0 2px 10px rgba(0,0,0,0.08); }
    header.scrolled a { color: #1f2937 !important; text-shadow: none; }
    .menu-btn {
      width: 3rem;
      height: 3rem;
      padding: 0;
      aspect-ratio: 1 / 1;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
    @font-face {
      font-family: 'Work Sans';
      src: url('fonts/WorkSans-SemiBold.woff2') format('woff2'),
           url('fonts/WorkSans-SemiBold.woff') format('woff');
      font-weight: 600;
      font-style: normal;
      font-display: swap;
    }
    * { box-sizing: border-box; }
    body {
      margin: 0;
      padding: 140px 1rem 4rem;
      font-family: 'Work Sans', sans-serif;
      background: var(--color-background);
      color: var(--color-text);
      line-height: 1.6;
    }
    .checklist-head {
      max-width: 960px;
      margin: 0 auto 2rem;
      text-align: center;
    }
    .checklist-head h1 {
      margin-bottom: 0.5rem;
      font-size: clamp(2rem, 5vw, 2.75rem);
    }
    .checklist-head p {
      color: var(--color-muted);
      margin: 0 auto;
      max-width: 640px;
    }
    .legend {
      display: flex;
      justify-content: center;
      gap: 1.5rem;
      margin-top: 1rem;
      font-size: 0.95rem;
    }
    .legend span {
      display: inline-flex;
      align-items: center;
      gap: 0.5rem;
    }
    main {
      max-width: 960px;
      margin: 0 auto;
      display: grid;
      gap: 2rem;
    }
    section {
      background: var(--color-card);
      border: 1px solid var(--color-border);
      border-radius: 1rem;
      padding: 1.75rem;
      box-shadow: 0 15px 30px rgba(15, 23, 42, 0.08);
    }
    section h2 {
      margin-top: 0;
      font-size: 1.75rem;
    }
    ul {
      list-style: none;
      margin: 1.5rem 0 0;
      padding: 0;
      display: grid;
      gap: 1.25rem;
    }
    .check-item {
      display: grid;
      grid-template-columns: auto 1fr;
      gap: 1rem;
      padding: 1rem 1.25rem;
      border-radius: 0.75rem;
      border: 1px solid var(--color-border);
      background: rgba(241, 245, 249, 0.5);
      align-items: flex-start;
    }
    .status-icon {
      width: 2.5rem;
      height: 2.5rem;
      border-radius: 999px;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      color: #fff;
      font-weight: 700;
      font-size: 1.4rem;
      flex-shrink: 0;
    }
    .check-item[data-complete="true"] .status-icon {
      background: var(--color-true);
    }
    .check-item[data-complete="false"] .status-icon {
      background: var(--color-false);
    }
    .check-item[data-complete="true"] .status-icon::after {
      content: "✓";
    }
    .check-item[data-complete="false"] .status-icon::after {
      content: "✕";
    }
    .item-content h3 {
      margin: 0 0 0.5rem;
      font-size: 1.2rem;
    }
    .item-content p {
      margin: 0;
      color: var(--color-muted);
    }
    .item-content img {
      margin: 0.75rem 0;
      border-radius: 0.5rem;
      display: block;
      max-width: 100%;
      height: auto;
      border: 1px solid var(--color-border);
    }
   
    @media (max-width: 640px) {
      section {
        padding: 1.25rem;
      }
      .check-item {
        grid-template-columns: 1fr;
      }
      .status-icon {
        width: 2.25rem;
        height: 2.25rem;
      }
    }
  </style>
</head>
<body>
  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-[#0f1e2f]/90 transition duration-300';
    require __DIR__ . '/includes/header.php';
  ?>

  <section class="checklist-head">
    <h1>Projekt-Checkliste index.html</h1>
    <p>Stand der Demo Version</p>
    <div class="legend">
      <span><span class="status-icon" style="background: var(--color-true);">✓</span> Erledigt</span>
      <span><span class="status-icon" style="background: var(--color-false);">✕</span> Offen</span>
    </div>
  </section>

  <main>
    <section aria-labelledby="section-high">
      <h2 id="section-high">Sehr wichtig</h2>
      <ul>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Professionelles, responsives Design</h3>
            <p>Die Website soll auf Desktop, Tablet und Smartphone überzeugen und die Markenidentität transportieren.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Klare Navigation und Struktur</h3>
            <p>Intuitive Menüführung und logisch aufgebaute Seitenhierarchie für eine reibungslose Nutzerführung.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Hochwertige Inhalte</h3>
            <p>Einzigartige, fehlerfreie Texte, Bilder und Videos, die Zielgruppenfragen beantworten und das Angebot erklären. ( Auf Demo Status, Videos und Bilder werden noch geupscaled.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Impressum &amp; Datenschutzerklärung</h3>
            <p>Rechtlich einwandfreie Seiten mit vollständigen Unternehmens- und Datenschutzinformationen.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Schnelle Ladezeit</h3>
            <img src="images/ladezeit_prototyp.jpg" alt="Symbol für optimierte Ladezeit" />
            <p>Optimierte Medien und sauberer Code für kurze Ladezeiten und geringere Absprungraten.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>SEO-Grundlagen</h3>
            <p>Gezielte Keywords, strukturierte Überschriften und Meta-Daten für gute Sichtbarkeit in Suchmaschinen.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Klare Call-to-Actions</h3>
            <p>Handlungsaufforderungen wie „Termin vereinbaren“ oder „Kontakt aufnehmen“, die Nutzer zum Ziel führen.</p>
          </div>
        </li>
        <li class="check-item" data-complete="false">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Kontaktmöglichkeiten</h3>
            <p>Leicht zugängliche Kontaktwege: Telefon, E-Mail, Formular oder Terminbuchung.</p>
          </div>
        </li>
      </ul>
    </section>

    <section aria-labelledby="section-medium">
      <h2 id="section-medium">Notwendig</h2>
      <ul>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Über-uns-Seite</h3>
            <p>Unternehmensgeschichte, Team und Werte authentisch präsentieren, um Vertrauen aufzubauen.</p>
          </div>
        </li>
        <li class="check-item" data-complete="false">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Social-Media-Anbindung</h3>
            <p>Verbindungen zu relevanten Kanälen zur Reichweitensteigerung und Interaktion mit der Community.</p>
          </div>
        </li>
        <li class="check-item" data-complete="false">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Blog oder Neuigkeiten</h3>
            <p>Aktuelle Inhalte wie Blogbeiträge, Projekte oder News stärken SEO und zeigen Unternehmensaktivität.</p>
          </div>
        </li>
        <li class="check-item" data-complete="false">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Gute Lesbarkeit</h3>
            <p>Gut strukturierte Texte mit Absätzen, Zwischenüberschriften und kontrastreicher Typografie.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Sicherheit (SSL)</h3>
            <p>Verschlüsselte Datenübertragung durch ein gültiges SSL-Zertifikat als Vertrauens- und Rankingfaktor.</p>
          </div>
        </li>
        <li class="check-item" data-complete="false">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Domain &amp; Hosting</h3>
            <p>Passender Domainname und zuverlässiger Hosting-Anbieter für hohe Verfügbarkeit und Performance.</p>
          </div>
        </li>
      </ul>
    </section>

    <section aria-labelledby="section-optional">
      <h2 id="section-optional">Optional</h2>
      <ul>
        <li class="check-item" data-complete="false">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Newsletter-Anmeldung</h3>
            <p>Leads gewinnen und Kundenbindung stärken durch regelmäßige Updates per Newsletter.</p>
          </div>
        </li>
        <li class="check-item" data-complete="false">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Kundenbewertungen</h3>
            <p>Testimonials und Rezensionen schaffen Glaubwürdigkeit und steigern die Conversion-Rate.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Favicon</h3>
            <p>Markensymbol für Browser-Tabs und Lesezeichen als professionelles Detail.</p>
          </div>
        </li>
        <li class="check-item" data-complete="true">
          <span class="status-icon" aria-hidden="true"></span>
          <div class="item-content">
            <h3>Barrierefreiheit</h3>
            <p>Verbesserte Zugänglichkeit für Menschen mit Einschränkungen zeigt Verantwortung und erweitert die Zielgruppe.</p>
          </div>
        </li>
      </ul>
    </section>
  </main>

  
  <?php require __DIR__ . '/includes/footer.php'; ?>
  

  

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
