<?php
// chat.php – OpenAI Relay (direkter API-Key, kein Env-Var)
// PHP 8+, ext-curl

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: https://auswahl-fuer-dich.de'); // <- ggf. anpassen
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }

// >>> HIER DEIN OPENAI API-KEY DIREKT EINTRAGEN <<<
$apiKey = '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';

$raw = file_get_contents('php://input');
$req = json_decode($raw, true);
if (!$req || !isset($req['history']) || !is_array($req['history'])) {
  http_response_code(400);
  echo json_encode(['error' => 'Bad request']);
  exit;
}

// Systemprompt laden (Datei aus vorherigem Setup)
$systemPath = __DIR__ . '/prompt/system.txt';
$system = is_file($systemPath) ? file_get_contents($systemPath) : "Du bist der Chat-Assistent von „Betten Sauer“. Antworte kurz (max 2–3 Sätze). Ziel: Ladenbesuch oder Rückruf-Leads. Keine Online-Fachberatung. Öffnungszeiten: Mo–Fr 10–18, Sa 10–14. Rückrufnummer: 0151 41391390.";

$messages = [['role' => 'system', 'content' => $system]];
$history = array_slice($req['history'], -6);
foreach ($history as $m) {
  $role = ($m['role'] === 'assistant') ? 'assistant' : 'user';
  $messages[] = ['role' => $role, 'content' => (string)$m['content']];
}

$payload = [
  'model' => 'gpt-4o-mini',
  'messages' => $messages,
  'temperature' => 0.4,
  'max_tokens' => 220,
];

$ch = curl_init('https://api.openai.com/v1/chat/completions');
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST => true,
  CURLOPT_HTTPHEADER => [
    'Content-Type: application/json',
    'Authorization: ' . 'Bearer ' . $apiKey,
  ],
  CURLOPT_POSTFIELDS => json_encode($payload),
  CURLOPT_TIMEOUT => 8,
  CURLOPT_CONNECTTIMEOUT => 4,
]);

$resp = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
$err  = curl_error($ch);
curl_close($ch);

if ($resp === false) {
  http_response_code(502);
  echo json_encode(['error' => 'OpenAI unreachable', 'detail' => $err]);
  exit;
}

http_response_code($code ?: 200);
echo $resp;
