<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Boxspringbetten Köln &amp; Siegburg | Betten Sauer</title>
  <meta name="description" content="Erleben Sie Boxspringbetten mit individueller Liegeanalyse in Köln &amp; Siegburg. Betten Sauer verbindet Ergonomie, Design und Handwerkskunst seit 1823." />
  <meta name="keywords" content="Boxspringbetten, Luxus Boxspringbett, ergonomisches Boxspringbett, Schlafkomfort, Betten Sauer Köln, Boxspringbett Siegburg, Liegeanalyse" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="boxspringbetten.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="boxspringbetten.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Boxspringbetten – Schlafkomfort auf höchstem Niveau" />
  <meta property="og:description" content="Luxus Boxspringbetten mit individueller Beratung in Köln und Siegburg. Entdecken Sie ergonomischen Schlafkomfort bei Betten Sauer." />
  <meta property="og:image" content="images/1200x800_boxspringbett.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Boxspringbetten – Schlafkomfort auf höchstem Niveau" />
  <meta name="twitter:description" content="Betten Sauer: Boxspringbetten mit persönlicher Liegeanalyse in Köln &amp; Siegburg. Design trifft Ergonomie seit 1823." />
  <meta name="twitter:image" content="images/1200x800_boxspringbett.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <section class="relative">
      <div class="relative hidden lg:block">
        <div class="relative h-[340px] sm:h-[380px] md:h-[440px] lg:h-[500px]">
          <img
            src="images/header/header_boxspringbetten.jpg"
            alt="Luxus Boxspringbett mit gepolstertem Kopfteil in einem elegant gestalteten Schlafzimmer"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
            decoding="async"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/50"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/45 to-[#0f1e2f]/75"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_boxspringbetten.jpg"
          alt="Boxspringbett mobile Darstellung"
          class="hero-mobile-img"
          loading="eager"
          decoding="async"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-5 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center lg:justify-end">
        <div class="w-full max-w-5xl space-y-5 lg:w-1/2 lg:px-12">
          <h1 class="text-3xl font-semibold text-shadow sm:text-4xl md:text-5xl lg:ml-auto">
            Boxspringbetten – Schlafkomfort auf höchstem Niveau
          </h1>
          <p class="text-base sm:text-lg md:text-xl text-white/90 lg:ml-auto">
            Betten Sauer verbindet Design, Ergonomie und handwerkliche Präzision zu einem Boxspringbett, das Ihren Schlaf nachhaltig verbessert.
          </p>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Schlafen wie auf Wolken – mit handverlesenen Boxspringbetten führender Marken.</h2>
        <p class="text-base leading-relaxed sm:text-lg">Stellen Sie sich vor, Sie öffnen morgens die Augen – und Ihr Rücken fühlt sich frei und erholt an. Genau dieses Gefühl ist unser Anspruch: Bei Betten Sauer finden Sie eine exklusive Auswahl an Boxspringbetten führender Marken, die höchsten Komfort, ergonomische Perfektion und stilvolles Design vereinen.</p>
        <p class="text-base leading-relaxed sm:text-lg">Mit viel Erfahrung und einem geschulten Blick für Qualität wählen wir nur Produkte, die in Verarbeitung, Ergonomie und Ästhetik überzeugen. Ob klassisch, modern oder individuell konfigurierbar – unser Team berät Sie persönlich und findet das Boxspringbett, das perfekt zu Ihnen und Ihren Schlafgewohnheiten passt.</p>
        <p class="text-base leading-relaxed sm:text-lg">Erleben Sie in unseren Showrooms in Köln und Siegburg, wie sich hochwertiger Schlafkomfort wirklich anfühlt – und warum sorgfältig ausgewählte Markenprodukte den Unterschied machen.</p>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Was macht ein Boxspringbett so besonders?</h2>
        <p class="text-base leading-relaxed sm:text-lg">Ein Luxus Boxspringbett entfaltet seine Wirkung durch drei exakt abgestimmte Ebenen. Jede Schicht übernimmt einen Teil der ergonomischen Arbeit und sorgt gemeinsam für das charakteristische, schwebende Liegegefühl.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Unterbox</h3>
            <p class="mt-3 text-sm leading-relaxed">Die gefederte Basis absorbiert Bewegungen, verteilt Ihr Gewicht gleichmäßig und schafft die komfortable Einstiegshöhe.</p>
            <figure class="mt-6 flex justify-center">
              <img src="images/produktbilder/boxspringbetten/unterbox.jpg" alt="Visualisierte Unterbox eines Boxspringbetts" class="h-32 w-auto object-contain" loading="lazy" decoding="async" />
            </figure>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Matratze</h3>
            <p class="mt-3 text-sm leading-relaxed">Punktelastische Taschenfedern oder Komfortschäume stützen die Wirbelsäule und lassen Schultern sowie Becken kontrolliert einsinken.</p>
            <figure class="mt-6 flex justify-center">
              <img src="images/produktbilder/boxspringbetten/matratze.jpg" alt="Visualisierte Matratze eines Boxspringbetts" class="h-32 w-auto object-contain" loading="lazy" decoding="async" />
            </figure>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Topper</h3>
            <p class="mt-3 text-sm leading-relaxed">Topper aus Latex, Viscoschaum oder Tencel-Schaum verfeinern das Liegegefühl, regulieren das Mikroklima und schaffen eine nahtlose Fläche.</p>
            <figure class="mt-6 flex justify-center">
              <img src="images/produktbilder/boxspringbetten/topper.jpg" alt="Visualisierter Topper eines Boxspringbetts" class="h-32 w-auto object-contain" loading="lazy" decoding="async" />
            </figure>
          </article>
        </div>
        <p class="text-base leading-relaxed sm:text-lg">Zusammen entsteht ein System, das Druckpunkte reduziert, Bewegungen leise abfedert und durch atmungsaktive Materialien ein angenehmes Schlafklima hält – zu jeder Jahreszeit.</p>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Passt ein Boxspringbett zu mir?</h2>
        <p class="text-base leading-relaxed sm:text-lg">Boxspringbetten sind für Menschen gedacht, die Entlastung und Ästhetik verbinden möchten. Seitenschläfer genießen das sanfte Einsinken der Schulter, Rückenschläfer schätzen die stabile Stütze im Lendenbereich, Mischtypen bewegen sich frei ohne harte Übergänge.</p>
        <p class="text-base leading-relaxed sm:text-lg">In unserer Liegeanalyse betrachten wir Körperbau, Bewegungsmuster und gesundheitliche Aspekte. So erkennen wir, ob ein ergonomisches Boxspringbett mit motorischer Verstellung, unterschiedlicher Festigkeit oder speziellen Klima-Lösungen die passende Wahl ist.</p>
        <div class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
          <h3 class="text-lg font-semibold text-[#4e759f]">Typische Gründe für Boxspring</h3>
          <ul class="mt-3 list-disc pl-6 space-y-2 text-sm leading-relaxed">
            <li>Höhere Einstiegshöhe erleichtert den Morgen und schont Hüfte sowie Knie</li>
            <li>Paare wünschen ruhiges Liegen ohne Schwingungen über die gesamte Fläche</li>
            <li>Rücken-, Schulter- oder Nackenbeschwerden verlangen individuelle Druckentlastung</li>
          </ul>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Die häufigsten Fragen unserer Kunden</h2>
        <div class="space-y-5">
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Sind Boxspringbetten wirklich besser?</h3>
            <p class="mt-3 text-sm leading-relaxed">Besser ist das Bett, das zu Ihrem Körper passt. Ein Boxspringbett überzeugt, wenn alle Ebenen harmonieren. Wir lassen Sie unterschiedliche Systeme im Vergleich spüren, damit Sie fundiert entscheiden können – ohne Marketingversprechen.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Was ist mit Allergien oder Rückenproblemen?</h3>
            <p class="mt-3 text-sm leading-relaxed">Wir konfigurieren hypoallergene Topper und waschbare Bezüge, achten auf Luftzirkulation und wählen Materialien, die zu Ihren Bedürfnissen passen. Bei Rücken- oder Bandscheibenproblemen stimmen wir Zonen und Festigkeiten millimetergenau ab.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Welche Marken führen Sie?</h3>
            <p class="mt-3 text-sm leading-relaxed">Unsere Auswahl umfasst europäische Premium-Manufakturen wie <span class="font-semibold">dormabell</span> und <span class="font-semibold">SCHRAMM</span> sowie exklusive Editionen für Betten Sauer. Handwerkliche Fertigung und langlebige Materialien sind für uns Voraussetzung.</p>
          </article>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Stil und Design – Ihr Boxspringbett, so individuell wie Sie</h2>
        <p class="text-base leading-relaxed sm:text-lg">Als Mittelpunkt des Schlafzimmers sollte Ihr Boxspringbett Ihren Stil widerspiegeln. Gemeinsam entwickeln wir ein Design, das Ruhe ausstrahlt und zu Ihren Räumen passt – von puristischen Linien bis zu opulenten Kopfteil-Inszenierungen.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Bezüge &amp; Texturen</h3>
            <p class="mt-3 text-sm leading-relaxed">Feine Wollstoffe, samtige Velours oder robuste Leinenstrukturen – alle Materialien sind langlebig und harmonieren mit unserer Bettwäsche-Kollektion.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Kopfteilformen</h3>
            <p class="mt-3 text-sm leading-relaxed">Schlank, dezent gekantet oder großzügig gepolstert: Wir gestalten Kopfteile, die skandinavische Ruhe oder urbane Eleganz verkörpern.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Farbwelten</h3>
            <p class="mt-3 text-sm leading-relaxed">Von Creme, Sand und Nebelgrau bis zu Tintenblau oder tiefem Moosgrün – wir finden die Palette, die Ihre Einrichtung ergänzt und Ruhe ausstrahlt.</p>
          </article>
        </div>
        <p class="text-base leading-relaxed sm:text-lg">Auf Wunsch ergänzen wir Ihr Boxspringbett um passende Nachttische, Plaids und Beleuchtung. So entsteht ein Schlafzimmer-Ensemble, das Form und Funktion in Balance bringt.</p>
      </div>
    </section>

    <section class="bg-[#0f1e2f] py-16 text-white">
      <div class="mx-auto max-w-4xl px-6 text-center space-y-6">
        <h2 class="text-2xl font-semibold sm:text-3xl">Beratung &amp; Probeliegen bei Betten Sauer</h2>
        <p class="text-base leading-relaxed sm:text-lg text-white/85">Erleben Sie den Unterschied einer professionellen Liegeanalyse. Unsere Schlafexperten führen Sie durch verschiedene Systeme, erklären jedes Detail und begleiten Sie mit der Erfahrung aus zwei Standorten, zertifizierten Teams und eigener Werkstatt.</p>
        <a href="index.php#kontaktformular" class="inline-flex items-center justify-center rounded-lg bg-white px-7 py-3 text-sm font-semibold uppercase tracking-wide text-[#4e759f] transition hover:bg-[#dce6f5] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
          Termin vereinbaren
        </a>
        <p class="text-sm leading-relaxed text-white/80">Lassen Sie sich bei Betten Sauer beraten und erleben Sie den Unterschied eines abgestimmten Boxspringbetts. Vereinbaren Sie Ihren Termin zur Liegeanalyse in Köln oder Siegburg.</p>
      </div>
    </section>

    <?php require __DIR__ . '/kontakt_sektion.php'; ?>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>

  <!-- Meta Title: Boxspringbetten Köln & Siegburg | Betten Sauer -->
  <!-- Meta Description: Boxspringbetten mit individueller Liegeanalyse bei Betten Sauer in Köln & Siegburg – Ergonomie, Design und Handwerkskunst seit 1823. -->
</body>
</html>
