<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Bettwäsche Köln &amp; Siegburg | Betten Sauer</title>
  <meta name="description" content="Hochwertige Bettwäsche aus Satin, Leinen, Baumwolle &amp; Tencel bei Betten Sauer. Persönliche Beratung in Köln und Siegburg für spürbaren Schlafkomfort." />
  <meta name="keywords" content="Bettwäsche Köln, Bettwäsche Siegburg, Luxus Bettwäsche, hochwertige Bettwäsche, Baumwolle, Satin, Leinen, Tencel, Schlafkomfort" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="bettwaesche.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="bettwaesche.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Bettwäsche zum Wohlfühlen – Betten Sauer" />
  <meta property="og:description" content="Luxus Bettwäsche aus Köln und Siegburg: Satin, Leinen, Baumwolle &amp; Tencel mit persönlicher Beratung für Ihren Schlafkomfort." />
  <meta property="og:image" content="images/header/header_bettwaesche.jpg" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Bettwäsche zum Wohlfühlen – Betten Sauer" />
  <meta name="twitter:description" content="Besuchen Sie Betten Sauer in Köln oder Siegburg und entdecken Sie hochwertige Bettwäsche für entspannte Nächte." />
  <meta name="twitter:image" content="images/header/header_bettwaesche.jpg" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <section class="relative">
      <div class="relative hidden lg:block">
        <div class="relative h-[340px] sm:h-[380px] md:h-[440px] lg:h-[500px]">
          <img
            src="images/header/header_bettwaesche.jpg"
            alt="Stimmungsvoller Blick auf Bettwäsche-Inszenierung bei Betten Sauer"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
            decoding="async"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/50"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/45 to-[#0f1e2f]/75"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_bettwaesche.jpg"
          alt="Bettwäsche-Arrangement – mobile Ansicht"
          class="hero-mobile-img"
          loading="eager"
          decoding="async"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-5 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center lg:justify-end">
        <div class="w-full max-w-5xl space-y-5 lg:w-1/2 lg:px-12">
          <h1 class="text-3xl font-semibold text-shadow sm:text-4xl md:text-5xl lg:ml-auto">
            Bettwäsche zum Wohlfühlen – spüren Sie den Unterschied Nacht für Nacht
          </h1>
          <p class="text-base sm:text-lg md:text-xl text-white/90 lg:ml-auto">
            Wir kuratieren Luxus Bettwäsche, die Körper und Sinne verwöhnt – mit feinen Materialien, ruhigen Farbwelten und individueller Beratung in Köln und Siegburg.
          </p>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-6xl px-6 lg:px-0">
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-[minmax(0,1.1fr)_minmax(0,0.9fr)] lg:items-center text-gray-700">
          <div class="space-y-6">
            <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Warum hochwertige Bettwäsche mehr ist als nur Stoff</h2>
            <p class="text-base leading-relaxed sm:text-lg">Die Wahl der Bettwäsche entscheidet über das Klima unter der Decke, über morgendliche Frische und den Eindruck, mit dem Sie abends abschalten. Wenn Fasern sanft über die Haut streichen, wenn Kissen und Decke in Farbe und Haptik harmonieren, spüren Sie das Ergebnis – Nacht für Nacht, Jahr für Jahr.</p>
            <p class="text-base leading-relaxed sm:text-lg">Als traditionsreiches Bettenfachgeschäft begleiten wir seit über 200 Jahren anspruchsvolle Schläferinnen und Schläfer in Köln und Siegburg. Unser Team verknüpft textile Expertise mit Einfühlungsvermögen: Wir zeigen Ihnen, wie Luxus Bettwäsche funktioniert, welche Stoffe Sie umschmeicheln und wie Ihr Schlafzimmer zu einem Ort spürbarer Ruhe wird.</p>
          </div>
          <figure class="overflow-hidden rounded-xl shadow-lg">
            <img
              src="images/produktbilder/bettwaesche/bettwaesche.jpg"
              alt="Gefaltete Bettwäsche in sanften Cremetönen auf einer Bank"
              class="h-full w-full object-cover"
              loading="lazy"
              decoding="async"
            />
          </figure>
        </div>
        <div class="mt-10 grid grid-cols-1 gap-6 md:grid-cols-3 text-gray-700">
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <div class="flex items-start gap-3">
              <span class="flex h-12 w-12 items-center justify-center rounded-full bg-[#e6effc]">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-[#4e759f]" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.8">
                  <path stroke-linecap="round" stroke-linejoin="round" d="M3 7.5h18M4.5 7.5V18a1.5 1.5 0 0 0 1.5 1.5h12a1.5 1.5 0 0 0 1.5-1.5V7.5M9 10.5h6m-9 6h12" />
                </svg>
              </span>
              <div class="space-y-2">
                <h3 class="text-lg font-semibold text-[#4e759f]">Schlafkomfort mit Konzept</h3>
                <p class="text-sm leading-relaxed">Wir kombinieren hochwertige Bettwäsche mit Matratzen, Kissen und Plaids. So entstehen Ensembles, die Ihr individuelles Schlafklima unterstützen.</p>
              </div>
            </div>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <div class="flex items-start gap-3">
              <span class="flex h-12 w-12 items-center justify-center rounded-full bg-[#e6effc]">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-[#4e759f]" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.8">
                  <path stroke-linecap="round" stroke-linejoin="round" d="M4 5.75A1.75 1.75 0 0 1 5.75 4h12.5A1.75 1.75 0 0 1 20 5.75V12a4 4 0 0 1-4 4H9.5L6 19.5V16H5.75A1.75 1.75 0 0 1 4 14.25V5.75Z" />
                </svg>
              </span>
              <div class="space-y-2">
                <h3 class="text-lg font-semibold text-[#4e759f]">Beratung in Köln &amp; Siegburg</h3>
                <p class="text-sm leading-relaxed">In unseren Häusern erleben Sie Bettwäsche für jede Jahreszeit, fühlen Stoffe und nehmen Farbwelten mit allen Sinnen auf.</p>
              </div>
            </div>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
            <div class="flex items-start gap-3">
              <span class="flex h-12 w-12 items-center justify-center rounded-full bg-[#e6effc]">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-[#4e759f]" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.8">
                  <path stroke-linecap="round" stroke-linejoin="round" d="M7 4.75A2.75 2.75 0 0 1 9.75 2h4.5A2.75 2.75 0 0 1 17 4.75V21l-5-3-5 3V4.75Z" />
                  <path stroke-linecap="round" stroke-linejoin="round" d="M9.5 8h5" />
                </svg>
              </span>
              <div class="space-y-2">
                <h3 class="text-lg font-semibold text-[#4e759f]">Tradition, die vertraut</h3>
                <p class="text-sm leading-relaxed">Seit 1823 steht Betten Sauer für Qualität, faire Empfehlungen und langlebige Produkte – vom ersten Beratungsgespräch bis zum Pflegeservice.</p>
              </div>
            </div>
          </article>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Welches Material passt zu Ihnen?</h2>
        <p class="text-base leading-relaxed sm:text-lg">Jede Nacht erzählt eine eigene Geschichte: Manche wünschen sich faszinierten Hotelglanz, andere lieben die naturbelassene Leichtigkeit. Wir führen Bettwäsche aus Baumwolle, Satin, Leinen und Tencel – und finden gemeinsam heraus, was Ihren Schlafkomfort erhöht.</p>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
          <article class="relative overflow-hidden rounded-xl border border-[#dce6f5] bg-white p-6 pb-20 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Baumwolle</h3>
            <p class="mt-3 text-sm leading-relaxed">Fein gekämmte Baumwolle sorgt für ein ausgewogenes Klima und eine natürliche, weiche Oberfläche. Sie ist pflegeleicht und begleitet Sie zuverlässig durch alle Jahreszeiten.</p>
            <img src="images/produktbilder/bettwaesche/baumwollstoff.png" alt="Illustration eines Baumwollstoffs" class="pointer-events-none absolute bottom-4 right-4 h-16 w-16 object-contain opacity-90" loading="lazy" decoding="async" />
          </article>
          <article class="relative overflow-hidden rounded-xl border border-[#dce6f5] bg-white p-6 pb-20 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Satin</h3>
            <p class="mt-3 text-sm leading-relaxed">Glänzend, seidig, luxuriös: Satin verwöhnt die Haut und reflektiert sanft das Licht. Ideal für Liebhaberinnen von Luxus Bettwäsche mit eleganter Anmutung.</p>
            <img src="images/produktbilder/bettwaesche/satin.png" alt="Illustration eines Satinstoffs" class="pointer-events-none absolute bottom-4 right-4 h-16 w-16 object-contain opacity-90" loading="lazy" decoding="async" />
          </article>
          <article class="relative overflow-hidden rounded-xl border border-[#dce6f5] bg-white p-6 pb-20 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Leinen</h3>
            <p class="mt-3 text-sm leading-relaxed">Leinen atmet, kühlt und entwickelt mit jeder Wäsche noch mehr Charakter. Perfekt für Menschen, die natürliche Strukturen und ein sommerliches Gefühl schätzen.</p>
            <img src="images/produktbilder/bettwaesche/leinenstoff.png" alt="Illustration eines Leinenstoffs" class="pointer-events-none absolute bottom-4 right-4 h-16 w-16 object-contain opacity-90" loading="lazy" decoding="async" />
          </article>
          <article class="relative overflow-hidden rounded-xl border border-[#dce6f5] bg-white p-6 pb-20 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Tencel</h3>
            <p class="mt-3 text-sm leading-relaxed">Aus Holzfasern gewonnen, überzeugt Tencel durch seidigen Fall, hohe Feuchtigkeitsaufnahme und Nachhaltigkeit – besonders angenehm für sensible Haut.</p>
            <img src="images/produktbilder/bettwaesche/tencelstoff.png" alt="Illustration eines Tencelstoffs" class="pointer-events-none absolute bottom-4 right-4 h-16 w-16 object-contain opacity-90" loading="lazy" decoding="async" />
          </article>
        </div>
        <div class="rounded-xl border border-dashed border-[#c7d9ef] bg-white/80 p-6 shadow-sm">
          <h3 class="text-base font-semibold uppercase tracking-wide text-[#4e759f]">Saisonale Empfehlungen</h3>
          <p class="mt-3 text-sm leading-relaxed">Für warme Sommernächte empfehlen wir atmungsaktives Leinen oder glatten Perkal aus Baumwolle. Im Winter sorgen kuschelige Satin- und Tencel-Qualitäten für wohliges Wärmegefühl, ohne zu beschweren.</p>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-4xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Für sensible Schläfer – natürliche Materialien für erholsame Nächte</h2>
        <p class="text-base leading-relaxed sm:text-lg">Sensibler Schlaf braucht Materialien, die beruhigen. Wir zeigen Ihnen Bettwäsche, die frei von reizenden Substanzen ist, die Feuchtigkeit reguliert und Haut und Atemwege respektvoll behandelt.</p>
        <p class="text-base leading-relaxed sm:text-lg">OEKO-TEX-zertifizierte Baumwolle, temperaturausgleichendes Leinen und Tencel aus nachhaltigen Quellen bilden die Basis für entspannte Nächte. Ergänzt wird die Auswahl durch hypoallergene Füllungen und passende Spannbettlaken in Premium-Qualität.</p>
        <ul class="space-y-3 text-sm leading-relaxed">
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Atmungsaktiv und feuchtigkeitsregulierend – ideal bei Nachtwärme oder wechselnden Temperaturen.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Sanft zur Haut dank mercerisierter Baumwolle, sanft vorgewaschenem Leinen und zartem Tencel.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Allergikerfreundlich durch zertifizierte Verarbeitung und transparente Herkunft.</li>
        </ul>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Design trifft Schlafkomfort</h2>
        <p class="text-base leading-relaxed sm:text-lg">Stil ist fühlbar. Deshalb inszenieren wir hochwertige Bettwäsche in Farbwelten, die Ruhe ausstrahlen und Ihren individuellen Stil unterstreichen – vom urbanen Loft bis zum sanft lichtdurchfluteten Altbauzimmer.</p>
        <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Klassisch &amp; zeitlos</h3>
            <p class="mt-3 text-sm leading-relaxed">Feine Streifen, Ton-in-Ton-Strukturen und zarte Glanzeffekte verleihen Ihrem Schlafzimmer einen eleganten Hotel-Charakter.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Naturfarben &amp; Ruhe</h3>
            <p class="mt-3 text-sm leading-relaxed">Sand, Muschelweiß und warmes Grau bringen Gelassenheit. Kombiniert mit Leinen entsteht ein entspannter, moderner Landhausstil.</p>
          </article>
          <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
            <h3 class="text-lg font-semibold text-[#4e759f]">Modern &amp; urban</h3>
            <p class="mt-3 text-sm leading-relaxed">Graphische Akzente, tiefe Blautöne und limitierte Editionen setzen Statements – ohne auf wohltuenden Schlafkomfort zu verzichten.</p>
          </article>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-4xl px-6 lg:px-0 space-y-8 text-gray-700">
        <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">So erkennen Sie echte Qualität</h2>
        <p class="text-base leading-relaxed sm:text-lg">Exzellente Bettwäsche bleibt auch nach vielen Wäschen formstabil, farbecht und angenehm auf der Haut. Darauf achten wir für Sie – und darum lohnt sich ein Blick auf die Details.</p>
        <ul class="space-y-3 text-sm leading-relaxed">
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Langstapelige Baumwollfasern oder hochwertige Leinen- und Tencelgarne für glatte, langlebige Oberflächen.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Präzise vernähte Kanten, französische Nähte und verdeckte Reißverschlüsse für einen aufgeräumten Look.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Fadendichte abgestimmt auf den Einsatzzweck: fein und seidig für Satin, luftig und kernig für Leinen.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">OEKO-TEX- oder GOTS-Zertifizierungen als verlässlicher Nachweis für schadstoffgeprüfte Materialien.</li>
          <li class="rounded-lg border border-[#dce6f5] bg-[#f7fbff] px-4 py-3">Pflegehinweise, die zu Ihrem Alltag passen – von unkompliziertem Waschen bis zum professionellen Pflegeservice.</li>
        </ul>
      </div>
    </section>

    <section class="bg-[#0f1e2f] py-16 text-white">
      <div class="mx-auto max-w-4xl px-6 text-center space-y-6">
        <h2 class="text-2xl font-semibold sm:text-3xl">Lassen Sie sich persönlich beraten</h2>
        <p class="text-base leading-relaxed sm:text-lg text-white/85">Reservieren Sie sich Zeit für Ihr Schlafzimmer: In Köln oder Siegburg erwartet Sie eine stilvolle Auswahl, persönliche Beratung und das sichere Gefühl, genau die Bettwäsche zu finden, die Ihren Schlafkomfort erhöht.</p>
        <p class="text-base leading-relaxed sm:text-lg text-white/85">Ob neue Lieblingsfarben, Ergänzungen für Gästezimmer oder maßgeschneiderte Größen – unsere Schlafexpertinnen begleiten Sie mit Ruhe und Achtsamkeit.</p>
        <a href="index.php#kontaktformular" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
          Termin vereinbaren
        </a>
        <div class="text-sm leading-relaxed text-white/80 space-y-1">
          <p>Telefon: <a class="underline hover:text-white" href="tel:+49221843236">0221 843236</a> &bull; WhatsApp: <a class="underline hover:text-white" href="https://wa.me/49221843236" target="_blank" rel="noopener">Nachricht an Betten Sauer senden</a></p>
          <p>Lassen Sie sich von unseren Schlafexpertinnen in Köln oder Siegburg persönlich beraten – und finden Sie Bettwäsche, die zu Ihnen passt.</p>
        </div>
      </div>
    </section>

    <?php require __DIR__ . '/kontakt_sektion.php'; ?>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
