<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Bettsysteme Köln &amp; Siegburg | Betten-Sauer</title>
  <meta name="description" content="Bettsysteme in Köln und Siegburg: Analyse, Vermessung und individuelle Schlafsysteme von Betten-Sauer mit Garantie und persönlichen Empfehlungen." />
  <meta name="keywords" content="Bettsysteme Köln, ergonomische Bettsysteme, Schlafberatung Köln, Betten-Sauer" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="bettsysteme.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="bettsysteme.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Bettsysteme Köln &amp; Siegburg" />
  <meta property="og:description" content="Bettsysteme mit Analyse, modularen Komponenten und individuellem Komfort bei Betten-Sauer in Köln und Siegburg." />
  <meta property="og:image" content="images/header/header_bettsysteme.jpg" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Bettsysteme Köln &amp; Siegburg" />
  <meta name="twitter:description" content="Ergonomische Bettsysteme mit persönlicher Beratung bei Betten-Sauer." />
  <meta name="twitter:image" content="images/header/header_bettsysteme.jpg" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <section class="relative">
      <div class="relative hidden lg:block">
        <div class="relative h-[340px] sm:h-[380px] md:h-[440px] lg:h-[500px]">
          <img
            src="images/header/header_bettsysteme.jpg"
            alt="Harmonischer Blick auf Bettsystem-Inszenierung bei Betten Sauer"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
            decoding="async"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/50"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/45 to-[#0f1e2f]/75"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_bettsysteme.jpg"
          alt="Bettsysteme bei Betten Sauer – mobile Ansicht"
          class="hero-mobile-img"
          loading="eager"
          decoding="async"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-5 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center lg:justify-end">
        <div class="w-full max-w-5xl space-y-5 lg:w-1/2 lg:px-12">
          <h1 class="text-3xl font-semibold text-shadow sm:text-4xl md:text-5xl lg:ml-auto">
            Das richtige Bettsystem beginnt mit dir – nicht mit der Matratze.
          </h1>
          <p class="text-base sm:text-lg md:text-xl text-white/90 lg:ml-auto">
            Erlebe, wie sich gesunder Schlaf anfühlt – individuell angepasst an dich, deinen Körper und deine Schlafgewohnheiten.
          </p>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-5xl px-6 lg:px-0 space-y-10">
        <div class="space-y-6 text-gray-700">
          <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Bettsysteme erklärt in drei Komponenten</h2>
          <p class="text-base leading-relaxed sm:text-lg">
            Wenn Kundinnen und Kunden von einer neuen Matratze sprechen, meinen sie oft das komplette Bettsystem. Bei Bettsystemen Köln betrachten wir Rahmen, Matratze und Kissen als Einheit – abgestimmt auf Ihre Schlafposition, Ihr Gewicht und Ihr Temperaturempfinden.
          </p>
          <div class="grid grid-cols-1 gap-6 sm:grid-cols-3">
            <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-5 shadow-sm">
              <h3 class="text-lg font-semibold text-[#4e759f]">Unterfederung</h3>
              <p class="mt-3 text-sm leading-relaxed">Teller-, Leisten- oder Motorrahmen übernehmen die gezielte Unterstützung für Schulter, Rücken und Becken.</p>
              <img src="images/produktbilder/bettsysteme/unterfederung.jpg" alt="Illustration einer Unterfederung für Bettsysteme" class="mt-5 h-28 w-auto max-w-full object-contain mx-auto" loading="lazy" decoding="async" />
            </article>
            <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-5 shadow-sm">
              <h3 class="text-lg font-semibold text-[#4e759f]">Matratze</h3>
              <p class="mt-3 text-sm leading-relaxed">Latex, Federkern oder Viscoschaum werden nach Ihrer Liegedauer, Ihrem Klimaempfinden und der gewünschten Festigkeit ausgewählt.</p>
              <img src="images/produktbilder/bettsysteme/matratze.jpg" alt="Illustration einer Matratze für individuelle Bettsysteme" class="mt-5 h-28 w-auto max-w-full object-contain mx-auto" loading="lazy" decoding="async" />
            </article>
            <article class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-5 shadow-sm">
              <h3 class="text-lg font-semibold text-[#4e759f]">Kissen &amp; Topper</h3>
              <p class="mt-3 text-sm leading-relaxed">Kissenhöhe, Stützzonen und optionale Topper schließen das System ab und sorgen für entspannte Nacken- und Schultermuskeln.</p>
              <img src="images/produktbilder/bettsysteme/kissen.jpg" alt="Illustration eines Kissens und Toppers als Abschluss des Bettsystems" class="mt-5 h-28 w-auto max-w-full object-contain mx-auto" loading="lazy" decoding="async" />
            </article>
          </div>
        </div>

        <div class="grid grid-cols-1 gap-8 lg:grid-cols-[minmax(0,1.2fr)_minmax(0,1fr)]">
          <div class="space-y-6 text-gray-700">
            <h2 class="text-2xl font-semibold text-[#4e759f]">Wir lösen die häufigsten Schlafprobleme</h2>
            <div class="space-y-4">
              <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
                <h3 class="text-lg font-semibold text-[#4e759f]">Rückenschmerzen am Morgen</h3>
                <p class="mt-2 text-sm leading-relaxed">Wir analysieren Ihre bevorzugte Schlafposition inklusive Schulterabsenkung und Lordose-Stütze. Seitenschläfer, Rückenschläfer und Mischtypen erhalten angepasste Zonen für eine ausgeglichene Wirbelsäule.</p>
              </article>
              <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
                <h3 class="text-lg font-semibold text-[#4e759f]">Viele Versuche – kein Erfolg</h3>
                <p class="mt-2 text-sm leading-relaxed">Statt Standardware messen wir mit dem dormabell Mess-System Ihre Körperdaten digital. Schulterabsenkungen, Beckenstützen und Lattenhärte lassen sich millimetergenau anpassen.</p>
              </article>
              <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
                <h3 class="text-lg font-semibold text-[#4e759f]">Unklare Unterschiede der Systeme</h3>
                <p class="mt-2 text-sm leading-relaxed">Wir vergleichen Ihnen vor Ort Holz-Lattenroste, Tellerfedern, Boxspring- und Motorrahmen. Icons, Sensorik und Probeschlafen machen die Unterschiede unmittelbar spürbar.</p>
              </article>
              <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
                <h3 class="text-lg font-semibold text-[#4e759f]">Beratung statt Verkauf</h3>
                <p class="mt-2 text-sm leading-relaxed">Unsere zertifizierten Schlafberaterinnen und Schlafberater arbeiten ohne Verkaufsprovision. Sie erhalten eine Empfehlung, die zu Ihrem Körper passt – nicht zu einem Lagerbestand.</p>
              </article>
               <article class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
                <h3 class="text-lg font-semibold text-[#4e759f]">Zufriedene Kunden – seit über 200 Jahren unser Erfolgsrezept</h3>
                <p class="mt-2 text-sm leading-relaxed">Seit mehr als zwei Jahrhunderten steht Betten Sauer für Qualität, Vertrauen und individuelle Schlaflösungen. Unser Anspruch: Ihr gesunder Schlaf ist kein Zufall, sondern das Ergebnis fundierter Beratung, moderner Bettsysteme und jahrzehntelanger Erfahrung.</p>
              </article>
            </div>
          </div>
          <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/bettsystem_vertikal.jpg" alt="Skizze eines Bettsystems mit markierten Zonen für Rücken und Schultern" class="h-full w-full object-cover" loading="lazy" decoding="async" />
          </figure>
        </div>
      </div>
    </section>

    <section class="bg-[#f6f9fd] py-16">
      <div class="mx-auto max-w-6xl px-6 lg:px-8 space-y-12">
        <div class="space-y-6 text-gray-700">
          <h2 class="text-2xl font-semibold text-[#4e759f]">Welches Bettsystem passt zu welchem Schlaftyp?</h2>
          <p class="text-base leading-relaxed sm:text-lg">Die Übersicht hilft Ihnen, Bettsysteme einzuordnen. Im Beratungsgespräch testen wir die Varianten anschließend live.</p>
          <div class="overflow-hidden rounded-xl border border-[#dce6f5] bg-white shadow-sm">
            <div class="grid grid-cols-1 divide-y divide-[#dce6f5] text-sm sm:text-base">
              <div class="grid grid-cols-1 gap-4 bg-[#f7fbff] px-6 py-4 font-semibold text-[#4e759f] sm:grid-cols-4">
                <span class="sm:col-span-1">System</span>
                <span>Empfohlen für</span>
                <span>Vorteil</span>
                <span>Fazit</span>
              </div>
              <div class="grid grid-cols-1 gap-4 px-6 py-5 sm:grid-cols-4">
                <span class="font-semibold text-[#4e759f]">Tellerrahmen + Latex</span>
                <span>Seitenschläfer mit sensibler Schulterpartie</span>
                <span>Feinfühlige Anpassung, hohe Punktelastizität</span>
                <span>Optimal bei häufigen Lagewechseln</span>
              </div>
              <div class="grid grid-cols-1 gap-4 px-6 py-5 sm:grid-cols-4">
                <span class="font-semibold text-[#4e759f]">Motorrahmen + Kaltschaum</span>
                <span>Mischtypen, Leserinnen und Leser im Bett</span>
                <span>Elektrische Positionen, stabile Unterstützung</span>
                <span>Entlastet Rücken und Beine beim Aufstehen</span>
              </div>
              <div class="grid grid-cols-1 gap-4 px-6 py-5 sm:grid-cols-4">
                <span class="font-semibold text-[#4e759f]">Boxspring-System</span>
                <span>Rückenschläfer mit Wunsch nach softem Liegegefühl</span>
                <span>Federkern in mehreren Ebenen, gute Belüftung</span>
                <span>Für warme Schlafräume geeignet</span>
              </div>
              <div class="grid grid-cols-1 gap-4 px-6 py-5 sm:grid-cols-4">
                <span class="font-semibold text-[#4e759f]">Lattenrost + Viskoauflage</span>
                <span>Druckempfindliche Personen, Ruheschläfer</span>
                <span>Sanftes Einsinken, entlastet Gelenke</span>
                <span>Benötigt gute Raumlüftung</span>
              </div>
            </div>
          </div>
        </div>

        <div class="grid grid-cols-1 gap-8 lg:grid-cols-[minmax(0,1fr)_minmax(0,1.1fr)]">
          <div class="space-y-6 text-gray-700">
            <h2 class="text-2xl font-semibold text-[#4e759f]">Wann lohnt sich der Wechsel?</h2>
            <p class="text-base leading-relaxed sm:text-lg">Ein neues Bettsystem zahlt sich aus, wenn Ihr Körper nachts keine echte Erholung findet. Die Checkliste hilft bei der Selbsteinschätzung:</p>
            <ul class="space-y-3 rounded-xl border border-[#dce6f5] bg-white p-6 text-sm leading-relaxed shadow-sm">
              <li>Sie wachen mindestens dreimal pro Woche mit Verspannungen im Nacken oder unteren Rücken auf.</li>
              <li>Sie spüren Druckstellen an Schultern oder Hüfte, obwohl Sie mehrfach die Matratze gewendet haben.</li>
              <li>Sie wechseln nachts häufig die Lage, weil es zu warm oder zu kalt wird.</li>
              <li>Ihre Matratze ist älter als acht Jahre oder Sie schlafen auf unterschiedlichen Höhen im Doppelbett.</li>
              <li>Sie schlafen auswärts deutlich besser als im eigenen Bett.</li>
            </ul>
            <p class="text-base leading-relaxed sm:text-lg">Wenn zwei oder mehr Punkte zutreffen, lohnt sich eine Analyse durch unsere Schlafberaterinnen und Schlafberater in Köln oder Siegburg.</p>
          </div>
          <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/vermessen02.jpg" alt="Kundin wird am dormabell Mess-System vermessen (WebP, komprimiert)" class="h-full w-full object-cover" loading="lazy" decoding="async" />
          </figure>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-6xl px-6 lg:px-8 space-y-12">
        <div class="grid grid-cols-1 gap-8 lg:grid-cols-[minmax(0,1fr)_minmax(0,1.1fr)] lg:items-center">
          <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
            <img src="images/produktbilder/bettsysteme/zusammenbau.jpg" alt="Offenes Boxspring-Bettsystem mit sichtbaren Schichten (JPG, komprimiert)" class="h-full w-full object-cover" loading="lazy" decoding="async" />
          </figure>
          <div class="space-y-6 text-gray-700">
            <h2 class="text-2xl font-semibold text-[#4e759f]">Wie Rahmen, Matratze und Kissen zusammenspielen</h2>
            <p class="text-base leading-relaxed sm:text-lg">Unser Team zeigt Ihnen an einem offenen Bettsystem-Modell, wie die Federwege unterhalb der Matratze arbeiten, wie Kissen die Halswirbelsäule stabilisieren und welche Topper das Klima regulieren. So verstehen Sie sofort, welche Stellschrauben Ihren Schlaf beeinflussen.</p>
            <div class="rounded-xl border border-[#dce6f5] bg-[#f7fbff] p-6 shadow-sm">
              <h3 class="text-lg font-semibold text-[#4e759f]">Geführte Entscheidungshilfe</h3>
              <p class="mt-3 text-sm leading-relaxed">Im Geschäft führen wir Sie durch drei Stationen: Analyse, Testliegen und Fine-Tuning. Auf Wunsch starten wir mit einem kurzen Fragebogen, damit Sie genau wissen, welches System Sie zuerst ausprobieren.</p>
            </div>
          </div>
        </div>

        <div class="space-y-6 text-gray-700">
          <h2 class="text-2xl font-semibold text-[#4e759f]">Erfahrungen aus Köln und Siegburg</h2>
          <div class="grid grid-cols-1 gap-6 sm:grid-cols-3">
            <figure class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
              <blockquote class="text-sm leading-relaxed italic text-gray-700">„Seit dem Wechsel auf das Röwa-System schlafe ich wieder durch. Die Schulterabsenkung macht den Unterschied.“</blockquote>
              <figcaption class="mt-3 text-xs font-semibold uppercase tracking-wide text-[#4e759f]">Martina K., Seitenschläferin</figcaption>
            </figure>
            <figure class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
              <blockquote class="text-sm leading-relaxed italic text-gray-700">„Ich habe viele Matratzen getestet. Erst die Messung bei Betten-Sauer hat gezeigt, wo mein Rücken Unterstützung braucht.“</blockquote>
              <figcaption class="mt-3 text-xs font-semibold uppercase tracking-wide text-[#4e759f]">Andreas L., Rückenschläfer</figcaption>
            </figure>
            <figure class="rounded-xl border border-[#dce6f5] bg-white p-6 shadow-sm">
              <blockquote class="text-sm leading-relaxed italic text-gray-700">„Die Schlafberater haben jede Einstellung erklärt. Jetzt wache ich ohne Taubheitsgefühle in den Armen auf.“</blockquote>
              <figcaption class="mt-3 text-xs font-semibold uppercase tracking-wide text-[#4e759f]">Sandra B., Mischschläferin</figcaption>
            </figure>
          </div>
          <p class="text-sm leading-relaxed text-gray-600">Betten-Sauer steht seit 1823 für handwerkliche Qualität und zertifizierte Schlafberater. Wir kombinieren Tradition mit modernen Messverfahren.</p>
        </div>
      </div>
    </section>

    <section class="bg-[#0f1e2f] py-16 text-white">
      <div class="mx-auto max-w-4xl px-6 text-center space-y-6">
        <h2 class="text-2xl font-semibold sm:text-3xl">Jetzt kostenlose Liegeanalyse buchen</h2>
        <p class="text-base leading-relaxed sm:text-lg text-white/85">Sichern Sie sich einen Termin zur Schlafberatung und testen Sie Bettsysteme unter Anleitung unserer zertifizierten Expertinnen und Experten.</p>
        <a href="index.php#kontaktformular" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
          Termin zur Schlafberatung sichern
        </a>
        <div class="text-sm leading-relaxed text-white/80">
          <p>Telefon: <a class="underline hover:text-white" href="tel:+49221843236">0221 843236</a> &bull; WhatsApp: <a class="underline hover:text-white" href="https://wa.me/49221843236" target="_blank" rel="noopener">Nachricht an Betten-Sauer senden</a></p>
        </div>
      </div>
    </section>

    <?php require __DIR__ . '/kontakt_sektion.php'; ?>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
