<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Bettgestelle Köln &amp; Siegburg | Design-Betten Sauer</title>
  <meta name="description" content="Bettgestelle aus Massivholz, Stoff oder Metall mit individueller Beratung bei Betten Sauer. Design-Betten, ergonomische Planung &amp; Schlafzimmereinrichtung in Köln und Siegburg." />
  <meta name="keywords" content="Bettgestelle, Design-Bett, Massivholzbett, Stoffbett, Betten Köln, Betten Siegburg, Schlafzimmereinrichtung" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="bettgestelle.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="bettgestelle.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Bettgestelle Köln &amp; Siegburg | Design-Betten Sauer" />
  <meta property="og:description" content="Design-Bettgestelle aus Massivholz, Stoff oder Metall – erleben Sie individuelle Beratung und Schlafzimmereinrichtung in Köln und Siegburg." />
  <meta property="og:image" content="images/produktbilder/header_bettgestell.jpg" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Bettgestelle Köln &amp; Siegburg | Design-Betten Sauer" />
  <meta name="twitter:description" content="Individuelle Bettgestelle aus Massivholz, Stoff oder Metall – Beratung für Ihr Design-Bett in Köln und Siegburg." />
  <meta name="twitter:image" content="images/produktbilder/header_bettgestell.jpg" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <section class="relative">
      <div class="relative hidden lg:block">
        <div class="relative h-[340px] sm:h-[380px] md:h-[440px] lg:h-[500px]">
          <img
            src="images/header/header_bettgestelle.jpg"
            alt="Abgedunkeltes Schlafzimmer mit modernen Bettgestellen bei Betten-Sauer"
            class="absolute inset-0 h-full w-full object-cover"
            loading="eager"
          />
          <div class="absolute inset-0 bg-[#0f1e2f]/55"></div>
          <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/40 to-[#0f1e2f]/70"></div>
        </div>
      </div>
      <figure class="lg:hidden">
        <img
          src="images/header/mobil_header_bettgestelle.jpg"
          alt="Modernes Bettgestell in der mobilen Ansicht von Betten Sauer"
          class="hero-mobile-img"
          loading="eager"
        />
      </figure>
      <div class="bg-[#647080] px-6 py-10 text-center text-white space-y-5 lg:absolute lg:inset-0 lg:z-10 lg:bg-transparent lg:text-left lg:flex lg:items-center lg:justify-end">
        <div class="w-full max-w-5xl space-y-5 lg:w-1/2 lg:px-12">
          <h1 class="text-3xl font-semibold text-shadow sm:text-4xl md:text-5xl lg:ml-auto">
            Bettgestelle Köln &amp; Siegburg – Rahmen mit Persönlichkeit
          </h1>
          <p class="text-base sm:text-lg md:text-xl text-white/90 lg:ml-auto">
            Wir planen Design-Betten, die zu Ihrem Schlafgefühl, Ihrem Körperbau und Ihrem Wohnstil passen. Massivholz, Stoff oder Metall: Sie entscheiden, wie sich Ihr Rückzugsort anfühlen soll.
          </p>
          <p class="text-sm sm:text-base text-white/80 lg:ml-auto">
            Erleben Sie maßgeschneiderte Bettgestelle, abgestimmt auf bestehende Matratzen, Lattenroste und gewünschte Einstiegshöhen – mit Beratung in Köln und Siegburg.
          </p>
        </div>
      </div>
    </section>

    <section class="bg-white py-16">
      <div class="mx-auto max-w-6xl px-6 lg:px-0">
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-[minmax(0,1.1fr)_minmax(0,0.9fr)] lg:items-center">
          <div class="space-y-6 text-gray-700">
            <h2 class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">Bettgestelle für individuelle Schlafräume</h2>
            <p class="text-base leading-relaxed sm:text-lg">
              Ein Bettgestell ist der Rahmen für Ihren persönlichen Rückzugsort. In Köln und Siegburg kuratieren wir Bettgestelle, die Stabilität, Design und ruhigen Schlaf vereinen – vom puristischen Design-Bett bis zum charaktervollen Massivholzbett.
            </p>
            <p class="text-base leading-relaxed sm:text-lg">
              Gemeinsam prüfen wir Körpergröße, gewünschte Einstiegshöhe sowie vorhandene Matratzen und Lattenroste. Als Ihr Ansprechpartner für Betten Köln und Betten Siegburg entsteht so eine Schlafzimmereinrichtung, die Ihren Stil unterstreicht und gleichzeitig ergonomisch zu Ihnen passt.
            </p>
            <ul class="list-disc list-inside space-y-3 text-base leading-relaxed sm:text-lg">
              <li>Materialkombinationen aus Massivholz, Metall, Stoff oder Leder – abgestimmt auf Haptik, Optik und Raumwirkung.</li>
              <li>Individuelle Anpassungen von Einstiegshöhe, Kopfteilen und Seitenteilen für komfortables Aufstehen und entspanntes Liegen.</li>
              <li>Handwerkliche Verarbeitung, nachhaltige Oberflächen und Pflegekonzepte für langlebige Bettgestelle.</li>
            </ul>
          </div>
          <figure class="overflow-hidden rounded-xl shadow-lg opacity-0 translate-y-6 transition-all duration-[1200ms] ease-out" data-fade-on-scroll>
            <img
              src="images/produktbilder/bett-merano-rueckseite-kt1.jpg"
              alt="Design-Bettgestell Merano mit gepolsterter Rückseite im Schlafzimmer"
              class="h-full w-full object-cover"
              loading="lazy"
              decoding="async"
            />
          </figure>
        </div>
      </div>
    </section>

    <section class="bg-[#f7fbff] py-16">
      <div class="mx-auto flex max-w-6xl flex-col gap-14 px-4 sm:px-6 lg:px-8">
        <div>
          <h2 class="text-2xl font-semibold text-[#4e759f]">Massivholzbett &amp; Design-Bettgestell in Köln</h2>
          <p class="mt-4 text-base leading-relaxed text-gray-700">
            Massivholz-Bettgestelle schaffen natürliche Wärme und bringen die Handschrift unserer Tischlereien zum Vorschein. Wir kombinieren regionale Hölzer, präzise Fugen und passende Beimöbel zu einem Design-Bett, das Beständigkeit und Leichtigkeit ausstrahlt.
          </p>
          <p class="text-base leading-relaxed text-gray-700">
            Ob geölt, seidenmatt lackiert oder mit Metallakzenten – jedes Massivholzbett wird in Köln oder Siegburg so abgestimmt, dass es Ihren Raum strukturiert und zugleich Ruhe ausstrahlt.
          </p>
          <div class="mt-8 grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3">
            <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
              <img src="images/produktbilder/holzbetten/holzbetten_koeln_betten_sauer.jpg" alt="Massivholzbett mit sanften Rundungen und passendem Nachttisch in Köln" class="h-56 w-full object-cover transition duration-300 hover:brightness-75" loading="lazy" decoding="async" />
            </figure>
            <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
              <img src="images/produktbilder/holzbetten/holzbetten_koeln_betten_sauer2.jpg" alt="Schwebendes Massivholzbett mit eleganter Lehne bei Betten Sauer" class="h-56 w-full object-cover transition duration-300 hover:brightness-75" loading="lazy" decoding="async" />
            </figure>
            <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
              <img src="images/produktbilder/holzbetten/holzbetten_koeln_betten_sauer3.jpg" alt="Design-Holzbett in Nussbaumoptik mit strukturierter Wand" class="h-56 w-full object-cover transition duration-300 hover:brightness-75" loading="lazy" decoding="async" />
            </figure>
            <figure class="overflow-hidden rounded-xl bg-white shadow-lg sm:col-span-2 lg:col-span-3">
              <img src="images/produktbilder/holzbetten/holzbetten_koeln_betten_sauer5.jpg" alt="Breites Holzbett mit Sideboard und ruhiger Farbwelt im Schlafzimmer" class="h-72 w-full object-cover transition duration-300 hover:brightness-75" loading="lazy" decoding="async" />
            </figure>
          </div>
        </div>

        <div>
          <h2 class="text-2xl font-semibold text-[#4e759f]">Stoffbett &amp; Polster-Bettgestelle aus Köln</h2>
          <p class="mt-4 text-base leading-relaxed text-gray-700">
            Stoff- und Lederbezüge schenken sanfte Haptik und akustische Ruhe. Wir zeigen Ihnen Polster-Bettgestelle, die sich farblich in Ihre Schlafzimmereinrichtung einfügen und zugleich als markantes Design-Statement wirken.
          </p>
          <p class="text-base leading-relaxed text-gray-700">
            Von der filigranen Naht über gepolsterte Kopfteile bis zur integrierten Beleuchtung planen wir Ihr Stoffbett so, dass Komfort, Pflegeleichtigkeit und Langlebigkeit selbstverständlich sind.
          </p>
          <div class="mt-8 grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3">
            <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
              <img src="images/produktbilder/polsterbetten/polsterbetten.jpeg" alt="Helles Polsterbett mit filigranen Nachttischen in Köln" class="h-56 w-full object-cover transition duration-300 hover:brightness-75" loading="lazy" decoding="async" />
            </figure>
            <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
              <img src="images/produktbilder/polsterbetten/polsterbetten_koeln.jpeg" alt="Modernes Polsterbett mit strukturierter Wand und Lichtstimmung" class="h-56 w-full object-cover transition duration-300 hover:brightness-75" loading="lazy" decoding="async" />
            </figure>
            <figure class="overflow-hidden rounded-xl bg-white shadow-lg">
              <img src="images/produktbilder/polsterbetten/polsterbetten_koeln_betten_sauer.jpeg" alt="Polsterbett mit hohem Kopfteil und Tageslicht bei Betten Sauer" class="h-56 w-full object-cover transition duration-300 hover:brightness-75" loading="lazy" decoding="async" />
            </figure>
            <figure class="overflow-hidden rounded-xl bg-white shadow-lg sm:col-span-2 lg:col-span-3">
              <img src="images/produktbilder/polsterbetten/polsterbetten_koeln-1.jpg" alt="Polsterbett mit weichem Kopfteil und harmonischer Farbwelt" class="h-72 w-full object-cover transition duration-300 hover:brightness-75" loading="lazy" decoding="async" />
            </figure>
          </div>
        </div>
      </div>
    </section>

    <section class="bg-white py-12">
      <div class="mx-auto flex max-w-4xl flex-col items-center gap-4 px-6 text-center">
        <p class="text-base leading-relaxed text-gray-800 sm:text-lg">Erleben Sie Ihr neues Bettgestell live in Köln oder Siegburg. Unsere Schlafberaterinnen und Schlafberater zeigen Ihnen Materialien, Funktionen und Kombinationen, die zu Ihrem Zuhause und Ihrem Schlafgefühl passen.</p>
        <a href="index.php#kontaktformular" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-6 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
          Jetzt Beratungstermin vereinbaren
        </a>
      </div>
    </section>

    <?php require __DIR__ . '/kontakt_sektion.php'; ?>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const fadeEls = document.querySelectorAll('[data-fade-on-scroll]');
    const observer = new IntersectionObserver(entries => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.classList.remove('opacity-0', 'translate-y-6');
          entry.target.classList.add('opacity-100', 'translate-y-0');
          observer.unobserve(entry.target);
        }
      });
    }, { threshold: 0.2 });

    fadeEls.forEach(el => observer.observe(el));

    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
<!--
Meta Title: Bettgestelle Köln & Siegburg | Design-Betten Sauer
Meta Description: Bettgestelle aus Massivholz, Stoff oder Metall bei Betten Sauer. Design-Betten, ergonomische Planung & Schlafzimmereinrichtung in Köln und Siegburg.
-->
