<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Aktuelles &amp; Presse | Betten-Sauer KG</title>
  <meta name="description" content="Aktuelle Interviews, Videos und Veröffentlichungen der Betten-Sauer KG. Bleiben Sie informiert mit Presseberichten, PDF-Downloads und TV-Beiträgen." />
  <meta name="keywords" content="Betten-Sauer Aktuelles, Presse Betten-Sauer, Videos Betten Sauer, Veröffentlichungen Betten Sauer" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="aktuelles.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="aktuelles.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Aktuelles &amp; Presse | Betten-Sauer KG" />
  <meta property="og:description" content="Interviews, Videos und Fachbeiträge rund um Betten-Sauer. Entdecken Sie aktuelle Veröffentlichungen und Medienberichte." />
  <meta property="og:image" content="images/1200x800_markenwelt.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Aktuelles &amp; Presse | Betten-Sauer KG" />
  <meta name="twitter:description" content="Bleiben Sie informiert – aktuelle Presseberichte, Videos und PDF-Downloads der Betten-Sauer KG." />
  <meta name="twitter:image" content="images/1200x800_markenwelt.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = false;
    require __DIR__ . '/includes/header.php';
  ?>

  <main class="aktuelles py-24 px-6">
    <div class="mx-auto max-w-6xl space-y-16">
      <section class="text-center space-y-6">
        <h1 class="text-3xl font-semibold text-[#0f1e2f]">Aktuelles</h1>
        <p class="text-base leading-relaxed text-gray-600">
          Aktuelle Interviews und Veröffentlichungen der <strong>Betten-Sauer KG</strong><br>
          Bleiben Sie stets auf dem Laufenden – hier finden Sie nützliche Informationen, Presseberichte, Videos und PDF-Downloads.
        </p>
      </section>

      <section id="videos" class="space-y-6">
        <div>
          <h2 class="text-2xl font-semibold text-[#4e759f] border-b border-gray-200 pb-2 flex items-center gap-2">
            <span aria-hidden="true">🎬</span>
            <span>Videos &amp; TV-Beiträge</span>
          </h2>
          <p class="mt-4 text-base leading-relaxed text-gray-600">
            Erleben Sie Betten-Sauer in bewegten Bildern – von Expertengesprächen bis hin zu TV-Auftritten und Reportagen.
          </p>
        </div>
        <?php
          $videos = [
            ['id' => 'lQV_w7sg6z8', 'title' => 'Qualität & Expertise für erholsamen Schlaf'],
            ['id' => 'k6QCy-_QtXA', 'title' => 'Das älteste Bettenfachgeschäft Deutschlands'],
            ['id' => 'Puqy7qAOXrQ', 'title' => 'So führt Michael Gouram den Traditionsbetrieb Betten-Sauer in die Zukunft'],
            ['id' => 'tK6saC9vq0g', 'title' => 'Bettenfachhänder des Jahres 2020'],
            ['id' => '2047zsEPLpw', 'title' => 'Betten-Sauer (Expertengespräch zwischen Herrn Michael Gouram & Herrn Dr. Kelter)'],
            ['id' => 'MjG6o36aLcA', 'title' => 'Topper und Matratzenschoner im Test'],
            ['id' => 'E8r0HazzUSM', 'title' => 'Hausjournal 2017 Vorstellung'],
            ['id' => 'zwIZcaxd76A', 'title' => 'Gesunder Schlaf Interview'],
            ['id' => 'ksQa_rWQFP4', 'title' => 'Bettenspezialist im Gespräch'],
            ['id' => 'vHafXoXfOxE', 'title' => 'Schlafexperten Interview'],
            ['id' => 'abA40LEGVfE', 'title' => 'Beratung für Boxspringbetten'],
            ['id' => 'X4RPu71KVBY', 'title' => 'Betten-Sauer bei RTL West'],
          ];

          $initialVideoCount = 4;
        ?>
        <div class="space-y-8">
          <div id="videosGrid" class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
            <?php foreach ($videos as $index => $video): ?>
              <?php
                $videoClasses = 'video-placeholder group relative aspect-video w-full overflow-hidden rounded-lg bg-gray-900 shadow transition focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-[#6793c4] focus-visible:ring-offset-2 focus-visible:ring-offset-white';
                if ($index >= $initialVideoCount) {
                  $videoClasses .= ' hidden';
                }
              ?>
              <button
                type="button"
                class="<?= $videoClasses ?>"
                data-video-id="<?= htmlspecialchars($video['id'], ENT_QUOTES) ?>"
                data-video-title="<?= htmlspecialchars($video['title'], ENT_QUOTES) ?>"
                aria-label="Video abspielen: <?= htmlspecialchars($video['title'], ENT_QUOTES) ?>"
              >
                <img
                  src="https://img.youtube.com/vi/<?= htmlspecialchars($video['id'], ENT_QUOTES) ?>/hqdefault.jpg"
                  alt="<?= htmlspecialchars('Vorschaubild: ' . $video['title'], ENT_QUOTES) ?>"
                  class="h-full w-full object-cover transition duration-300 group-hover:scale-105"
                  loading="lazy"
                  decoding="async"
                />
                <div class="absolute inset-0 bg-black/45 transition group-hover:bg-black/25"></div>
                <div class="absolute inset-0 flex flex-col items-center justify-center gap-3 text-white">
                  <span class="inline-flex h-14 w-14 items-center justify-center rounded-full bg-white/90 text-[#0f1e2f] shadow-lg transition group-hover:bg-white">
                    <svg class="h-6 w-6" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                      <path d="M8 5v14l11-7z" />
                    </svg>
                  </span>
                  <span class="px-4 text-center text-sm font-semibold leading-snug drop-shadow">
                    <?= htmlspecialchars($video['title'], ENT_QUOTES) ?>
                  </span>
                </div>
              </button>
            <?php endforeach; ?>
          </div>

          <?php if (count($videos) > $initialVideoCount): ?>
            <div class="text-center">
              <button
                id="showMoreVideos"
                type="button"
                class="inline-flex items-center justify-center rounded-lg border border-[#4e759f] px-6 py-3 text-sm font-semibold uppercase tracking-wide text-[#4e759f] transition hover:bg-[#4e759f] hover:text-white focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-[#4e759f] focus-visible:ring-offset-2 focus-visible:ring-offset-white"
              >
                Weitere Videos anzeigen
              </button>
            </div>
          <?php endif; ?>

          <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
            <a href="https://www.ardmediathek.de/video/ard-buffet/gesunder-schlaf-trotz-allergie/das-erste/Y3JpZDovL3N3ci5kZS9hZXgvbzIwNjkzNjc" target="_blank" rel="noopener noreferrer" class="block rounded-lg bg-gray-100 p-4 shadow transition hover:bg-gray-200">
              <strong>Gesunder Schlaf trotz Allergie (ARD Buffet)</strong><br>
              <span class="text-sm text-gray-600">ARD Mediathek</span>
            </a>

            <a href="https://www.ardmediathek.de/video/ard-buffet/die-richtige-sommer-bettdecke/das-erste/Y3JpZDovL3N3ci5kZS9hZXgvbzIwNDkxMzQ" target="_blank" rel="noopener noreferrer" class="block rounded-lg bg-gray-100 p-4 shadow transition hover:bg-gray-200">
              <strong>Die richtige Sommer-Bettdecke (ARD Buffet)</strong><br>
              <span class="text-sm text-gray-600">ARD Mediathek</span>
            </a>

            <a href="https://www.rtl.de/cms/in-koeln-aeltestes-bettenhaus-wird-200-jahre-5036822.html" target="_blank" rel="noopener noreferrer" class="block rounded-lg bg-gray-100 p-4 shadow transition hover:bg-gray-200">
              <strong>RTL: In Köln – ältestes Bettenhaus wird 200 Jahre</strong><br>
              <span class="text-sm text-gray-600">RTL News</span>
            </a>

            <a href="https://www.ardmediathek.de/video/ard-buffet/so-finden-sie-das-perfekte-bett/das-erste/Y3JpZDovL3N3ci5kZS9hZXgvbzIwMTQzMDU" target="_blank" rel="noopener noreferrer" class="block rounded-lg bg-gray-100 p-4 shadow transition hover:bg-gray-200">
              <strong>So finden Sie das perfekte Bett</strong><br>
              <span class="text-sm text-gray-600">ARD Buffet</span>
            </a>
          </div>
        </div>
      </section>

      <section id="pdfs" class="space-y-6">
        <div>
          <h2 class="text-2xl font-semibold text-[#4e759f] border-b border-gray-200 pb-2 flex items-center gap-2">
            <span aria-hidden="true">📄</span>
            <span>Downloads &amp; Veröffentlichungen</span>
          </h2>
          <p class="mt-4 text-base leading-relaxed text-gray-600">
            Lesen Sie interessante Fachbeiträge, Presseberichte und Hausjournale rund um das Thema Schlaf und Betten-Sauer.
          </p>
        </div>
        <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
          <?php
            $pdfs = [
              ['Frühlingsfrische für Ihr Bett', 'pdf/fruehlingsfrische.pdf'],
              ['Boxspringbetten – Mehr als nur Schlafen', 'pdf/Boxspringbetten.pdf'],
              ['Kölner Stadt-Anzeiger 2025 – Endlich erholsam schlafen', 'pdf/Koelner-Stadtanzeiger.pdf'],
              ['Hausjournal 2017 (Imagebroschüre 2016)', 'pdf/Betten-Sauer_Imagebroschuere-2016_v1.pdf'],
              ['Bergische Daune – PDF 1', 'pdf/Bergische-Daune-1.pdf'],
              ['Bergische Daune – PDF 2', 'pdf/Bergische-Daune.pdf'],
              ['Newsletter – Mehr Informationen', 'pdf/Newsletter.pdf'],
              ['Bettenfachhändler des Jahres – Flyer 2015', 'pdf/BettenSauer_Flyer2015.pdf'],
              ['Hausjournal 2013', 'pdf/Betten-Sauer-2013-Hausjournal.pdf'],
              ['Lattoflex – Informationsflyer', 'pdf/lattoflex-1.pdf'],
            ];

            foreach ($pdfs as $pdf) {
              echo '
              <a href="' . $pdf[1] . '" target="_blank" rel="noopener noreferrer" class="block rounded-lg border bg-white p-5 transition hover:shadow-lg">
                <div class="flex items-center gap-3">
                  <img src="/assets/icons/pdf-icon.svg" alt="PDF Download" class="h-8 w-8" loading="lazy" />
                  <span class="font-medium text-[#3a3a3a]">' . $pdf[0] . '</span>
                </div>
                <p class="mt-2 text-sm text-gray-500">Jetzt öffnen oder herunterladen</p>
              </a>
              ';
            }
          ?>
        </div>
      </section>
    </div>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 80 || !isHeroHeader) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();

    const videoPlaceholders = document.querySelectorAll('.video-placeholder');

    const createVideoEmbed = (videoId, title) => {
      const wrapper = document.createElement('div');
      wrapper.className = 'aspect-video w-full overflow-hidden rounded-lg shadow';

      const iframe = document.createElement('iframe');
      iframe.src = `https://www.youtube-nocookie.com/embed/${videoId}?autoplay=1`;
      iframe.title = title;
      iframe.loading = 'lazy';
      iframe.allowFullscreen = true;
      iframe.className = 'h-full w-full';
      iframe.setAttribute('allow', 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share');

      wrapper.appendChild(iframe);
      return wrapper;
    };

    videoPlaceholders.forEach(placeholder => {
      placeholder.addEventListener('click', () => {
        if (placeholder.dataset.videoLoaded === 'true') return;
        placeholder.dataset.videoLoaded = 'true';
        const embed = createVideoEmbed(placeholder.dataset.videoId, placeholder.dataset.videoTitle);
        placeholder.replaceWith(embed);
      });
    });

    const showMoreBtn = document.getElementById('showMoreVideos');
    if (showMoreBtn) {
      showMoreBtn.addEventListener('click', () => {
        document.querySelectorAll('.video-placeholder.hidden').forEach(video => video.classList.remove('hidden'));
        showMoreBtn.classList.add('hidden');
      });
    }
  </script>
</body>
</html>
