<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Allgemeine Geschäftsbedingungen – Betten-Sauer Köln</title>
  <meta name="description" content="Allgemeine Geschäftsbedingungen der Betten-Sauer KG für Bestellungen im Online-Shop. Informationen zu Vertragsschluss, Lieferung, Bezahlung und Gewährleistung.">
  <meta name="author" content="Betten-Sauer KG">
  <meta name="theme-color" content="#6793c4">

  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-6.png" type="image/gif">
  <link rel="icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-7.png" type="image/png">
  <link rel="apple-touch-icon" href="https://www.betten-sauer.de/wp-content/uploads/favicon-8.png">

  <link rel="stylesheet" href="css/style.css">

  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    .menu-btn {
      width: 3rem;
      height: 3rem;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(103,147,196,0.92);
      color: #fff;
      border-radius: 9999px;
      font-size: 1.7rem;
      box-shadow: 0 6px 16px rgba(15,30,47,0.25);
      transition: background 0.25s ease, transform 0.15s ease, box-shadow 0.25s ease;
    }
    .menu-btn:hover { background: #4e759f; transform: translateY(-1px); }
    .menu-btn:active { transform: translateY(1px); }
    header.scrolled .menu-btn {
      background: #0f1e2f;
      box-shadow: 0 4px 12px rgba(15,30,47,0.2);
    }
  </style>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-[#0f1e2f]/90 transition duration-300';
    require __DIR__ . '/includes/header.php';
  ?>

  <main class="pt-28 pb-20 bg-gray-50">
    <section class="max-w-5xl mx-auto px-6 space-y-10">
      <div class="rounded-3xl bg-gradient-to-br from-[#0f1e2f] via-[#1b2f4b] to-[#274773] text-white text-center py-16 px-6 md:px-10 shadow-xl">
        <h1 class="text-3xl md:text-4xl font-semibold">Allgemeine Geschäftsbedingungen</h1>
        <p class="mt-4 text-base md:text-lg text-white/85 max-w-2xl mx-auto">
          Unsere AGB regeln transparent die Bedingungen rund um Bestellung, Lieferung, Gewährleistung und Service der Betten-Sauer KG.
        </p>
      </div>

      <div class="bg-white shadow-lg rounded-2xl border border-gray-200 p-8 space-y-8 leading-relaxed">
        <section>
          <h2 class="text-2xl font-semibold mb-4">1. Geltungsbereich</h2>
          <p>
            Für alle Bestellungen über unseren Online-Shop durch Verbraucher und Unternehmer gelten die nachfolgenden AGB.
          </p>
          <p class="mt-4">
            Verbraucher ist jede natürliche Person, die ein Rechtsgeschäft zu Zwecken abschließt, die überwiegend weder ihrer
            gewerblichen noch ihrer selbständigen beruflichen Tätigkeit zugerechnet werden können. Unternehmer ist eine natürliche
            oder juristische Person oder eine rechtsfähige Personengesellschaft, die bei Abschluss eines Rechtsgeschäfts in Ausübung
            ihrer gewerblichen oder selbständigen beruflichen Tätigkeit handelt.
          </p>
          <p class="mt-4">
            Gegenüber Unternehmern gelten diese AGB auch für künftige Geschäftsbeziehungen, ohne dass wir nochmals auf sie hinweisen müssten.
            Verwendet der Unternehmer entgegenstehende oder ergänzende Allgemeine Geschäftsbedingungen, wird deren Geltung hiermit widersprochen;
            sie werden nur dann Vertragsbestandteil, wenn wir dem ausdrücklich zugestimmt haben.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">2. Vertragspartner, Vertragsschluss</h2>
          <p>
            Der Kaufvertrag kommt zustande mit Betten Sauer KG.
          </p>
          <p class="mt-4">
            Die Darstellung der Produkte im Online-Shop stellt kein rechtlich bindendes Angebot, sondern einen unverbindlichen Online-Katalog dar.
            Sie können unsere Produkte zunächst unverbindlich in den Warenkorb legen und Ihre Eingaben vor Absenden Ihrer verbindlichen Bestellung
            jederzeit korrigieren, indem Sie die hierfür im Bestellablauf vorgesehenen und erläuterten Korrekturhilfen nutzen. Durch Anklicken des
            Bestellbuttons geben Sie eine verbindliche Bestellung der im Warenkorb enthaltenen Waren ab. Die Bestätigung des Zugangs Ihrer Bestellung
            erfolgt per E-Mail unmittelbar nach dem Absenden der Bestellung.
          </p>
          <p class="mt-4">
            Wann der Vertrag mit uns zustande kommt, richtet sich nach der von Ihnen gewählten Zahlungsart:
          </p>
          <ul class="list-disc list-inside space-y-2 mt-4">
            <li><strong>Nachnahme, Rechnung, PayPal (Plus):</strong> Wir nehmen Ihre Bestellung durch Versand einer Annahmeerklärung in separater E-Mail oder durch Auslieferung der Ware innerhalb von zwei Tagen an.</li>
            <li><strong>Vorkasse:</strong> Wir nehmen Ihre Bestellung durch Versand einer Annahmeerklärung in separater E-Mail innerhalb von zwei Tagen an, in welcher wir Ihnen unsere Bankverbindung nennen.</li>
            <li><strong>Kreditkarte:</strong> Nach Ihrer Legitimation als rechtmäßiger Karteninhaber fordern wir Ihr Kreditkartenunternehmen zur Einleitung der Zahlungstransaktion auf und nehmen dadurch Ihr Angebot nach Prüfung innerhalb von 2 Werktagen an.</li>
            <li><strong>PayPal:</strong> Nach Abgabe der Bestellung im Shop fordern wir PayPal zur Einleitung der Zahlungstransaktion auf. Nach Überprüfung der Bestellung binnen 2 Werktagen erhalten Sie eine Auftragsbestätigung.</li>
            <li><strong>Amazon Pay:</strong> Nach Abgabe der Bestellung fordern wir Amazon zur Einleitung der Zahlungstransaktion auf und nehmen nach Prüfung Ihr Angebot binnen 2 Tagen an.</li>
            <li><strong>Barzahlung bei Abholung:</strong> Wir nehmen Ihre Bestellung durch Versand einer Auftragsbestätigung in separater E-Mail innerhalb von zwei Tagen an.</li>
          </ul>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">3. Vertragssprache, Vertragstextspeicherung</h2>
          <p>
            Die für den Vertragsschluss zur Verfügung stehende Sprache ist Deutsch. Wir speichern den Vertragstext und senden Ihnen die Bestelldaten
            und unsere AGB per E-Mail zu. Der Vertragstext ist aus Sicherheitsgründen nicht mehr über das Internet zugänglich.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">4. Lieferbedingungen</h2>
          <p>
            Zuzüglich zu den angegebenen Produktpreisen kommen noch Versandkosten hinzu. Näheres zur Höhe der Versandkosten erfahren Sie bei den Angeboten.
            Sie haben grundsätzlich die Möglichkeit der Abholung bei Betten Sauer KG, Brücker Mauspfad 539, 51109 Köln, Deutschland zu den angegebenen Geschäftszeiten.
            Eine Lieferung an Packstationen erfolgt nicht.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">5. Bezahlung</h2>
          <p>
            In unserem Shop stehen Ihnen grundsätzlich die folgenden Zahlungsarten zur Verfügung: Vorkasse, Kreditkarte, PayPal, Amazon Pay, Rechnung, Barzahlung bei Abholung.
            Details zu jeder Zahlungsart entnehmen Sie bitte den Hinweisen während des Bestellprozesses.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">6. Eigentumsvorbehalt</h2>
          <p>
            Die Ware bleibt bis zur vollständigen Bezahlung unser Eigentum. Für Unternehmer gelten ergänzende Regelungen zum Eigentumsvorbehalt, insbesondere zur Weiterveräußerung
            und Forderungsabtretung.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">7. Transportschäden</h2>
          <p>
            Für Verbraucher gilt: Bitte reklamieren Sie offensichtliche Transportschäden möglichst sofort beim Zusteller und nehmen Sie Kontakt zu uns auf. Für Unternehmer gilt:
            Die Gefahr geht mit Übergabe an den Spediteur über; die Untersuchungs- und Rügepflicht nach § 377 HGB ist zu beachten.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">8. Gewährleistung und Garantien</h2>
          <p>
            Es gilt das gesetzliche Mängelhaftungsrecht. Für Verbraucher beträgt die Verjährungsfrist bei gebrauchten Sachen ein Jahr ab Lieferung. Für Unternehmer beträgt die Verjährungsfrist
            ein Jahr ab Gefahrübergang. Weitere Einschränkungen sowie Ausnahmen, insbesondere bei Schäden an Leben, Körper oder Gesundheit, bleiben unberührt.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">9. Haftung</h2>
          <p>
            Wir haften uneingeschränkt für Schäden aus Verletzung des Lebens, des Körpers oder der Gesundheit sowie bei vorsätzlicher oder grob fahrlässiger Pflichtverletzung.
            Bei leicht fahrlässiger Verletzung wesentlicher Vertragspflichten ist die Haftung auf den vorhersehbaren Schaden begrenzt. Im Übrigen sind Ansprüche auf Schadensersatz ausgeschlossen.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">10. Streitbeilegung</h2>
          <p>
            Die Europäische Kommission stellt eine Plattform zur Online-Streitbeilegung (OS) bereit: <a href="https://ec.europa.eu/consumers/odr/" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">https://ec.europa.eu/consumers/odr/</a>.
            Wir sind bereit, an einem außergerichtlichen Schlichtungsverfahren vor einer Verbraucherschlichtungsstelle teilzunehmen.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">11. 30-Tage-Umtauschgarantie</h2>
          <p>
            Verbraucher haben die Möglichkeit, Kissen und Zudecken innerhalb von 30 Tagen gegen andere Artikel umzutauschen. Die Ware muss ungebraucht und originalverpackt sein.
            Weitere Details zur Abwicklung, Kosten und Gutschriften finden Sie in den vollständigen Bedingungen.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">12. Kundenrezensionen</h2>
          <p>
            Mit Abgabe einer Kundenrezension räumt uns der Kunde eine zeitlich und örtlich unbeschränkte, gebührenfreie, nicht ausschließliche Lizenz ein, diese Medieninhalte zu nutzen,
            zu kopieren, zu veröffentlichen und zu vervielfältigen. Rezensionen geben ausschließlich die Meinung des Kunden wieder.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">13. Schlussbestimmungen</h2>
          <p>
            Es gilt deutsches Recht unter Ausschluss des UN-Kaufrechts. Ausschließlicher Gerichtsstand für Kaufleute, juristische Personen des öffentlichen Rechts oder öffentlich-rechtliche
            Sondervermögen ist der Geschäftssitz der Betten-Sauer KG.
          </p>
        </section>

        <section>
          <h2 class="text-2xl font-semibold mb-4">14. Gesetzliches Mängelhaftungsrecht</h2>
          <p>
            Die Mängelhaftung richtet sich nach der Regelung „Gewährleistung“ in diesen Allgemeinen Geschäftsbedingungen.
          </p>
          <p class="mt-4 text-sm text-gray-600">
            Diese AGB und Kundeninformationen wurden von den auf IT-Recht spezialisierten Juristen des Händlerbundes erstellt. Weitere Informationen:
            <a href="https://www.haendlerbund.de/agb-service" class="text-[#6793c4] hover:underline" target="_blank" rel="noopener">https://www.haendlerbund.de/agb-service</a>.
          </p>
          <p class="mt-4 text-sm text-gray-600">
            Alternative Streitbeilegung gemäß Art. 14 Abs. 1 ODR-VO und § 36 VSBG: Zur Teilnahme an einem Streitbeilegungsverfahren vor einer Verbraucherschlichtungsstelle sind wir nicht verpflichtet und nicht bereit.
          </p>
        </section>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector("header");
    const desktopLinks = document.querySelectorAll('#menu a');
    const scrollTopBtn = document.getElementById("scrollTopBtn");
    const isHeroHeader = header?.dataset.hero === 'true';
    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add("scrolled");
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "block";
      } else {
        header.classList.remove("scrolled");
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
        if (scrollTopBtn) scrollTopBtn.style.display = "none";
      }
    };

    window.addEventListener("scroll", updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
