<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Abhol- &amp; Lieferservice für Bettwaren | Betten Sauer</title>
  <meta name="description" content="Betten Sauer holt Ihre Bettdecken und Kissen in Köln &amp; Inhausen ab, reinigt sie schonend und liefert sie frisch zurück. Abholservice für Bettwaren inklusive UV-Desinfektion." />
  <meta name="keywords" content="Bettdecken Abholservice, Kissen Reinigung Köln, Bettwaren Lieferservice, Betten Sauer Abholung, Bettdecken Waschservice" />
  <meta name="author" content="Betten-Sauer KG" />
  <meta name="theme-color" content="#6793c4" />
  <link rel="canonical" href="abhol.php" />
  <meta property="og:type" content="website" />
  <meta property="og:locale" content="de_DE" />
  <meta property="og:url" content="abhol.php" />
  <meta property="og:site_name" content="Betten-Sauer KG" />
  <meta property="og:title" content="Abhol- &amp; Lieferservice für Bettwaren | Betten Sauer" />
  <meta property="og:description" content="Wir holen Ihre Bettwaren ab und bringen sie frisch gewaschen, aufgeschüttelt und desinfiziert zurück – für nur 10 Euro extra." />
  <meta property="og:image" content="images/1200x800_abhol_lieferservice.webp" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Abhol- &amp; Lieferservice für Bettwaren | Betten Sauer" />
  <meta name="twitter:description" content="Abholung und Lieferung für Bettdecken &amp; Kissen in Köln und Inhausen. Schonende Reinigung, UV-Desinfektion und persönlicher Service." />
  <meta name="twitter:image" content="images/1200x800_abhol_lieferservice.webp" />

  <link rel="stylesheet" href="css/style.css" />

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white">

  <?php
    $headerClass = 'fixed top-0 left-0 right-0 z-20 bg-transparent transition duration-300';
    $headerDataHero = true;
    require __DIR__ . '/includes/header.php';
  ?>

  <main>
    <!-- Hero -->
    <section class="relative" aria-labelledby="hero-heading">
      <div class="relative h-[360px] sm:h-[420px] md:h-[480px] lg:h-[540px]">
        <img
          src="images/header/header_abhol02.jpg"
          alt="Mitarbeiter von Betten Sauer holt Bettwaren bei Kundin ab"
          class="absolute inset-0 h-full w-full object-cover"
          loading="eager"
          decoding="async"
        />
        <div class="absolute inset-0 bg-[#0f1e2f]/55"></div>
        <div class="absolute inset-0 bg-gradient-to-b from-transparent via-[#0f1e2f]/35 to-[#0f1e2f]/80"></div>
        <div class="relative z-10 flex h-full items-center justify-center lg:justify-end">
          <div class="w-full max-w-5xl space-y-6 px-6 text-center text-white lg:w-1/2 lg:px-12 lg:text-left">
            <h1 id="hero-heading" class="text-3xl font-semibold leading-tight text-shadow sm:text-4xl md:text-5xl lg:ml-auto">
              Wir holen Ihre Bettwaren – Sie genießen frischen Schlaf.
            </h1>
            <p class="text-base text-white/85 sm:text-lg md:text-xl lg:ml-auto">
              Unser Abhol- und Lieferservice bringt Ihre Decken und Kissen frisch gewaschen, desinfiziert und aufgeschüttelt zurück.
            </p>
            <div class="pt-2 flex justify-center lg:justify-start">
              <a href="#anfrage" class="inline-flex items-center justify-center rounded-lg bg-[#6793c4] px-7 py-3 text-sm font-semibold uppercase tracking-wide text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                Abholung vereinbaren
              </a>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Ablauf -->
    <section class="bg-white py-16" aria-labelledby="ablauf-heading">
      <div class="mx-auto max-w-6xl space-y-12 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="ablauf-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            So einfach geht&rsquo;s
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Sie rufen an oder schreiben uns – wir kümmern uns um den Rest. Damit Ihre Bettwaren ohne Umwege wieder frisch in Ihrem Schlafzimmer landen.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-8 md:grid-cols-3">
          <?php
            $steps = [
              [
                'title' => 'Termin vereinbaren',
                'text'  => 'Kontakt per Telefon oder E-Mail – wir finden gemeinsam Ihren Wunschtermin.',
                'icon'  => '<path d="M8 2v4" /><path d="M16 2v4" /><rect x="3" y="4" width="18" height="18" rx="2" /><path d="M3 10h18" /><path d="m9 16 2 2 4-4" />',
              ],
              [
                'title' => 'Abholung vor Ort',
                'text'  => 'Wir kommen zu Ihnen in Köln, Inhausen & Umgebung und holen Decken oder Kissen persönlich ab.',
                'icon'  => '<path d="M4 17H2V7h12v10" /><path d="M14 12h5l3 3v5h-4" /><circle cx="7" cy="19" r="2" /><circle cx="18" cy="19" r="2" /><path d="M6 7V4h6v3" />',
              ],
              [
                'title' => 'Frisch am nächsten Tag',
                'text'  => 'Gewaschen, hygienisch aufbereitet und aufgeschüttelt – meist schon am Folgetag zurück.',
                'icon'  => '<path d="M12 3v4" /><path d="M12 17v4" /><path d="M5.22 5.22 7.64 7.64" /><path d="M16.36 16.36 18.78 18.78" /><path d="M3 12h4" /><path d="M17 12h4" /><path d="M5.22 18.78 7.64 16.36" /><path d="M16.36 7.64 18.78 5.22" /><circle cx="12" cy="12" r="4" />',
              ],
            ];
          ?>
          <?php foreach ($steps as $index => $step): ?>
            <article class="flex flex-col gap-4 rounded-2xl border border-[#d6e2f1] bg-white p-8 text-center shadow-lg shadow-[#0f1e2f]/10">
              <div class="mx-auto flex h-16 w-16 items-center justify-center rounded-full bg-[#6793c4]/15 text-lg font-semibold text-[#4e759f]">
                <?= $index + 1 ?>
              </div>
              <div class="mx-auto flex h-12 w-12 items-center justify-center rounded-full bg-[#6793c4]/15" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-[#4e759f]" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                  <?= $step['icon'] ?>
                </svg>
              </div>
              <h3 class="text-xl font-semibold text-[#0f1e2f]"><?= htmlspecialchars($step['title'], ENT_QUOTES) ?></h3>
              <p class="text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($step['text'], ENT_QUOTES) ?></p>
            </article>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- Hygiene & Qualität -->
    <section class="bg-[#f5f7fa] py-16" aria-labelledby="qualitaet-heading">
      <div class="mx-auto max-w-5xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="qualitaet-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Sauberkeit mit gutem Gefühl
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Unser Atelier arbeitet mit sanften, dennoch gründlichen Verfahren – von Hand begleitet und kontrolliert.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-3">
          <?php
            $hygienePoints = [
              '🌿 Wir waschen ausschließlich mit Naturseife – schonend für Haut und Umwelt.',
              '🧺 Spezialmaschinen lockern die Füllung wieder auf und verteilen sie gleichmäßig.',
              '☀️ UV-Licht entfernt Bakterien und Viren ohne aggressive Chemie.',
            ];
          ?>
          <?php foreach ($hygienePoints as $point): ?>
            <div class="rounded-2xl border border-[#d6e2f1] bg-white p-6 text-center text-sm leading-relaxed text-gray-700 shadow-md shadow-[#0f1e2f]/10">
              <?= htmlspecialchars($point, ENT_QUOTES) ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- Preis -->
    <section class="bg-white py-16" aria-labelledby="preis-heading">
      <div class="mx-auto max-w-5xl space-y-8 px-6 text-gray-700 lg:px-0">
        <h2 id="preis-heading" class="text-center text-2xl font-semibold text-[#4e759f] sm:text-3xl">
          Was kostet der Service?
        </h2>
        <div class="rounded-2xl border border-[#dce4ef] bg-[#f9fbfe] p-8 shadow-lg shadow-[#0f1e2f]/10">
          <p class="text-base leading-relaxed sm:text-lg">
            Für Abholung und Lieferung berechnen wir pauschal nur <strong class="text-[#0f1e2f]">10&nbsp;Euro</strong>. Die Reinigung selbst hängt von Art und Größe Ihrer Bettware ab.
            Unsere aktuellen Preise finden Sie in unserer <button type="button" data-price-modal-open class="text-[#4e759f] underline hover:text-[#2f506f]">Preistabelle</button>.
          </p>
          <p class="mt-4 text-sm text-gray-600">
            Auf Wunsch holen wir auch Matratzen- oder Kissenfüllungen separat ab – sprechen Sie uns einfach an.
          </p>
        </div>
      </div>
    </section>
    <div id="priceModal" class="fixed inset-0 z-40 hidden" role="dialog" aria-modal="true" aria-labelledby="priceModalTitle">
      <div class="absolute inset-0 bg-black/70" data-price-modal-close></div>
      <div class="relative mx-auto mt-16 w-full max-w-3xl overflow-y-auto rounded-2xl bg-white p-8 shadow-2xl shadow-black/30 max-h-[calc(100vh-4rem)]">
        <div class="flex items-start justify-between gap-4">
          <div>
            <p class="text-xs font-semibold uppercase tracking-[0.2em] text-[#4e759f]">Preise im Überblick</p>
            <h3 id="priceModalTitle" class="mt-2 text-2xl font-semibold text-[#0f1e2f]">
              So preiswert ist die richtige Bettenpflege bei BETTEN-SAUER
            </h3>
          </div>
          <button type="button" class="rounded-full p-2 text-gray-500 transition hover:bg-gray-100 hover:text-gray-800" data-price-modal-close aria-label="Preistabelle schließen">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
              <path d="M6 6l12 12M6 18L18 6" />
            </svg>
          </button>
        </div>
        <div class="mt-6 space-y-6 text-sm leading-relaxed text-gray-700">
          <ol class="space-y-6 list-decimal pl-5">
            <li>
              <div class="space-y-3">
                <h4 class="text-lg font-semibold text-[#0f1e2f]">Reinigen von Daunendecken und Federkissen</h4>
                <p>Füllung reinigen, sortieren, entstauben, dämpfen, antibakteriell und gegen Milben behandeln. Der Bezug wird hierbei nicht gewaschen.</p>
                <ul class="space-y-2 list-disc pl-5">
                  <li><strong>Daunendecken:</strong> ab 29,- Euro &ndash; empfohlen alle drei bis vier Jahre. Bei regelmäßiger Pflege hält eine gute Decke über 20 Jahre.</li>
                  <li><strong>Federkissen:</strong> 9,- Euro &ndash; empfohlen alle ein bis zwei Jahre. Mit dieser Pflege bleibt ein gutes Federkissen bis zu acht Jahre im Einsatz.</li>
                </ul>
              </div>
            </li>
            <li>
              <div class="space-y-3">
                <h4 class="text-lg font-semibold text-[#0f1e2f]">Waschen von Daunendecken und Federkissen</h4>
                <p>Komplettwäsche mit reiner Naturseife und ohne Chemie. Ideal zwischen den Reinigungsintervallen oder kombiniert mit der Daunenreinigung &ndash; inklusive Bezugswäsche.</p>
                <ul class="space-y-2 list-disc pl-5">
                  <li><strong>Daunendecke:</strong> ab 29,- Euro</li>
                  <li><strong>Federkissen:</strong> 12,- Euro</li>
                </ul>
              </div>
            </li>
            <li>
              <div class="space-y-3">
                <h4 class="text-lg font-semibold text-[#0f1e2f]">Waschen von Bettwaren mit Naturhaarfüllung</h4>
                <p>Wäsche mit reiner Naturseife ohne Chemie. Geeignet für Füllungen aus Schurwolle, Kamelhaar, Lama oder Kaschmir.</p>
                <ul class="space-y-2 list-disc pl-5">
                  <li><strong>Steppbett:</strong> alle drei bis vier Jahre, ab 44,- Euro</li>
                  <li><strong>Kissen:</strong> alle ein bis zwei Jahre, 19,- Euro</li>
                  <li><strong>Matratzenbezug:</strong> alle zwei bis drei Jahre, 59,- Euro</li>
                </ul>
              </div>
            </li>
            <li>
              <div class="space-y-3">
                <h4 class="text-lg font-semibold text-[#0f1e2f]">Waschen von Bettwaren mit Synthetikfüllung</h4>
                <p>Schonend mit Naturseife, ohne Chemie. Für Bettwaren mit Kunstfaserfüllung.</p>
                <ul class="space-y-2 list-disc pl-5">
                  <li><strong>Steppbett:</strong> alle drei bis vier Jahre, ab 29,- Euro</li>
                  <li><strong>Kissen:</strong> alle ein bis zwei Jahre, 12,- Euro</li>
                  <li><strong>Matratzenbezug:</strong> alle zwei bis drei Jahre, 39,- Euro</li>
                </ul>
              </div>
            </li>
          </ol>
          <p>Wir nehmen Ihre Bettwaren täglich zur Reinigung oder Wäsche entgegen. Werfen Sie gerne einen Blick in unsere Fertigungs- und Reinigungsanlage &ndash; vereinbaren Sie dafür einfach einen Termin unter <a href="tel:+49221843236" class="font-semibold text-[#4e759f] underline hover:text-[#2f506f]">0221&nbsp;843236</a>.</p>
          <p class="text-sm font-semibold text-[#0f1e2f]">Übrigens: Bettwaren, die Sie bei uns gekauft haben, waschen und reinigen wir zum Sonderpreis!</p>
        </div>
      </div>
    </div>

    <!-- Serviceversprechen -->
    <section class="bg-[#0f1e2f] py-16 text-white" aria-labelledby="versprechen-heading">
      <div class="mx-auto max-w-6xl space-y-10 px-6 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="versprechen-heading" class="text-2xl font-semibold sm:text-3xl">
            Unser Versprechen
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed text-white/80 sm:text-lg">
            Wir behandeln jede Bettware mit derselben Sorgfalt, die wir auch für unseren eigenen Schlaf wählen würden.
          </p>
        </div>
        <div class="grid grid-cols-1 gap-6 sm:grid-cols-3">
          <?php
            $promise = [
              [
                'icon' => '<path d="M4 7h16v10H4z" /><path d="M6 5l1-2h10l1 2" /><path d="M10 11h4" />',
                'title' => 'Schonende Pflege',
                'text'  => 'Jede Decke wird individuell geprüft und mit passendem Programm gewaschen.',
              ],
              [
                'icon' => '<path d="M3 3h13l5 5v6a4 4 0 0 1-4 4H3z" /><path d="M14 3v5h5" /><path d="M7 13h5" />',
                'title' => 'Schneller Rücktransport',
                'text'  => 'In der Regel erhalten Sie Ihre Bettwaren bereits am Folgetag zurück.',
              ],
              [
                'icon' => '<path d="M7 8h10" /><path d="M7 12h4" /><path d="M7 16h7" /><path d="M3 5h18" /><path d="M5 5v14" /><path d="M19 5v14" />',
                'title' => 'Persönlicher Kontakt',
                'text'  => 'Sie sprechen mit unserem Team – keine anonyme Reinigung, sondern echte Fachleute.',
              ],
            ];
          ?>
          <?php foreach ($promise as $item): ?>
            <article class="flex flex-col items-center gap-4 rounded-2xl border border-white/15 bg-white/5 p-8 text-center shadow-lg shadow-black/20">
              <div class="flex h-12 w-12 items-center justify-center rounded-full bg-white/15" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 w-7 text-white" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                  <?= $item['icon'] ?>
                </svg>
              </div>
              <h3 class="text-lg font-semibold text-white"><?= htmlspecialchars($item['title'], ENT_QUOTES) ?></h3>
              <p class="text-sm leading-relaxed text-white/80"><?= htmlspecialchars($item['text'], ENT_QUOTES) ?></p>
            </article>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- Kontakt -->
    <section id="anfrage" class="bg-white py-16" aria-labelledby="anfrage-heading">
      <div class="mx-auto max-w-6xl gap-16 px-6 text-gray-700 lg:grid lg:grid-cols-[minmax(0,1fr)_minmax(0,1.05fr)] lg:px-0">
        <div class="space-y-6">
          <h2 id="anfrage-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Kontakt &amp; Terminvereinbarung
          </h2>
          <p class="text-base leading-relaxed sm:text-lg">
            Sie möchten Ihre Bettwaren abholen lassen? Unser Team in Köln oder Inhausen ist für Sie da und organisiert Abholung, Reinigung und Lieferung.
          </p>
          <div class="space-y-3 text-sm text-gray-600">
            <p><strong class="text-[#0f1e2f]">Telefon Köln:</strong> <a href="tel:+49221843236" class="text-[#4e759f] underline hover:text-[#2f506f]">0221&nbsp;843236</a></p>
            <p><strong class="text-[#0f1e2f]">Telefon Inhausen:</strong> <a href="tel:+4922412414230" class="text-[#4e759f] underline hover:text-[#2f506f]">02241&nbsp;2414230</a></p>
            <p><strong class="text-[#0f1e2f]">E-Mail:</strong> <a href="mailto:info@betten-sauer.de" class="text-[#4e759f] underline hover:text-[#2f506f]">info@betten-sauer.de</a></p>
          </div>
        </div>
        <div>
          <form action="lead.php" method="POST" class="rounded-2xl border border-[#dce4ef] bg-white p-8 shadow-xl shadow-[#0f1e2f]/10" novalidate aria-describedby="anfrage-form-info">
            <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
              <div>
                <label for="anfrage-name" class="mb-1 block text-sm font-semibold text-gray-800">Name *</label>
                <input
                  type="text"
                  id="anfrage-name"
                  name="name"
                  required
                  aria-required="true"
                  autocomplete="name"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
              <div>
                <label for="anfrage-email" class="mb-1 block text-sm font-semibold text-gray-800">E-Mail *</label>
                <input
                  type="email"
                  id="anfrage-email"
                  name="email"
                  required
                  aria-required="true"
                  autocomplete="email"
                  class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
                />
              </div>
            </div>
            <div class="mt-6">
              <label for="anfrage-adresse" class="mb-1 block text-sm font-semibold text-gray-800">Adresse *</label>
              <input
                type="text"
                id="anfrage-adresse"
                name="adresse"
                required
                aria-required="true"
                autocomplete="street-address"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              />
            </div>
            <div class="mt-6">
              <label for="anfrage-datum" class="mb-1 block text-sm font-semibold text-gray-800">Gewünschtes Abholdatum *</label>
              <input
                type="date"
                id="anfrage-datum"
                name="abholdatum"
                required
                aria-required="true"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              />
            </div>
            <div class="mt-6">
              <label for="anfrage-nachricht" class="mb-1 block text-sm font-semibold text-gray-800">Nachricht *</label>
              <textarea
                id="anfrage-nachricht"
                name="nachricht"
                rows="5"
                required
                aria-required="true"
                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 shadow-sm transition focus:border-[#6793c4] focus:outline-none focus:ring-4 focus:ring-[#6793c4]/25"
              ></textarea>
            </div>
            <div class="mt-6 flex items-start gap-3">
              <input
                type="checkbox"
                id="anfrage-datenschutz"
                name="datenschutz"
                required
                aria-required="true"
                class="mt-1 h-5 w-5 cursor-pointer rounded border-gray-300 text-[#6793c4] focus:ring-4 focus:ring-[#6793c4]/30 focus:ring-offset-0"
              />
              <label for="anfrage-datenschutz" class="text-sm leading-relaxed text-gray-700">
                Ich bin damit einverstanden, dass Betten Sauer meine Angaben zur Kontaktaufnahme verarbeitet.
                Details finden Sie in unserer <a href="datenschutz.php" class="text-[#4e759f] underline hover:text-[#2f506f]">Datenschutzerklärung</a>.
              </label>
            </div>
            <div class="mt-6">
              <div class="rounded-md border border-dashed border-gray-300 bg-gray-50 p-4 text-center text-sm text-gray-500">
                reCAPTCHA Platzhalter – hinterlegen Sie Ihren Site-Key für den Live-Betrieb.
              </div>
            </div>
            <div class="mt-8">
              <button type="submit" class="w-full rounded-lg bg-[#6793c4] px-6 py-3 text-base font-semibold text-white transition hover:bg-[#4e759f] focus-visible:outline-none focus-visible:ring-4 focus-visible:ring-[#4e759f]/30">
                Abholung anfragen
              </button>
            </div>
          </form>
          <p id="anfrage-form-info" class="mt-4 text-xs text-gray-500">
            Alle mit * gekennzeichneten Felder sind Pflichtfelder.
          </p>
        </div>
      </div>
    </section>

    <!-- FAQ -->
    <section class="bg-[#f5f7fa] py-16" aria-labelledby="faq-heading">
      <div class="mx-auto max-w-5xl space-y-10 px-6 text-gray-700 lg:px-0">
        <div class="space-y-4 text-center">
          <h2 id="faq-heading" class="text-2xl font-semibold text-[#4e759f] sm:text-3xl">
            Häufige Fragen
          </h2>
          <p class="mx-auto max-w-3xl text-base leading-relaxed sm:text-lg">
            Noch Unsicherheiten? Wir beantworten gerne, wie der Service abläuft.
          </p>
        </div>
        <div class="space-y-6">
          <?php
            $faqs = [
              [
                'question' => 'Wie lange dauert die Reinigung?',
                'answer'   => 'In der Regel 1–2 Tage. Wir informieren Sie, falls besondere Pflegeprogramme etwas mehr Zeit benötigen.',
              ],
              [
                'question' => 'Wie verpacke ich meine Bettwaren?',
                'answer'   => 'Am besten in einem sauberen Baumwollbezug oder einem atmungsaktiven Sack. Wir bringen die Transporttaschen mit.',
              ],
              [
                'question' => 'Was, wenn ich bei der Abholung nicht zu Hause bin?',
                'answer'   => 'Gern vereinbaren wir einen Abstellort oder holen bei Nachbarn ab – Hauptsache, Ihre Bettwaren sind sicher vorbereitet.',
              ],
            ];
          ?>
          <?php foreach ($faqs as $faq): ?>
            <div class="rounded-2xl border border-[#d6e2f1] bg-white p-6 shadow-md shadow-[#0f1e2f]/10">
              <h3 class="text-lg font-semibold text-[#0f1e2f]"><?= htmlspecialchars($faq['question'], ENT_QUOTES) ?></h3>
              <p class="mt-2 text-sm leading-relaxed text-gray-600"><?= htmlspecialchars($faq['answer'], ENT_QUOTES) ?></p>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </section>
  </main>

  <?php require __DIR__ . '/includes/footer.php'; ?>

  <script src="js/menu.js"></script>
  <script>
    const header = document.querySelector('header');
    const desktopLinks = document.querySelectorAll('#menu a');
    const isHeroHeader = header?.dataset.hero === 'true';
    const priceModal = document.getElementById('priceModal');
    const priceModalTrigger = document.querySelector('[data-price-modal-open]');
    const priceModalClosers = document.querySelectorAll('[data-price-modal-close]');
    function toggleBodyScroll(shouldLock) {
      document.body.classList.toggle('overflow-hidden', shouldLock);
    }
    function closePriceModal() {
      if (!priceModal) return;
      priceModal.classList.add('hidden');
      toggleBodyScroll(false);
      document.removeEventListener('keydown', handlePriceModalEsc);
    }
    function handlePriceModalEsc(event) {
      if (event.key === 'Escape') {
        closePriceModal();
      }
    }
    function openPriceModal() {
      if (!priceModal) return;
      priceModal.classList.remove('hidden');
      toggleBodyScroll(true);
      document.addEventListener('keydown', handlePriceModalEsc);
      priceModal.querySelector('button[data-price-modal-close]')?.focus();
    }

    priceModalTrigger?.addEventListener('click', openPriceModal);
    priceModalClosers.forEach(button => button.addEventListener('click', closePriceModal));

    const ensureSubmenuContrast = () => {
      desktopLinks.forEach(link => {
        if (link.closest('ul ul')) {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        }
      });
    };

    const updateHeaderState = () => {
      if (!header) return;
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
        desktopLinks.forEach(link => {
          link.classList.remove('text-white');
          link.classList.add('text-gray-800');
          link.style.textShadow = 'none';
        });
        ensureSubmenuContrast();
      } else {
        header.classList.remove('scrolled');
        desktopLinks.forEach(link => {
          link.classList.add('text-white');
          link.classList.remove('text-gray-800');
          if (!link.closest('ul ul')) {
            link.style.textShadow = isHeroHeader ? '0 2px 8px rgba(0,0,0,.6)' : 'none';
          } else {
            link.style.textShadow = 'none';
          }
        });
        ensureSubmenuContrast();
      }
    };

    window.addEventListener('scroll', updateHeaderState);
    updateHeaderState();
  </script>
</body>
</html>
